/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.plugin.locale;

import it.businesslogic.ireport.plugin.locale.MissingResourceCellRenderer;
import it.businesslogic.ireport.plugin.locale.ResourceKey;
import it.businesslogic.ireport.plugin.locale.TranslationStatusDialog;
import it.businesslogic.ireport.util.I18n;
import it.businesslogic.ireport.util.Misc;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Properties;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class TranslationStatusDetailDialog
extends JDialog {
    private Properties properties = null;
    private String fileName = "";
    private JButton jButtonDetails;
    private JButton jButtonOk;
    private JScrollPane jScrollPane1;
    private JTable jTableLanguages;
    static /* synthetic */ Class class$java$lang$String;

    public TranslationStatusDetailDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initAll();
    }

    public TranslationStatusDetailDialog(Dialog parent, boolean modal) {
        super(parent, modal);
        this.initAll();
    }

    private void initAll() {
        this.initComponents();
        TableColumnModel tcm = this.jTableLanguages.getColumnModel();
        TableColumn tc = tcm.getColumn(0);
        tc.setCellRenderer(new MissingResourceCellRenderer());
        DefaultListSelectionModel dsm = new DefaultListSelectionModel();
        dsm.setSelectionMode(0);
        dsm.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                TranslationStatusDetailDialog.this.jButtonDetails.setEnabled(TranslationStatusDetailDialog.this.jTableLanguages.getSelectedRow() >= 0);
            }
        });
        this.jTableLanguages.setSelectionModel(dsm);
        this.pack();
        Misc.centerFrame(this);
    }

    public void setLanguage(String language, Properties defaultTranslations) {
        DefaultTableModel dtm = (DefaultTableModel)this.jTableLanguages.getModel();
        dtm.setRowCount(0);
        this.properties = new Properties();
        this.fileName = language;
        try {
            this.properties.load(this.getClass().getResourceAsStream("/it/businesslogic/ireport/locale/" + language));
        }
        catch (Exception ex) {
            // empty catch block
        }
        Iterator<Object> namesIterator = defaultTranslations.keySet().iterator();
        Object[] names = new String[defaultTranslations.keySet().size()];
        for (int i = 0; i < names.length; ++i) {
            names[i] = (String)namesIterator.next();
        }
        Arrays.sort(names);
        double translated = 0.0;
        for (int i = 0; i < names.length; ++i) {
            String name = "" + (String)names[i];
            ResourceKey rk = new ResourceKey(name);
            if (this.properties.getProperty(name) == null) {
                rk.setMissing(true);
            }
            dtm.addRow(new Object[]{rk, !rk.isMissing() ? this.properties.getProperty(name) : "", I18n.getString(name)});
        }
        this.jTableLanguages.updateUI();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTableLanguages = new JTable();
        this.jButtonOk = new JButton();
        this.jButtonDetails = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(2);
        this.jTableLanguages.setModel(new DefaultTableModel(new Object[0][], new String[]{"Key", "Translation", "Default"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{class$java$lang$String == null ? (class$java$lang$String = TranslationStatusDetailDialog.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = TranslationStatusDetailDialog.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = TranslationStatusDetailDialog.class$("java.lang.String")) : class$java$lang$String};
                this.canEdit = new boolean[]{false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jTableLanguages.setGridColor(new Color(204, 204, 204));
        this.jTableLanguages.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                TranslationStatusDetailDialog.this.jTableLanguagesMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTableLanguages);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jScrollPane1, gridBagConstraints);
        this.jButtonOk.setText("Close");
        this.jButtonOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TranslationStatusDetailDialog.this.jButtonOkActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.getContentPane().add((Component)this.jButtonOk, gridBagConstraints);
        this.jButtonDetails.setText("Export");
        this.jButtonDetails.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TranslationStatusDetailDialog.this.jButtonDetailsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jButtonDetails, gridBagConstraints);
        this.pack();
    }

    private void jButtonOkActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void jButtonDetailsActionPerformed(ActionEvent evt) {
        try {
            JFileChooser jfc = new JFileChooser();
            jfc.setSelectedFile(new File(this.getFileName()));
            if (jfc.showSaveDialog(this) == 0) {
                FileOutputStream fos = new FileOutputStream(jfc.getSelectedFile());
                this.getProperties().store(fos, "");
                PrintWriter pw = new PrintWriter(new OutputStreamWriter(fos));
                pw.println("\n\n# ---------- Missing translations -------------");
                for (int i = 0; i < this.jTableLanguages.getRowCount(); ++i) {
                    ResourceKey rk = (ResourceKey)this.jTableLanguages.getValueAt(i, 0);
                    if (!rk.isMissing()) continue;
                    pw.println("#" + rk + "=" + this.jTableLanguages.getValueAt(i, 2));
                }
                pw.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jTableLanguagesMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            if (evt.getButton() == 1) {
                this.jButtonDetailsActionPerformed(null);
            }
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new TranslationStatusDialog((Frame)new JFrame(), true).setVisible(true);
            }
        });
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }
}

