/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.util.JRImageLoader;

public class JRResultSetDataSource
implements JRDataSource {
    private ResultSet resultSet = null;
    private Map columnIndexMap = new HashMap();
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$io$InputStream;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$sql$Clob;
    static /* synthetic */ Class class$java$io$Reader;
    static /* synthetic */ Class class$java$sql$Blob;
    static /* synthetic */ Class class$java$awt$Image;

    public JRResultSetDataSource(ResultSet rs) {
        this.resultSet = rs;
    }

    public boolean next() throws JRException {
        boolean hasNext = false;
        if (this.resultSet != null) {
            try {
                hasNext = this.resultSet.next();
            }
            catch (SQLException e) {
                throw new JRException("Unable to get next record.", e);
            }
        }
        return hasNext;
    }

    public Object getFieldValue(JRField field) throws JRException {
        Object objValue;
        block42: {
            objValue = null;
            if (field != null && this.resultSet != null) {
                Integer columnIndex = this.getColumnIndex(field.getName());
                Class clazz = field.getValueClass();
                try {
                    if (clazz.equals(class$java$lang$Boolean == null ? (class$java$lang$Boolean = JRResultSetDataSource.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
                        objValue = this.resultSet.getBoolean(columnIndex) ? Boolean.TRUE : Boolean.FALSE;
                        break block42;
                    }
                    if (clazz.equals(class$java$lang$Byte == null ? (class$java$lang$Byte = JRResultSetDataSource.class$("java.lang.Byte")) : class$java$lang$Byte)) {
                        objValue = new Byte(this.resultSet.getByte(columnIndex));
                        if (this.resultSet.wasNull()) {
                            objValue = null;
                        }
                        break block42;
                    }
                    if (clazz.equals(class$java$util$Date == null ? (class$java$util$Date = JRResultSetDataSource.class$("java.util.Date")) : class$java$util$Date)) {
                        objValue = this.resultSet.getDate(columnIndex);
                        if (this.resultSet.wasNull()) {
                            objValue = null;
                        }
                        break block42;
                    }
                    if (clazz.equals(class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = JRResultSetDataSource.class$("java.sql.Timestamp")) : class$java$sql$Timestamp)) {
                        objValue = this.resultSet.getTimestamp(columnIndex);
                        if (this.resultSet.wasNull()) {
                            objValue = null;
                        }
                        break block42;
                    }
                    if (clazz.equals(class$java$sql$Time == null ? (class$java$sql$Time = JRResultSetDataSource.class$("java.sql.Time")) : class$java$sql$Time)) {
                        objValue = this.resultSet.getTime(columnIndex);
                        if (this.resultSet.wasNull()) {
                            objValue = null;
                        }
                        break block42;
                    }
                    if (clazz.equals(class$java$lang$Double == null ? (class$java$lang$Double = JRResultSetDataSource.class$("java.lang.Double")) : class$java$lang$Double)) {
                        objValue = new Double(this.resultSet.getDouble(columnIndex));
                        if (this.resultSet.wasNull()) {
                            objValue = null;
                        }
                        break block42;
                    }
                    if (clazz.equals(class$java$lang$Float == null ? (class$java$lang$Float = JRResultSetDataSource.class$("java.lang.Float")) : class$java$lang$Float)) {
                        objValue = new Float(this.resultSet.getFloat(columnIndex));
                        if (this.resultSet.wasNull()) {
                            objValue = null;
                        }
                        break block42;
                    }
                    if (clazz.equals(class$java$lang$Integer == null ? (class$java$lang$Integer = JRResultSetDataSource.class$("java.lang.Integer")) : class$java$lang$Integer)) {
                        objValue = new Integer(this.resultSet.getInt(columnIndex));
                        if (this.resultSet.wasNull()) {
                            objValue = null;
                        }
                        break block42;
                    }
                    if (clazz.equals(class$java$io$InputStream == null ? (class$java$io$InputStream = JRResultSetDataSource.class$("java.io.InputStream")) : class$java$io$InputStream)) {
                        byte[] bytes = this.readBytes(columnIndex);
                        objValue = bytes == null ? null : new ByteArrayInputStream(bytes);
                        break block42;
                    }
                    if (clazz.equals(class$java$lang$Long == null ? (class$java$lang$Long = JRResultSetDataSource.class$("java.lang.Long")) : class$java$lang$Long)) {
                        objValue = new Long(this.resultSet.getLong(columnIndex));
                        if (this.resultSet.wasNull()) {
                            objValue = null;
                        }
                        break block42;
                    }
                    if (clazz.equals(class$java$lang$Short == null ? (class$java$lang$Short = JRResultSetDataSource.class$("java.lang.Short")) : class$java$lang$Short)) {
                        objValue = new Short(this.resultSet.getShort(columnIndex));
                        if (this.resultSet.wasNull()) {
                            objValue = null;
                        }
                        break block42;
                    }
                    if (clazz.equals(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = JRResultSetDataSource.class$("java.math.BigDecimal")) : class$java$math$BigDecimal)) {
                        objValue = this.resultSet.getBigDecimal(columnIndex);
                        if (this.resultSet.wasNull()) {
                            objValue = null;
                        }
                        break block42;
                    }
                    if (clazz.equals(class$java$lang$String == null ? (class$java$lang$String = JRResultSetDataSource.class$("java.lang.String")) : class$java$lang$String)) {
                        int columnType = this.resultSet.getMetaData().getColumnType(columnIndex);
                        switch (columnType) {
                            case 2005: {
                                Clob clob = this.resultSet.getClob(columnIndex);
                                if (this.resultSet.wasNull()) {
                                    objValue = null;
                                    break;
                                }
                                objValue = this.clobToString(clob);
                                break;
                            }
                            default: {
                                objValue = this.resultSet.getString(columnIndex);
                                if (this.resultSet.wasNull()) {
                                    objValue = null;
                                    break;
                                } else {
                                    break;
                                }
                            }
                        }
                        break block42;
                    }
                    if (clazz.equals(class$java$sql$Clob == null ? (class$java$sql$Clob = JRResultSetDataSource.class$("java.sql.Clob")) : class$java$sql$Clob)) {
                        objValue = this.resultSet.getClob(columnIndex);
                        if (this.resultSet.wasNull()) {
                            objValue = null;
                        }
                    } else if (clazz.equals(class$java$io$Reader == null ? (class$java$io$Reader = JRResultSetDataSource.class$("java.io.Reader")) : class$java$io$Reader)) {
                        Reader reader = null;
                        long size = -1L;
                        int columnType = this.resultSet.getMetaData().getColumnType(columnIndex);
                        switch (columnType) {
                            case 2005: {
                                Clob clob = this.resultSet.getClob(columnIndex);
                                if (this.resultSet.wasNull()) break;
                                reader = clob.getCharacterStream();
                                size = clob.length();
                                break;
                            }
                            default: {
                                reader = this.resultSet.getCharacterStream(columnIndex);
                                if (!this.resultSet.wasNull()) break;
                                reader = null;
                            }
                        }
                        objValue = reader == null ? null : this.getArrayReader(reader, size);
                    } else if (clazz.equals(class$java$sql$Blob == null ? (class$java$sql$Blob = JRResultSetDataSource.class$("java.sql.Blob")) : class$java$sql$Blob)) {
                        objValue = this.resultSet.getBlob(columnIndex);
                        if (this.resultSet.wasNull()) {
                            objValue = null;
                        }
                    } else {
                        byte[] bytes;
                        objValue = clazz.equals(class$java$awt$Image == null ? (class$java$awt$Image = JRResultSetDataSource.class$("java.awt.Image")) : class$java$awt$Image) ? ((bytes = this.readBytes(columnIndex)) == null ? null : JRImageLoader.loadImage(bytes)) : this.resultSet.getObject(columnIndex);
                    }
                }
                catch (Exception e) {
                    throw new JRException("Unable to get value for field '" + field.getName() + "' of class '" + clazz.getName() + "'", e);
                }
            }
        }
        return objValue;
    }

    private Integer getColumnIndex(String fieldName) throws JRException {
        Integer columnIndex = (Integer)this.columnIndexMap.get(fieldName);
        if (columnIndex == null) {
            block6: {
                try {
                    ResultSetMetaData metadata = this.resultSet.getMetaData();
                    for (int i = 1; i <= metadata.getColumnCount(); ++i) {
                        if (!fieldName.equalsIgnoreCase(metadata.getColumnName(i))) continue;
                        columnIndex = new Integer(i);
                        break;
                    }
                    if (columnIndex != null) break block6;
                    if (fieldName.startsWith("COLUMN_")) {
                        columnIndex = new Integer(fieldName.substring(7));
                        if (columnIndex <= 0 || columnIndex > this.resultSet.getMetaData().getColumnCount()) {
                            throw new JRException("Column index out of range : " + columnIndex);
                        }
                        break block6;
                    }
                    throw new JRException("Unknown column name : " + fieldName);
                }
                catch (SQLException e) {
                    throw new JRException("Unable to retrieve result set metadata.", e);
                }
            }
            this.columnIndexMap.put(fieldName, columnIndex);
        }
        return columnIndex;
    }

    protected String clobToString(Clob clob) throws JRException {
        try {
            int bufSize = 8192;
            char[] buf = new char[bufSize];
            BufferedReader reader = new BufferedReader(clob.getCharacterStream(), bufSize);
            StringBuffer str = new StringBuffer((int)clob.length());
            int read = reader.read(buf);
            while (read > 0) {
                str.append(buf, 0, read);
                read = reader.read(buf);
            }
            return str.toString();
        }
        catch (SQLException e) {
            throw new JRException("Unable to read clob value", e);
        }
        catch (IOException e) {
            throw new JRException("Unable to read clob value", e);
        }
    }

    protected CharArrayReader getArrayReader(Reader reader, long size) throws IOException {
        char[] buf = new char[8192];
        CharArrayWriter bufWriter = new CharArrayWriter(size > 0L ? (int)size : 8192);
        BufferedReader bufReader = new BufferedReader(reader, 8192);
        int read = bufReader.read(buf);
        while (read > 0) {
            bufWriter.write(buf, 0, read);
            read = bufReader.read(buf);
        }
        bufWriter.flush();
        return new CharArrayReader(bufWriter.toCharArray());
    }

    protected byte[] readBytes(Integer columnIndex) throws SQLException, IOException {
        InputStream is = null;
        long size = -1L;
        int columnType = this.resultSet.getMetaData().getColumnType(columnIndex);
        switch (columnType) {
            case 2004: {
                Blob blob = this.resultSet.getBlob(columnIndex);
                if (this.resultSet.wasNull()) break;
                is = blob.getBinaryStream();
                size = blob.length();
                break;
            }
            default: {
                is = this.resultSet.getBinaryStream(columnIndex);
                if (!this.resultSet.wasNull()) break;
                is = null;
            }
        }
        byte[] bytes = null;
        if (is != null) {
            bytes = this.readBytes(is, size);
        }
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] readBytes(InputStream is, long size) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(size > 0L ? (int)size : 1000);
        byte[] bytes = new byte[1000];
        int ln = 0;
        try {
            while ((ln = is.read(bytes)) > 0) {
                baos.write(bytes, 0, ln);
            }
            baos.flush();
        }
        finally {
            try {
                baos.close();
            }
            catch (IOException e) {}
        }
        return baos.toByteArray();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

