/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast.expr;

import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ExpressionTransformer;
import org.codehaus.groovy.classgen.AsmClassGenerator;

public class CastExpression
extends Expression {
    private Expression expression;
    private boolean ignoreAutoboxing = false;
    private boolean coerce = false;

    public static CastExpression asExpression(String typeName, Expression expression) {
        CastExpression answer = new CastExpression(typeName, expression);
        answer.setCoerce(true);
        return answer;
    }

    public CastExpression(String type, Expression expression) {
        super.setType(type);
        this.expression = expression;
    }

    public CastExpression(String type, Expression expression, boolean ignoreAutoboxing) {
        super.setType(type);
        this.expression = expression;
        this.ignoreAutoboxing = ignoreAutoboxing;
    }

    public boolean isIgnoringAutoboxing() {
        return this.ignoreAutoboxing;
    }

    public boolean isCoerce() {
        return this.coerce;
    }

    public void setCoerce(boolean coerce) {
        this.coerce = coerce;
    }

    public String toString() {
        return super.toString() + "[(" + this.type + ") " + this.expression + "]";
    }

    public void visit(GroovyCodeVisitor visitor) {
        visitor.visitCastExpression(this);
    }

    public Expression transformExpression(ExpressionTransformer transformer) {
        return new CastExpression(this.type, transformer.transform(this.expression));
    }

    public String getText() {
        return "(" + this.type + ") " + this.expression.getText();
    }

    public Expression getExpression() {
        return this.expression;
    }

    protected void resolveType(AsmClassGenerator resolver) {
    }
}

