/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import java.util.ArrayList;
import mondrian.olap.Dimension;
import mondrian.olap.Exp;
import mondrian.olap.Hierarchy;
import mondrian.olap.Level;
import mondrian.olap.Member;
import mondrian.olap.MemberFormatter;
import mondrian.olap.OlapElement;
import mondrian.olap.OlapElementBase;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.olap.Validator;
import mondrian.olap.Visitor;
import mondrian.olap.type.MemberType;
import mondrian.olap.type.Type;
import mondrian.resource.MondrianResource;

public abstract class MemberBase
extends OlapElementBase
implements Member {
    protected Member parentMember;
    protected final Level level;
    protected String uniqueName;
    protected final int flags;
    protected final String parentUniqueName;

    protected MemberBase(Member parentMember, Level level, int flags) {
        this.parentMember = parentMember;
        this.level = level;
        this.parentUniqueName = parentMember == null ? null : parentMember.getUniqueName();
        this.flags = flags;
    }

    public String getQualifiedName() {
        return MondrianResource.instance().MdxMemberName.str(this.uniqueName);
    }

    public final int getCategory() {
        return 6;
    }

    public Type getTypeX() {
        return new MemberType(this.getHierarchy(), null, null);
    }

    public abstract String getName();

    public final String getUniqueName() {
        return this.uniqueName;
    }

    public final String getCaption() {
        MemberFormatter mf = this.getLevel().getMemberFormatter();
        if (mf != null) {
            return mf.formatMember(this);
        }
        String caption = super.getCaption();
        return caption != null ? caption : this.getName();
    }

    public final String getParentUniqueName() {
        return this.parentUniqueName;
    }

    public Dimension getDimension() {
        return this.level.getDimension();
    }

    public final Hierarchy getHierarchy() {
        return this.level.getHierarchy();
    }

    public final Level getLevel() {
        return this.level;
    }

    public final int getMemberType() {
        return this.flags & 7;
    }

    public String getDescription() {
        return null;
    }

    public final boolean isMeasure() {
        return this.level.getHierarchy().getDimension().isMeasures();
    }

    public final boolean isAll() {
        return this.level.isAll();
    }

    public boolean isNull() {
        return false;
    }

    public OlapElement lookupChild(SchemaReader schemaReader, String s) {
        return schemaReader.lookupMemberChildByName(this, s);
    }

    public Member getParentMember() {
        if (this.parentUniqueName == null) {
            return null;
        }
        if (this.parentMember != null) {
            return this.parentMember;
        }
        boolean failIfNotFound = true;
        Hierarchy hierarchy = this.getHierarchy();
        SchemaReader schemaReader = hierarchy.getDimension().getSchema().getSchemaReader();
        String[] parentUniqueNameParts = Util.explode(this.parentUniqueName);
        this.parentMember = (MemberBase)schemaReader.getMemberByUniqueName(parentUniqueNameParts, failIfNotFound);
        return this.parentMember;
    }

    public boolean isChildOrEqualTo(Member member) {
        return member == null ? false : this.isChildOrEqualTo(member.getUniqueName());
    }

    public boolean isChildOrEqualTo(String uniqueName) {
        if (uniqueName == null) {
            return false;
        }
        String thisUniqueName = this.getUniqueName();
        if (thisUniqueName.equals(uniqueName)) {
            return true;
        }
        String parentUniqueName = this.getParentUniqueName();
        return parentUniqueName == null ? false : ((MemberBase)this.getParentMember()).isChildOrEqualTo(uniqueName);
    }

    public boolean isCalculated() {
        return this.isCalculatedInQuery() ? true : this.getMemberType() == 4;
    }

    public int getSolveOrder() {
        return -1;
    }

    public Exp getExpression() {
        return null;
    }

    public Exp accept(Validator validator) {
        return this;
    }

    public Member[] getAncestorMembers() {
        ArrayList<Member> list = new ArrayList<Member>();
        for (Member parentMember = this.getParentMember(); parentMember != null; parentMember = (MemberBase)parentMember.getParentMember()) {
            list.add(parentMember);
        }
        return list.toArray(new Member[list.size()]);
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public void childrenAccept(Visitor visitor) {
    }

    public int getOrdinal() {
        return -1;
    }

    public boolean isHidden() {
        return false;
    }

    public Member getDataMember() {
        return null;
    }

    public String getPropertyFormattedValue(String propertyName) {
        return this.getPropertyValue(propertyName).toString();
    }
}

