/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import mondrian.olap.DriverManager;
import mondrian.rolap.MemberReader;
import mondrian.rolap.RolapConnection;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapUtil;

public class Test {
    PrintWriter pw = new PrintWriter(System.out, true);
    RolapConnection connection;

    public static void main(String[] args) {
        Test test = new Test(args);
        test.run();
    }

    Test(String[] args) {
        String connectString = "Data Source=LOCALHOST;Provider=msolap;Catalog=Foodmart";
        boolean fresh = true;
        this.connection = (RolapConnection)DriverManager.getConnection(connectString, null, fresh);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void convertFoodMart() throws SQLException {
        SQLException e32;
        Statement statement;
        Connection connection;
        block19: {
            connection = null;
            statement = null;
            Statement statement2 = null;
            try {
                try {
                    Class.forName("com.ms.jdbc.odbc.JdbcOdbcDriver");
                }
                catch (ClassNotFoundException e2) {
                    // empty catch block
                }
                String connectString = "jdbc:odbc:DSN=FoodMart2";
                connection = java.sql.DriverManager.getConnection(connectString);
                statement = connection.createStatement();
                statement2 = connection.createStatement();
                String sql = "select * from ( select *, \"fname\" + ' ' + \"lname\" as \"name\" from \"customer\")order by \"country\", \"state_province\", \"city\", \"name\"";
                ResultSet resultSet = statement.executeQuery(sql);
                int i = 0;
                while (resultSet.next()) {
                    int customer_id = resultSet.getInt("customer_id");
                    statement2.executeUpdate("update \"customer\" set \"ordinal\" = " + ++i * 3 + " where \"customer_id\" = " + customer_id);
                }
                connection.commit();
                Object var10_10 = null;
                if (statement2 == null) break block19;
            }
            catch (Throwable throwable) {
                SQLException e32;
                Object var10_11 = null;
                if (statement2 != null) {
                    try {
                        statement2.close();
                    }
                    catch (SQLException e32) {
                        // empty catch block
                    }
                }
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException e32) {
                        // empty catch block
                    }
                }
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException e32) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            try {
                statement2.close();
            }
            catch (SQLException e32) {
                // empty catch block
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException e32) {
                // empty catch block
            }
        }
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException e32) {}
        }
    }

    void run() {
        RolapCube salesCube = (RolapCube)this.connection.getSchema().lookupCube("Sales", true);
        RolapHierarchy measuresHierarchy = (RolapHierarchy)salesCube.getMeasuresHierarchy();
        this.testMemberReader(measuresHierarchy.memberReader);
        RolapHierarchy genderHierarchy = (RolapHierarchy)salesCube.lookupHierarchy("Gender", false);
        this.testMemberReader(genderHierarchy.memberReader);
        RolapHierarchy customerHierarchy = (RolapHierarchy)salesCube.lookupHierarchy("Customers", false);
        this.testMemberReader(customerHierarchy.memberReader);
    }

    void testMemberReader(MemberReader reader) {
        this.pw.println();
        this.pw.println("MemberReader class=" + reader.getClass());
        this.pw.println("Count=" + reader.getMemberCount());
        this.pw.print("Root member(s)=");
        RolapMember[] rootMembers = RolapUtil.toArray(reader.getRootMembers());
        this.print(rootMembers);
        this.pw.println();
        RolapLevel[] levels = (RolapLevel[])rootMembers[0].getHierarchy().getLevels();
        RolapLevel level = levels[levels.length > 1 ? 1 : 0];
        this.pw.print("Members at level " + level.getUniqueName() + " are ");
        RolapMember[] members = RolapUtil.toArray(reader.getMembersInLevel(level, 0, Integer.MAX_VALUE));
        this.print(members);
        this.pw.println();
        this.pw.println("First children of first children: {");
        ArrayList<RolapMember> firstChildren = new ArrayList<RolapMember>();
        RolapMember member = rootMembers[0];
        while (member != null) {
            firstChildren.add(member);
            this.pw.print("\t");
            this.print(member);
            ArrayList children = new ArrayList();
            reader.getMemberChildren(member, children);
            if (children.isEmpty()) break;
            this.pw.print(" (" + children.size() + " children)");
            RolapMember leadMember = reader.getLeadMember(member, 5);
            this.pw.print(", lead(5)=");
            this.print(leadMember);
            member = children.size() > 1 ? (RolapMember)children.get(1) : (children.size() > 0 ? (RolapMember)children.get(0) : null);
            this.pw.println();
        }
        this.pw.println("}");
    }

    private void print(RolapMember member) {
        if (member == null) {
            this.pw.print("Member(null)");
            return;
        }
        this.pw.print("Member(" + member.getUniqueName() + ")");
    }

    private void print(RolapMember[] members) {
        this.pw.print("{");
        for (int i = 0; i < members.length; ++i) {
            if (i > 0) {
                this.pw.print(", ");
            }
            this.print(members[i]);
        }
        this.pw.print("}");
    }
}

