/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.query;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRQuery;
import net.sf.jasperreports.engine.JRQueryChunk;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.fill.JRFillParameter;
import net.sf.jasperreports.engine.query.JRQueryExecuter;

public abstract class JRAbstractQueryExecuter
implements JRQueryExecuter {
    protected final JRDataset dataset;
    private final Map parametersMap;
    private String queryString;
    private List parameterNames;

    protected JRAbstractQueryExecuter(JRDataset dataset, Map parametersMap) {
        this.dataset = dataset;
        this.parametersMap = parametersMap;
        this.queryString = "";
        this.parameterNames = new ArrayList();
    }

    protected void parseQuery() {
        JRQueryChunk[] chunks;
        JRQuery query = this.dataset.getQuery();
        if (query != null && (chunks = query.getChunks()) != null && chunks.length > 0) {
            StringBuffer sbuffer = new StringBuffer();
            JRQueryChunk chunk = null;
            block4: for (int i = 0; i < chunks.length; ++i) {
                chunk = chunks[i];
                switch (chunk.getType()) {
                    case 3: {
                        String parameterName = chunk.getText();
                        Object parameterValue = this.getParameterValue(parameterName);
                        sbuffer.append(String.valueOf(parameterValue));
                        continue block4;
                    }
                    case 2: {
                        sbuffer.append(this.getParameterReplacement(chunk.getText()));
                        this.parameterNames.add(chunk.getText());
                        continue block4;
                    }
                    default: {
                        sbuffer.append(chunk.getText());
                    }
                }
            }
            this.queryString = sbuffer.toString();
        }
    }

    protected String getQueryString() {
        return this.queryString;
    }

    protected List getCollectedParameterNames() {
        return this.parameterNames;
    }

    protected Object getParameterValue(String parameterName) {
        JRFillParameter parameter = this.getParameter(parameterName);
        return parameter.getValue();
    }

    protected JRFillParameter getParameter(String parameterName) {
        JRFillParameter parameter = (JRFillParameter)this.parametersMap.get(parameterName);
        if (parameter == null) {
            throw new JRRuntimeException("Parameter \"" + parameterName + "\" does not exist.");
        }
        return parameter;
    }

    protected abstract String getParameterReplacement(String var1);
}

