/*
 * Decompiled with CFR 0.152.
 */
package com.digitprop.tonic;

import com.digitprop.tonic.MenuItemUI;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuDragMouseEvent;
import javax.swing.event.MenuDragMouseListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import javax.swing.event.MenuListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;

public class MenuUI
extends MenuItemUI {
    protected ChangeListener changeListener;
    protected PropertyChangeListener propertyChangeListener;
    protected MenuListener menuListener;
    private static MenuListener sharedMenuListener;
    private int lastMnemonic = 0;
    private InputMap selectedWindowInputMap;
    private static final boolean TRACE = false;
    private static final boolean VERBOSE = false;
    private static final boolean DEBUG = false;

    public static ComponentUI createUI(JComponent x) {
        return new MenuUI();
    }

    protected void installDefaults() {
        super.installDefaults();
        ((JMenu)this.menuItem).setDelay(200);
    }

    protected String getPropertyPrefix() {
        return "Menu";
    }

    protected void installListeners() {
        super.installListeners();
        if (this.changeListener == null) {
            this.changeListener = this.createChangeListener(this.menuItem);
        }
        if (this.changeListener != null) {
            this.menuItem.addChangeListener(this.changeListener);
        }
        if (this.propertyChangeListener == null) {
            this.propertyChangeListener = this.createPropertyChangeListener(this.menuItem);
        }
        if (this.propertyChangeListener != null) {
            this.menuItem.addPropertyChangeListener(this.propertyChangeListener);
        }
        if (this.menuListener == null) {
            this.menuListener = this.createMenuListener(this.menuItem);
        }
        if (this.menuListener != null) {
            ((JMenu)this.menuItem).addMenuListener(this.menuListener);
        }
    }

    protected void installKeyboardActions() {
        super.installKeyboardActions();
        this.updateMnemonicBinding();
    }

    void updateMnemonicBinding() {
        int i;
        int mnemonic = this.menuItem.getModel().getMnemonic();
        int[] shortcutKeys = (int[])UIManager.get("Menu.shortcutKeys");
        if (mnemonic == this.lastMnemonic || shortcutKeys == null) {
            return;
        }
        if (this.lastMnemonic != 0 && this.windowInputMap != null) {
            i = 0;
            while (i < shortcutKeys.length) {
                this.windowInputMap.remove(KeyStroke.getKeyStroke(this.lastMnemonic, shortcutKeys[i], false));
                ++i;
            }
        }
        if (mnemonic != 0) {
            if (this.windowInputMap == null) {
                this.windowInputMap = this.createMyInputMap(2);
                SwingUtilities.replaceUIInputMap(this.menuItem, 2, this.windowInputMap);
            }
            i = 0;
            while (i < shortcutKeys.length) {
                this.windowInputMap.put(KeyStroke.getKeyStroke(mnemonic, shortcutKeys[i], false), "selectMenu");
                ++i;
            }
        }
        this.lastMnemonic = mnemonic;
    }

    protected void uninstallKeyboardActions() {
        super.uninstallKeyboardActions();
    }

    ActionMap getMyActionMap() {
        return this.createMyActionMap();
    }

    ActionMap createMyActionMap() {
        ActionMap am = super.createMyActionMap();
        if (am != null) {
            am.put("selectMenu", new PostAction((JMenu)this.menuItem, true));
        }
        return am;
    }

    protected MouseInputListener createMouseInputListener(JComponent c) {
        return new MouseInputHandler();
    }

    protected MenuListener createMenuListener(JComponent c) {
        if (sharedMenuListener == null) {
            sharedMenuListener = new MenuHandler();
        }
        return sharedMenuListener;
    }

    protected ChangeListener createChangeListener(JComponent c) {
        return null;
    }

    protected PropertyChangeListener createPropertyChangeListener(JComponent c) {
        return new PropertyChangeHandler();
    }

    protected void uninstallDefaults() {
        this.menuItem.setArmed(false);
        this.menuItem.setSelected(false);
        this.menuItem.resetKeyboardActions();
        super.uninstallDefaults();
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        if (this.changeListener != null) {
            this.menuItem.removeChangeListener(this.changeListener);
        }
        if (this.propertyChangeListener != null) {
            this.menuItem.removePropertyChangeListener(this.propertyChangeListener);
        }
        if (this.menuListener != null) {
            ((JMenu)this.menuItem).removeMenuListener(this.menuListener);
        }
        this.changeListener = null;
        this.propertyChangeListener = null;
        this.menuListener = null;
    }

    protected MenuDragMouseListener createMenuDragMouseListener(JComponent c) {
        return new MenuDragMouseHandler();
    }

    protected MenuKeyListener createMenuKeyListener(JComponent c) {
        return new MenuKeyHandler();
    }

    public Dimension getMaximumSize(JComponent c) {
        if (((JMenu)this.menuItem).isTopLevelMenu()) {
            Dimension d = c.getPreferredSize();
            return new Dimension(d.width, Short.MAX_VALUE);
        }
        return null;
    }

    protected void setupPostTimer(JMenu menu) {
        Timer timer = new Timer(menu.getDelay(), new PostAction(menu, false));
        timer.setRepeats(false);
        timer.start();
    }

    private static void appendPath(MenuElement[] path, MenuElement elem) {
        MenuElement[] newPath = new MenuElement[path.length + 1];
        System.arraycopy(path, 0, newPath, 0, path.length);
        newPath[path.length] = elem;
        MenuSelectionManager.defaultManager().setSelectedPath(newPath);
    }

    private static class PostAction
    extends AbstractAction {
        JMenu menu;
        boolean force = false;

        PostAction(JMenu menu, boolean shouldForce) {
            this.menu = menu;
            this.force = shouldForce;
        }

        public void actionPerformed(ActionEvent e) {
            MenuSelectionManager defaultManager = MenuSelectionManager.defaultManager();
            if (this.force) {
                Container cnt = this.menu.getParent();
                if (cnt != null && cnt instanceof JMenuBar) {
                    MenuElement[] subElements = this.menu.getPopupMenu().getSubElements();
                    MenuElement[] me = subElements.length > 0 ? new MenuElement[]{(MenuElement)((Object)cnt), this.menu, this.menu.getPopupMenu(), subElements[0]} : new MenuElement[]{(MenuElement)((Object)cnt), this.menu, this.menu.getPopupMenu()};
                    defaultManager.setSelectedPath(me);
                }
            } else {
                MenuElement[] path = defaultManager.getSelectedPath();
                if (path.length > 0 && path[path.length - 1] == this.menu) {
                    MenuUI.appendPath(path, this.menu.getPopupMenu());
                }
            }
        }

        public boolean isEnabled() {
            return this.menu.getModel().isEnabled();
        }
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            String prop = e.getPropertyName();
            if (prop.equals("mnemonic")) {
                MenuUI.this.updateMnemonicBinding();
            }
        }
    }

    protected class MouseInputHandler
    implements MouseInputListener {
        protected MouseInputHandler() {
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            MenuElement[] selectedPath;
            JMenu menu = (JMenu)MenuUI.this.menuItem;
            if (!menu.isEnabled()) {
                return;
            }
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            if (menu.isTopLevelMenu()) {
                if (menu.isSelected()) {
                    manager.clearSelectedPath();
                } else {
                    Container cnt = menu.getParent();
                    if (cnt != null && cnt instanceof JMenuBar) {
                        MenuElement[] me = new MenuElement[]{(MenuElement)((Object)cnt), menu};
                        manager.setSelectedPath(me);
                    }
                }
            }
            if ((selectedPath = manager.getSelectedPath()).length > 0 && selectedPath[selectedPath.length - 1] != menu.getPopupMenu()) {
                if (menu.isTopLevelMenu() || menu.getDelay() == 0) {
                    MenuUI.appendPath(selectedPath, menu.getPopupMenu());
                } else {
                    MenuUI.this.setupPostTimer(menu);
                }
            }
        }

        public void mouseReleased(MouseEvent e) {
            JMenu menu = (JMenu)MenuUI.this.menuItem;
            if (!menu.isEnabled()) {
                return;
            }
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            manager.processMouseEvent(e);
            if (!e.isConsumed()) {
                manager.clearSelectedPath();
            }
        }

        public void mouseEntered(MouseEvent e) {
            JMenu menu = (JMenu)MenuUI.this.menuItem;
            if (!menu.isEnabled()) {
                return;
            }
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            MenuElement[] selectedPath = manager.getSelectedPath();
            if (!menu.isTopLevelMenu()) {
                if (selectedPath.length <= 0 || selectedPath[selectedPath.length - 1] != menu.getPopupMenu()) {
                    if (menu.getDelay() == 0) {
                        MenuUI.appendPath(MenuUI.this.getPath(), menu.getPopupMenu());
                    } else {
                        manager.setSelectedPath(MenuUI.this.getPath());
                        MenuUI.this.setupPostTimer(menu);
                    }
                }
            } else if (selectedPath.length > 0 && selectedPath[0] == menu.getParent()) {
                MenuElement[] newPath = new MenuElement[]{(MenuElement)((Object)menu.getParent()), menu, menu.getPopupMenu()};
                manager.setSelectedPath(newPath);
            }
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mouseDragged(MouseEvent e) {
            JMenu menu = (JMenu)MenuUI.this.menuItem;
            if (!menu.isEnabled()) {
                return;
            }
            MenuSelectionManager.defaultManager().processMouseEvent(e);
        }

        public void mouseMoved(MouseEvent e) {
        }
    }

    private static class MenuHandler
    implements MenuListener {
        MenuHandler() {
        }

        public void menuSelected(MenuEvent e) {
        }

        public void menuDeselected(MenuEvent e) {
        }

        public void menuCanceled(MenuEvent e) {
            JMenu m = (JMenu)e.getSource();
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            if (manager.isComponentPartOfCurrentMenu(m)) {
                MenuSelectionManager.defaultManager().clearSelectedPath();
            }
        }
    }

    public class ChangeHandler
    implements ChangeListener {
        public JMenu menu;
        public MenuUI ui;
        public boolean isSelected = false;
        public Component wasFocused;

        public ChangeHandler(JMenu m, MenuUI ui) {
            this.menu = m;
            this.ui = ui;
        }

        public void stateChanged(ChangeEvent e) {
        }
    }

    private class MenuDragMouseHandler
    implements MenuDragMouseListener {
        MenuDragMouseHandler() {
        }

        public void menuDragMouseEntered(MenuDragMouseEvent e) {
        }

        public void menuDragMouseDragged(MenuDragMouseEvent e) {
            Component comp;
            if (!MenuUI.this.menuItem.isEnabled()) {
                return;
            }
            MenuSelectionManager manager = e.getMenuSelectionManager();
            MenuElement[] path = e.getPath();
            Point p = e.getPoint();
            if (p.x >= 0 && p.x < MenuUI.this.menuItem.getWidth() && p.y >= 0 && p.y < MenuUI.this.menuItem.getHeight()) {
                JMenu menu = (JMenu)MenuUI.this.menuItem;
                MenuElement[] selectedPath = manager.getSelectedPath();
                if (selectedPath.length <= 0 || selectedPath[selectedPath.length - 1] != menu.getPopupMenu()) {
                    if (menu.isTopLevelMenu() || menu.getDelay() == 0 || e.getID() == 506) {
                        MenuUI.appendPath(path, menu.getPopupMenu());
                    } else {
                        manager.setSelectedPath(path);
                        MenuUI.this.setupPostTimer(menu);
                    }
                }
            } else if (e.getID() == 502 && (comp = manager.componentForPoint(e.getComponent(), e.getPoint())) == null) {
                manager.clearSelectedPath();
            }
        }

        public void menuDragMouseExited(MenuDragMouseEvent e) {
        }

        public void menuDragMouseReleased(MenuDragMouseEvent e) {
        }
    }

    private class MenuKeyHandler
    implements MenuKeyListener {
        MenuKeyHandler() {
        }

        public void menuKeyTyped(MenuKeyEvent e) {
            int key = MenuUI.this.menuItem.getMnemonic();
            if (key == 0) {
                return;
            }
            MenuElement[] path = e.getPath();
            if (this.lower(key) == this.lower(e.getKeyChar())) {
                JPopupMenu popupMenu = ((JMenu)MenuUI.this.menuItem).getPopupMenu();
                MenuElement[] sub = popupMenu.getSubElements();
                if (sub.length > 0) {
                    MenuSelectionManager manager = e.getMenuSelectionManager();
                    MenuElement[] newPath = new MenuElement[path.length + 2];
                    System.arraycopy(path, 0, newPath, 0, path.length);
                    newPath[path.length] = popupMenu;
                    newPath[path.length + 1] = sub[0];
                    manager.setSelectedPath(newPath);
                }
                e.consume();
            }
        }

        public void menuKeyPressed(MenuKeyEvent e) {
        }

        public void menuKeyReleased(MenuKeyEvent e) {
        }

        private int lower(int ascii) {
            if (ascii >= 65 && ascii <= 90) {
                return ascii + 97 - 65;
            }
            return ascii;
        }
    }
}

