/*
 * Decompiled with CFR 0.152.
 */
package mondrian.jolap;

import javax.olap.OLAPException;
import javax.olap.query.dimensionfilters.RankingMemberFilter;
import javax.olap.query.enumerations.RankingType;
import javax.olap.query.enumerations.RankingTypeEnum;
import mondrian.jolap.MondrianDataBasedMemberFilter;
import mondrian.jolap.MondrianDimensionStepManager;
import mondrian.olap.Exp;
import mondrian.olap.FunCall;
import mondrian.olap.Literal;
import mondrian.olap.Util;

class MondrianRankingMemberFilter
extends MondrianDataBasedMemberFilter
implements RankingMemberFilter {
    private RankingType type;
    private int top;
    private boolean topPercent;
    private int bottom;
    private boolean bottomPercent;

    public MondrianRankingMemberFilter(MondrianDimensionStepManager manager) {
        super(manager);
    }

    Exp convert(Exp exp) throws OLAPException {
        Exp newExp = this._convert(exp);
        return this.combine(exp, newExp);
    }

    Exp _convert(Exp exp) throws OLAPException {
        if (this.type == RankingTypeEnum.BOTTOM) {
            if (this.bottomPercent) {
                return new FunCall("BottomPercent", new Exp[]{exp, Literal.create(new Integer(this.bottom))});
            }
            return new FunCall("Bottom", new Exp[]{exp, Literal.create(new Integer(this.bottom))});
        }
        if (this.type == RankingTypeEnum.TOP) {
            if (this.topPercent) {
                return new FunCall("TopPercent", new Exp[]{exp, Literal.create(new Integer(this.top))});
            }
            return new FunCall("Top", new Exp[]{exp, Literal.create(new Integer(this.top))});
        }
        if (this.type == RankingTypeEnum.TOP_BOTTOM) {
            throw new UnsupportedOperationException();
        }
        throw Util.newInternal("Unknown ranking type " + this.type);
    }

    public int getTop() throws OLAPException {
        return this.top;
    }

    public void setTop(int input) throws OLAPException {
        this.top = input;
    }

    public boolean isTopPercent() throws OLAPException {
        return this.topPercent;
    }

    public void setTopPercent(boolean input) throws OLAPException {
        this.topPercent = input;
    }

    public int getBottom() throws OLAPException {
        return this.bottom;
    }

    public void setBottom(int input) throws OLAPException {
        this.bottom = input;
    }

    public boolean isBottomPercent() throws OLAPException {
        return this.bottomPercent;
    }

    public void setBottomPercent(boolean input) throws OLAPException {
        this.bottomPercent = input;
    }

    public RankingType getType() throws OLAPException {
        return this.type;
    }

    public void setType(RankingType input) throws OLAPException {
        this.type = input;
    }
}

