/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import mondrian.olap.FunDef;
import mondrian.olap.Syntax;
import mondrian.olap.fun.FunUtil;
import mondrian.olap.fun.MultiResolver;
import mondrian.olap.fun.Resolver;
import mondrian.olap.fun.SimpleResolver;

public class FunInfo
implements Comparable {
    private final Syntax syntax;
    private final String name;
    private final String description;
    private final int[] returnTypes;
    private final int[][] parameterTypes;

    static FunInfo make(Resolver resolver) {
        FunInfo funInfo = null;
        if (resolver instanceof SimpleResolver) {
            FunDef funDef = ((SimpleResolver)resolver).getFunDef();
            funInfo = new FunInfo(funDef);
        } else {
            funInfo = resolver instanceof MultiResolver ? new FunInfo((MultiResolver)resolver) : new FunInfo(resolver);
        }
        return funInfo;
    }

    FunInfo(FunDef funDef) {
        this.syntax = funDef.getSyntax();
        this.name = funDef.getName();
        this.description = funDef.getDescription();
        this.returnTypes = new int[]{funDef.getReturnCategory()};
        this.parameterTypes = new int[][]{funDef.getParameterTypes()};
    }

    FunInfo(MultiResolver multiResolver) {
        this.syntax = multiResolver.getSyntax();
        this.name = multiResolver.getName();
        this.description = multiResolver.getDescription();
        String[] signatures = multiResolver.getSignatures();
        this.returnTypes = new int[signatures.length];
        this.parameterTypes = new int[signatures.length][];
        for (int i = 0; i < signatures.length; ++i) {
            this.returnTypes[i] = FunUtil.decodeReturnType(signatures[i]);
            this.parameterTypes[i] = FunUtil.decodeParameterTypes(signatures[i]);
        }
    }

    FunInfo(Resolver resolver) {
        this.syntax = resolver.getSyntax();
        this.name = resolver.getName();
        this.description = resolver.getDescription();
        this.returnTypes = null;
        this.parameterTypes = null;
    }

    public String[] getSignatures() {
        if (this.parameterTypes == null) {
            return null;
        }
        String[] sigs = new String[this.parameterTypes.length];
        for (int i = 0; i < sigs.length; ++i) {
            sigs[i] = this.syntax.getSignature(this.name, this.returnTypes[i], this.parameterTypes[i]);
        }
        return sigs;
    }

    public Syntax getSyntax() {
        return this.syntax;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public int[] getReturnTypes() {
        return this.returnTypes;
    }

    public int[][] getParameterTypes() {
        return this.parameterTypes;
    }

    public int compareTo(Object o) {
        FunInfo fi = (FunInfo)o;
        return this.name.compareTo(fi.name);
    }
}

