/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mondrian.olap.Dimension;
import mondrian.olap.EnumeratedValues;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.ExpBase;
import mondrian.olap.FunCall;
import mondrian.olap.FunDef;
import mondrian.olap.Hierarchy;
import mondrian.olap.Level;
import mondrian.olap.Literal;
import mondrian.olap.Member;
import mondrian.olap.SchemaReader;
import mondrian.olap.Syntax;
import mondrian.olap.Util;
import mondrian.olap.Validator;
import mondrian.olap.fun.MondrianEvaluationException;
import mondrian.olap.type.Type;
import mondrian.olap.type.TypeUtil;
import mondrian.resource.MondrianResource;
import org.apache.log4j.Logger;

public class FunUtil
extends Util {
    static final String[] emptyStringArray = new String[0];
    private static final boolean debug = false;
    private static final Double nullValue = new Double(0.0);
    static /* synthetic */ Class class$mondrian$olap$fun$FunUtil$MemberComparator;
    static /* synthetic */ Class class$mondrian$olap$fun$FunUtil$ArrayComparator;

    public static RuntimeException newEvalException(FunDef funDef, String message) {
        Util.discard((Object)funDef);
        return new MondrianEvaluationException(message);
    }

    static Exp getArgNoEval(Exp[] args, int index) {
        return FunUtil.getArgNoEval(args, index, null);
    }

    static Exp getArgNoEval(Exp[] args, int index, Exp defaultValue) {
        return index >= args.length ? defaultValue : args[index];
    }

    static Object getArg(Evaluator evaluator, Exp[] args, int index) {
        return FunUtil.getArg(evaluator, args, index, null);
    }

    static Object getArg(Evaluator evaluator, Exp[] args, int index, Object defaultValue) {
        return index >= args.length ? defaultValue : args[index].evaluate(evaluator);
    }

    static String getStringArg(Evaluator evaluator, Exp[] args, int index, String defaultValue) {
        return (String)FunUtil.getArg(evaluator, args, index, defaultValue);
    }

    static String getLiteralArg(Exp[] args, int i, String defaultValue, String[] allowedValues, FunDef funDef) {
        if (i >= args.length) {
            if (defaultValue == null) {
                throw FunUtil.newEvalException(funDef, "Required argument is missing");
            }
            return defaultValue;
        }
        Exp arg = args[i];
        if (!(arg instanceof Literal) || arg.getCategory() != 11) {
            throw FunUtil.newEvalException(funDef, "Expected a symbol, found '" + arg + "'");
        }
        String s = (String)((Literal)arg).getValue();
        StringBuffer sb = new StringBuffer(64);
        for (int j = 0; j < allowedValues.length; ++j) {
            String allowedValue = allowedValues[j];
            if (allowedValue.equalsIgnoreCase(s)) {
                return allowedValue;
            }
            if (j > 0) {
                sb.append(", ");
            }
            sb.append(allowedValue);
        }
        throw FunUtil.newEvalException(funDef, "Allowed values are: {" + sb + "}");
    }

    static int getLiteralArg(Exp[] args, int i, int defaultValue, EnumeratedValues allowedValues, FunDef funDef) {
        String literal = FunUtil.getLiteralArg(args, i, allowedValues.getName(defaultValue), allowedValues.getNames(), funDef);
        return literal == null ? -1 : allowedValues.getOrdinal(literal);
    }

    static boolean getBooleanArg(Evaluator evaluator, Exp[] args, int index, boolean defaultValue) {
        Object o = FunUtil.getArg(evaluator, args, index);
        return o == null ? defaultValue : (Boolean)o;
    }

    static Boolean getBooleanArg(Evaluator evaluator, Exp[] args, int index) {
        Object o = FunUtil.getArg(evaluator, args, index);
        return (Boolean)o;
    }

    static int getIntArg(Evaluator evaluator, Exp[] args, int index) {
        Object o = FunUtil.getScalarArg(evaluator, args, index);
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        if (o instanceof RuntimeException) {
            return 0;
        }
        String s = o.toString();
        double d = Double.valueOf(s);
        return (int)d;
    }

    static Object getScalarArg(Evaluator evaluator, Exp[] args, int index) {
        return args[index].evaluateScalar(evaluator);
    }

    static BigDecimal getDecimalArg(Evaluator evaluator, Exp[] args, int index) {
        Object o = FunUtil.getScalarArg(evaluator, args, index);
        if (o instanceof BigDecimal) {
            return (BigDecimal)o;
        }
        if (o instanceof BigInteger) {
            return new BigDecimal((BigInteger)o);
        }
        if (o instanceof Number) {
            return new BigDecimal(((Number)o).doubleValue());
        }
        throw Util.newInternal("arg " + o + " cannot be converted to BigDecimal");
    }

    protected static Double getDoubleArg(Evaluator evaluator, Exp[] args, int index) {
        return FunUtil.getDoubleArg(evaluator, args, index, nullValue);
    }

    static Double getDoubleArg(Evaluator evaluator, Exp[] args, int index, Double nullValue) {
        Object o = FunUtil.getScalarArg(evaluator, args, index);
        if (o instanceof Double) {
            return (Double)o;
        }
        if (o instanceof Number) {
            return new Double(((Number)o).doubleValue());
        }
        if (o instanceof Throwable) {
            return new Double(Double.NaN);
        }
        if (o == null || o == Util.nullValue) {
            return nullValue;
        }
        throw Util.newInternal("arg " + o + " cannot be converted to Double");
    }

    static Member getMemberArg(Evaluator evaluator, Exp[] args, int index, boolean fail) {
        if (index >= args.length) {
            if (fail) {
                throw FunUtil.newInternal("missing member argument");
            }
            return null;
        }
        Exp arg = args[index];
        Object o = arg.evaluate(evaluator);
        if (o instanceof Member) {
            return (Member)o;
        }
        if (o instanceof Hierarchy) {
            return evaluator.getContext(((Hierarchy)o).getDimension());
        }
        if (o instanceof Dimension) {
            return evaluator.getContext((Dimension)o);
        }
        throw FunUtil.newInternal("expecting a member, got " + o);
    }

    public static Member[] getTupleArg(Evaluator evaluator, Exp[] args, int index) {
        Exp arg = args[index];
        Object o = arg.evaluate(evaluator);
        return (Member[])o;
    }

    public static Member[] getTupleOrMemberArg(Evaluator evaluator, Exp[] args, int index) {
        Exp arg = args[index];
        Object o0 = arg.evaluate(evaluator);
        if (o0 == null) {
            return null;
        }
        if (o0 instanceof Member[]) {
            return (Member[])o0;
        }
        if (o0 instanceof Member) {
            return new Member[]{(Member)o0};
        }
        throw Util.newInternal("Expected tuple or member, got " + o0);
    }

    static Level getLevelArg(Evaluator evaluator, Exp[] args, int index, boolean fail) {
        if (index >= args.length) {
            if (fail) {
                throw FunUtil.newInternal("missing level argument");
            }
            return null;
        }
        Exp arg = args[index];
        Object o = arg.evaluate(evaluator);
        return (Level)o;
    }

    static Hierarchy getHierarchyArg(Evaluator evaluator, Exp[] args, int index, boolean fail) {
        if (index >= args.length) {
            if (fail) {
                throw FunUtil.newInternal("missing hierarchy argument");
            }
            return null;
        }
        Exp arg = args[index];
        Object o = arg.evaluate(evaluator);
        return (Hierarchy)o;
    }

    static Dimension getDimensionArg(Evaluator evaluator, Exp[] args, int index, boolean fail) {
        if (index >= args.length) {
            if (fail) {
                throw FunUtil.newInternal("missing dimension argument");
            }
            return null;
        }
        Exp arg = args[index];
        Object o = arg.evaluate(evaluator);
        return (Dimension)o;
    }

    static void checkCompatible(Exp left, Exp right, FunDef funDef) {
        Type rightType;
        Type leftType = TypeUtil.stripSetType(left.getTypeX());
        if (!TypeUtil.isUnionCompatible(leftType, rightType = TypeUtil.stripSetType(right.getTypeX()))) {
            throw FunUtil.newEvalException(funDef, "Expressions must have the same hierarchy");
        }
    }

    static boolean checkFlag(int value, int mask, boolean strict) {
        return strict ? (value & mask) == mask : (value & mask) != 0;
    }

    static void addUnique(List left, List right, Set set) {
        if (right == null) {
            return;
        }
        int n = right.size();
        for (int i = 0; i < n; ++i) {
            Object o;
            Object p = o = right.get(i);
            if (o instanceof Object[]) {
                p = new ArrayHolder((Object[])o);
            }
            if (!set.add(p)) continue;
            left.add(o);
        }
    }

    static List addMembers(SchemaReader schemaReader, List members, Hierarchy hierarchy) {
        Level[] levels = schemaReader.getHierarchyLevels(hierarchy);
        for (int i = 0; i < levels.length; ++i) {
            FunUtil.addMembers(schemaReader, members, levels[i]);
        }
        return members;
    }

    static List addMembers(SchemaReader schemaReader, List members, Level level) {
        Object[] levelMembers = schemaReader.getLevelMembers(level);
        FunUtil.addAll((List)members, (Object[])levelMembers);
        return members;
    }

    static void removeCalculatedMembers(List memberList) {
        for (int i = 0; i < memberList.size(); ++i) {
            Member member = (Member)memberList.get(i);
            if (!member.isCalculated()) continue;
            memberList.remove(i);
            --i;
        }
    }

    static boolean isAncestorOf(Member m0, Member m1, boolean strict) {
        if (strict) {
            if (m1 == null) {
                return false;
            }
            m1 = m1.getParentMember();
        }
        while (m1 != null) {
            if (m1 == m0) {
                return true;
            }
            m1 = m1.getParentMember();
        }
        return false;
    }

    static Map evaluateMembers(Evaluator evaluator, ExpBase exp, List members, boolean parentsToo) {
        Member[] constantTuple = exp.isConstantTuple();
        return constantTuple == null ? FunUtil._evaluateMembers(evaluator.push(), exp, members, parentsToo) : FunUtil.evaluateMembers(evaluator.push(constantTuple), members, parentsToo);
    }

    private static Map _evaluateMembers(Evaluator evaluator, ExpBase exp, List members, boolean parentsToo) {
        HashMap<Member, Object> mapMemberToValue = new HashMap<Member, Object>();
        int count = members.size();
        for (int i = 0; i < count; ++i) {
            Member member = (Member)members.get(i);
            do {
                evaluator.setContext(member);
                Object result = exp.evaluateScalar(evaluator);
                mapMemberToValue.put(member, result);
            } while (parentsToo && (member = member.getParentMember()) != null && !mapMemberToValue.containsKey(member));
        }
        return mapMemberToValue;
    }

    static Map evaluateMembers(Evaluator evaluator, List members, boolean parentsToo) {
        HashMap<Member, Object> mapMemberToValue = new HashMap<Member, Object>();
        int count = members.size();
        for (int i = 0; i < count; ++i) {
            Member member = (Member)members.get(i);
            do {
                evaluator.setContext(member);
                Object result = evaluator.evaluateCurrent();
                mapMemberToValue.put(member, result);
            } while (parentsToo && (member = member.getParentMember()) != null && !mapMemberToValue.containsKey(member));
        }
        return mapMemberToValue;
    }

    static void sort(Evaluator evaluator, List members, ExpBase exp, boolean desc, boolean brk) {
        Comparator comparator;
        if (members.isEmpty()) {
            return;
        }
        Object first = members.get(0);
        Map mapMemberToValue = null;
        if (first instanceof Member) {
            boolean parentsToo = !brk;
            mapMemberToValue = FunUtil.evaluateMembers(evaluator, exp, members, parentsToo);
            comparator = brk ? new BreakMemberComparator(mapMemberToValue, desc) : new HierarchicalMemberComparator(mapMemberToValue, desc);
        } else {
            Util.assertTrue(first instanceof Member[]);
            int arity = ((Member[])first).length;
            if (brk) {
                comparator = new BreakArrayComparator(evaluator, exp, arity);
                if (desc) {
                    comparator = new ReverseComparator(comparator);
                }
            } else {
                comparator = new HierarchicalArrayComparator(evaluator, exp, arity, desc);
            }
        }
        Collections.sort(members, comparator);
    }

    static void hierarchize(List members, boolean post) {
        Comparator comparator;
        if (members.isEmpty()) {
            return;
        }
        Object first = members.get(0);
        if (first instanceof Member) {
            comparator = new HierarchizeComparator(post);
        } else {
            Util.assertTrue(first instanceof Member[]);
            int arity = ((Member[])first).length;
            comparator = new HierarchizeArrayComparator(arity, post);
        }
        Collections.sort(members, comparator);
    }

    static int sign(double d) {
        return d == 0.0 ? 0 : (d < 0.0 ? -1 : 1);
    }

    static int compareValues(double d1, double d2) {
        return d1 == d2 ? 0 : (d1 < d2 ? -1 : 1);
    }

    static int compareValues(int i, int j) {
        return i == j ? 0 : (i < j ? -1 : 1);
    }

    static int compareValues(Object value0, Object value1) {
        if (value0 == value1) {
            return 0;
        }
        if (value0 == null) {
            return -1;
        }
        if (value1 == null) {
            return 1;
        }
        if (value0 instanceof RuntimeException || value1 instanceof RuntimeException) {
            return 0;
        }
        if (value0 == Util.nullValue) {
            return -1;
        }
        if (value1 == Util.nullValue) {
            return 1;
        }
        if (value0 instanceof String) {
            return ((String)value0).compareTo((String)value1);
        }
        if (value0 instanceof Number) {
            return FunUtil.compareValues(((Number)value0).doubleValue(), ((Number)value1).doubleValue());
        }
        throw Util.newInternal("cannot compare " + value0);
    }

    static void toPercent(List members, Map mapMemberToValue) {
        int i;
        double total = 0.0;
        int numMembers = members.size();
        for (i = 0; i < numMembers; ++i) {
            Object o = mapMemberToValue.get(members.get(i));
            if (!(o instanceof Number)) continue;
            total += ((Number)o).doubleValue();
        }
        for (i = 0; i < numMembers; ++i) {
            Object member = members.get(i);
            Object o = mapMemberToValue.get(member);
            if (!(o instanceof Number)) continue;
            double d = ((Number)o).doubleValue();
            mapMemberToValue.put(member, new Double(d / total * 100.0));
        }
    }

    static Object topOrBottom(Evaluator evaluator, List members, ExpBase exp, boolean isTop, boolean isPercent, double target) {
        Map mapMemberToValue = FunUtil.evaluateMembers(evaluator, exp, members, false);
        BreakMemberComparator comparator = new BreakMemberComparator(mapMemberToValue, isTop);
        Collections.sort(members, comparator);
        if (isPercent) {
            FunUtil.toPercent(members, mapMemberToValue);
        }
        double runningTotal = 0.0;
        int numMembers = members.size();
        int nullCount = 0;
        for (int i = 0; i < numMembers; ++i) {
            if (runningTotal >= target) {
                members = members.subList(0, i);
                break;
            }
            Object o = mapMemberToValue.get(members.get(i));
            if (o instanceof Number) {
                runningTotal += ((Number)o).doubleValue();
                continue;
            }
            if (o instanceof Exception) continue;
            if (o instanceof Util.NullCellValue) {
                ++nullCount;
                continue;
            }
            throw Util.newInternal("got " + o + " when expecting Number");
        }
        if (numMembers > 0 && isPercent && nullCount == numMembers) {
            return isTop ? members.subList(0, 1) : members.subList(numMembers - 1, numMembers);
        }
        return members;
    }

    public static Syntax decodeSyntacticType(String flags) {
        char c = flags.charAt(0);
        switch (c) {
            case 'p': {
                return Syntax.Property;
            }
            case 'f': {
                return Syntax.Function;
            }
            case 'm': {
                return Syntax.Method;
            }
            case 'i': {
                return Syntax.Infix;
            }
            case 'P': {
                return Syntax.Prefix;
            }
            case 'I': {
                return Syntax.Internal;
            }
        }
        throw FunUtil.newInternal("unknown syntax code '" + c + "' in string '" + flags + "'");
    }

    public static int decodeReturnType(String flags) {
        int returnType = FunUtil.decodeType(flags, 1);
        if ((returnType & 0x1F) != returnType) {
            throw FunUtil.newInternal("bad return code flag in flags '" + flags + "'");
        }
        return returnType;
    }

    public static int decodeType(String flags, int offset) {
        char c = flags.charAt(offset);
        switch (c) {
            case 'a': {
                return 1;
            }
            case 'd': {
                return 2;
            }
            case 'h': {
                return 3;
            }
            case 'l': {
                return 4;
            }
            case 'b': {
                return 5;
            }
            case 'm': {
                return 6;
            }
            case 'N': {
                return 71;
            }
            case 'n': {
                return 7;
            }
            case 'I': {
                return 79;
            }
            case 'i': {
                return 15;
            }
            case 'x': {
                return 8;
            }
            case '#': {
                return 73;
            }
            case 'S': {
                return 9;
            }
            case 't': {
                return 10;
            }
            case 'v': {
                return 13;
            }
            case 'y': {
                return 11;
            }
        }
        throw FunUtil.newInternal("unknown type code '" + c + "' in string '" + flags + "'");
    }

    public static int[] decodeParameterTypes(String flags) {
        int[] parameterTypes = new int[flags.length() - 2];
        for (int i = 0; i < parameterTypes.length; ++i) {
            parameterTypes[i] = FunUtil.decodeType(flags, i + 2);
        }
        return parameterTypes;
    }

    public static void sortValuesDesc(Object[] values) {
        Arrays.sort(values, DescendingValueComparator.instance);
    }

    public static int searchValuesDesc(Object[] values, Object value) {
        return Arrays.binarySearch(values, value, DescendingValueComparator.instance);
    }

    static Object median(Evaluator evaluator, List members, ExpBase exp) {
        SetWrapper sw = FunUtil.evaluateSet(evaluator, members, exp);
        if (sw.errorCount > 0) {
            return new Double(Double.NaN);
        }
        if (sw.v.size() == 0) {
            return Util.nullValue;
        }
        double[] asArray = new double[sw.v.size()];
        for (int i = 0; i < asArray.length; ++i) {
            asArray[i] = (Double)sw.v.get(i);
        }
        Arrays.sort(asArray);
        int length = asArray.length;
        Double result = (length & 1) == 1 ? new Double(asArray[length >> 1]) : new Double((asArray[(length >> 1) - 1] + asArray[length >> 1]) / 2.0);
        return result;
    }

    static Object quartile(Evaluator evaluator, List members, ExpBase exp, int range) {
        Util.assertPrecondition(range >= 1 && range <= 3, "range >= 1 && range <= 3");
        SetWrapper sw = FunUtil.evaluateSet(evaluator, members, exp);
        if (sw.errorCount > 0) {
            return new Double(Double.NaN);
        }
        if (sw.v.size() == 0) {
            return Util.nullValue;
        }
        double[] asArray = new double[sw.v.size()];
        for (int i = 0; i < asArray.length; ++i) {
            asArray[i] = (Double)sw.v.get(i);
        }
        Arrays.sort(asArray);
        double dm = asArray.length * range / 4;
        int median = (int)Math.floor(dm);
        return dm == (double)median && median < asArray.length - 1 ? new Double((asArray[median] + asArray[median + 1]) / 2.0) : new Double(asArray[median]);
    }

    public static Object min(Evaluator evaluator, List members, Exp exp) {
        SetWrapper sw = FunUtil.evaluateSet(evaluator, members, (ExpBase)exp);
        if (sw.errorCount > 0) {
            return new Double(Double.NaN);
        }
        if (sw.v.size() == 0) {
            return Util.nullValue;
        }
        double min = Double.MAX_VALUE;
        for (int i = 0; i < sw.v.size(); ++i) {
            double iValue = (Double)sw.v.get(i);
            if (!(iValue < min)) continue;
            min = iValue;
        }
        return new Double(min);
    }

    public static Object max(Evaluator evaluator, List members, Exp exp) {
        SetWrapper sw = FunUtil.evaluateSet(evaluator, members, (ExpBase)exp);
        if (sw.errorCount > 0) {
            return new Double(Double.NaN);
        }
        if (sw.v.size() == 0) {
            return Util.nullValue;
        }
        double max = Double.MIN_VALUE;
        for (int i = 0; i < sw.v.size(); ++i) {
            double iValue = (Double)sw.v.get(i);
            if (!(iValue > max)) continue;
            max = iValue;
        }
        return new Double(max);
    }

    static Object var(Evaluator evaluator, List members, ExpBase exp, boolean biased) {
        SetWrapper sw = FunUtil.evaluateSet(evaluator, members, exp);
        return FunUtil._var(sw, biased);
    }

    private static Object _var(SetWrapper sw, boolean biased) {
        if (sw.errorCount > 0) {
            return new Double(Double.NaN);
        }
        if (sw.v.size() == 0) {
            return Util.nullValue;
        }
        double stdev = 0.0;
        double avg = FunUtil._avg(sw);
        for (int i = 0; i < sw.v.size(); ++i) {
            stdev += Math.pow((Double)sw.v.get(i) - avg, 2.0);
        }
        int n = sw.v.size();
        if (!biased) {
            --n;
        }
        return new Double(stdev / (double)n);
    }

    static Object correlation(Evaluator evaluator, List members, ExpBase exp1, ExpBase exp2) {
        SetWrapper sw1 = FunUtil.evaluateSet(evaluator, members, exp1);
        SetWrapper sw2 = FunUtil.evaluateSet(evaluator, members, exp2);
        Object covar = FunUtil._covariance(sw1, sw2, false);
        Object var1 = FunUtil._var(sw1, false);
        Object var2 = FunUtil._var(sw2, false);
        if (covar instanceof Double && var1 instanceof Double && var2 instanceof Double) {
            return new Double((Double)covar / Math.sqrt((Double)var1 * (Double)var2));
        }
        return Util.nullValue;
    }

    static Object covariance(Evaluator evaluator, List members, ExpBase exp1, ExpBase exp2, boolean biased) {
        SetWrapper sw1 = FunUtil.evaluateSet(evaluator.push(), members, exp1);
        SetWrapper sw2 = FunUtil.evaluateSet(evaluator.push(), members, exp2);
        return FunUtil._covariance(sw1, sw2, biased);
    }

    private static Object _covariance(SetWrapper sw1, SetWrapper sw2, boolean biased) {
        if (sw1.v.size() != sw2.v.size()) {
            return Util.nullValue;
        }
        double avg1 = FunUtil._avg(sw1);
        double avg2 = FunUtil._avg(sw2);
        double covar = 0.0;
        for (int i = 0; i < sw1.v.size(); ++i) {
            double diff1 = (Double)sw1.v.get(i) - avg1;
            double diff2 = (Double)sw2.v.get(i) - avg2;
            covar += diff1 * diff2;
        }
        int n = sw1.v.size();
        if (!biased) {
            --n;
        }
        return new Double(covar / (double)n);
    }

    static Object stdev(Evaluator evaluator, List members, ExpBase exp, boolean biased) {
        Object o = FunUtil.var(evaluator, members, exp, biased);
        return o instanceof Double ? new Double(Math.sqrt((Double)o)) : o;
    }

    public static Object avg(Evaluator evaluator, List members, Exp exp) {
        SetWrapper sw = FunUtil.evaluateSet(evaluator, members, (ExpBase)exp);
        return sw.errorCount > 0 ? new Double(Double.NaN) : (sw.v.size() == 0 ? Util.nullValue : new Double(FunUtil._avg(sw)));
    }

    private static double _avg(SetWrapper sw) {
        double sum = 0.0;
        for (int i = 0; i < sw.v.size(); ++i) {
            sum += ((Double)sw.v.get(i)).doubleValue();
        }
        return sum / (double)sw.v.size();
    }

    public static Object sum(Evaluator evaluator, List members, Exp exp) {
        SetWrapper sw = FunUtil.evaluateSet(evaluator, members, (ExpBase)exp);
        if (sw.errorCount > 0) {
            return new Double(Double.NaN);
        }
        if (sw.v.size() == 0) {
            return Util.nullValue;
        }
        double sum = 0.0;
        for (int i = 0; i < sw.v.size(); ++i) {
            sum += ((Double)sw.v.get(i)).doubleValue();
        }
        return new Double(sum);
    }

    public static Object count(Evaluator evaluator, List members, boolean includeEmpty) {
        if (members == null) {
            return new Double(0.0);
        }
        if (includeEmpty) {
            return new Double(members.size());
        }
        int retval = 0;
        for (int i = 0; i < members.size(); ++i) {
            Object member = members.get(i);
            if (member instanceof Member) {
                evaluator.setContext((Member)member);
            } else {
                evaluator.setContext((Member[])member);
            }
            Object o = evaluator.evaluateCurrent();
            if (o == Util.nullValue || o == null) continue;
            ++retval;
        }
        return new Double(retval);
    }

    static SetWrapper evaluateSet(Evaluator evaluator, List members, ExpBase exp) {
        Util.assertPrecondition(exp != null, "exp != null");
        SetWrapper retval = new SetWrapper();
        Iterator it = members.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (obj instanceof Member[]) {
                evaluator.setContext((Member[])obj);
            } else {
                evaluator.setContext((Member)obj);
            }
            Object o = exp.evaluateScalar(evaluator);
            if (o == null || o == Util.nullValue) {
                ++retval.nullCount;
                continue;
            }
            if (o instanceof Throwable) {
                ++retval.errorCount;
                continue;
            }
            if (o instanceof Double) {
                retval.v.add(o);
                continue;
            }
            if (o instanceof Number) {
                retval.v.add(new Double(((Number)o).doubleValue()));
                continue;
            }
            retval.v.add(o);
        }
        return retval;
    }

    static SetWrapper[] evaluateSet(Evaluator evaluator, List members, ExpBase[] exps) {
        Util.assertPrecondition(exps != null, "exps != null");
        SetWrapper[] retvals = new SetWrapper[exps.length];
        for (int i = 0; i < exps.length; ++i) {
            retvals[i] = new SetWrapper();
        }
        Iterator it = members.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (obj instanceof Member[]) {
                evaluator.setContext((Member[])obj);
            } else {
                evaluator.setContext((Member)obj);
            }
            for (int i = 0; i < exps.length; ++i) {
                ExpBase exp = exps[i];
                SetWrapper retval = retvals[i];
                Object o = exp.evaluateScalar(evaluator);
                if (o == null || o == Util.nullValue) {
                    ++retval.nullCount;
                    retval.v.add(null);
                    continue;
                }
                if (o instanceof Throwable) {
                    ++retval.errorCount;
                    retval.v.add(null);
                    continue;
                }
                if (o instanceof Double) {
                    retval.v.add(o);
                    continue;
                }
                if (o instanceof Number) {
                    retval.v.add(new Double(((Number)o).doubleValue()));
                    continue;
                }
                retval.v.add(o);
            }
        }
        return retvals;
    }

    static List periodsToDate(Evaluator evaluator, Level level, Member member) {
        Member m;
        if (member == null) {
            member = evaluator.getContext(level.getHierarchy().getDimension());
        }
        for (m = member; m != null && m.getLevel() != level; m = m.getParentMember()) {
        }
        ArrayList members = new ArrayList();
        if (m != null) {
            SchemaReader reader = evaluator.getSchemaReader();
            m = Util.getFirstDescendantOnLevel(reader, m, member.getLevel());
            reader.getMemberRange(level, m, member, members);
        }
        return members;
    }

    static List memberRange(Evaluator evaluator, Member startMember, Member endMember) {
        Level level = startMember.getLevel();
        FunUtil.assertTrue(level == endMember.getLevel());
        ArrayList members = new ArrayList();
        evaluator.getSchemaReader().getMemberRange(level, startMember, endMember, members);
        if (members.isEmpty()) {
            evaluator.getSchemaReader().getMemberRange(level, endMember, startMember, members);
        }
        return members;
    }

    static Member cousin(SchemaReader schemaReader, Member member, Member ancestorMember) {
        if (ancestorMember.isNull()) {
            return ancestorMember;
        }
        if (member.getHierarchy() != ancestorMember.getHierarchy()) {
            throw MondrianResource.instance().CousinHierarchyMismatch.ex(member.getUniqueName(), ancestorMember.getUniqueName());
        }
        if (member.getLevel().getDepth() < ancestorMember.getLevel().getDepth()) {
            return member.getHierarchy().getNullMember();
        }
        Member cousin = FunUtil.cousin2(schemaReader, member, ancestorMember);
        if (cousin == null) {
            cousin = member.getHierarchy().getNullMember();
        }
        return cousin;
    }

    private static Member cousin2(SchemaReader schemaReader, Member member1, Member member2) {
        if (member1.getLevel() == member2.getLevel()) {
            return member2;
        }
        Member uncle = FunUtil.cousin2(schemaReader, member1.getParentMember(), member2);
        if (uncle == null) {
            return null;
        }
        int ordinal = Util.getMemberOrdinalInParent(schemaReader, member1);
        Member[] cousins = schemaReader.getMemberChildren(uncle);
        if (cousins.length <= ordinal) {
            return null;
        }
        return cousins[ordinal];
    }

    static Member ancestor(Evaluator evaluator, Member member, int distance, Level targetLevel) {
        if (targetLevel != null && member.getHierarchy() != targetLevel.getHierarchy()) {
            throw MondrianResource.instance().MemberNotInLevelHierarchy.ex(member.getUniqueName(), targetLevel.getUniqueName());
        }
        if (distance == 0) {
            return member;
        }
        if (distance < 0) {
            return member.getHierarchy().getNullMember();
        }
        Member[] ancestors = member.getAncestorMembers();
        SchemaReader schemaReader = evaluator.getSchemaReader();
        Member result = member.getHierarchy().getNullMember();
        for (int i = 0; i < ancestors.length; ++i) {
            Member ancestorMember = ancestors[i];
            if (targetLevel != null) {
                if (ancestorMember.getLevel() != targetLevel) continue;
                if (schemaReader.isVisible(ancestorMember)) {
                    result = ancestorMember;
                    break;
                }
                result = member.getHierarchy().getNullMember();
                break;
            }
            if (!schemaReader.isVisible(ancestorMember) || --distance != 0) continue;
            if (targetLevel == null || ancestorMember.getLevel() == targetLevel) {
                result = ancestorMember;
                break;
            }
            result = member.getHierarchy().getNullMember();
            break;
        }
        return result;
    }

    public static int compareHierarchically(Member m1, Member m2, boolean post) {
        Member prev2;
        Member prev1;
        if (FunUtil.equals(m1, m2)) {
            return 0;
        }
        while (true) {
            int depth2;
            int depth1;
            if ((depth1 = m1.getDepth()) < (depth2 = m2.getDepth())) {
                if (!FunUtil.equals(m1, m2 = m2.getParentMember())) continue;
                return post ? 1 : -1;
            }
            if (depth1 > depth2) {
                if (!FunUtil.equals(m1 = m1.getParentMember(), m2)) continue;
                return post ? -1 : 1;
            }
            prev1 = m1;
            prev2 = m2;
            if (FunUtil.equals(m1 = m1.getParentMember(), m2 = m2.getParentMember())) break;
        }
        return FunUtil.compareSiblingMembers(prev1, prev2);
    }

    static int compareSiblingMembers(Member m1, Member m2) {
        int ordinal2;
        int ordinal1 = m1.getOrdinal();
        return ordinal1 == (ordinal2 = m2.getOrdinal()) ? m1.compareTo(m2) : (ordinal1 < ordinal2 ? -1 : 1);
    }

    public static boolean callDependsOnSet(FunCall call, Dimension dimension) {
        Exp[] args = call.getArgs();
        if (args[0].dependsOn(dimension)) {
            return true;
        }
        if (args[0].getTypeX().usesDimension(dimension)) {
            return false;
        }
        if (args.length == 1) {
            return true;
        }
        for (int i = 1; i < args.length; ++i) {
            Exp exp = args[i];
            if (!exp.dependsOn(dimension)) continue;
            return true;
        }
        return false;
    }

    public static Exp convert(Exp fromExp, int to, Validator validator) {
        Exp exp = FunUtil.convert_(fromExp, to, validator);
        if (exp == null) {
            throw FunUtil.newInternal("cannot convert " + fromExp + " to " + to);
        }
        return validator.validate(exp, false);
    }

    private static Exp convert_(Exp fromExp, int to, Validator validator) {
        int from = fromExp.getCategory();
        if (from == to) {
            return fromExp;
        }
        switch (from) {
            case 1: {
                return null;
            }
            case 2: {
                switch (to) {
                    case 3: {
                        return new FunCall("Hierarchy", Syntax.Property, new Exp[]{new FunCall("CurrentMember", Syntax.Property, new Exp[]{fromExp})});
                    }
                    case 4: {
                        return new FunCall("Level", Syntax.Property, new Exp[]{new FunCall("CurrentMember", Syntax.Property, new Exp[]{fromExp})});
                    }
                    case 6: 
                    case 10: {
                        return new FunCall("CurrentMember", Syntax.Property, new Exp[]{fromExp});
                    }
                }
                return null;
            }
            case 3: {
                switch (to) {
                    case 2: {
                        return new FunCall("Dimension", Syntax.Property, new Exp[]{fromExp});
                    }
                }
                return null;
            }
            case 4: {
                switch (to) {
                    case 2: {
                        return new FunCall("Dimension", Syntax.Property, new Exp[]{fromExp});
                    }
                    case 3: {
                        return new FunCall("Hierarchy", Syntax.Property, new Exp[]{fromExp});
                    }
                }
                return null;
            }
            case 5: {
                return null;
            }
            case 6: {
                switch (to) {
                    case 2: {
                        return new FunCall("Dimension", Syntax.Property, new Exp[]{fromExp});
                    }
                    case 3: {
                        return new FunCall("Hierarchy", Syntax.Property, new Exp[]{fromExp});
                    }
                    case 4: {
                        return new FunCall("Level", Syntax.Property, new Exp[]{fromExp});
                    }
                    case 10: {
                        return fromExp;
                    }
                    case 71: 
                    case 73: {
                        return new FunCall("Value", Syntax.Property, new Exp[]{fromExp});
                    }
                    case 7: 
                    case 9: 
                    case 13: {
                        return validator.getFunTable().createValueFunCall(fromExp, validator);
                    }
                }
                return null;
            }
            case 71: 
            case 79: {
                switch (to) {
                    case 7: 
                    case 13: 
                    case 15: {
                        return fromExp;
                    }
                }
                return null;
            }
            case 15: {
                switch (to) {
                    case 7: 
                    case 13: {
                        return fromExp;
                    }
                    case 71: 
                    case 79: {
                        return validator.getFunTable().createValueFunCall(fromExp, validator);
                    }
                }
                return null;
            }
            case 7: {
                switch (to) {
                    case 13: 
                    case 15: {
                        return fromExp;
                    }
                    case 71: 
                    case 79: {
                        return validator.getFunTable().createValueFunCall(fromExp, validator);
                    }
                }
                return null;
            }
            case 8: {
                return null;
            }
            case 73: {
                switch (to) {
                    case 9: 
                    case 13: {
                        return fromExp;
                    }
                }
                return null;
            }
            case 9: {
                switch (to) {
                    case 13: {
                        return fromExp;
                    }
                    case 73: {
                        return validator.getFunTable().createValueFunCall(fromExp, validator);
                    }
                }
                return null;
            }
            case 10: {
                switch (to) {
                    case 7: 
                    case 9: 
                    case 13: {
                        return validator.getFunTable().createValueFunCall(fromExp, validator);
                    }
                }
                return null;
            }
            case 13: {
                return null;
            }
            case 11: {
                return null;
            }
        }
        throw FunUtil.newInternal("unknown category " + from);
    }

    public static boolean canConvert(Exp fromExp, int to, int[] conversionCount) {
        int from = fromExp.getCategory();
        if (from == to) {
            return true;
        }
        switch (from) {
            case 1: {
                return false;
            }
            case 2: {
                switch (to) {
                    case 3: 
                    case 4: 
                    case 6: 
                    case 10: {
                        conversionCount[0] = conversionCount[0] + 1;
                        return true;
                    }
                }
                return false;
            }
            case 3: {
                switch (to) {
                    case 2: {
                        conversionCount[0] = conversionCount[0] + 1;
                        return true;
                    }
                }
                return false;
            }
            case 4: {
                switch (to) {
                    case 2: {
                        conversionCount[0] = conversionCount[0] + 2;
                        return true;
                    }
                    case 3: {
                        conversionCount[0] = conversionCount[0] + 1;
                        return true;
                    }
                }
                return false;
            }
            case 5: {
                return false;
            }
            case 6: {
                switch (to) {
                    case 2: 
                    case 3: 
                    case 4: 
                    case 10: {
                        conversionCount[0] = conversionCount[0] + 1;
                        return true;
                    }
                    case 7: {
                        conversionCount[0] = conversionCount[0] + 1;
                        return true;
                    }
                    case 9: 
                    case 13: {
                        conversionCount[0] = conversionCount[0] + 2;
                        return true;
                    }
                }
                return false;
            }
            case 71: {
                return to == 13 || to == 7;
            }
            case 7: {
                return to == 13 || to == 15 || to == 79 || to == 71;
            }
            case 15: {
                return to == 13 || to == 79 || to == 7 || to == 71;
            }
            case 8: {
                return false;
            }
            case 73: {
                return to == 13 || to == 9;
            }
            case 9: {
                return to == 13 || to == 73;
            }
            case 10: {
                return to == 13 || to == 7;
            }
            case 13: {
                return false;
            }
            case 11: {
                return false;
            }
        }
        throw FunUtil.newInternal("unknown category " + from);
    }

    private static class DescendingValueComparator
    implements Comparator {
        static final DescendingValueComparator instance = new DescendingValueComparator();

        private DescendingValueComparator() {
        }

        public int compare(Object o1, Object o2) {
            return -FunUtil.compareValues(o1, o2);
        }
    }

    static class SetWrapper {
        List v = new ArrayList();
        public int errorCount = 0;
        public int nullCount = 0;

        SetWrapper() {
        }
    }

    protected static class ArrayHolder {
        private Object[] a;

        ArrayHolder(Object[] a) {
            this.a = a;
        }

        public int hashCode() {
            int h = 0;
            for (int i = 0; i < this.a.length; ++i) {
                Object o = this.a[i];
                int rotated = h << 4 | h >> 28 & 0xF;
                h = rotated ^ o.hashCode();
            }
            return h;
        }

        public boolean equals(Object o) {
            return o instanceof ArrayHolder && ArrayHolder.equals(this.a, ((ArrayHolder)o).a);
        }

        private static boolean equals(Object[] a1, Object[] a2) {
            if (a1.length != a2.length) {
                return false;
            }
            for (int i = 0; i < a1.length; ++i) {
                if (a1[i].equals(a2[i])) continue;
                return false;
            }
            return true;
        }
    }

    private static class ReverseComparator
    implements Comparator {
        Comparator comparator;

        ReverseComparator(Comparator comparator) {
            this.comparator = comparator;
        }

        public int compare(Object o1, Object o2) {
            int c = this.comparator.compare(o1, o2);
            return -c;
        }
    }

    private static class HierarchizeComparator
    implements Comparator {
        private final boolean post;

        HierarchizeComparator(boolean post) {
            this.post = post;
        }

        public int compare(Object o1, Object o2) {
            return FunUtil.compareHierarchically((Member)o1, (Member)o2, this.post);
        }
    }

    private static class HierarchizeArrayComparator
    extends ArrayComparator {
        private final boolean post;

        HierarchizeArrayComparator(int arity, boolean post) {
            super(arity);
            this.post = post;
        }

        protected int compare(Member[] a1, Member[] a2) {
            for (int i = 0; i < this.arity; ++i) {
                Member m1 = a1[i];
                Member m2 = a2[i];
                int c = FunUtil.compareHierarchically(m1, m2, this.post);
                if (c != 0) {
                    return c;
                }
                Util.assertTrue(m1.equals(m2));
            }
            return 0;
        }
    }

    private static class BreakArrayComparator
    extends ArrayExpComparator {
        BreakArrayComparator(Evaluator evaluator, Exp exp, int arity) {
            super(evaluator, exp, arity);
        }

        protected int compare(Member[] a1, Member[] a2) {
            this.evaluator.setContext(a1);
            Object v1 = this.exp.evaluateScalar(this.evaluator);
            this.evaluator.setContext(a2);
            Object v2 = this.exp.evaluateScalar(this.evaluator);
            return FunUtil.compareValues(v1, v2);
        }
    }

    private static class HierarchicalArrayComparator
    extends ArrayExpComparator {
        private final boolean desc;

        HierarchicalArrayComparator(Evaluator evaluator, Exp exp, int arity, boolean desc) {
            super(evaluator, exp, arity);
            this.desc = desc;
        }

        protected int compare(Member[] a1, Member[] a2) {
            Member m2;
            Member m1;
            int c = 0;
            this.evaluator = this.evaluator.push();
            for (int i = 0; i < this.arity && (c = this.compareHierarchicallyButSiblingsByValue(m1 = a1[i], m2 = a2[i])) == 0; ++i) {
                Util.assertTrue(m1.equals(m2));
                this.evaluator.setContext(m1);
            }
            this.evaluator = this.evaluator.pop();
            return c;
        }

        protected int compareHierarchicallyButSiblingsByValue(Member m1, Member m2) {
            Member prev2;
            Member prev1;
            if (FunUtil.equals(m1, m2)) {
                return 0;
            }
            while (true) {
                int depth2;
                int depth1;
                if ((depth1 = m1.getDepth()) < (depth2 = m2.getDepth())) {
                    if (!FunUtil.equals(m1, m2 = m2.getParentMember())) continue;
                    return -1;
                }
                if (depth1 > depth2) {
                    if (!FunUtil.equals(m1 = m1.getParentMember(), m2)) continue;
                    return 1;
                }
                prev1 = m1;
                prev2 = m2;
                if (FunUtil.equals(m1 = m1.getParentMember(), m2 = m2.getParentMember())) break;
            }
            int c = this.compareByValue(prev1, prev2);
            if (c == 0) {
                c = FunUtil.compareSiblingMembers(prev1, prev2);
            }
            return this.desc ? -c : c;
        }

        private int compareByValue(Member m1, Member m2) {
            Member old = this.evaluator.setContext(m1);
            Object v1 = this.exp.evaluateScalar(this.evaluator);
            this.evaluator.setContext(m2);
            Object v2 = this.exp.evaluateScalar(this.evaluator);
            this.evaluator.setContext(old);
            int c = FunUtil.compareValues(v1, v2);
            return c;
        }
    }

    private static abstract class ArrayExpComparator
    extends ArrayComparator {
        Evaluator evaluator;
        final Exp exp;

        ArrayExpComparator(Evaluator evaluator, Exp exp, int arity) {
            super(arity);
            this.evaluator = evaluator;
            this.exp = exp;
        }
    }

    private static abstract class ArrayComparator
    implements Comparator {
        private static final Logger LOGGER = Logger.getLogger((Class)(class$mondrian$olap$fun$FunUtil$ArrayComparator == null ? (class$mondrian$olap$fun$FunUtil$ArrayComparator = FunUtil.class$("mondrian.olap.fun.FunUtil$ArrayComparator")) : class$mondrian$olap$fun$FunUtil$ArrayComparator));
        int arity;

        ArrayComparator(int arity) {
            this.arity = arity;
        }

        private static String toString(Member[] a) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < a.length; ++i) {
                Member member = a[i];
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(member.getUniqueName());
            }
            return sb.toString();
        }

        public int compare(Object o1, Object o2) {
            Member[] a1 = (Member[])o1;
            Member[] a2 = (Member[])o2;
            int c = this.compare(a1, a2);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("compare {" + ArrayComparator.toString(a1) + "}, {" + ArrayComparator.toString(a2) + "} yields " + c));
            }
            return c;
        }

        protected abstract int compare(Member[] var1, Member[] var2);
    }

    private static class BreakMemberComparator
    extends MemberComparator {
        BreakMemberComparator(Map mapMemberToValue, boolean desc) {
            super(mapMemberToValue, desc);
        }

        protected int compareInternal(Member m1, Member m2) {
            return this.compareByValue(m1, m2);
        }
    }

    private static class HierarchicalMemberComparator
    extends MemberComparator {
        HierarchicalMemberComparator(Map mapMemberToValue, boolean desc) {
            super(mapMemberToValue, desc);
        }

        protected int compareInternal(Member m1, Member m2) {
            return this.compareHierarchicallyButSiblingsByValue(m1, m2);
        }
    }

    private static abstract class MemberComparator
    implements Comparator {
        private static final Logger LOGGER = Logger.getLogger((Class)(class$mondrian$olap$fun$FunUtil$MemberComparator == null ? (class$mondrian$olap$fun$FunUtil$MemberComparator = FunUtil.class$("mondrian.olap.fun.FunUtil$MemberComparator")) : class$mondrian$olap$fun$FunUtil$MemberComparator));
        Map mapMemberToValue;
        private boolean desc;

        MemberComparator(Map mapMemberToValue, boolean desc) {
            this.mapMemberToValue = mapMemberToValue;
            this.desc = desc;
        }

        public int compare(Object o1, Object o2) {
            Member m1 = (Member)o1;
            Member m2 = (Member)o2;
            int c = this.compareInternal(m1, m2);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("compare " + m1.getUniqueName() + "(" + this.mapMemberToValue.get(m1) + "), " + m2.getUniqueName() + "(" + this.mapMemberToValue.get(m2) + ")" + " yields " + c));
            }
            return c;
        }

        protected abstract int compareInternal(Member var1, Member var2);

        protected int compareByValue(Member m1, Member m2) {
            Object value1 = this.mapMemberToValue.get(m1);
            Object value2 = this.mapMemberToValue.get(m2);
            int c = FunUtil.compareValues(value1, value2);
            return this.desc ? -c : c;
        }

        protected int compareHierarchicallyButSiblingsByValue(Member m1, Member m2) {
            Member prev2;
            Member prev1;
            if (FunUtil.equals(m1, m2)) {
                return 0;
            }
            while (true) {
                int depth2;
                int depth1;
                if ((depth1 = m1.getDepth()) < (depth2 = m2.getDepth())) {
                    if (!Util.equals(m1, m2 = m2.getParentMember())) continue;
                    return -1;
                }
                if (depth1 > depth2) {
                    if (!Util.equals(m1 = m1.getParentMember(), m2)) continue;
                    return 1;
                }
                prev1 = m1;
                prev2 = m2;
                if (Util.equals(m1 = m1.getParentMember(), m2 = m2.getParentMember())) break;
            }
            int c = this.compareByValue(prev1, prev2);
            if (c != 0) {
                return c;
            }
            c = FunUtil.compareSiblingMembers(prev1, prev2);
            return c;
        }
    }
}

