/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.io.PrintWriter;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.ExpBase;
import mondrian.olap.Member;
import mondrian.olap.Syntax;
import mondrian.olap.Validator;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.type.TupleType;
import mondrian.olap.type.Type;
import mondrian.olap.type.TypeUtil;
import mondrian.resource.MondrianResource;

class TupleFunDef
extends FunDefBase {
    private final int[] argTypes;

    TupleFunDef(int[] argTypes) {
        super("()", "(<Member> [, <Member>]...)", "Parenthesis operator constructs a tuple.  If there is only one member, the expression is equivalent to the member expression.", Syntax.Parentheses, 10, argTypes);
        this.argTypes = argTypes;
    }

    public int getReturnCategory() {
        return 10;
    }

    public int[] getParameterTypes() {
        return this.argTypes;
    }

    public void unparse(Exp[] args, PrintWriter pw) {
        ExpBase.unparseList(pw, args, "(", ", ", ")");
    }

    public Type getResultType(Validator validator, Exp[] args) {
        if (args.length == 1) {
            return TypeUtil.toMemberType(args[0].getTypeX());
        }
        Type[] types = new Type[args.length];
        for (int i = 0; i < args.length; ++i) {
            Exp arg = args[i];
            types[i] = TypeUtil.toMemberType(arg.getTypeX());
        }
        return new TupleType(types);
    }

    public Object evaluate(Evaluator evaluator, Exp[] args) {
        Member[] members = new Member[args.length];
        for (int i = 0; i < args.length; ++i) {
            Member member = TupleFunDef.getMemberArg(evaluator, args, i, true);
            if (member == null || member.isNull()) {
                return null;
            }
            members[i] = member;
        }
        this.checkDimensions(members);
        return members;
    }

    private void checkDimensions(Member[] members) {
        for (int i = 0; i < members.length; ++i) {
            Member member = members[i];
            for (int j = 0; j < i; ++j) {
                Member member1 = members[j];
                if (member.getDimension() != member1.getDimension()) continue;
                throw MondrianResource.instance().DupDimensionsInTuple.ex(member.getDimension().getUniqueName());
            }
        }
    }
}

