/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mondrian.olap.Util;
import mondrian.rolap.MemberCache;
import mondrian.rolap.MemberKey;
import mondrian.rolap.MemberReader;
import mondrian.rolap.MemberSource;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.TupleReader;
import mondrian.rolap.sql.MemberChildrenConstraint;
import mondrian.rolap.sql.TupleConstraint;

class CacheMemberReader
implements MemberReader,
MemberCache {
    private final MemberSource source;
    private final RolapMember[] members;
    private final Map mapKeyToMember;

    CacheMemberReader(MemberSource source) {
        this.source = source;
        this.mapKeyToMember = new HashMap();
        this.members = source.getMembers();
        for (int i = 0; i < this.members.length; ++i) {
            this.members[i].setOrdinal(i);
        }
    }

    public RolapHierarchy getHierarchy() {
        return this.source.getHierarchy();
    }

    public boolean setCache(MemberCache cache) {
        return false;
    }

    public RolapMember[] getMembers() {
        return this.members;
    }

    public Object makeKey(RolapMember parent, Object key) {
        return new MemberKey(parent, key);
    }

    public RolapMember getMember(Object key) {
        return (RolapMember)this.mapKeyToMember.get(key);
    }

    public Object putMember(Object key, RolapMember value) {
        return this.mapKeyToMember.put(key, value);
    }

    public void putChildren(RolapMember member, MemberChildrenConstraint constraint, List children) {
        throw new UnsupportedOperationException();
    }

    public List getChildrenFromCache(RolapMember member, MemberChildrenConstraint constraint) {
        return null;
    }

    public List getLevelMembersFromCache(RolapLevel level, TupleConstraint constraint) {
        return null;
    }

    public RolapMember lookupMember(String[] uniqueNameParts, boolean failIfNotFound) {
        return RolapUtil.lookupMember(this, uniqueNameParts, failIfNotFound);
    }

    public List getRootMembers() {
        ArrayList<RolapMember> list = new ArrayList<RolapMember>();
        for (int i = 0; i < this.members.length; ++i) {
            if (this.members[i].getParentUniqueName() != null) continue;
            list.add(this.members[i]);
        }
        return list;
    }

    public List getMembersInLevel(RolapLevel level, int startOrdinal, int endOrdinal) {
        ArrayList<RolapMember> list = new ArrayList<RolapMember>();
        int levelDepth = level.getDepth();
        for (int i = 0; i < this.members.length; ++i) {
            RolapMember member = this.members[i];
            if (member.getLevel().getDepth() != levelDepth || startOrdinal > member.getOrdinal() || member.getOrdinal() >= endOrdinal) continue;
            list.add(this.members[i]);
        }
        return list;
    }

    public List getMembersInLevel(RolapLevel level, int startOrdinal, int endOrdinal, TupleConstraint constraint) {
        return this.getMembersInLevel(level, startOrdinal, endOrdinal);
    }

    public void getMemberChildren(RolapMember parentMember, List children) {
        for (int i = 0; i < this.members.length; ++i) {
            RolapMember member = this.members[i];
            if (member.getParentMember() != parentMember) continue;
            children.add(member);
        }
    }

    public void getMemberChildren(RolapMember member, List children, MemberChildrenConstraint constraint) {
        this.getMemberChildren(member, children);
    }

    public void getMemberChildren(List parentMembers, List children) {
        for (int i = 0; i < this.members.length; ++i) {
            RolapMember member = this.members[i];
            if (!parentMembers.contains(member.getParentMember())) continue;
            children.add(member);
        }
    }

    public void getMemberChildren(List parentMembers, List children, MemberChildrenConstraint constraint) {
        this.getMemberChildren(parentMembers, children);
    }

    public RolapMember getLeadMember(RolapMember member, int n) {
        if (n >= 0) {
            for (int ordinal = member.getOrdinal(); ordinal < this.members.length; ++ordinal) {
                if (this.members[ordinal].getLevel() != member.getLevel() || n-- != 0) continue;
                return this.members[ordinal];
            }
            return (RolapMember)member.getHierarchy().getNullMember();
        }
        for (int ordinal = member.getOrdinal(); ordinal >= 0; --ordinal) {
            if (this.members[ordinal].getLevel() != member.getLevel() || n++ != 0) continue;
            return this.members[ordinal];
        }
        return (RolapMember)member.getHierarchy().getNullMember();
    }

    public void getMemberRange(RolapLevel level, RolapMember startMember, RolapMember endMember, List list) {
        Util.assertPrecondition(startMember != null, "startMember != null");
        Util.assertPrecondition(endMember != null, "endMember != null");
        Util.assertPrecondition(startMember.getLevel() == endMember.getLevel(), "startMember.getLevel() == endMember.getLevel()");
        for (int i = startMember.getOrdinal(); i <= endMember.getOrdinal(); ++i) {
            if (this.members[i].getLevel() != endMember.getLevel()) continue;
            list.add(this.members[i]);
        }
    }

    public int getMemberCount() {
        return this.members.length;
    }

    public int compare(RolapMember m1, RolapMember m2, boolean siblingsAreEqual) {
        if (m1 == m2) {
            return 0;
        }
        if (siblingsAreEqual && m1.getParentMember() == m2.getParentMember()) {
            return 0;
        }
        Util.assertTrue(this.members[m1.getOrdinal()] == m1);
        Util.assertTrue(this.members[m2.getOrdinal()] == m2);
        return m1.getOrdinal() < m2.getOrdinal() ? -1 : 1;
    }

    public TupleReader.MemberBuilder getMemberBuilder() {
        return null;
    }
}

