/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import mondrian.olap.Cube;
import mondrian.olap.Dimension;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.ExpCacheDescriptor;
import mondrian.olap.FunCall;
import mondrian.olap.FunDef;
import mondrian.olap.Hierarchy;
import mondrian.olap.Id;
import mondrian.olap.Literal;
import mondrian.olap.Member;
import mondrian.olap.OlapElement;
import mondrian.olap.Parameter;
import mondrian.olap.Property;
import mondrian.olap.Query;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.olap.fun.FunUtil;
import mondrian.resource.MondrianResource;
import mondrian.rolap.CellReader;
import mondrian.rolap.HierarchyUsage;
import mondrian.rolap.RolapConnection;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapResult;
import mondrian.util.Format;
import org.apache.log4j.Logger;

class RolapEvaluator
implements Evaluator {
    private static final Logger LOGGER = Logger.getLogger((Class)RolapEvaluator.class);
    private static final Object nullResult = new Object();
    private final Member[] currentMembers;
    private final Evaluator parent;
    protected CellReader cellReader;
    private final int depth;
    private Member expandingMember;
    private boolean nonEmpty;
    protected final RolapEvaluatorRoot root;

    protected RolapEvaluator(RolapEvaluatorRoot root, RolapEvaluator parent, CellReader cellReader, Member[] currentMembers) {
        this.root = root;
        this.parent = parent;
        if (parent == null) {
            this.depth = 0;
            this.nonEmpty = false;
        } else {
            this.depth = parent.depth + 1;
            this.nonEmpty = parent.nonEmpty;
        }
        this.cellReader = cellReader;
        this.currentMembers = currentMembers == null ? new Member[root.cube.getDimensions().length] : currentMembers;
    }

    RolapEvaluator(RolapEvaluatorRoot root) {
        this(root, null, null, null);
        SchemaReader scr = this.root.connection.getSchemaReader();
        Dimension[] dimensions = this.root.cube.getDimensions();
        for (int i = 0; i < dimensions.length; ++i) {
            Dimension dimension = dimensions[i];
            int ordinal = dimension.getOrdinal(this.root.cube);
            Hierarchy hier = dimension.getHierarchy();
            Member member = scr.getHierarchyDefaultMember(hier);
            if (member == null) {
                throw MondrianResource.instance().InvalidHierarchyCondition.ex(hier.getUniqueName());
            }
            HierarchyUsage[] hierarchyUsages = this.root.cube.getUsages(hier);
            if (hierarchyUsages.length != 0) {
                ((RolapMember)member).makeUniqueName(hierarchyUsages[0]);
            }
            this.currentMembers[ordinal] = member;
        }
    }

    protected Logger getLogger() {
        return LOGGER;
    }

    Member[] getCurrentMembers() {
        return this.currentMembers;
    }

    void setCellReader(CellReader cellReader) {
        this.cellReader = cellReader;
    }

    public Cube getCube() {
        return this.root.cube;
    }

    public Query getQuery() {
        return this.root.result.getQuery();
    }

    public int getDepth() {
        return this.depth;
    }

    public Evaluator getParent() {
        return this.parent;
    }

    public SchemaReader getSchemaReader() {
        return this.root.schemaReader;
    }

    public Evaluator push(Member[] members) {
        RolapEvaluator evaluator = this._push();
        evaluator.setContext(members);
        return evaluator;
    }

    public Evaluator push(Member member) {
        RolapEvaluator evaluator = this._push();
        evaluator.setContext(member);
        return evaluator;
    }

    public Evaluator push() {
        return this._push();
    }

    protected RolapEvaluator _push() {
        Member[] cloneCurrentMembers = (Member[])this.currentMembers.clone();
        return new RolapEvaluator(this.root, this, this.cellReader, cloneCurrentMembers);
    }

    public Evaluator pop() {
        return this.parent;
    }

    public Object visit(Literal literal) {
        return literal.getValue();
    }

    public Object visit(Parameter parameter) {
        return parameter.getExp().evaluate(this);
    }

    public Object visit(FunCall funCall) {
        FunDef funDef = funCall.getFunDef();
        return funDef.evaluate(this, funCall.getArgs());
    }

    public Object visit(Id id) {
        throw new Error("unsupported");
    }

    public Object visit(OlapElement mdxElement) {
        return mdxElement;
    }

    public Member setContext(Member member) {
        RolapMember m = (RolapMember)member;
        int ordinal = m.getDimension().getOrdinal(this.root.cube);
        Member previous = this.currentMembers[ordinal];
        this.currentMembers[ordinal] = m;
        return previous;
    }

    public void setContext(Member[] members) {
        for (int i = 0; i < members.length; ++i) {
            Member member = members[i];
            if (member == null) {
                if (!this.getLogger().isDebugEnabled()) continue;
                this.getLogger().debug((Object)("RolapEvaluator.setContext: member == null  , count=" + i));
                continue;
            }
            this.setContext(member);
        }
    }

    public Member getContext(Dimension dimension) {
        return this.currentMembers[dimension.getOrdinal(this.root.cube)];
    }

    public Object evaluateCurrent() {
        Member maxSolveMember = this.getMaxSolveMember();
        if (maxSolveMember != null) {
            RolapMember defaultMember = (RolapMember)maxSolveMember.getHierarchy().getDefaultMember();
            Util.assertTrue(defaultMember != maxSolveMember, "default member must not be calculated");
            RolapEvaluator evaluator = (RolapEvaluator)this.push(defaultMember);
            evaluator.setExpanding(maxSolveMember);
            return maxSolveMember.getExpression().evaluateScalar(evaluator);
        }
        return this.cellReader.get(this);
    }

    private Member getMaxSolveMember() {
        int maxSolve = Integer.MIN_VALUE;
        Member maxSolveMember = null;
        int count = this.currentMembers.length;
        for (int i = 0; i < count; ++i) {
            int solve;
            Member currentMember = this.currentMembers[i];
            if (currentMember == null) {
                if (!this.getLogger().isDebugEnabled()) continue;
                this.getLogger().debug((Object)("RolapEvaluator.getMinSolveMember: member == null  , count=" + i));
                continue;
            }
            if (!currentMember.isCalculated() || (solve = currentMember.getSolveOrder()) <= maxSolve) continue;
            maxSolve = solve;
            maxSolveMember = currentMember;
        }
        return maxSolveMember;
    }

    private void setExpanding(Member member) {
        this.expandingMember = member;
        int memberCount = this.currentMembers.length;
        if (this.depth > memberCount && this.depth % memberCount == 0) {
            RolapEvaluator.checkRecursion((RolapEvaluator)this.parent);
        }
    }

    private static void checkRecursion(RolapEvaluator eval) {
        while (true) {
            if (eval == null) {
                return;
            }
            if (eval.expandingMember != null) break;
            eval = (RolapEvaluator)eval.getParent();
        }
        block1: for (RolapEvaluator eval2 = (RolapEvaluator)eval.getParent(); eval2 != null; eval2 = (RolapEvaluator)eval2.getParent()) {
            if (eval2.expandingMember != eval.expandingMember) continue;
            for (int i = 0; i < eval.currentMembers.length; ++i) {
                Member member = eval2.currentMembers[i];
                if (member == null) {
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug((Object)("RolapEvaluator.checkRecursion: member == null  , count=" + i));
                    continue;
                }
                Member parentMember = eval.getContext(member.getDimension());
                if (member != parentMember) continue block1;
            }
            throw FunUtil.newEvalException(null, "Infinite loop while evaluating calculated member '" + eval.expandingMember + "'; context stack is " + eval.getContextString());
        }
    }

    private String getContextString() {
        boolean skipDefaultMembers = true;
        StringBuffer sb = new StringBuffer("{");
        int frameCount = 0;
        for (RolapEvaluator eval = this; eval != null; eval = (RolapEvaluator)eval.getParent()) {
            if (eval.expandingMember == null) continue;
            if (frameCount++ > 0) {
                sb.append(", ");
            }
            sb.append("(");
            int memberCount = 0;
            for (int j = 0; j < eval.currentMembers.length; ++j) {
                Member m = eval.currentMembers[j];
                if (skipDefaultMembers && m == m.getHierarchy().getDefaultMember()) continue;
                if (memberCount++ > 0) {
                    sb.append(", ");
                }
                sb.append(m.getUniqueName());
            }
            sb.append(")");
        }
        sb.append("}");
        return sb.toString();
    }

    public Object getProperty(String name, Object defaultValue) {
        Object o = defaultValue;
        int maxSolve = Integer.MIN_VALUE;
        for (int i = 0; i < this.currentMembers.length; ++i) {
            int solve;
            Member member = this.currentMembers[i];
            if (member == null) {
                if (!this.getLogger().isDebugEnabled()) continue;
                this.getLogger().debug((Object)("RolapEvaluator.getProperty: member == null  , count=" + i));
                continue;
            }
            Object p = member.getPropertyValue(name);
            if (p == null || (solve = member.getSolveOrder()) <= maxSolve) continue;
            o = p;
            maxSolve = solve;
        }
        return o;
    }

    String getFormatString() {
        Exp formatExp = (Exp)this.getProperty(Property.FORMAT_EXP.name, null);
        if (formatExp == null) {
            return "Standard";
        }
        Object o = formatExp.evaluate(this);
        return o.toString();
    }

    private Format getFormat() {
        String formatString = this.getFormatString();
        return Format.get(formatString, this.root.connection.getLocale());
    }

    String format(Evaluator evaluator, Object o) {
        return this.getFormat().format(o);
    }

    public String format(Object o) {
        if (o == Util.nullValue) {
            Format format = this.getFormat();
            return format.format(null);
        }
        if (o instanceof Throwable) {
            return "#ERR: " + o.toString();
        }
        if (o instanceof String) {
            return (String)o;
        }
        Format format = this.getFormat();
        return format.format(o);
    }

    private Object getExpResultCacheKey(ExpCacheDescriptor descriptor) {
        ArrayList<Exp> key = new ArrayList<Exp>();
        key.add(descriptor.getExp());
        int[] dimensionOrdinals = descriptor.getDependentDimensionOrdinals();
        for (int i = 0; i < dimensionOrdinals.length; ++i) {
            int dimensionOrdinal = dimensionOrdinals[i];
            Member member = this.currentMembers[dimensionOrdinal];
            if (member == null) {
                this.getLogger().debug((Object)("RolapEvaluator.getExpResultCacheKey: member == null; dimensionOrdinal=" + i));
                continue;
            }
            key.add(member);
        }
        return key;
    }

    public Object getCachedResult(ExpCacheDescriptor cacheDescriptor) {
        Object key = this.getExpResultCacheKey(cacheDescriptor);
        Object result = this.root.expResultCache.get(key);
        if (result == null) {
            result = cacheDescriptor.getExp().evaluate(this);
            this.root.expResultCache.put(key, result == null ? nullResult : result);
        } else if (result == nullResult) {
            result = null;
        }
        return result;
    }

    public void clearExpResultCache() {
        this.root.expResultCache.clear();
    }

    public boolean isNonEmpty() {
        return this.nonEmpty;
    }

    public void setNonEmpty(boolean nonEmpty) {
        this.nonEmpty = nonEmpty;
    }

    public RuntimeException newEvalException(Object context, String s) {
        return FunUtil.newEvalException((FunDef)context, s);
    }

    public Object evaluateNamedSet(String name, Exp exp) {
        return this.root.result.evaluateNamedSet(name, exp);
    }

    public Member[] getMembers() {
        return this.currentMembers;
    }

    protected static class RolapEvaluatorRoot {
        final RolapResult result;
        final Map expResultCache = new HashMap();
        final RolapCube cube;
        final RolapConnection connection;
        final SchemaReader schemaReader;

        RolapEvaluatorRoot(RolapResult result) {
            this.result = result;
            this.cube = (RolapCube)result.getQuery().getCube();
            this.connection = (RolapConnection)result.getQuery().getConnection();
            this.schemaReader = this.cube.getSchemaReader(this.connection.role);
        }
    }
}

