/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mondrian.olap.Exp;
import mondrian.olap.FunCall;
import mondrian.olap.FunDef;
import mondrian.olap.Hierarchy;
import mondrian.olap.NativeEvaluator;
import mondrian.olap.Util;
import mondrian.rolap.MemberReader;
import mondrian.rolap.RolapEvaluator;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapNative;
import mondrian.rolap.RolapSchemaReader;
import mondrian.rolap.SqlConstraintUtils;
import mondrian.rolap.SqlContextConstraint;
import mondrian.rolap.SqlTupleReader;
import mondrian.rolap.TupleReader;
import mondrian.rolap.cache.HardSmartCache;
import mondrian.rolap.cache.SmartCache;
import mondrian.rolap.cache.SoftSmartCache;
import mondrian.rolap.sql.MemberChildrenConstraint;
import mondrian.rolap.sql.SqlQuery;
import mondrian.rolap.sql.TupleConstraint;
import org.apache.log4j.Logger;

public abstract class RolapNativeSet
extends RolapNative {
    protected static final Logger LOGGER = Logger.getLogger((Class)RolapNativeSet.class);
    private SmartCache cache = new SoftSmartCache();

    protected abstract boolean isStrict();

    protected CrossJoinArg checkDescendants(FunDef fun, Exp[] args) {
        if (!"Descendants".equalsIgnoreCase(fun.getName())) {
            return null;
        }
        if (args.length != 2) {
            return null;
        }
        if (!(args[0] instanceof RolapMember)) {
            return null;
        }
        RolapMember member = (RolapMember)args[0];
        if (member.isCalculated()) {
            return null;
        }
        if (!(args[1] instanceof RolapLevel)) {
            return null;
        }
        RolapLevel level = (RolapLevel)args[1];
        if (!RolapNativeSet.isSimpleLevel(level)) {
            return null;
        }
        return new DescendantsCrossJoinArg(level, member);
    }

    protected CrossJoinArg checkLevelMembers(FunDef fun, Exp[] args) {
        if (!"Members".equalsIgnoreCase(fun.getName())) {
            return null;
        }
        if (args.length != 1) {
            return null;
        }
        if (!(args[0] instanceof RolapLevel)) {
            return null;
        }
        RolapLevel level = (RolapLevel)args[0];
        if (!RolapNativeSet.isSimpleLevel(level)) {
            return null;
        }
        return new DescendantsCrossJoinArg(level, null);
    }

    protected CrossJoinArg checkMemberChildren(FunDef fun, Exp[] args) {
        if (!"Children".equalsIgnoreCase(fun.getName())) {
            return null;
        }
        if (args.length != 1) {
            return null;
        }
        if (!(args[0] instanceof RolapMember)) {
            return null;
        }
        RolapMember member = (RolapMember)args[0];
        if (member.isCalculated()) {
            return null;
        }
        RolapLevel level = member.getRolapLevel();
        if ((level = (RolapLevel)level.getChildLevel()) == null || !RolapNativeSet.isSimpleLevel(level)) {
            return null;
        }
        return new DescendantsCrossJoinArg(level, member);
    }

    protected CrossJoinArg checkEnumeration(FunDef fun, Exp[] args) {
        if (!"{}".equalsIgnoreCase(fun.getName())) {
            return null;
        }
        return EnumCrossJoinArg.instance(args, this.isStrict());
    }

    protected CrossJoinArg[] checkCrossJoin(FunDef fun, Exp[] args) {
        if (!"Crossjoin".equalsIgnoreCase(fun.getName())) {
            return null;
        }
        if (args.length != 2) {
            return null;
        }
        CrossJoinArg[] arg0 = this.checkCrossJoinArg(args[0]);
        if (arg0 == null) {
            return null;
        }
        CrossJoinArg[] arg1 = this.checkCrossJoinArg(args[1]);
        if (arg1 == null) {
            return null;
        }
        CrossJoinArg[] ret = new CrossJoinArg[arg0.length + arg1.length];
        System.arraycopy(arg0, 0, ret, 0, arg0.length);
        System.arraycopy(arg1, 0, ret, arg0.length, arg1.length);
        return ret;
    }

    protected CrossJoinArg[] checkCrossJoinArg(Exp exp) {
        if (!(exp instanceof FunCall)) {
            return null;
        }
        FunDef fun = ((FunCall)exp).getFunDef();
        Exp[] args = ((FunCall)exp).getArgs();
        return this.checkCrossJoinArg(fun, args);
    }

    protected CrossJoinArg[] checkCrossJoinArg(FunDef fun, Exp[] args) {
        CrossJoinArg arg = this.checkMemberChildren(fun, args);
        if (arg == null) {
            arg = this.checkLevelMembers(fun, args);
        }
        if (arg == null) {
            arg = this.checkDescendants(fun, args);
        }
        if (arg == null) {
            arg = this.checkEnumeration(fun, args);
        }
        if (arg != null) {
            return new CrossJoinArg[]{arg};
        }
        return this.checkCrossJoin(fun, args);
    }

    protected static boolean isSimpleLevel(RolapLevel level) {
        RolapHierarchy hier = (RolapHierarchy)level.getHierarchy();
        if (hier.isRagged()) {
            return false;
        }
        if (level.getParentExp() != null) {
            return false;
        }
        return !level.isMeasure();
    }

    protected boolean isPreferInterpreter(CrossJoinArg[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].isPreferInterpreter()) continue;
            return false;
        }
        return true;
    }

    void useHardCache(boolean hard) {
        this.cache = hard ? new HardSmartCache() : new SoftSmartCache();
    }

    protected static class EnumCrossJoinArg
    implements CrossJoinArg {
        private RolapMember[] members;
        private RolapLevel level = null;
        private boolean strict;

        private EnumCrossJoinArg(RolapLevel level, RolapMember[] members, boolean strict) {
            this.level = level;
            this.members = members;
            this.strict = strict;
        }

        static CrossJoinArg instance(Exp[] args, boolean strict) {
            if (args.length == 0) {
                return null;
            }
            RolapLevel level = null;
            for (int i = 0; i < args.length; ++i) {
                if (!(args[i] instanceof RolapMember)) {
                    return null;
                }
                RolapMember m = (RolapMember)args[i];
                if (strict && m.isCalculated()) {
                    return null;
                }
                if (i == 0) {
                    level = m.getRolapLevel();
                    continue;
                }
                if (level.equals(m.getLevel())) continue;
                return null;
            }
            if (!RolapNativeSet.isSimpleLevel(level)) {
                return null;
            }
            RolapMember[] members = new RolapMember[args.length];
            System.arraycopy(args, 0, members, 0, args.length);
            return new EnumCrossJoinArg(level, members, strict);
        }

        public RolapLevel getLevel() {
            return this.level;
        }

        public boolean isPreferInterpreter() {
            return true;
        }

        public int hashCode() {
            int c = 12;
            for (int i = 0; i < this.members.length; ++i) {
                c = 31 * c + this.members[i].hashCode();
            }
            if (this.strict) {
                ++c;
            }
            return c;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof EnumCrossJoinArg)) {
                return false;
            }
            EnumCrossJoinArg that = (EnumCrossJoinArg)obj;
            if (this.strict != that.strict) {
                return false;
            }
            for (int i = 0; i < this.members.length; ++i) {
                if (this.members[i] == that.members[i]) continue;
                return false;
            }
            return true;
        }

        public void addConstraint(SqlQuery sqlQuery) {
            SqlConstraintUtils.addMemberConstraint(sqlQuery, Arrays.asList(this.members), this.strict);
        }
    }

    protected static class DescendantsCrossJoinArg
    implements CrossJoinArg {
        RolapMember member;
        RolapLevel level;

        public DescendantsCrossJoinArg(RolapLevel level, RolapMember member) {
            this.level = level;
            this.member = member;
        }

        public RolapLevel getLevel() {
            return this.level;
        }

        public boolean isPreferInterpreter() {
            return false;
        }

        private boolean equals(Object o1, Object o2) {
            return o1 == null ? o2 == null : o1.equals(o2);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DescendantsCrossJoinArg)) {
                return false;
            }
            DescendantsCrossJoinArg that = (DescendantsCrossJoinArg)obj;
            if (!this.equals(this.level, that.level)) {
                return false;
            }
            return this.equals(this.member, that.member);
        }

        public int hashCode() {
            int c = 1;
            if (this.level != null) {
                c = this.level.hashCode();
            }
            if (this.member != null) {
                c = 31 * c + this.member.hashCode();
            }
            return c;
        }

        public void addConstraint(SqlQuery sqlQuery) {
            if (this.member != null) {
                SqlConstraintUtils.addMemberConstraint(sqlQuery, this.member, true);
            }
        }
    }

    protected static interface CrossJoinArg {
        public RolapLevel getLevel();

        public void addConstraint(SqlQuery var1);

        public boolean isPreferInterpreter();
    }

    protected class SetEvaluator
    implements NativeEvaluator {
        private CrossJoinArg[] args;
        private RolapSchemaReader schemaReader;
        private TupleConstraint constraint;
        private int maxRows = 0;

        public SetEvaluator(CrossJoinArg[] args, RolapSchemaReader schemaReader, TupleConstraint constraint) {
            this.args = args;
            this.schemaReader = schemaReader;
            this.constraint = constraint;
        }

        public Object execute() {
            SqlTupleReader tr = new SqlTupleReader(this.constraint);
            tr.setMaxRows(this.maxRows);
            for (int i = 0; i < this.args.length; ++i) {
                this.addLevel(tr, this.args[i]);
            }
            Object key = tr.getCacheKey();
            List result = (List)RolapNativeSet.this.cache.get(key);
            if (result != null) {
                if (RolapNativeSet.this.listener != null) {
                    RolapNative.TupleEvent e = new RolapNative.TupleEvent(this, tr);
                    RolapNativeSet.this.listener.foundInCache(e);
                }
                return this.copy(result);
            }
            if (RolapNativeSet.this.listener != null) {
                RolapNative.TupleEvent e = new RolapNative.TupleEvent(this, tr);
                RolapNativeSet.this.listener.excutingSql(e);
            }
            result = tr.readTuples(this.schemaReader.getDataSource());
            RolapNativeSet.this.cache.put(key, result);
            return this.copy(result);
        }

        private List copy(List list) {
            ArrayList copy = new ArrayList();
            copy.addAll(list);
            return copy;
        }

        private void addLevel(TupleReader tr, CrossJoinArg arg) {
            RolapLevel level = arg.getLevel();
            Hierarchy hierarchy = level.getHierarchy();
            MemberReader mr = this.schemaReader.getMemberReader(hierarchy);
            TupleReader.MemberBuilder mb = mr.getMemberBuilder();
            Util.assertTrue(mb != null, "MemberBuilder not found");
            tr.addLevelMembers(level, mb);
        }

        int getMaxRows() {
            return this.maxRows;
        }

        void setMaxRows(int maxRows) {
            this.maxRows = maxRows;
        }
    }

    protected static abstract class SetConstraint
    extends SqlContextConstraint {
        CrossJoinArg[] args;

        SetConstraint(CrossJoinArg[] args, RolapEvaluator evaluator, boolean strict) {
            super(evaluator, strict);
            this.args = args;
        }

        protected boolean isJoinRequired() {
            return this.args.length > 1 || super.isJoinRequired();
        }

        public void addConstraint(SqlQuery sqlQuery) {
            super.addConstraint(sqlQuery);
            for (int i = 0; i < this.args.length; ++i) {
                CrossJoinArg arg = this.args[i];
                arg.addConstraint(sqlQuery);
            }
        }

        public MemberChildrenConstraint getMemberChildrenConstraint(RolapMember parent) {
            return null;
        }

        public Object getCacheKey() {
            ArrayList<Object> key = new ArrayList<Object>();
            key.add(super.getCacheKey());
            key.addAll(Arrays.asList(this.args));
            return key;
        }
    }
}

