/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast.expr;

import groovy.lang.MetaMethod;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ExpressionTransformer;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.classgen.AsmClassGenerator;

public class MethodCallExpression
extends Expression {
    private Expression objectExpression;
    private String method;
    private Expression arguments;
    private boolean safe;
    private boolean implicitThis;
    private MetaMethod metaMethod = null;

    public MetaMethod getMetaMethod() {
        return this.metaMethod;
    }

    public MethodCallExpression(Expression objectExpression, String method, Expression arguments) {
        this.objectExpression = objectExpression;
        this.method = method;
        this.arguments = arguments;
    }

    public void visit(GroovyCodeVisitor visitor) {
        visitor.visitMethodCallExpression(this);
    }

    public Expression transformExpression(ExpressionTransformer transformer) {
        MethodCallExpression answer = new MethodCallExpression(transformer.transform(this.objectExpression), this.method, transformer.transform(this.arguments));
        answer.setSafe(this.safe);
        return answer;
    }

    protected void resolveType(AsmClassGenerator resolver) {
        this.objectExpression.resolve(resolver);
        this.arguments.resolve(resolver);
        resolver.resolve(this);
    }

    public Expression getArguments() {
        return this.arguments;
    }

    public String getMethod() {
        return this.method;
    }

    public Expression getObjectExpression() {
        return this.objectExpression;
    }

    public String getText() {
        return this.objectExpression.getText() + "." + this.method + this.arguments.getText();
    }

    public boolean isSafe() {
        return this.safe;
    }

    public void setSafe(boolean safe) {
        this.safe = safe;
    }

    public boolean isImplicitThis() {
        return this.implicitThis;
    }

    public void setImplicitThis(boolean implicitThis) {
        this.implicitThis = implicitThis;
    }

    public String toString() {
        return super.toString() + "[object: " + this.objectExpression + " method: " + this.method + " arguments: " + this.arguments + "]";
    }

    public static boolean isSuperMethodCall(MethodCallExpression call) {
        Expression expression = call.getObjectExpression();
        if (expression instanceof VariableExpression) {
            VariableExpression varExp = (VariableExpression)expression;
            String variable = varExp.getVariable();
            return variable.equals("super");
        }
        return false;
    }

    public void setMethod(MetaMethod mmeth) {
        this.metaMethod = mmeth;
        super.setTypeClass(mmeth.getReturnType());
    }
}

