/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast;

import antlr.RecognitionException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.QueryException;
import org.hibernate.hql.ast.ParseErrorHandler;
import org.hibernate.hql.ast.QuerySyntaxError;

public class ErrorCounter
implements ParseErrorHandler {
    private Log log = LogFactory.getLog((Class)(class$org$hibernate$hql$ast$ErrorCounter == null ? (class$org$hibernate$hql$ast$ErrorCounter = ErrorCounter.class$("org.hibernate.hql.ast.ErrorCounter")) : class$org$hibernate$hql$ast$ErrorCounter));
    private Log hqlLog = LogFactory.getLog((String)"org.hibernate.hql.PARSER");
    private List errorList = new ArrayList();
    private List warningList = new ArrayList();
    private List recognitionExceptions = new ArrayList();
    static /* synthetic */ Class class$org$hibernate$hql$ast$ErrorCounter;

    public void reportError(RecognitionException e) {
        this.reportError(e.toString());
        this.recognitionExceptions.add(e);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)e, (Throwable)e);
        }
    }

    public void reportError(String s) {
        String message = "*** ERROR: " + s;
        this.hqlLog.error((Object)message);
        this.errorList.add(message);
    }

    public int getErrorCount() {
        return this.errorList.size();
    }

    public void reportWarning(String s) {
        String message = "*** WARNING: " + s;
        this.hqlLog.warn((Object)message);
        this.warningList.add(message);
    }

    private String getErrorString() {
        StringBuffer buf = new StringBuffer();
        Iterator iterator = this.errorList.iterator();
        while (iterator.hasNext()) {
            buf.append((String)iterator.next());
            if (!iterator.hasNext()) continue;
            buf.append("\n");
        }
        return buf.toString();
    }

    public void throwQueryException() throws QueryException {
        if (this.getErrorCount() > 0) {
            if (this.recognitionExceptions.size() > 0) {
                throw new QuerySyntaxError((RecognitionException)((Object)this.recognitionExceptions.get(0)));
            }
            throw new QueryException(this.getErrorString());
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"throwQueryException() : no errors");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

