/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.connection;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Vector;
import net.sf.jasperreports.engine.JRException;

public class JRCsvDataSourceInspector {
    private DateFormat dateFormat = new SimpleDateFormat();
    private char fieldDelimiter = (char)44;
    private String recordDelimiter = "\n";
    private HashMap columnNames = new HashMap();
    private Vector fields;
    private Reader reader;
    private char[] buffer = new char[1024];
    private int position;
    private int bufSize;

    public JRCsvDataSourceInspector(InputStream stream) {
        this(new InputStreamReader(stream));
    }

    public JRCsvDataSourceInspector(File file) throws FileNotFoundException {
        this(new FileReader(file));
    }

    public JRCsvDataSourceInspector(Reader reader) {
        this.reader = reader;
    }

    private boolean parseRow() throws IOException {
        String field;
        int pos = 0;
        int startFieldPos = 0;
        boolean insideQuotes = false;
        boolean hadQuotes = false;
        boolean misplacedQuote = false;
        this.fields = new Vector();
        String row = this.getRow();
        if (row == null || row.length() == 0) {
            return false;
        }
        while (pos < row.length()) {
            char c = row.charAt(pos);
            if (c == '\"') {
                if (!insideQuotes) {
                    if (!hadQuotes) {
                        insideQuotes = true;
                        hadQuotes = true;
                    } else {
                        misplacedQuote = true;
                    }
                } else if (pos + 1 < row.length() && row.charAt(pos + 1) == '\"') {
                    ++pos;
                } else {
                    insideQuotes = false;
                }
            }
            if (c == this.fieldDelimiter && !insideQuotes) {
                field = row.substring(startFieldPos, pos);
                if (misplacedQuote) {
                    misplacedQuote = false;
                    hadQuotes = false;
                    field = "";
                } else if (hadQuotes) {
                    if ((field = field.trim()).startsWith("\"") && field.endsWith("\"")) {
                        field = field.substring(1, field.length() - 1);
                        field = this.replaceAll(field, "\"\"", "\"");
                    } else {
                        field = "";
                    }
                    hadQuotes = false;
                }
                this.fields.add(field);
                startFieldPos = pos + 1;
            }
            if (++pos != row.length() || !insideQuotes) continue;
            row = row + this.recordDelimiter + this.getRow();
        }
        field = row.substring(startFieldPos, pos);
        if (field == null || field.length() == 0) {
            return true;
        }
        if (misplacedQuote) {
            field = "";
        } else if (hadQuotes) {
            if ((field = field.trim()).startsWith("\"") && field.endsWith("\"")) {
                field = field.substring(1, field.length() - 1);
                field = this.replaceAll(field, "\"\"", "\"");
            } else {
                field = "";
            }
        }
        this.fields.add(field);
        return true;
    }

    private String getRow() throws IOException {
        StringBuffer row = new StringBuffer();
        try {
            while (true) {
                char c;
                if ((c = this.getChar()) == this.recordDelimiter.charAt(0)) {
                    int i;
                    char[] temp = new char[this.recordDelimiter.length()];
                    temp[0] = c;
                    boolean isDelimiter = true;
                    for (i = 1; i < this.recordDelimiter.length() && isDelimiter; ++i) {
                        temp[i] = this.getChar();
                        if (temp[i] == this.recordDelimiter.charAt(i)) continue;
                        isDelimiter = false;
                    }
                    if (isDelimiter) {
                        return row.toString();
                    }
                    row.append(temp, 0, i);
                }
                row.append(c);
            }
        }
        catch (JRException e) {
            return row.toString();
        }
    }

    private char getChar() throws IOException, JRException {
        if (this.position + 1 > this.bufSize) {
            this.bufSize = this.reader.read(this.buffer);
            this.position = 0;
            if (this.bufSize == -1) {
                throw new JRException("No more chars");
            }
        }
        return this.buffer[this.position++];
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    public char getFieldDelimiter() {
        return this.fieldDelimiter;
    }

    public void setFieldDelimiter(char fieldDelimiter) {
        this.fieldDelimiter = fieldDelimiter;
    }

    public String getRecordDelimiter() {
        return this.recordDelimiter;
    }

    public void setRecordDelimiter(String recordDelimiter) {
        this.recordDelimiter = recordDelimiter;
    }

    public void setColumnNames(String[] columnNames) {
        this.columnNames.clear();
        for (int i = 0; i < columnNames.length; ++i) {
            this.columnNames.put(columnNames[i], new Integer(i));
        }
    }

    public Vector getColumnNames() throws IOException {
        this.parseRow();
        return this.fields;
    }

    private String replaceAll(String string, String substring, String replacement) {
        StringBuffer result = new StringBuffer();
        int index = string.indexOf(substring);
        int oldIndex = 0;
        while (index >= 0) {
            result.append(string.substring(oldIndex, index));
            result.append(replacement);
            oldIndex = index += substring.length();
            index = string.indexOf(substring, index);
        }
        if (oldIndex < string.length()) {
            result.append(string.substring(oldIndex, string.length()));
        }
        return result.toString();
    }
}

