/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.crosstab;

import it.businesslogic.ireport.Box;
import it.businesslogic.ireport.BoxElement;
import it.businesslogic.ireport.CrosstabReportElement;
import it.businesslogic.ireport.ReportElement;
import it.businesslogic.ireport.Style;
import it.businesslogic.ireport.util.Java2DUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;

public class CrosstabCell
implements BoxElement {
    public static final int HEADER_CELL = 1;
    public static final int CT_HEADER_CELL = 3;
    public static final int DETAIL_CELL = 0;
    public static final int NODATA_CELL = 2;
    private int type = 0;
    private String name = null;
    private int top = 0;
    private int left = 0;
    private int width = 0;
    private int height = 0;
    private String mode = "Transparent";
    private boolean paintSelection = false;
    private Style style = null;
    private int topIndex = 0;
    private int bottomIndex = 0;
    private int leftIndex = 0;
    private int rightIndex = 0;
    private String rowTotalGroup = "";
    private String columnTotalGroup = "";
    private CrosstabReportElement parent = null;
    private Color backcolor = null;
    private Box box = new Box();
    private double zoomFactor = 1.0;

    public String getName() {
        if (this.name == null) {
            if (this.getType() == 2) {
                this.setName("When no data");
            } else if (this.getType() == 0) {
                this.setName((this.getRowTotalGroup().equals("") ? "Detail" : this.getRowTotalGroup()) + " / " + (this.getColumnTotalGroup().equals("") ? "Detail" : this.getColumnTotalGroup()));
            } else if (this.getType() == 3) {
                this.setName("Crosstab header");
            }
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getTop() {
        return this.top;
    }

    public void setTop(int top) {
        this.top = top;
    }

    public int getLeft() {
        return this.left;
    }

    public void setLeft(int left) {
        this.left = left;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public Box getBox() {
        return this.box;
    }

    public void setBox(Box box) {
        this.box = box;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getRowTotalGroup() {
        return this.rowTotalGroup;
    }

    public void setRowTotalGroup(String rowTotalGroup) {
        this.rowTotalGroup = rowTotalGroup;
    }

    public String getColumnTotalGroup() {
        return this.columnTotalGroup;
    }

    public void setColumnTotalGroup(String columnTotalGroup) {
        this.columnTotalGroup = columnTotalGroup;
    }

    public Color getBackcolor() {
        return this.backcolor;
    }

    public void setBackcolor(Color backcolor) {
        this.backcolor = backcolor;
    }

    public CrosstabReportElement getParent() {
        return this.parent;
    }

    public void setParent(CrosstabReportElement parent) {
        this.parent = parent;
    }

    public Rectangle getBounds() {
        return new Rectangle(this.left, this.top, this.width, this.height);
    }

    public void drawCell(Graphics2D g, double zoom_factor) {
        Color bgcolor;
        this.zoomFactor = zoom_factor;
        Color color = bgcolor = this.getBackcolor() == null || this.getMode().equals("Transparent") ? Color.WHITE : this.getBackcolor();
        if (this.getType() == 2) {
            g.setColor(new Color(bgcolor.getRed(), bgcolor.getGreen(), bgcolor.getBlue(), 200));
        } else {
            g.setColor(bgcolor);
        }
        g.fillRect(10 + this.getZoomedDim(this.getLeft()), 10 + this.getZoomedDim(this.getTop()), this.getZoomedDim(this.getWidth()) - 1, this.getZoomedDim(this.getHeight()) - 1);
        g.setFont(new Font("Arial", 1, 12));
        int txt_height = g.getFontMetrics().getHeight();
        txt_height -= g.getFontMetrics().getMaxDescent();
        Color c = this.getBackcolor() == null ? Color.WHITE : this.getBackcolor();
        g.setColor(new Color(255 - c.getRed(), 255 - c.getGreen(), 255 - c.getBlue(), 32));
        Java2DUtil.setClip(g, Math.max(2, this.getZoomedDim(2)) + 10 + this.getZoomedDim(this.getLeft()), Math.max(2, this.getZoomedDim(2)) + 10 + this.getZoomedDim(this.getTop()), this.getZoomedDim(this.getWidth()) - 1 - Math.max(2, this.getZoomedDim(2)), this.getZoomedDim(this.getHeight()) - 1 - Math.max(2, this.getZoomedDim(2)));
        g.drawString(this.getName(), Math.max(2, this.getZoomedDim(2)) + 10 + this.getZoomedDim(this.getLeft()), Math.max(2, this.getZoomedDim(2)) + 10 + this.getZoomedDim(this.getTop()) + g.getFontMetrics().getAscent());
        c = this.getBackcolor() == null ? Color.WHITE : this.getBackcolor();
        g.setColor(new Color(255 - c.getRed(), 255 - c.getGreen(), 255 - c.getBlue(), 200));
        Java2DUtil.resetClip(g);
        if (this.isPaintSelection()) {
            for (int j = 1; j <= 20; ++j) {
                g.setColor(new Color(255, 168, 0, j));
                int i = 10;
                g.fillRect(this.getZoomedDim(this.getLeft()) - i + 10, this.getZoomedDim(this.getTop()) - i + 10, this.getZoomedDim(this.getWidth()) + i * 2, i);
                g.fillRect(this.getZoomedDim(this.getLeft()) - i + 10, this.getZoomedDim(this.getTop()) + 10, i, this.getZoomedDim(this.getHeight()));
                g.fillRect(this.getZoomedDim(this.getLeft()) + 10 - i, this.getZoomedDim(this.getTop()) + this.getZoomedDim(this.getHeight()) + 10, this.getZoomedDim(this.getWidth()) + i * 2, i);
                g.fillRect(this.getZoomedDim(this.getLeft()) + this.getZoomedDim(this.getWidth()) + 10, this.getZoomedDim(this.getTop()) + 10, i, this.getZoomedDim(this.getHeight()));
            }
        }
    }

    public void drawCellBox(Graphics2D g, double zoom_factor, boolean isFirstInColumn, boolean isFirstInRow) {
        this.zoomFactor = zoom_factor;
        Stroke oldStroke = g.getStroke();
        Color oldColor = g.getColor();
        if (this.box != null) {
            int ax = this.getZoomedDim(this.getLeft()) + 10;
            int ay = this.getZoomedDim(this.getTop()) + 10;
            int bx = ax + this.getZoomedDim(this.getWidth());
            int by = ay + this.getZoomedDim(this.getHeight());
            Stroke newBoxStroke = null;
            if (this.box.getLeftBorderColor() != null && (newBoxStroke = ReportElement.getPenStroke(this.box.getLeftBorder(), zoom_factor)) != null) {
                g.setColor(this.box.getLeftBorderColor());
                newBoxStroke = ReportElement.getPenStroke(this.box.getLeftBorder(), zoom_factor);
                if (newBoxStroke != null) {
                    g.setStroke(newBoxStroke);
                    g.drawLine(ax, ay, ax, by);
                }
                newBoxStroke = null;
            } else if (isFirstInRow && this.box.getRightBorderColor() != null) {
                g.setColor(this.box.getRightBorderColor());
                newBoxStroke = ReportElement.getPenStroke(this.box.getRightBorder(), zoom_factor);
                if (newBoxStroke != null) {
                    g.setStroke(newBoxStroke);
                    g.drawLine(ax, ay, ax, by);
                }
            }
            if (this.box.getTopBorderColor() != null && (newBoxStroke = ReportElement.getPenStroke(this.box.getTopBorder(), zoom_factor)) != null) {
                g.setColor(this.box.getTopBorderColor());
                g.setStroke(newBoxStroke);
                g.drawLine(ax, ay, bx, ay);
            } else if (isFirstInColumn && this.box.getBottomBorderColor() != null) {
                g.setColor(this.box.getBottomBorderColor());
                newBoxStroke = ReportElement.getPenStroke(this.box.getBottomBorder(), zoom_factor);
                if (newBoxStroke != null) {
                    g.setStroke(newBoxStroke);
                    g.drawLine(ax, ay, bx, ay);
                }
            }
            if (this.box.getRightBorderColor() != null) {
                g.setColor(this.box.getRightBorderColor());
                newBoxStroke = ReportElement.getPenStroke(this.box.getRightBorder(), zoom_factor);
                if (newBoxStroke != null) {
                    g.setStroke(newBoxStroke);
                    g.drawLine(bx, ay, bx, by);
                }
            }
            if (this.box.getBottomBorderColor() != null) {
                g.setColor(this.box.getBottomBorderColor());
                newBoxStroke = ReportElement.getPenStroke(this.box.getBottomBorder(), zoom_factor);
                if (newBoxStroke != null) {
                    g.setStroke(newBoxStroke);
                    g.drawLine(ax, by, bx, by);
                }
            }
        }
        g.setStroke(oldStroke);
    }

    public int getZoomedDim(int dim) {
        if (this.getZoomFactor() == 1.0) {
            return dim;
        }
        return (int)((double)dim * this.getZoomFactor());
    }

    public CrosstabCell cloneMe() {
        CrosstabCell cell = new CrosstabCell();
        cell.setTop(this.getTop());
        cell.setLeft(this.getLeft());
        cell.setHeight(this.getHeight());
        cell.setWidth(this.getWidth());
        cell.setBox(this.getBox().cloneMe());
        cell.setBackcolor(this.getBackcolor());
        cell.setColumnTotalGroup(this.getColumnTotalGroup());
        cell.setRowTotalGroup(this.getRowTotalGroup());
        cell.setParent(this.getParent());
        cell.setType(this.getType());
        return cell;
    }

    public double getZoomFactor() {
        return this.zoomFactor;
    }

    public void setZoomFactor(double zoomFactor) {
        this.zoomFactor = zoomFactor;
    }

    public int getTopIndex() {
        return this.topIndex;
    }

    public void setTopIndex(int topIndex) {
        this.topIndex = topIndex;
    }

    public int getBottomIndex() {
        return this.bottomIndex;
    }

    public void setBottomIndex(int bottomIndex) {
        this.bottomIndex = bottomIndex;
    }

    public int getLeftIndex() {
        return this.leftIndex;
    }

    public void setLeftIndex(int leftIndex) {
        this.leftIndex = leftIndex;
    }

    public int getRightIndex() {
        return this.rightIndex;
    }

    public void setRightIndex(int rightIndex) {
        this.rightIndex = rightIndex;
    }

    public String toString() {
        return this.getName();
    }

    public boolean isPaintSelection() {
        return this.paintSelection;
    }

    public void setPaintSelection(boolean paintSelection) {
        this.paintSelection = paintSelection;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public Style getStyle() {
        return this.style;
    }

    public void setStyle(Style style) {
        if (this.style != style) {
            this.style = style;
            if (style != null) {
                this.setBackcolor(style.getAttributeColor("backcolor", this.getBackcolor(), true));
                this.setMode(style.getAttributeString("mode", this.getMode(), true));
                if (style.getAttributeString("border", null, true) != null) {
                    this.getBox().setBorder(style.getAttributeString("border", null, true));
                }
                if (style.getAttributeColor("borderColor", null, true) != null) {
                    this.getBox().setBorderColor(style.getAttributeColor("borderColor", null, true));
                }
                if (style.getAttributeString("padding", null, true) != null) {
                    this.getBox().setPadding(Integer.parseInt(style.getAttributeString("padding", null, true)));
                }
                if (style.getAttributeString("topBorder", null, true) != null) {
                    this.getBox().setTopBorder(style.getAttributeString("topBorder", null, true));
                }
                if (style.getAttributeColor("topBorderColor", null, true) != null) {
                    this.getBox().setTopBorderColor(style.getAttributeColor("topBorderColor", null, true));
                }
                if (style.getAttributeString("topPadding", null, true) != null) {
                    this.getBox().setTopPadding(Integer.parseInt(style.getAttributeString("topPadding", null, true)));
                }
                if (style.getAttributeString("leftBorder", null, true) != null) {
                    this.getBox().setLeftBorder(style.getAttributeString("leftBorder", null, true));
                }
                if (style.getAttributeColor("leftBorderColor", null, true) != null) {
                    this.getBox().setLeftBorderColor(style.getAttributeColor("leftBorderColor", null, true));
                }
                if (style.getAttributeString("leftPadding", null, true) != null) {
                    this.getBox().setLeftPadding(Integer.parseInt(style.getAttributeString("leftPadding", null, true)));
                }
                if (style.getAttributeString("rightBorder", null, true) != null) {
                    this.getBox().setRightBorder(style.getAttributeString("rightBorder", null, true));
                }
                if (style.getAttributeColor("rightBorderColor", null, true) != null) {
                    this.getBox().setRightBorderColor(style.getAttributeColor("rightBorderColor", null, true));
                }
                if (style.getAttributeString("rightPadding", null, true) != null) {
                    this.getBox().setRightPadding(Integer.parseInt(style.getAttributeString("rightPadding", null, true)));
                }
                if (style.getAttributeString("bottomBorder", null, true) != null) {
                    this.getBox().setBottomBorder(style.getAttributeString("bottomBorder", null, true));
                }
                if (style.getAttributeColor("bottomBorderColor", null, true) != null) {
                    this.getBox().setBottomBorderColor(style.getAttributeColor("bottomBorderColor", null, true));
                }
                if (style.getAttributeString("bottomPadding", null, true) != null) {
                    this.getBox().setBottomPadding(Integer.parseInt(style.getAttributeString("bottomPadding", null, true)));
                }
            }
        }
    }
}

