/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui;

import bsh.EvalError;
import bsh.Interpreter;
import it.businesslogic.ireport.IReportConnection;
import it.businesslogic.ireport.JRField;
import it.businesslogic.ireport.JRParameter;
import it.businesslogic.ireport.JRProperty;
import it.businesslogic.ireport.Report;
import it.businesslogic.ireport.SubDataset;
import it.businesslogic.ireport.connection.JRCSVDataSourceConnection;
import it.businesslogic.ireport.connection.JRDataSourceProviderConnection;
import it.businesslogic.ireport.data.BeanInspectorPanel;
import it.businesslogic.ireport.data.ejbql.EJBQLFieldsReader;
import it.businesslogic.ireport.data.olap.OLAPQueryExecuter;
import it.businesslogic.ireport.data.olap.OlapBrowser;
import it.businesslogic.ireport.gui.JRSQLExpressionArea;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.gui.sheet.Tag;
import it.businesslogic.ireport.hibernate.HQLFieldsReader;
import it.businesslogic.ireport.util.Misc;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableModel;
import mondrian.olap.Query;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignParameter;
import net.sf.jasperreports.engine.design.JRDesignQuery;
import net.sf.jasperreports.engine.design.JasperDesign;

public class ReportQueryDialog
extends JDialog
implements ClipboardOwner {
    private BeanInspectorPanel bip1 = null;
    private BeanInspectorPanel bip2 = null;
    private OlapBrowser olapBrowser = null;
    protected static String[] standard_types = new String[]{"java.lang.String", "java.lang.Object", "java.lang.Boolean", "java.lang.Byte", "java.util.Date", "java.sql.Timestamp", "java.sql.Time", "java.lang.Double", "java.lang.Float", "java.lang.Integer", "java.io.InputStream", "java.lang.Long", "java.lang.Short", "java.math.BigDecimal"};
    public FieldReader readerThread = null;
    public static int num = 1;
    Timer stoppedChanging = new Timer(500, new ActionListener(){

        public void actionPerformed(ActionEvent evt) {
            if (ReportQueryDialog.this.automaticlyReadFieldsCheckBox.isSelected()) {
                ReportQueryDialog.this.processQueryChanged(ReportQueryDialog.this.jRSQLExpressionArea1.getText().trim());
            }
        }
    });
    Map parameterNameToExpressionID = null;
    private JCheckBox automaticlyReadFieldsCheckBox;
    private JButton cancelButton;
    private JLabel columnsErrorMsgLabel;
    private JScrollPane columnsErrorScrollPane;
    private JScrollPane columnsScrollPane;
    private JButton exportQueryButton;
    private JButton jButton2;
    private JButton jButton3;
    private JButton jButtonLoadQuery;
    private JButton jButtonReadBeanAttributes3;
    private JButton jButtonSaveQuery;
    private JComboBox jComboBoxQueryType;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JLabel jLabelStatusSQL;
    private JPanel jPanel1;
    private JPanel jPanel11;
    private JPanel jPanel14;
    private JPanel jPanel15;
    private JPanel jPanel16;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JPanel jPanel9;
    private JPanel jPanelQueryArea;
    private JPanel jPanelSQL;
    private JRSQLExpressionArea jRSQLExpressionArea1;
    private JSeparator jSeparator1;
    private JSplitPane jSplitPane1;
    private JSplitPane jSplitPane2;
    private JTabbedPane jTabbedPane1;
    private JTable jTableFields;
    private JTextField jTextFieldBeanClass1;
    private JButton okButton;
    private JButton readFieldsButton;
    private boolean isSettingSQLExpression = false;
    private SubDataset subDataset;

    private JLabel getJLabelStatusSQL() {
        return this.jLabelStatusSQL;
    }

    public ReportQueryDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.setSize(800, 550);
        Misc.centerFrame(this);
        this.stoppedChanging.setRepeats(false);
        this.jRSQLExpressionArea1.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                if (ReportQueryDialog.this.isSettingSQLExpression) {
                    return;
                }
                ReportQueryDialog.this.stoppedChanging.restart();
            }

            public void insertUpdate(DocumentEvent e) {
                if (ReportQueryDialog.this.isSettingSQLExpression) {
                    return;
                }
                ReportQueryDialog.this.stoppedChanging.restart();
            }

            public void removeUpdate(DocumentEvent e) {
                if (ReportQueryDialog.this.isSettingSQLExpression) {
                    return;
                }
                ReportQueryDialog.this.stoppedChanging.restart();
            }
        });
        this.setColumnsError("Please open a report.");
        if (MainFrame.getMainInstance().getProperties().getProperty("beanClass") != null) {
            this.jTextFieldBeanClass1.setText(MainFrame.getMainInstance().getProperties().getProperty("beanClass") + "");
        }
        this.jComboBoxQueryType.addItem(new Tag("sql", "SQL"));
        this.jComboBoxQueryType.addItem(new Tag("hql", "Hibernate Query Language (HQL)"));
        this.jComboBoxQueryType.addItem(new Tag("xPath", "XPath"));
        this.jComboBoxQueryType.addItem(new Tag("ejbql", "EJBQL"));
        this.jComboBoxQueryType.addItem(new Tag("mdx", "MDX"));
        this.okButton.setEnabled(false);
        this.bip1 = new BeanInspectorPanel();
        this.bip1.setComboVisible(false);
        this.bip1.setJTableFields(this.jTableFields);
        this.bip1.setPathOnDescription(true);
        this.jPanel11.add((Component)this.bip1, "Center");
        this.bip2 = new BeanInspectorPanel();
        this.bip2.setJTableFields(this.jTableFields);
        this.olapBrowser = new OlapBrowser();
        this.olapBrowser.setJTableFields(this.jTableFields);
        this.setBeanExplorerObject(null, false, false);
    }

    private void processQueryChanged(String query) {
        if (this.subDataset == null) {
            this.setColumnsError("Please open a report.");
            return;
        }
        if (query.length() == 0) {
            this.setColumnsError("You must insert a valid query first");
            return;
        }
        IReportConnection conn = (IReportConnection)MainFrame.getMainInstance().getProperties().get("DefaultConnection");
        Object obj = this.jComboBoxQueryType.getSelectedItem();
        String queryLanguage = "sql";
        queryLanguage = obj != null && obj instanceof Tag ? "" + ((Tag)obj).getValue() : "" + obj;
        if (queryLanguage.equals("sql") && (conn == null || !conn.isJDBCConnection())) {
            this.setColumnsError("The active connection is not of type JDBC. Activate a JDBC connection first.");
            return;
        }
        try {
            if (this.readerThread != null && this.readerThread.isAlive()) {
                this.readerThread.interrupt();
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        this.readerThread = new FieldReader(query, conn, queryLanguage);
        this.readerThread.start();
    }

    private void setColumns(List cols) {
        this.columnsErrorMsgLabel.setText("");
        this.jPanel2.remove(this.columnsErrorScrollPane);
        this.jPanel2.add((Component)this.columnsScrollPane, "Center");
        this.jPanel2.revalidate();
        DefaultTableModel dtm = (DefaultTableModel)this.jTableFields.getModel();
        dtm.getDataVector().clear();
        for (int i = 0; i < cols.size(); ++i) {
            Object[] row = (Object[])cols.get(i);
            dtm.addRow(row);
        }
        this.jTableFields.selectAll();
        this.okButton.setEnabled(true);
    }

    private void setColumnsError(String msg) {
        this.columnsErrorMsgLabel.setText(msg);
        this.jPanel2.remove(this.columnsScrollPane);
        this.jPanel2.add((Component)this.columnsErrorScrollPane, "Center");
        this.jPanel2.revalidate();
        this.columnsErrorMsgLabel.repaint();
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.jPanel1 = new JPanel();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanelSQL = new JPanel();
        this.jPanel14 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jComboBoxQueryType = new JComboBox();
        this.jPanel16 = new JPanel();
        this.jButtonLoadQuery = new JButton();
        this.jButtonSaveQuery = new JButton();
        this.jPanelQueryArea = new JPanel();
        this.jSplitPane2 = new JSplitPane();
        this.jPanel7 = new JPanel();
        this.jRSQLExpressionArea1 = new JRSQLExpressionArea();
        this.jLabelStatusSQL = new JLabel();
        this.automaticlyReadFieldsCheckBox = new JCheckBox();
        this.readFieldsButton = new JButton();
        this.exportQueryButton = new JButton();
        this.jPanel8 = new JPanel();
        this.jTextFieldBeanClass1 = new JTextField();
        this.jLabel3 = new JLabel();
        this.jButtonReadBeanAttributes3 = new JButton();
        this.jPanel11 = new JPanel();
        this.jSeparator1 = new JSeparator();
        this.jPanel6 = new JPanel();
        this.jButton2 = new JButton();
        this.jPanel15 = new JPanel();
        this.jButton3 = new JButton();
        this.jPanel2 = new JPanel();
        this.columnsScrollPane = new JScrollPane();
        this.jTableFields = new JTable();
        this.jPanel3 = new JPanel();
        this.jPanel4 = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.jPanel9 = new JPanel();
        this.columnsErrorScrollPane = new JScrollPane();
        this.columnsErrorMsgLabel = new JLabel();
        this.setTitle("Report query");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ReportQueryDialog.this.closeDialog(evt);
            }

            public void windowOpened(WindowEvent evt) {
                ReportQueryDialog.this.formWindowOpened(evt);
            }
        });
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setResizeWeight(0.5);
        this.jPanel1.setLayout(new BorderLayout());
        this.jPanel1.setMinimumSize(new Dimension(10, 100));
        this.jPanel1.setPreferredSize(new Dimension(10, 350));
        this.jTabbedPane1.setMinimumSize(new Dimension(154, 350));
        this.jTabbedPane1.setPreferredSize(new Dimension(154, 350));
        this.jPanelSQL.setLayout(new GridBagLayout());
        this.jPanelSQL.setMinimumSize(new Dimension(1, 100));
        this.jPanelSQL.setPreferredSize(new Dimension(1, 350));
        this.jPanel14.setLayout(new GridBagLayout());
        this.jLabel1.setText("Query language");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel14.add((Component)this.jLabel1, gridBagConstraints);
        this.jComboBoxQueryType.setEditable(true);
        this.jComboBoxQueryType.setMinimumSize(new Dimension(200, 18));
        this.jComboBoxQueryType.setPreferredSize(new Dimension(200, 22));
        this.jComboBoxQueryType.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportQueryDialog.this.jComboBoxQueryTypeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 0, 4, 4);
        this.jPanel14.add((Component)this.jComboBoxQueryType, gridBagConstraints);
        this.jPanel16.setLayout(new GridBagLayout());
        this.jButtonLoadQuery.setIcon(new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/menu/folder_database.png")));
        this.jButtonLoadQuery.setText("Load query");
        this.jButtonLoadQuery.setMargin(new Insets(2, 4, 2, 4));
        this.jButtonLoadQuery.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportQueryDialog.this.jButtonLoadQueryActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        this.jPanel16.add((Component)this.jButtonLoadQuery, gridBagConstraints);
        this.jButtonSaveQuery.setIcon(new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/menu/database_save.png")));
        this.jButtonSaveQuery.setText("Save query");
        this.jButtonSaveQuery.setMargin(new Insets(2, 4, 2, 4));
        this.jButtonSaveQuery.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportQueryDialog.this.jButtonSaveQueryActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.jPanel16.add((Component)this.jButtonSaveQuery, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.jPanel14.add((Component)this.jPanel16, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanelSQL.add((Component)this.jPanel14, gridBagConstraints);
        this.jPanelQueryArea.setLayout(new BorderLayout());
        this.jSplitPane2.setBorder(null);
        this.jSplitPane2.setDividerSize(6);
        this.jSplitPane2.setResizeWeight(0.5);
        this.jSplitPane2.setOneTouchExpandable(true);
        this.jPanel7.setLayout(new GridBagLayout());
        this.jRSQLExpressionArea1.setBorder(BorderFactory.createEtchedBorder());
        this.jRSQLExpressionArea1.setMinimumSize(new Dimension(50, 200));
        this.jRSQLExpressionArea1.setPreferredSize(new Dimension(661, 340));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel7.add((Component)this.jRSQLExpressionArea1, gridBagConstraints);
        this.jLabelStatusSQL.setBorder(BorderFactory.createEtchedBorder());
        this.jLabelStatusSQL.setMinimumSize(new Dimension(4, 20));
        this.jLabelStatusSQL.setPreferredSize(new Dimension(4, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        this.jPanel7.add((Component)this.jLabelStatusSQL, gridBagConstraints);
        this.automaticlyReadFieldsCheckBox.setSelected(true);
        this.automaticlyReadFieldsCheckBox.setText("Automatically Retrieve Fields");
        this.automaticlyReadFieldsCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportQueryDialog.this.automaticlyReadFieldsCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.jPanel7.add((Component)this.automaticlyReadFieldsCheckBox, gridBagConstraints);
        this.readFieldsButton.setText("Read Fields");
        this.readFieldsButton.setEnabled(false);
        this.readFieldsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportQueryDialog.this.readFieldsButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 10, 2, 0);
        this.jPanel7.add((Component)this.readFieldsButton, gridBagConstraints);
        this.exportQueryButton.setText("Send to clipboard");
        this.exportQueryButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportQueryDialog.this.exportQueryButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 10, 2, 0);
        this.jPanel7.add((Component)this.exportQueryButton, gridBagConstraints);
        this.jSplitPane2.setLeftComponent(this.jPanel7);
        this.jPanelQueryArea.add((Component)this.jSplitPane2, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 2, 4);
        this.jPanelSQL.add((Component)this.jPanelQueryArea, gridBagConstraints);
        this.jTabbedPane1.addTab("Report query ", this.jPanelSQL);
        this.jPanel8.setLayout(new GridBagLayout());
        this.jPanel8.setMinimumSize(new Dimension(235, 30));
        this.jPanel8.setPreferredSize(new Dimension(215, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 5, 3);
        this.jPanel8.add((Component)this.jTextFieldBeanClass1, gridBagConstraints);
        this.jLabel3.setText("Class name");
        this.jLabel3.setVerticalAlignment(3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 5, 3);
        this.jPanel8.add((Component)this.jLabel3, gridBagConstraints);
        this.jButtonReadBeanAttributes3.setText("Read attributes");
        this.jButtonReadBeanAttributes3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportQueryDialog.this.jButtonReadBeanAttributes3ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 3, 5, 3);
        this.jPanel8.add((Component)this.jButtonReadBeanAttributes3, gridBagConstraints);
        this.jPanel11.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 4, 4);
        this.jPanel8.add((Component)this.jPanel11, gridBagConstraints);
        this.jSeparator1.setMinimumSize(new Dimension(0, 4));
        this.jSeparator1.setPreferredSize(new Dimension(0, 4));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.jPanel8.add((Component)this.jSeparator1, gridBagConstraints);
        this.jTabbedPane1.addTab("JavaBean Datasource", this.jPanel8);
        this.jButton2.setText("Get fields from datasource");
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportQueryDialog.this.jButton2ActionPerformed(evt);
            }
        });
        this.jPanel6.add(this.jButton2);
        this.jTabbedPane1.addTab("DataSource Provider", this.jPanel6);
        this.jButton3.setText("Get fields from datasource");
        this.jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportQueryDialog.this.jButton2ActionPerformed1(evt);
            }
        });
        this.jPanel15.add(this.jButton3);
        this.jTabbedPane1.addTab("CSV Datasource", this.jPanel15);
        this.jPanel1.add((Component)this.jTabbedPane1, "Center");
        this.jSplitPane1.setTopComponent(this.jPanel1);
        this.jPanel2.setLayout(new BorderLayout());
        this.jPanel2.setPreferredSize(new Dimension(453, 150));
        this.columnsScrollPane.setPreferredSize(new Dimension(453, 150));
        this.jTableFields.setModel(new DefaultTableModel(new Object[0][], new String[]{"Field name", "Field type", "Description"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false, false, false};
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jTableFields.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                ReportQueryDialog.this.jTableFieldsKeyReleased(evt);
            }
        });
        this.columnsScrollPane.setViewportView(this.jTableFields);
        this.jPanel2.add((Component)this.columnsScrollPane, "Center");
        this.jPanel3.setLayout(new BorderLayout());
        this.jPanel3.setPreferredSize(new Dimension(10, 34));
        this.jPanel3.setMinimumSize(new Dimension(10, 34));
        this.jPanel4.setLayout(new GridBagLayout());
        this.jPanel4.setPreferredSize(new Dimension(150, 10));
        this.okButton.setText("OK");
        this.okButton.setEnabled(false);
        this.okButton.setMaximumSize(new Dimension(67, 25));
        this.okButton.setMinimumSize(new Dimension(67, 25));
        this.okButton.setPreferredSize(new Dimension(67, 25));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportQueryDialog.this.okButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.jPanel4.add((Component)this.okButton, gridBagConstraints);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportQueryDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.jPanel4.add((Component)this.cancelButton, gridBagConstraints);
        this.jPanel3.add((Component)this.jPanel4, "East");
        this.jPanel9.setLayout(null);
        this.jPanel9.setMinimumSize(new Dimension(100, 20));
        this.jPanel3.add((Component)this.jPanel9, "Center");
        this.jPanel2.add((Component)this.jPanel3, "South");
        this.columnsErrorMsgLabel.setText("jLabel1");
        this.columnsErrorMsgLabel.setVerticalAlignment(1);
        this.columnsErrorMsgLabel.setVerticalTextPosition(1);
        this.columnsErrorScrollPane.setViewportView(this.columnsErrorMsgLabel);
        this.jPanel2.add((Component)this.columnsErrorScrollPane, "Center");
        this.jSplitPane1.setBottomComponent(this.jPanel2);
        this.getContentPane().add((Component)this.jSplitPane1, "Center");
        this.pack();
    }

    private void jButtonSaveQueryActionPerformed(ActionEvent evt) {
        Misc.saveSQLQuery(this.jRSQLExpressionArea1.getText(), this);
    }

    private void jButtonLoadQueryActionPerformed(ActionEvent evt) {
        String query = Misc.loadSQLQuery(this);
        if (query != null) {
            this.jRSQLExpressionArea1.setText(query);
        }
    }

    private void jComboBoxQueryTypeActionPerformed(ActionEvent evt) {
        this.setBeanExplorerObject(null, false, false);
        this.readFieldsButton.setEnabled(!this.automaticlyReadFieldsCheckBox.isSelected());
        if (this.jComboBoxQueryType.getSelectedItem() == null) {
            return;
        }
        if (this.jComboBoxQueryType.getSelectedItem() instanceof Tag && ((Tag)this.jComboBoxQueryType.getSelectedItem()).getValue().equals("ejbql")) {
            this.readFieldsButton.setEnabled(true);
        } else if (this.jComboBoxQueryType.getSelectedItem() instanceof Tag && ((Tag)this.jComboBoxQueryType.getSelectedItem()).getValue().equals("mdx")) {
            this.setSpecialLanguageComponent(this.olapBrowser);
            this.readFieldsButton.setEnabled(true);
        } else {
            this.jLabelStatusSQL.setText("");
        }
    }

    public void setBeanExplorerObject(Vector v, boolean pathOnDescription, boolean useCombo) {
        if (v == null) {
            this.setSpecialLanguageComponent(null);
        } else {
            this.bip2.setComboVisible(useCombo);
            this.bip2.setPathOnDescription(pathOnDescription);
            this.bip2.setClassNames(v);
            this.setSpecialLanguageComponent(this.bip2);
        }
        this.jRSQLExpressionArea1.requestFocusInWindow();
        this.jRSQLExpressionArea1.requestFocus();
    }

    public void setSpecialLanguageComponent(Component c) {
        if (c == null) {
            if (this.jPanelQueryArea.getComponent(0) != this.jPanel7) {
                this.jPanelQueryArea.removeAll();
                this.jPanelQueryArea.add((Component)this.jPanel7, "Center");
            }
        } else if (this.jPanelQueryArea.getComponent(0) != this.jSplitPane2 || this.jSplitPane2.getRightComponent() != c) {
            this.jPanelQueryArea.removeAll();
            this.jSplitPane2.setLeftComponent(this.jPanel7);
            this.jSplitPane2.setRightComponent(c);
            this.jPanelQueryArea.add((Component)this.jSplitPane2, "Center");
        }
        this.jPanelQueryArea.updateUI();
        this.jRSQLExpressionArea1.requestFocusInWindow();
        this.jRSQLExpressionArea1.requestFocus();
    }

    private void jButton2ActionPerformed1(ActionEvent evt) {
        IReportConnection conn = (IReportConnection)MainFrame.getMainInstance().getProperties().get("DefaultConnection");
        if (conn == null || !(conn instanceof JRCSVDataSourceConnection)) {
            this.setColumnsError("The active connection is not a JasperReports CSV DataSource.");
            return;
        }
        JRCSVDataSourceConnection ic = (JRCSVDataSourceConnection)conn;
        try {
            Vector names = ic.getColumnNames();
            DefaultTableModel dtm = (DefaultTableModel)this.jTableFields.getModel();
            dtm.setRowCount(0);
            for (int nd = 0; nd < names.size(); ++nd) {
                String fieldName = "" + names.elementAt(nd);
                JRField field = new JRField(fieldName, "java.lang.String");
                field.setDescription("");
                Vector<Object> row = new Vector<Object>();
                row.addElement(field);
                row.addElement(field.getClassType());
                row.addElement(field.getDescription());
                dtm.addRow(row);
            }
            this.jTableFields.setRowSelectionInterval(0, names.size() - 1);
        }
        catch (Exception ex) {
            this.setColumnsError("" + ex.getMessage());
        }
    }

    private void formWindowOpened(WindowEvent evt) {
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        IReportConnection conn = (IReportConnection)MainFrame.getMainInstance().getProperties().get("DefaultConnection");
        if (conn == null || !(conn instanceof JRDataSourceProviderConnection)) {
            this.setColumnsError("The active connection is not a JasperReports DataSource provider.");
            return;
        }
        JRDataSourceProviderConnection ic = (JRDataSourceProviderConnection)conn;
        try {
            int i;
            Report rep = MainFrame.getMainInstance().getActiveReportFrame().getReport();
            JasperDesign report = new JasperDesign();
            JRDesignQuery queryDes = new JRDesignQuery();
            queryDes.setText(this.jRSQLExpressionArea1.getText());
            String queryLanguage = "sql";
            Object obj = this.jComboBoxQueryType.getSelectedItem();
            queryLanguage = obj != null && obj instanceof Tag ? "" + ((Tag)obj).getValue() : "" + obj;
            queryDes.setLanguage(queryLanguage);
            report.setQuery(queryDes);
            for (i = 0; i < rep.getJRproperties().size(); ++i) {
                JRProperty property = (JRProperty)rep.getJRproperties().elementAt(i);
                report.setProperty(property.getName(), property.getValue());
            }
            for (i = 0; i < rep.getParameters().size(); ++i) {
                JRParameter ireportParam = (JRParameter)rep.getParameters().elementAt(i);
                if (ireportParam.isBuiltin()) continue;
                JRDesignParameter param = new JRDesignParameter();
                param.setName(ireportParam.getName());
                JRDesignExpression de = new JRDesignExpression();
                de.setText(ireportParam.getDefaultValueExpression());
                de.setValueClassName(ireportParam.getClassType());
                param.setDefaultValueExpression((JRExpression)de);
                param.setForPrompting(ireportParam.isIsForPrompting());
                param.setValueClassName(ireportParam.getClassType());
                report.addParameter((net.sf.jasperreports.engine.JRParameter)param);
            }
            try {
                report.setName(rep.getName());
            }
            catch (Exception ex) {
                // empty catch block
            }
            JasperReport jr = new JasperReport((JRReport)report, "", null, null, "");
            net.sf.jasperreports.engine.JRField[] jrfields = ic.getDataSourceProvider().getFields(jr);
            DefaultTableModel dtm = (DefaultTableModel)this.jTableFields.getModel();
            dtm.setRowCount(0);
            for (int i2 = 0; i2 < jrfields.length; ++i2) {
                JRField field = new JRField(jrfields[i2].getName(), jrfields[i2].getValueClassName());
                field.setDescription(Misc.nvl(jrfields[i2].getDescription(), ""));
                Vector<Object> row = new Vector<Object>();
                row.addElement(field);
                row.addElement(field.getClassType());
                row.addElement(field.getDescription());
                dtm.addRow(row);
            }
        }
        catch (Exception ex) {
            this.setColumnsError("" + ex.getMessage());
        }
    }

    private void exportQueryButtonActionPerformed(ActionEvent evt) {
        FieldReader fr = new FieldReader(this.jRSQLExpressionArea1.getText(), null);
        String query = fr.interpretQuery();
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection fieldContent = new StringSelection(query);
        clipboard.setContents(fieldContent, this);
    }

    private void jButtonReadBeanAttributes3ActionPerformed(ActionEvent evt) {
        this.bip1.setClassName(this.jTextFieldBeanClass1.getText().trim());
    }

    protected void getFieldsFromClass(Class clazz, String path) throws Exception {
        DefaultTableModel dtm = (DefaultTableModel)this.jTableFields.getModel();
        Method[] methods = clazz.getMethods();
        Field[] fields = clazz.getFields();
        for (int i = 0; i < methods.length; ++i) {
            if (!Modifier.isPublic(methods[i].getModifiers()) || !methods[i].getDeclaringClass().getName().equals(clazz.getName()) || Modifier.isNative(methods[i].getModifiers()) || !methods[i].getName().startsWith("get") || methods[i].getReturnType().isPrimitive() || methods[i].getReturnType().isArray()) continue;
            String fieldName = methods[i].getName().substring(3);
            for (int f = 0; f < fields.length; ++f) {
                if (!fields[f].getName().equalsIgnoreCase(fieldName)) continue;
                fieldName = fields[f].getName();
                break;
            }
            String returnType = methods[i].getReturnType().getName();
            boolean found = false;
            for (int cc = 0; cc < standard_types.length; ++cc) {
                if (!returnType.equalsIgnoreCase(standard_types[cc])) continue;
                JRField field = new JRField(fieldName, returnType);
                field.setDescription(path + "" + fieldName);
                Vector<Object> row = new Vector<Object>();
                row.addElement(field);
                row.addElement(field.getClassType());
                row.addElement(field.getDescription());
                dtm.addRow(row);
                found = true;
                break;
            }
            if (found) continue;
            JRField field = new JRField(fieldName, "java.lang.Object");
            field.setDescription(path + "" + fieldName);
            Vector<Object> row = new Vector<Object>();
            row.addElement(field);
            row.addElement(field.getClassType());
            row.addElement(field.getDescription());
            dtm.addRow(row);
            Class<?> subClazz = Class.forName(returnType);
            this.getFieldsFromClass(subClazz, path + fieldName + ".");
        }
    }

    private void automaticlyReadFieldsCheckBoxActionPerformed(ActionEvent evt) {
        if (this.automaticlyReadFieldsCheckBox.isSelected()) {
            this.readFieldsButton.setEnabled(false);
            this.processQueryChanged(this.jRSQLExpressionArea1.getText().trim());
        } else {
            this.readFieldsButton.setEnabled(true);
            this.jLabelStatusSQL.setText("Enter your query above. Then use the Read Fields button to retrieve the list of fields.");
        }
        MainFrame.getMainInstance().getProperties().setProperty("UseAutoRegiesterFields", "" + this.automaticlyReadFieldsCheckBox.isSelected());
    }

    private void readFieldsButtonActionPerformed(ActionEvent evt) {
        this.processQueryChanged(this.jRSQLExpressionArea1.getText().trim());
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        ++num;
        this.setVisible(false);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        try {
            if (this.stoppedChanging != null) {
                this.stoppedChanging.stop();
            }
            if (this.getSubDataset() != null) {
                ++num;
                Object obj = this.jComboBoxQueryType.getSelectedItem();
                if (obj != null && obj instanceof Tag) {
                    this.subDataset.setQueryLanguage("" + ((Tag)obj).getValue());
                } else {
                    this.subDataset.setQueryLanguage("" + obj);
                }
                this.subDataset.setQuery(this.jRSQLExpressionArea1.getText());
                if (this.jTableFields.getRowCount() > 0) {
                    this.subDataset.getFields().clear();
                    int[] selectedRows = this.jTableFields.getSelectedRows();
                    for (int i = 0; i < selectedRows.length; ++i) {
                        if (selectedRows[i] > this.jTableFields.getRowCount()) continue;
                        JRField field = (JRField)this.jTableFields.getValueAt(selectedRows[i], 0);
                        Enumeration e = this.subDataset.getFields().elements();
                        boolean found = false;
                        while (e.hasMoreElements()) {
                            JRField f = (JRField)e.nextElement();
                            if (!f.getName().equalsIgnoreCase(field.getName())) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        this.subDataset.addField(field);
                    }
                    if (this.subDataset instanceof Report) {
                        MainFrame.getMainInstance().getValuesDialog().getValuesPanel().updateFields();
                    }
                }
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        this.setVisible(false);
    }

    private void jTableFieldsKeyReleased(KeyEvent evt) {
        if (evt.getKeyCode() == 127) {
            DefaultTableModel dtm = (DefaultTableModel)this.jTableFields.getModel();
            while (this.jTableFields.getSelectedRow() >= 0) {
                dtm.removeRow(this.jTableFields.getSelectedRow());
            }
        }
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) {
        new ReportQueryDialog((Frame)new JFrame(), true).setVisible(true);
    }

    private Interpreter prepareExpressionEvaluator() throws EvalError {
        Interpreter interpreter = new Interpreter();
        interpreter.setClassLoader(interpreter.getClass().getClassLoader());
        StringTokenizer st = new StringTokenizer(MainFrame.getMainInstance().getProperties().getProperty("classpath", ""), "\n");
        interpreter.eval("String tmp;");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token == null || token.trim().length() <= 0) continue;
            interpreter.set("tmp", (Object)token.trim());
            interpreter.eval("addClassPath(tmp);");
        }
        Enumeration imps = MainFrame.getMainInstance().getActiveReportFrame().getReport().getImports().elements();
        while (imps.hasMoreElements()) {
            String var = (String)imps.nextElement();
            interpreter.eval("import " + var + ";");
        }
        return interpreter;
    }

    private Class classStringToClass(String classType) {
        Class c = null;
        if (classType.equals("java.lang.String")) {
            c = String.class;
        } else if (classType.equals("java.lang.Integer")) {
            c = Integer.class;
        } else if (classType.equals("java.lang.Boolean")) {
            c = Boolean.class;
        } else if (classType.equals("java.lang.Byte")) {
            c = Byte.class;
        } else if (classType.equals("java.util.Date")) {
            c = Date.class;
        } else if (classType.equals("java.sql.Timestamp")) {
            c = Timestamp.class;
        } else if (classType.equals("java.sql.Time")) {
            c = Time.class;
        } else if (classType.equals("java.lang.Double")) {
            c = Double.class;
        } else if (classType.equals("java.lang.Float")) {
            c = Float.class;
        } else if (classType.equals("java.lang.Long")) {
            c = Long.class;
        } else if (classType.equals("java.lang.Short")) {
            c = Short.class;
        } else if (classType.equals("java.math.BigDecimal")) {
            c = BigDecimal.class;
        }
        return c;
    }

    public void lostOwnership(Clipboard parClipboard, Transferable parTransferable) {
    }

    public static Object recursiveInterpreter(Interpreter interpreter, String expression, Vector parameters) throws EvalError {
        return ReportQueryDialog.recursiveInterpreter(interpreter, expression, parameters, 0);
    }

    public static Object recursiveInterpreter(Interpreter interpreter, String expression, Vector parameters, int recursion_level) throws EvalError {
        if (++recursion_level > 100) {
            return null;
        }
        if (expression != null && expression.trim().length() > 0) {
            while (expression.indexOf("$P{") >= 0) {
                int start_index = expression.indexOf("$P{") + 3;
                String param_name = expression.substring(start_index, expression.indexOf("}", start_index));
                String param_expression = "";
                for (int i = 0; i < parameters.size(); ++i) {
                    JRParameter p = (JRParameter)parameters.elementAt(i);
                    if (!p.getName().equals(param_name)) continue;
                    param_expression = p.getDefaultValueExpression();
                    break;
                }
                expression = Misc.string_replace(param_name, "$P{" + param_name + "}", expression);
                interpreter.set(param_name, ReportQueryDialog.recursiveInterpreter(interpreter, param_expression, parameters, recursion_level));
            }
            Object res = interpreter.eval(expression);
            return res;
        }
        return null;
    }

    public SubDataset getSubDataset() {
        return this.subDataset;
    }

    public void setSubDataset(SubDataset subDataset) {
        this.subDataset = subDataset;
        DefaultTableModel dtm = (DefaultTableModel)this.jTableFields.getModel();
        dtm.setRowCount(0);
        ++num;
        this.jLabelStatusSQL.setText("");
        this.jRSQLExpressionArea1.setText("");
        this.setBeanExplorerObject(null, true, true);
        try {
            this.automaticlyReadFieldsCheckBox.setSelected(Boolean.parseBoolean(MainFrame.getMainInstance().getProperties().getProperty("UseAutoRegiesterFields", "true")));
            this.automaticlyReadFieldsCheckBoxActionPerformed(null);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (subDataset == null) {
            this.jRSQLExpressionArea1.setText("");
        } else {
            this.isSettingSQLExpression = true;
            this.jRSQLExpressionArea1.setText(this.subDataset.getQuery());
            this.isSettingSQLExpression = false;
            ArrayList<Object[]> columns = new ArrayList<Object[]>();
            Iterator i = subDataset.getFields().iterator();
            while (i.hasNext()) {
                JRField field = (JRField)i.next();
                columns.add(new Object[]{field, field.getClassType(), field.getDescription()});
            }
            this.setColumns(columns);
            for (int ix = 0; ix < this.jComboBoxQueryType.getItemCount(); ++ix) {
                if (this.jComboBoxQueryType.getItemAt(ix) instanceof Tag) continue;
                this.jComboBoxQueryType.removeItemAt(ix);
                --ix;
            }
            boolean found = false;
            for (int ix = 0; ix < this.jComboBoxQueryType.getItemCount(); ++ix) {
                Tag t = (Tag)this.jComboBoxQueryType.getItemAt(ix);
                if (!t.getValue().equals(subDataset.getQueryLanguage())) continue;
                found = true;
                this.jComboBoxQueryType.setSelectedIndex(ix);
                break;
            }
            if (!found) {
                this.jComboBoxQueryType.setEditable(true);
                this.jComboBoxQueryType.setSelectedItem(subDataset.getQueryLanguage());
            }
            this.jLabelStatusSQL.setText("");
            if (subDataset.getQueryLanguage().equals("ejbql")) {
                this.jLabelStatusSQL.setText("Field detection is not yet available for EJBQL queries");
            } else if (subDataset.getQueryLanguage().equals("mdx")) {
                this.setSpecialLanguageComponent(this.olapBrowser);
                this.readFieldsButton.setEnabled(true);
            }
        }
    }

    class FieldReader
    extends Thread {
        String src_query;
        String src_query_language = "sql";
        IReportConnection conn;

        public FieldReader(String query, IReportConnection conn) {
            this(query, conn, "sql");
        }

        public FieldReader(String query, IReportConnection conn, String query_language) {
            this.src_query = query;
            this.conn = conn;
            this.src_query_language = query_language;
        }

        private void setColumnsFromWorker(final List columns) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        String str = ReportQueryDialog.this.jRSQLExpressionArea1.getText().trim();
                        if (str.compareTo(FieldReader.this.src_query) == 0) {
                            ReportQueryDialog.this.setColumns(columns);
                        }
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void setBeanExplorerFromWorker(final Vector v, final boolean pathOnDescription, final boolean useCombo) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        String str = ReportQueryDialog.this.jRSQLExpressionArea1.getText().trim();
                        if (str.compareTo(FieldReader.this.src_query) == 0) {
                            ReportQueryDialog.this.setBeanExplorerObject(v, pathOnDescription, useCombo);
                        }
                        ReportQueryDialog.this.jRSQLExpressionArea1.requestFocusInWindow();
                        ReportQueryDialog.this.jRSQLExpressionArea1.requestFocus();
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private void setColumnErrorFromWork(final String error_msg) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        String str = ReportQueryDialog.this.jRSQLExpressionArea1.getText().trim();
                        if (str.compareTo(FieldReader.this.src_query) == 0) {
                            ReportQueryDialog.this.setColumnsError(error_msg);
                            ReportQueryDialog.this.jRSQLExpressionArea1.requestFocusInWindow();
                        }
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public String interpretQuery() {
            String query = this.src_query;
            try {
                Interpreter interpreter = ReportQueryDialog.this.prepareExpressionEvaluator();
                ArrayList queryParams = new ArrayList();
                Enumeration enumParams = ReportQueryDialog.this.subDataset.getParameters().elements();
                while (enumParams.hasMoreElements()) {
                    JRParameter parameter = (JRParameter)enumParams.nextElement();
                    String p1 = "$P{" + parameter.getName() + "}";
                    String p2 = "$P!{" + parameter.getName() + "}";
                    Object defValue = parameter.getDefaultValueExpression() != null && !parameter.getDefaultValueExpression().equals("") ? ReportQueryDialog.recursiveInterpreter(interpreter, parameter.getDefaultValueExpression(), ReportQueryDialog.this.subDataset.getParameters()) : null;
                    int ip1 = query.indexOf(p1);
                    while (ip1 != -1) {
                        if (defValue == null) {
                            throw new IllegalArgumentException("Please set a default value for the parameter '" + parameter.getName() + "'");
                        }
                        String before = query.substring(0, ip1);
                        String after = query.substring(ip1 + p1.length());
                        if (parameter.getClassType().equals("java.lang.String")) {
                            String stt = defValue.toString();
                            stt = Misc.string_replace("''", "'", stt);
                            query = before + "'" + stt + "'" + after;
                        } else {
                            query = before + "" + defValue.toString() + "" + after;
                        }
                        ip1 = query.indexOf(p1);
                    }
                    int ip2 = query.indexOf(p2);
                    while (ip2 != -1) {
                        if (defValue == null) {
                            throw new IllegalArgumentException("Please set a default value for the parameter '" + parameter.getName() + "'");
                        }
                        String before = query.substring(0, ip2);
                        String after = query.substring(ip2 + p2.length());
                        query = before + "" + defValue.toString() + "" + after;
                        ip2 = query.indexOf(p2);
                    }
                }
                return query;
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(null, ex.getMessage());
                return "";
            }
        }

        public void run() {
            if (this.src_query_language == null || this.src_query_language.equals("sql")) {
                this.runSQL();
            } else if (this.src_query_language.equals("hql")) {
                this.runHQL();
            } else if (this.src_query_language.equals("mdx")) {
                this.runMDX();
            } else if (this.src_query_language.equals("ejbql")) {
                this.runEJBQL();
            }
        }

        public void runHQL() {
            String error_msg = "";
            ++num;
            ReportQueryDialog.this.getJLabelStatusSQL().setText("Executing HQL query....");
            try {
                Thread.currentThread().setContextClassLoader(MainFrame.getMainInstance().getReportClassLoader());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            HQLFieldsReader hqlFR = new HQLFieldsReader(this.src_query, ReportQueryDialog.this.getSubDataset().getParameters());
            try {
                Vector fields = hqlFR.readFields();
                ArrayList<Object[]> columns = new ArrayList<Object[]>();
                for (int i = 0; i < fields.size(); ++i) {
                    JRField field = (JRField)fields.elementAt(i);
                    columns.add(new Object[]{field, field.getClassType(), field.getDescription()});
                }
                Vector v = hqlFR.getNotScalars();
                if (v.size() == 0) {
                    v = null;
                }
                this.setBeanExplorerFromWorker(v, true, true);
                this.setColumnsFromWorker(columns);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.setBeanExplorerFromWorker(null, true, true);
                this.setColumnErrorFromWork("Error: " + ex.getMessage());
            }
            ReportQueryDialog.this.getJLabelStatusSQL().setText("Ready");
        }

        public void runMDX() {
            String error_msg = "";
            ++num;
            ReportQueryDialog.this.getJLabelStatusSQL().setText("Executing MDX query....");
            try {
                Thread.currentThread().setContextClassLoader(MainFrame.getMainInstance().getReportClassLoader());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            OLAPQueryExecuter olapQE = new OLAPQueryExecuter(this.src_query, ReportQueryDialog.this.getSubDataset().getParameters());
            String lastError = "";
            try {
                final Query query = olapQE.createOlapQuery();
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        String str = ReportQueryDialog.this.jRSQLExpressionArea1.getText().trim();
                        if (str.compareTo(FieldReader.this.src_query) == 0) {
                            ReportQueryDialog.this.olapBrowser.setOlapQuery(query);
                        }
                    }
                });
            }
            catch (Exception ex) {
                ex.printStackTrace();
                ReportQueryDialog.this.olapBrowser.setOlapQuery(null);
                lastError = " (Last error was " + ex.getMessage() + ")";
            }
            ReportQueryDialog.this.getJLabelStatusSQL().setText("Ready" + lastError);
        }

        public void runEJBQL() {
            String error_msg = "";
            ++num;
            ReportQueryDialog.this.getJLabelStatusSQL().setText("Executing EJBQL query....");
            try {
                Thread.currentThread().setContextClassLoader(MainFrame.getMainInstance().getReportClassLoader());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            EJBQLFieldsReader ejbqlFR = new EJBQLFieldsReader(this.src_query, ReportQueryDialog.this.getSubDataset().getParameters());
            try {
                Vector fields = ejbqlFR.readFields();
                ArrayList<Object[]> columns = new ArrayList<Object[]>();
                for (int i = 0; i < fields.size(); ++i) {
                    JRField field = (JRField)fields.elementAt(i);
                    columns.add(new Object[]{field, field.getClassType(), field.getDescription()});
                }
                Vector<String> v = null;
                if (ejbqlFR.getSingleClassName() != null) {
                    v = new Vector<String>();
                    v.add(ejbqlFR.getSingleClassName());
                }
                System.out.println("Single class name: " + ejbqlFR.getSingleClassName());
                this.setBeanExplorerFromWorker(v, true, false);
                this.setColumnsFromWorker(columns);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.setBeanExplorerFromWorker(null, true, false);
                this.setColumnErrorFromWork("Error: " + ex.getMessage());
            }
            ReportQueryDialog.this.getJLabelStatusSQL().setText("Ready");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void runSQL() {
            String error_msg = "";
            int in = ++num;
            ReportQueryDialog.this.getJLabelStatusSQL().setText("Executing SQL query....");
            Connection con = null;
            Statement ps = null;
            try {
                String query = this.src_query;
                Interpreter interpreter = ReportQueryDialog.this.prepareExpressionEvaluator();
                ArrayList<Object> queryParams = new ArrayList<Object>();
                Enumeration enumParams = ReportQueryDialog.this.subDataset.getParameters().elements();
                block52: while (true) {
                    int ip1;
                    Object defValue;
                    String p2;
                    String p1;
                    JRParameter parameter;
                    if (enumParams.hasMoreElements()) {
                        parameter = (JRParameter)enumParams.nextElement();
                        p1 = "$P{" + parameter.getName() + "}";
                        p2 = "$P!{" + parameter.getName() + "}";
                        defValue = parameter.getDefaultValueExpression() != null && !parameter.getDefaultValueExpression().equals("") ? ReportQueryDialog.recursiveInterpreter(interpreter, parameter.getDefaultValueExpression(), ReportQueryDialog.this.subDataset.getParameters()) : null;
                        ip1 = query.indexOf(p1);
                    } else {
                        con = this.conn.getConnection();
                        if (in < num) {
                            return;
                        }
                        ps = con.prepareStatement(query);
                        for (int pc = 0; pc < queryParams.size(); ++pc) {
                            ps.setObject(pc + 1, queryParams.get(pc));
                        }
                        try {
                            ps.setFetchSize(0);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        ResultSet rs = ps.executeQuery();
                        if (in < num) {
                            return;
                        }
                        ResultSetMetaData rsmd = rs.getMetaData();
                        if (in < num) {
                            return;
                        }
                        ArrayList<Object[]> columns = new ArrayList<Object[]>();
                        for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
                            JRField field = new JRField(rsmd.getColumnLabel(i), Misc.getJdbcTypeClass(rsmd, i));
                            columns.add(new Object[]{field, field.getClassType()});
                        }
                        this.setColumnsFromWorker(columns);
                        ReportQueryDialog.this.getJLabelStatusSQL().setText("Ready");
                        return;
                    }
                    while (ip1 != -1) {
                        if (defValue == null) {
                            throw new IllegalArgumentException("Please set a default value for the parameter '" + parameter.getName() + "'");
                        }
                        String before = query.substring(0, ip1);
                        String after = query.substring(ip1 + p1.length());
                        query = before + " ? " + after;
                        queryParams.add(defValue);
                        ip1 = query.indexOf(p1);
                    }
                    int ip2 = query.indexOf(p2);
                    while (true) {
                        if (ip2 == -1) continue block52;
                        if (defValue == null) {
                            throw new IllegalArgumentException("Please set a default value for the parameter '" + parameter.getName() + "'");
                        }
                        String before = query.substring(0, ip2);
                        String after = query.substring(ip2 + p2.length());
                        query = before + "" + defValue.toString() + "" + after;
                        ip2 = query.indexOf(p2);
                    }
                    break;
                }
            }
            catch (IllegalArgumentException ie) {
                error_msg = ie.getMessage();
                ReportQueryDialog.this.getJLabelStatusSQL().setText("Ready");
            }
            catch (NoClassDefFoundError ex) {
                ex.printStackTrace();
                error_msg = "NoClassDefFoundError!!\nCheck your classpath!";
                ReportQueryDialog.this.getJLabelStatusSQL().setText("Ready");
            }
            catch (SQLException ex) {
                error_msg = "SQL problems:\n" + ex.getMessage();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                error_msg = "General problem:\n" + ex.getMessage() + "\n\nCheck username and password; is the DBMS active ?!";
                ReportQueryDialog.this.getJLabelStatusSQL().setText("Ready");
            }
            finally {
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (Exception e) {}
                }
                if (con != null) {
                    try {
                        con.close();
                    }
                    catch (Exception e) {}
                }
            }
            ReportQueryDialog.this.getJLabelStatusSQL().setText("Ready");
            this.setColumnErrorFromWork(error_msg);
        }
    }
}

