/*
 * Decompiled with CFR 0.152.
 */
package mondrian.util;

import java.sql.Time;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import mondrian.util.DailyDateSchedule;
import mondrian.util.DateSchedule;
import mondrian.util.MonthlyByDayDateSchedule;
import mondrian.util.MonthlyByWeekDateSchedule;
import mondrian.util.OnceTimeSchedule;
import mondrian.util.ScheduleUtil;
import mondrian.util.TimeSchedule;
import mondrian.util.WeeklyDateSchedule;

public class Schedule {
    private DateSchedule dateSchedule;
    private TimeSchedule timeSchedule;
    private TimeZone tz;
    private Date begin;
    private Date end;
    public static final int LAST_DAY_OF_MONTH = 0;
    public static final int LAST_WEEK_OF_MONTH = 0;
    static final TimeZone utcTimeZone = TimeZone.getTimeZone("UTC");
    static final int allDaysOfWeekBitmap = 254;
    static final int allDaysOfMonthBitmap = -268435457;
    static final int allWeeksOfMonthBitmap = 63;

    private Schedule(DateSchedule dateSchedule, TimeSchedule timeSchedule, TimeZone tz, Date begin, Date end) {
        this.dateSchedule = dateSchedule;
        this.timeSchedule = timeSchedule;
        this.tz = tz;
        this.begin = begin;
        this.end = end;
    }

    public static Schedule createOnce(Date date, TimeZone tz) {
        Calendar calendar = ScheduleUtil.createCalendar(date);
        Time timeOfDay = ScheduleUtil.createTime(calendar.get(11), calendar.get(12), calendar.get(13));
        calendar.add(13, 1);
        Date datePlusDelta = calendar.getTime();
        return Schedule.createDaily(date, datePlusDelta, tz, timeOfDay, 1);
    }

    public static Schedule createDaily(Date begin, Date end, TimeZone tz, Time timeOfDay, int period) {
        DailyDateSchedule dateSchedule = new DailyDateSchedule(begin == null ? null : ScheduleUtil.createCalendar(begin), period);
        return new Schedule(dateSchedule, new OnceTimeSchedule(ScheduleUtil.createTimeCalendar(timeOfDay)), tz, begin, end);
    }

    public static Schedule createWeekly(Date begin, Date end, TimeZone tz, Time timeOfDay, int period, int daysOfWeekBitmap) {
        WeeklyDateSchedule dateSchedule = new WeeklyDateSchedule(begin == null ? null : ScheduleUtil.createCalendar(begin), period, daysOfWeekBitmap);
        return new Schedule(dateSchedule, new OnceTimeSchedule(ScheduleUtil.createTimeCalendar(timeOfDay)), tz, begin, end);
    }

    public static Schedule createMonthlyByDay(Date begin, Date end, TimeZone tz, Time timeOfDay, int period, int daysOfMonthBitmap) {
        MonthlyByDayDateSchedule dateSchedule = new MonthlyByDayDateSchedule(begin == null ? null : ScheduleUtil.createCalendar(begin), period, daysOfMonthBitmap);
        return new Schedule(dateSchedule, new OnceTimeSchedule(ScheduleUtil.createTimeCalendar(timeOfDay)), tz, begin, end);
    }

    public static Schedule createMonthlyByWeek(Date begin, Date end, TimeZone tz, Time timeOfDay, int period, int daysOfWeekBitmap, int weeksOfMonthBitmap) {
        MonthlyByWeekDateSchedule dateSchedule = new MonthlyByWeekDateSchedule(begin == null ? null : ScheduleUtil.createCalendar(begin), period, daysOfWeekBitmap, weeksOfMonthBitmap);
        return new Schedule(dateSchedule, new OnceTimeSchedule(ScheduleUtil.createTimeCalendar(timeOfDay)), tz, begin, end);
    }

    public Date nextOccurrence(Date after, boolean strict) {
        Date next;
        if (after == null || this.begin != null && this.begin.after(after)) {
            after = this.begin;
            strict = false;
        }
        if (after == null) {
            after = new Date(0L);
        }
        if ((next = this.nextOccurrence0(after, strict)) != null && this.end != null && !next.before(this.end)) {
            next = null;
        }
        return next;
    }

    private Date nextOccurrence0(Date after, boolean strict) {
        Calendar next = ScheduleUtil.createCalendar(after);
        if (this.tz == null || this.tz.getID().equals("GMT")) {
            return this.nextOccurrence1(next, strict);
        }
        int offset = next == null ? this.tz.getRawOffset() : ScheduleUtil.timezoneOffset(this.tz, next);
        next.add(14, offset);
        Date result = this.nextOccurrence1(next, strict);
        if (result == null) {
            return null;
        }
        Calendar resultCalendar = ScheduleUtil.createCalendar(result);
        int offset2 = ScheduleUtil.timezoneOffset(this.tz, resultCalendar);
        resultCalendar.add(14, -offset2);
        return resultCalendar.getTime();
    }

    private Date nextOccurrence1(Calendar earliest, boolean strict) {
        Calendar earliestDay = ScheduleUtil.floor(earliest);
        Calendar earliestTime = ScheduleUtil.getTime(earliest);
        Calendar nextDay = this.dateSchedule.nextOccurrence(earliestDay, false);
        Calendar nextTime = this.timeSchedule.nextOccurrence(earliestTime, strict);
        if (nextTime == null) {
            nextDay = this.dateSchedule.nextOccurrence(earliestDay, true);
            nextTime = this.timeSchedule.nextOccurrence(ScheduleUtil.midnightTime, false);
        }
        if (nextDay == null || nextTime == null) {
            return null;
        }
        nextDay.set(11, nextTime.get(11));
        nextDay.set(12, nextTime.get(12));
        nextDay.set(13, nextTime.get(13));
        nextDay.set(14, nextTime.get(14));
        return nextDay.getTime();
    }
}

