/*
 * FontListLoader.java
 *
 *  iReport  --  Visual designer for generating JasperReports Documents
 *  Copyright (C) 2002-2003  Giulio Toffoli gt@businesslogic.it
 *
 *  This program is free software; you can redistribute  and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Giulio Toffoli
 *  Via T.Aspetti, 233
 *  35100 Padova ITALY
 *  gt@businesslogic.it
 *
 *
 * Created on 22 maggio 2003, 18.45
 */

package it.businesslogic.ireport;
import java.util.*;
/**
 *
 * @author  Administrator
 */
public class FontListLoader {

    /** Creates a new instance of FontListLoader */
    public FontListLoader() {
    }

    public static java.awt.Font loadFont(String file)
    {
        java.awt.Font f = null;
        try {
            f = java.awt.Font.createFont(f.TRUETYPE_FONT,  new java.io.FileInputStream(file));
        }
        catch (IllegalArgumentException ett)
        {
            System.out.println(ett.getMessage() +" No TrueType font");
        }
        catch (java.awt.FontFormatException ef)
        {
            System.out.println(ef.getMessage() +" FontFormatException");
        }
         catch (java.io.IOException ioex)
        {
            System.out.println(ioex.getMessage() +" IOException");
        }
        catch (Exception ex)
        {
            System.out.println(ex.getMessage() +" General Exception");
        }

        return f;
    }

    public static Vector loadTTFFonts()
    {
        Vector fonts = new Vector();

        String path = System.getProperty("java.class.path");
        //path += System.getProperty("path.separator") + "C:\\winnt\\fonts";
        if (path != null && path.length()>0)
        {
           StringTokenizer st = new StringTokenizer(path,  System.getProperty("path.separator") );

            while (st.hasMoreTokens())
            {
                String path_str = (String)st.nextToken();

                java.io.File file = new java.io.File(path_str);
                if (!file.exists()) {

                    continue;
                }
                if (file.isDirectory())
                {
                    String[] files = file.list( new java.io.FilenameFilter(){
                        public boolean accept(java.io.File dir, String filename)
                        {
// modified                          	
//                            return filename.toUpperCase().endsWith(".TTF") ;
                            return filename.toUpperCase().endsWith(".TTF") || filename.toUpperCase().endsWith(".TTC");
                        }
                    });

                    //added begin 
                    com.lowagie.text.pdf.FontMapper fontMapper = new com.lowagie.text.pdf.DefaultFontMapper();
                    
                    if (files == null)
                    {
                        System.out.println("Unable to list files in: " + file);
                        continue;
                    }
                    for (int i=0; i<files.length; ++i)
                    {
			if (files[i].toUpperCase().endsWith(".TTC")) {
    				try {
        				String[] names = com.lowagie.text.pdf.BaseFont.enumerateTTCNames(file.getPath() + file.separator + files[i]);
        				for (int a = 0; a < names.length; a++) {
            					java.awt.Font f = fontMapper.pdfToAwt( com.lowagie.text.FontFactory.getFont( file.getPath() + file.separator + files[i]).getBaseFont(), 10 );
            					if (f != null) {
	                				fonts.addElement(new IRFont(f, files[i]));
        	    				}
            					else
                					System.out.println("Failed to load font "+file.getPath() + file.separator +files[i]);
        				}
    				} catch(com.lowagie.text.DocumentException de) {
	        			System.out.println(de);
    				} catch(java.io.IOException ioe) {
        				System.out.println(ioe);
                                }
			} else {
			//added end
                            java.awt.Font f = loadFont( file.getPath() + file.separator + files[i]);
                            if (f != null)
                            {
                                fonts.addElement(new IRFont(f, files[i]));
                                //System.out.println(""+ f.getFamily() + " " + f.getFontName() +" ("+file.getPath() + file.separator +files[i]+")");
                            }
                            else
                                System.out.println("Failed to load font "+file.getPath() + file.separator +files[i]);
                    	}
                    }
                } else if (path_str.toUpperCase().endsWith(".TTF"))
                {
                    // Try to load this file...
                    System.out.println("m"+ path_str);
                }
                else if (path_str.toUpperCase().endsWith(".TTC"))
                {
                    // Try to load this file...
                    System.out.println("TTC: "+ path_str);
                }
            }
        }
        return fonts;
    }

}
