/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.FunDef;
import mondrian.olap.Member;
import mondrian.olap.Util;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.MultiResolver;

class DrilldownMemberFunDef
extends FunDefBase {
    private final boolean recursive;
    static final String[] reservedWords = new String[]{"RECURSIVE"};

    DrilldownMemberFunDef(FunDef funDef, boolean recursive) {
        super(funDef);
        this.recursive = recursive;
    }

    protected void drillDownObj(Evaluator evaluator, Object element, Set memberSet, List resultList) {
        int j;
        if (null == element) {
            return;
        }
        Member m = null;
        int k = -1;
        if (element instanceof Member) {
            if (!memberSet.contains(element)) {
                return;
            }
            m = (Member)element;
        } else {
            Util.assertTrue(element instanceof Member[]);
            Member[] members = (Member[])element;
            for (j = 0; j < members.length; ++j) {
                Member member = members[j];
                if (!memberSet.contains(member)) continue;
                k = j;
                m = member;
                break;
            }
            if (k == -1) {
                return;
            }
        }
        Member[] children = evaluator.getSchemaReader().getMemberChildren(m);
        for (j = 0; j < children.length; ++j) {
            Member[] objNew;
            if (k < 0) {
                objNew = children[j];
            } else {
                Member[] members = (Member[])((Member[])element).clone();
                members[k] = children[j];
                objNew = members;
            }
            resultList.add(objNew);
            if (!this.recursive) continue;
            this.drillDownObj(evaluator, objNew, memberSet, resultList);
        }
    }

    public Object evaluate(Evaluator evaluator, Exp[] args) {
        List v0 = (List)DrilldownMemberFunDef.getArg(evaluator, args, 0);
        List v1 = (List)DrilldownMemberFunDef.getArg(evaluator, args, 1);
        if (null == v0 || v0.isEmpty() || null == v1 || v1.isEmpty()) {
            return v0;
        }
        HashSet set1 = new HashSet();
        set1.addAll(v1);
        ArrayList result = new ArrayList();
        int i = 0;
        int n = v0.size();
        while (i < n) {
            Object o = v0.get(i++);
            result.add(o);
            this.drillDownObj(evaluator, o, set1, result);
        }
        return result;
    }

    static class Resolver
    extends MultiResolver {
        public Resolver() {
            super("DrilldownMember", "DrilldownMember(<Set1>, <Set2>[, RECURSIVE])", "Drills down the members in a set that are present in a second specified set.", new String[]{"fxxx", "fxxxy"});
        }

        protected FunDef createFunDef(Exp[] args, FunDef dummyFunDef) {
            boolean recursive = Resolver.getLiteralArg(args, 2, "", reservedWords, dummyFunDef).equals("RECURSIVE");
            return new DrilldownMemberFunDef(dummyFunDef, recursive);
        }

        public String[] getReservedWords() {
            return reservedWords;
        }
    }
}

