/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.config;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public abstract class AbstractFactoryBean
implements FactoryBean,
InitializingBean,
DisposableBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private boolean singleton = true;
    private Object singletonInstance;

    public void setSingleton(boolean singleton) {
        this.singleton = singleton;
    }

    public boolean isSingleton() {
        return this.singleton;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.singleton) {
            this.singletonInstance = this.createInstance();
        }
    }

    public final Object getObject() throws Exception {
        if (this.singleton) {
            return this.singletonInstance;
        }
        return this.createInstance();
    }

    public void destroy() throws Exception {
        if (this.singleton) {
            this.destroyInstance(this.singletonInstance);
        }
    }

    protected abstract Object createInstance() throws Exception;

    protected void destroyInstance(Object instance) throws Exception {
    }
}

