/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.util.Map;
import net.sf.jasperreports.charts.JRAreaPlot;
import net.sf.jasperreports.charts.JRBar3DPlot;
import net.sf.jasperreports.charts.JRBarPlot;
import net.sf.jasperreports.charts.JRBubblePlot;
import net.sf.jasperreports.charts.JRCandlestickPlot;
import net.sf.jasperreports.charts.JRCategoryDataset;
import net.sf.jasperreports.charts.JRHighLowDataset;
import net.sf.jasperreports.charts.JRHighLowPlot;
import net.sf.jasperreports.charts.JRLinePlot;
import net.sf.jasperreports.charts.JRPie3DPlot;
import net.sf.jasperreports.charts.JRPieDataset;
import net.sf.jasperreports.charts.JRPiePlot;
import net.sf.jasperreports.charts.JRScatterPlot;
import net.sf.jasperreports.charts.JRTimePeriodDataset;
import net.sf.jasperreports.charts.JRTimeSeriesDataset;
import net.sf.jasperreports.charts.JRTimeSeriesPlot;
import net.sf.jasperreports.charts.JRXyDataset;
import net.sf.jasperreports.charts.JRXyzDataset;
import net.sf.jasperreports.charts.fill.JRFillBar3DPlot;
import net.sf.jasperreports.charts.fill.JRFillBarPlot;
import net.sf.jasperreports.charts.fill.JRFillBubblePlot;
import net.sf.jasperreports.charts.fill.JRFillCategoryDataset;
import net.sf.jasperreports.charts.fill.JRFillHighLowDataset;
import net.sf.jasperreports.charts.fill.JRFillLinePlot;
import net.sf.jasperreports.charts.fill.JRFillPie3DPlot;
import net.sf.jasperreports.charts.fill.JRFillPieDataset;
import net.sf.jasperreports.charts.fill.JRFillTimePeriodDataset;
import net.sf.jasperreports.charts.fill.JRFillTimeSeriesDataset;
import net.sf.jasperreports.charts.fill.JRFillXyDataset;
import net.sf.jasperreports.charts.fill.JRFillXyzDataset;
import net.sf.jasperreports.charts.util.PieLabelGenerator;
import net.sf.jasperreports.engine.JRAbstractChartCustomizer;
import net.sf.jasperreports.engine.JRAbstractObjectFactory;
import net.sf.jasperreports.engine.JRBox;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRChartCustomizer;
import net.sf.jasperreports.engine.JRChartDataset;
import net.sf.jasperreports.engine.JRChartPlot;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRHyperlinkParameter;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintHyperlinkParameters;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRRenderable;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRCloneable;
import net.sf.jasperreports.engine.fill.JRFillChartDataset;
import net.sf.jasperreports.engine.fill.JRFillCloneFactory;
import net.sf.jasperreports.engine.fill.JRFillElement;
import net.sf.jasperreports.engine.fill.JRFillHyperlinkHelper;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRTemplateImage;
import net.sf.jasperreports.engine.fill.JRTemplatePrintImage;
import net.sf.jasperreports.engine.util.JRClassLoader;
import net.sf.jasperreports.engine.util.JRFontUtil;
import net.sf.jasperreports.engine.util.JRStyleResolver;
import net.sf.jasperreports.engine.xml.JRXmlWriter;
import net.sf.jasperreports.renderers.JFreeChartRenderer;
import net.sf.jasperreports.renderers.JRCategoryChartImageMapRenderer;
import net.sf.jasperreports.renderers.JRHighLowChartImageMapRenderer;
import net.sf.jasperreports.renderers.JRPieChartImageMapRenderer;
import net.sf.jasperreports.renderers.JRTimePeriodChartImageMapRenderer;
import net.sf.jasperreports.renderers.JRTimeSeriesChartImageMapRenderer;
import net.sf.jasperreports.renderers.JRXYChartImageMapRenderer;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.XYItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.PiePlot3D;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.category.BarRenderer3D;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.chart.renderer.category.StackedBarRenderer3D;
import org.jfree.chart.renderer.xy.CandlestickRenderer;
import org.jfree.chart.renderer.xy.HighLowRenderer;
import org.jfree.chart.renderer.xy.XYBubbleRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.title.Title;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.DefaultHighLowDataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.OHLCDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYZDataset;

public class JRFillChart
extends JRFillElement
implements JRChart {
    private static final Color TRANSPARENT_PAINT = new Color(0, 0, 0, 0);
    protected byte chartType = 0;
    protected JRFont titleFont = null;
    protected JRFont subtitleFont = null;
    protected JRGroup evaluationGroup = null;
    protected JRFillChartDataset dataset = null;
    protected JRChartPlot plot = null;
    protected JRRenderable renderer = null;
    private String anchorName = null;
    private String hyperlinkReference = null;
    private String hyperlinkAnchor = null;
    private Integer hyperlinkPage = null;
    private String hyperlinkTooltip;
    private JRPrintHyperlinkParameters hyperlinkParameters;
    protected String customizerClass;
    protected JRChartCustomizer chartCustomizer;

    protected JRFillChart(JRBaseFiller filler, JRChart chart, JRFillObjectFactory factory) {
        super(filler, chart, factory);
        this.chartType = chart.getChartType();
        switch (this.chartType) {
            case 1: {
                this.dataset = (JRFillChartDataset)((Object)factory.getCategoryDataset((JRCategoryDataset)chart.getDataset()));
                this.plot = factory.getAreaPlot((JRAreaPlot)chart.getPlot());
                break;
            }
            case 3: {
                this.dataset = (JRFillChartDataset)((Object)factory.getCategoryDataset((JRCategoryDataset)chart.getDataset()));
                this.plot = factory.getBarPlot((JRBarPlot)chart.getPlot());
                break;
            }
            case 2: {
                this.dataset = (JRFillChartDataset)((Object)factory.getCategoryDataset((JRCategoryDataset)chart.getDataset()));
                this.plot = factory.getBar3DPlot((JRBar3DPlot)chart.getPlot());
                break;
            }
            case 4: {
                this.dataset = (JRFillChartDataset)((Object)factory.getXyzDataset((JRXyzDataset)chart.getDataset()));
                this.plot = factory.getBubblePlot((JRBubblePlot)chart.getPlot());
                break;
            }
            case 5: {
                this.dataset = (JRFillChartDataset)((Object)factory.getHighLowDataset((JRHighLowDataset)chart.getDataset()));
                this.plot = factory.getCandlestickPlot((JRCandlestickPlot)chart.getPlot());
                break;
            }
            case 6: {
                this.dataset = (JRFillChartDataset)((Object)factory.getHighLowDataset((JRHighLowDataset)chart.getDataset()));
                this.plot = factory.getHighLowPlot((JRHighLowPlot)chart.getPlot());
                break;
            }
            case 7: {
                this.dataset = (JRFillChartDataset)((Object)factory.getCategoryDataset((JRCategoryDataset)chart.getDataset()));
                this.plot = factory.getLinePlot((JRLinePlot)chart.getPlot());
                break;
            }
            case 9: {
                this.dataset = (JRFillChartDataset)((Object)factory.getPieDataset((JRPieDataset)chart.getDataset()));
                this.plot = factory.getPiePlot((JRPiePlot)chart.getPlot());
                break;
            }
            case 8: {
                this.dataset = (JRFillChartDataset)((Object)factory.getPieDataset((JRPieDataset)chart.getDataset()));
                this.plot = factory.getPie3DPlot((JRPie3DPlot)chart.getPlot());
                break;
            }
            case 10: {
                this.dataset = (JRFillChartDataset)((Object)factory.getXyDataset((JRXyDataset)chart.getDataset()));
                this.plot = factory.getScatterPlot((JRScatterPlot)chart.getPlot());
                break;
            }
            case 12: {
                this.dataset = (JRFillChartDataset)((Object)factory.getCategoryDataset((JRCategoryDataset)chart.getDataset()));
                this.plot = factory.getBarPlot((JRBarPlot)chart.getPlot());
                break;
            }
            case 11: {
                this.dataset = (JRFillChartDataset)((Object)factory.getCategoryDataset((JRCategoryDataset)chart.getDataset()));
                this.plot = factory.getBar3DPlot((JRBar3DPlot)chart.getPlot());
                break;
            }
            case 16: {
                this.dataset = (JRFillChartDataset)((Object)factory.getTimeSeriesDataset((JRTimeSeriesDataset)chart.getDataset()));
                this.plot = factory.getTimeSeriesPlot((JRTimeSeriesPlot)chart.getPlot());
                break;
            }
            case 13: {
                this.dataset = (JRFillChartDataset)((Object)factory.getXyDataset((JRXyDataset)chart.getDataset()));
                this.plot = factory.getAreaPlot((JRAreaPlot)chart.getPlot());
                break;
            }
            case 14: {
                switch (chart.getDataset().getDatasetType()) {
                    case 6: {
                        this.dataset = (JRFillChartDataset)((Object)factory.getTimeSeriesDataset((JRTimeSeriesDataset)chart.getDataset()));
                        break;
                    }
                    case 5: {
                        this.dataset = (JRFillChartDataset)((Object)factory.getTimePeriodDataset((JRTimePeriodDataset)chart.getDataset()));
                        break;
                    }
                    case 3: {
                        this.dataset = (JRFillChartDataset)((Object)factory.getXyDataset((JRXyDataset)chart.getDataset()));
                    }
                }
                this.plot = factory.getBarPlot((JRBarPlot)chart.getPlot());
                break;
            }
            case 15: {
                this.dataset = (JRFillChartDataset)((Object)factory.getXyDataset((JRXyDataset)chart.getDataset()));
                this.plot = factory.getLinePlot((JRLinePlot)chart.getPlot());
                break;
            }
            default: {
                throw new JRRuntimeException("Chart type not supported.");
            }
        }
        if (chart.getTitleFont() != null) {
            this.titleFont = factory.getFont(chart.getTitleFont());
        }
        if (chart.getSubtitleFont() != null) {
            this.subtitleFont = factory.getFont(chart.getSubtitleFont());
        }
        this.evaluationGroup = factory.getGroup(chart.getEvaluationGroup());
        this.customizerClass = chart.getCustomizerClass();
        if (this.customizerClass != null && this.customizerClass.length() > 0) {
            try {
                Class myClass = JRClassLoader.loadClassForName(this.customizerClass);
                this.chartCustomizer = (JRChartCustomizer)myClass.newInstance();
            }
            catch (Exception e) {
                throw new JRRuntimeException("Could not create chart customizer instance.", e);
            }
            if (this.chartCustomizer instanceof JRAbstractChartCustomizer) {
                ((JRAbstractChartCustomizer)this.chartCustomizer).init(filler, this);
            }
        }
    }

    public byte getMode() {
        return JRStyleResolver.getMode(this, (byte)2);
    }

    public boolean isShowLegend() {
        return ((JRChart)this.parent).isShowLegend();
    }

    public void setShowLegend(boolean isShowLegend) {
    }

    public byte getEvaluationTime() {
        return ((JRChart)this.parent).getEvaluationTime();
    }

    public JRGroup getEvaluationGroup() {
        return this.evaluationGroup;
    }

    public JRBox getBox() {
        return (JRBox)((Object)this.parent);
    }

    public JRFont getTitleFont() {
        return this.titleFont;
    }

    public byte getTitlePosition() {
        return ((JRChart)this.parent).getTitlePosition();
    }

    public void setTitlePosition(byte titlePosition) {
    }

    public Color getTitleColor() {
        return ((JRChart)this.parent).getTitleColor();
    }

    public void setTitleColor(Color titleColor) {
    }

    public JRFont getSubtitleFont() {
        return this.subtitleFont;
    }

    public Color getSubtitleColor() {
        return ((JRChart)this.parent).getSubtitleColor();
    }

    public void setSubtitleColor(Color subtitleColor) {
    }

    public JRExpression getTitleExpression() {
        return ((JRChart)this.parent).getTitleExpression();
    }

    public JRExpression getSubtitleExpression() {
        return ((JRChart)this.parent).getSubtitleExpression();
    }

    public byte getHyperlinkType() {
        return ((JRChart)this.parent).getHyperlinkType();
    }

    public byte getHyperlinkTarget() {
        return ((JRChart)this.parent).getHyperlinkTarget();
    }

    public JRExpression getAnchorNameExpression() {
        return ((JRChart)this.parent).getAnchorNameExpression();
    }

    public JRExpression getHyperlinkReferenceExpression() {
        return ((JRChart)this.parent).getHyperlinkReferenceExpression();
    }

    public JRExpression getHyperlinkAnchorExpression() {
        return ((JRChart)this.parent).getHyperlinkAnchorExpression();
    }

    public JRExpression getHyperlinkPageExpression() {
        return ((JRChart)this.parent).getHyperlinkPageExpression();
    }

    public JRChartDataset getDataset() {
        return this.dataset;
    }

    public JRChartPlot getPlot() {
        return this.plot;
    }

    protected JRRenderable getRenderer() {
        return this.renderer;
    }

    protected String getAnchorName() {
        return this.anchorName;
    }

    protected String getHyperlinkReference() {
        return this.hyperlinkReference;
    }

    protected String getHyperlinkAnchor() {
        return this.hyperlinkAnchor;
    }

    protected Integer getHyperlinkPage() {
        return this.hyperlinkPage;
    }

    protected String getHyperlinkTooltip() {
        return this.hyperlinkTooltip;
    }

    protected JRTemplateImage getJRTemplateImage() {
        JRStyle style = this.getStyle();
        JRTemplateImage template = (JRTemplateImage)this.getTemplate(style);
        if (template == null) {
            template = new JRTemplateImage(this.filler.getJasperPrint().getDefaultStyleProvider(), this);
            this.registerTemplate(style, template);
        }
        return template;
    }

    protected void rewind() {
    }

    protected void evaluate(byte evaluation) throws JRException {
        this.reset();
        this.evaluatePrintWhenExpression(evaluation);
        if ((this.isPrintWhenExpressionNull() || !this.isPrintWhenExpressionNull() && this.isPrintWhenTrue()) && this.getEvaluationTime() == 1) {
            this.evaluateImage(evaluation);
        }
    }

    protected void evaluateImage(byte evaluation) throws JRException {
        JFreeChartRenderer chartRenderer;
        this.evaluateDatasetRun(evaluation);
        switch (this.chartType) {
            case 1: {
                chartRenderer = this.evaluateAreaImage(evaluation);
                break;
            }
            case 3: {
                chartRenderer = this.evaluateBarImage(evaluation);
                break;
            }
            case 2: {
                chartRenderer = this.evaluateBar3DImage(evaluation);
                break;
            }
            case 4: {
                chartRenderer = this.evaluateBubbleImage(evaluation);
                break;
            }
            case 5: {
                chartRenderer = this.evaluateCandlestickImage(evaluation);
                break;
            }
            case 6: {
                chartRenderer = this.evaluateHighLowImage(evaluation);
                break;
            }
            case 7: {
                chartRenderer = this.evaluateLineImage(evaluation);
                break;
            }
            case 9: {
                chartRenderer = this.evaluatePieImage(evaluation);
                break;
            }
            case 8: {
                chartRenderer = this.evaluatePie3DImage(evaluation);
                break;
            }
            case 10: {
                chartRenderer = this.evaluateScatterImage(evaluation);
                break;
            }
            case 12: {
                chartRenderer = this.evaluateStackedBarImage(evaluation);
                break;
            }
            case 11: {
                chartRenderer = this.evaluateStackedBar3DImage(evaluation);
                break;
            }
            case 16: {
                chartRenderer = this.evaluateTimeSeriesImage(evaluation);
                break;
            }
            case 13: {
                chartRenderer = this.evaluateXyAreaImage(evaluation);
                break;
            }
            case 14: {
                chartRenderer = this.evaluateXYBarImage(evaluation);
                break;
            }
            case 15: {
                chartRenderer = this.evaluateXyLineImage(evaluation);
                break;
            }
            default: {
                throw new JRRuntimeException("Chart type " + this.getChartType() + " not supported.");
            }
        }
        if (this.chartCustomizer != null) {
            this.chartCustomizer.customize(chartRenderer.getChart(), this);
        }
        this.renderer = chartRenderer;
        this.anchorName = (String)this.evaluateExpression(this.getAnchorNameExpression(), evaluation);
        this.hyperlinkReference = (String)this.evaluateExpression(this.getHyperlinkReferenceExpression(), evaluation);
        this.hyperlinkAnchor = (String)this.evaluateExpression(this.getHyperlinkAnchorExpression(), evaluation);
        this.hyperlinkPage = (Integer)this.evaluateExpression(this.getHyperlinkPageExpression(), evaluation);
        this.hyperlinkTooltip = (String)this.evaluateExpression(this.getHyperlinkTooltipExpression(), evaluation);
        this.hyperlinkParameters = JRFillHyperlinkHelper.evaluateHyperlinkParameters(this, this.expressionEvaluator, evaluation);
    }

    protected boolean prepare(int availableStretchHeight, boolean isOverflow) {
        boolean willOverflow = false;
        if (this.isPrintWhenExpressionNull() || !this.isPrintWhenExpressionNull() && this.isPrintWhenTrue()) {
            this.setToPrint(true);
        } else {
            this.setToPrint(false);
        }
        if (!this.isToPrint()) {
            return willOverflow;
        }
        boolean isToPrint = true;
        boolean isReprinted = false;
        if (this.getEvaluationTime() == 1) {
            if (isOverflow && this.isAlreadyPrinted() && !this.isPrintWhenDetailOverflows()) {
                isToPrint = false;
            }
            if (isToPrint && availableStretchHeight < this.getRelativeY() - this.getY() - this.getBandBottomY()) {
                isToPrint = false;
                willOverflow = true;
            }
            if (isToPrint && isOverflow && this.isPrintWhenDetailOverflows() && (this.isAlreadyPrinted() || !this.isAlreadyPrinted() && !this.isPrintRepeatedValues())) {
                isReprinted = true;
            }
            if (isToPrint && this.isRemoveLineWhenBlank() && this.getRenderer() == null) {
                isToPrint = false;
            }
        } else {
            if (isOverflow && this.isAlreadyPrinted() && !this.isPrintWhenDetailOverflows()) {
                isToPrint = false;
            }
            if (isToPrint && availableStretchHeight < this.getRelativeY() - this.getY() - this.getBandBottomY()) {
                isToPrint = false;
                willOverflow = true;
            }
            if (isToPrint && isOverflow && this.isPrintWhenDetailOverflows() && (this.isAlreadyPrinted() || !this.isAlreadyPrinted() && !this.isPrintRepeatedValues())) {
                isReprinted = true;
            }
        }
        this.setToPrint(isToPrint);
        this.setReprinted(isReprinted);
        return willOverflow;
    }

    protected JRPrintElement fill() {
        JRTemplatePrintImage printImage = new JRTemplatePrintImage(this.getJRTemplateImage());
        printImage.setX(this.getX());
        printImage.setY(this.getRelativeY());
        printImage.setWidth(this.getWidth());
        printImage.setHeight(this.getStretchHeight());
        byte evaluationType = this.getEvaluationTime();
        if (evaluationType == 1) {
            this.copy(printImage);
        } else {
            this.filler.addBoundElement(this, printImage, evaluationType, this.getEvaluationGroup(), this.band);
        }
        return printImage;
    }

    protected void copy(JRPrintImage printImage) {
        printImage.setRenderer(this.getRenderer());
        printImage.setAnchorName(this.getAnchorName());
        printImage.setHyperlinkReference(this.getHyperlinkReference());
        printImage.setHyperlinkAnchor(this.getHyperlinkAnchor());
        printImage.setHyperlinkPage(this.getHyperlinkPage());
        printImage.setHyperlinkTooltip(this.getHyperlinkTooltip());
        printImage.setBookmarkLevel(this.getBookmarkLevel());
        printImage.setHyperlinkParameters(this.hyperlinkParameters);
    }

    public byte getChartType() {
        return this.chartType;
    }

    public JRChild getCopy(JRAbstractObjectFactory factory) {
        return factory.getChart(this);
    }

    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect(this);
    }

    public void writeXml(JRXmlWriter writer) {
    }

    private void configureChart(JFreeChart chart, byte evaluation) throws JRException {
        String subtitleText;
        if (this.getMode() == 1) {
            chart.setBackgroundPaint((Paint)this.getBackcolor());
        } else {
            chart.setBackgroundPaint((Paint)TRANSPARENT_PAINT);
        }
        if (chart.getTitle() != null) {
            TextTitle title = chart.getTitle();
            title.setPaint((Paint)this.getTitleColor());
            JRFont font = this.getTitleFont();
            if (font != null) {
                Map attributes = JRFontUtil.getNonPdfAttributes(font);
                title.setFont(new Font(attributes));
            }
        }
        if ((subtitleText = (String)this.evaluateExpression(this.getSubtitleExpression(), evaluation)) != null) {
            TextTitle subtitle = new TextTitle(subtitleText);
            subtitle.setPaint((Paint)this.getSubtitleColor());
            JRFont font = this.getSubtitleFont();
            if (font != null) {
                Map attributes = JRFontUtil.getNonPdfAttributes(font);
                subtitle.setFont(new Font(attributes));
            }
            chart.addSubtitle((Title)subtitle);
        }
        this.configurePlot(chart.getPlot());
    }

    private void configurePlot(Plot p) {
        p.setOutlinePaint((Paint)TRANSPARENT_PAINT);
        if (this.getPlot().getBackcolor() == null) {
            p.setBackgroundPaint((Paint)TRANSPARENT_PAINT);
        } else {
            p.setBackgroundPaint((Paint)this.getPlot().getBackcolor());
        }
        p.setBackgroundAlpha(this.getPlot().getBackgroundAlpha());
        p.setForegroundAlpha(this.getPlot().getForegroundAlpha());
    }

    protected JFreeChartRenderer evaluateAreaImage(byte evaluation) throws JRException {
        JFreeChart chart = ChartFactory.createAreaChart((String)((String)this.evaluateExpression(this.getTitleExpression(), evaluation)), (String)((String)this.evaluateExpression(((JRAreaPlot)this.getPlot()).getCategoryAxisLabelExpression(), evaluation)), (String)((String)this.evaluateExpression(((JRAreaPlot)this.getPlot()).getValueAxisLabelExpression(), evaluation)), (CategoryDataset)((CategoryDataset)this.dataset.getDataset()), (PlotOrientation)this.getPlot().getOrientation(), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(chart, evaluation);
        return this.getCategoryRenderer(chart);
    }

    protected JFreeChartRenderer evaluateBar3DImage(byte evaluation) throws JRException {
        JFreeChart chart = ChartFactory.createBarChart3D((String)((String)this.evaluateExpression(this.getTitleExpression(), evaluation)), (String)((String)this.evaluateExpression(((JRBar3DPlot)this.getPlot()).getCategoryAxisLabelExpression(), evaluation)), (String)((String)this.evaluateExpression(((JRBar3DPlot)this.getPlot()).getValueAxisLabelExpression(), evaluation)), (CategoryDataset)((CategoryDataset)this.dataset.getDataset()), (PlotOrientation)this.getPlot().getOrientation(), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(chart, evaluation);
        CategoryPlot categoryPlot = (CategoryPlot)chart.getPlot();
        BarRenderer3D barRenderer3D = new BarRenderer3D(((JRFillBar3DPlot)this.getPlot()).getXOffset(), ((JRFillBar3DPlot)this.getPlot()).getYOffset());
        categoryPlot.setRenderer((CategoryItemRenderer)barRenderer3D);
        barRenderer3D.setBaseItemLabelGenerator((CategoryItemLabelGenerator)((JRFillCategoryDataset)this.getDataset()).getLabelGenerator());
        barRenderer3D.setItemLabelsVisible(((JRFillBar3DPlot)this.getPlot()).isShowLabels());
        return this.getCategoryRenderer(chart);
    }

    protected JFreeChartRenderer evaluateBarImage(byte evaluation) throws JRException {
        CategoryDataset categoryDataset = (CategoryDataset)this.dataset.getDataset();
        JFreeChart chart = ChartFactory.createBarChart((String)((String)this.evaluateExpression(this.getTitleExpression(), evaluation)), (String)((String)this.evaluateExpression(((JRBarPlot)this.getPlot()).getCategoryAxisLabelExpression(), evaluation)), (String)((String)this.evaluateExpression(((JRBarPlot)this.getPlot()).getValueAxisLabelExpression(), evaluation)), (CategoryDataset)categoryDataset, (PlotOrientation)this.getPlot().getOrientation(), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(chart, evaluation);
        CategoryPlot categoryPlot = (CategoryPlot)chart.getPlot();
        categoryPlot.getDomainAxis().setTickMarksVisible(((JRFillBarPlot)this.getPlot()).isShowTickMarks());
        categoryPlot.getDomainAxis().setTickLabelsVisible(((JRFillBarPlot)this.getPlot()).isShowTickLabels());
        ((NumberAxis)categoryPlot.getRangeAxis()).setTickMarksVisible(((JRFillBarPlot)this.getPlot()).isShowTickMarks());
        ((NumberAxis)categoryPlot.getRangeAxis()).setTickLabelsVisible(((JRFillBarPlot)this.getPlot()).isShowTickLabels());
        CategoryItemRenderer categoryRenderer = categoryPlot.getRenderer();
        categoryRenderer.setBaseItemLabelGenerator((CategoryItemLabelGenerator)((JRFillCategoryDataset)this.getDataset()).getLabelGenerator());
        categoryRenderer.setItemLabelsVisible(((JRFillBarPlot)this.getPlot()).isShowLabels());
        return this.getCategoryRenderer(chart);
    }

    protected JFreeChartRenderer evaluateBubbleImage(byte evaluation) throws JRException {
        JFreeChart chart = ChartFactory.createBubbleChart((String)((String)this.evaluateExpression(this.getTitleExpression(), evaluation)), (String)((String)this.evaluateExpression(((JRBubblePlot)this.getPlot()).getXAxisLabelExpression(), evaluation)), (String)((String)this.evaluateExpression(((JRBubblePlot)this.getPlot()).getYAxisLabelExpression(), evaluation)), (XYZDataset)((XYZDataset)this.dataset.getDataset()), (PlotOrientation)this.getPlot().getOrientation(), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(chart, evaluation);
        XYPlot xyPlot = (XYPlot)chart.getPlot();
        XYBubbleRenderer bubbleRenderer = new XYBubbleRenderer(((JRFillBubblePlot)this.getPlot()).getScaleType());
        xyPlot.setRenderer((XYItemRenderer)bubbleRenderer);
        return this.getXYZRenderer(chart);
    }

    protected JFreeChartRenderer evaluateCandlestickImage(byte evaluation) throws JRException {
        JFreeChart chart = ChartFactory.createCandlestickChart((String)((String)this.evaluateExpression(this.getTitleExpression(), evaluation)), (String)((String)this.evaluateExpression(((JRCandlestickPlot)this.getPlot()).getTimeAxisLabelExpression(), evaluation)), (String)((String)this.evaluateExpression(((JRCandlestickPlot)this.getPlot()).getValueAxisLabelExpression(), evaluation)), (OHLCDataset)((DefaultHighLowDataset)this.dataset.getDataset()), (boolean)this.isShowLegend());
        this.configureChart(chart, evaluation);
        XYPlot xyPlot = (XYPlot)chart.getPlot();
        CandlestickRenderer candlestickRenderer = (CandlestickRenderer)xyPlot.getRenderer();
        candlestickRenderer.setDrawVolume(((JRCandlestickPlot)this.getPlot()).isShowVolume());
        return this.getHighLowRenderer(chart);
    }

    protected JFreeChartRenderer evaluateHighLowImage(byte evaluation) throws JRException {
        JFreeChart chart = ChartFactory.createHighLowChart((String)((String)this.evaluateExpression(this.getTitleExpression(), evaluation)), (String)((String)this.evaluateExpression(((JRHighLowPlot)this.getPlot()).getTimeAxisLabelExpression(), evaluation)), (String)((String)this.evaluateExpression(((JRHighLowPlot)this.getPlot()).getValueAxisLabelExpression(), evaluation)), (OHLCDataset)((DefaultHighLowDataset)this.dataset.getDataset()), (boolean)this.isShowLegend());
        this.configureChart(chart, evaluation);
        XYPlot xyPlot = (XYPlot)chart.getPlot();
        HighLowRenderer hlRenderer = (HighLowRenderer)xyPlot.getRenderer();
        hlRenderer.setDrawOpenTicks(((JRHighLowPlot)this.getPlot()).isShowOpenTicks());
        hlRenderer.setDrawCloseTicks(((JRHighLowPlot)this.getPlot()).isShowCloseTicks());
        return this.getHighLowRenderer(chart);
    }

    protected JFreeChartRenderer evaluateLineImage(byte evaluation) throws JRException {
        JFreeChart chart = ChartFactory.createLineChart((String)((String)this.evaluateExpression(this.getTitleExpression(), evaluation)), (String)((String)this.evaluateExpression(((JRLinePlot)this.getPlot()).getCategoryAxisLabelExpression(), evaluation)), (String)((String)this.evaluateExpression(((JRLinePlot)this.getPlot()).getValueAxisLabelExpression(), evaluation)), (CategoryDataset)((CategoryDataset)this.dataset.getDataset()), (PlotOrientation)this.getPlot().getOrientation(), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(chart, evaluation);
        CategoryPlot categoryPlot = (CategoryPlot)chart.getPlot();
        LineAndShapeRenderer lineRenderer = (LineAndShapeRenderer)categoryPlot.getRenderer();
        lineRenderer.setShapesVisible(((JRFillLinePlot)this.getPlot()).isShowShapes());
        lineRenderer.setLinesVisible(((JRFillLinePlot)this.getPlot()).isShowLines());
        return this.getCategoryRenderer(chart);
    }

    protected JFreeChartRenderer evaluatePie3DImage(byte evaluation) throws JRException {
        JFreeChart chart = ChartFactory.createPieChart3D((String)((String)this.evaluateExpression(this.getTitleExpression(), evaluation)), (PieDataset)((PieDataset)this.dataset.getDataset()), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(chart, evaluation);
        PiePlot3D piePlot3D = (PiePlot3D)chart.getPlot();
        piePlot3D.setDepthFactor(((JRFillPie3DPlot)this.getPlot()).getDepthFactor());
        PieLabelGenerator labelGenerator = ((JRFillPieDataset)this.getDataset()).getLabelGenerator();
        if (labelGenerator != null) {
            piePlot3D.setLabelGenerator((PieSectionLabelGenerator)labelGenerator);
        }
        return this.getPieRenderer(chart);
    }

    protected JFreeChartRenderer evaluatePieImage(byte evaluation) throws JRException {
        JFreeChart chart = ChartFactory.createPieChart((String)((String)this.evaluateExpression(this.getTitleExpression(), evaluation)), (PieDataset)((PieDataset)this.dataset.getDataset()), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(chart, evaluation);
        PiePlot piePlot = (PiePlot)chart.getPlot();
        PieLabelGenerator labelGenerator = ((JRFillPieDataset)this.getDataset()).getLabelGenerator();
        if (labelGenerator != null) {
            piePlot.setLabelGenerator((PieSectionLabelGenerator)labelGenerator);
        }
        return this.getPieRenderer(chart);
    }

    protected JFreeChartRenderer evaluateScatterImage(byte evaluation) throws JRException {
        JFreeChart chart = ChartFactory.createScatterPlot((String)((String)this.evaluateExpression(this.getTitleExpression(), evaluation)), (String)((String)this.evaluateExpression(((JRScatterPlot)this.getPlot()).getXAxisLabelExpression(), evaluation)), (String)((String)this.evaluateExpression(((JRScatterPlot)this.getPlot()).getYAxisLabelExpression(), evaluation)), (XYDataset)((XYDataset)this.dataset.getDataset()), (PlotOrientation)this.getPlot().getOrientation(), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(chart, evaluation);
        XYLineAndShapeRenderer plotRenderer = (XYLineAndShapeRenderer)((XYPlot)chart.getPlot()).getRenderer();
        JRScatterPlot scatterPlot = (JRScatterPlot)this.getPlot();
        plotRenderer.setLinesVisible(scatterPlot.isShowLines());
        plotRenderer.setShapesVisible(scatterPlot.isShowShapes());
        return this.getXYRenderer(chart);
    }

    protected JFreeChartRenderer evaluateStackedBar3DImage(byte evaluation) throws JRException {
        JFreeChart chart = ChartFactory.createStackedBarChart3D((String)((String)this.evaluateExpression(this.getTitleExpression(), evaluation)), (String)((String)this.evaluateExpression(((JRBar3DPlot)this.getPlot()).getCategoryAxisLabelExpression(), evaluation)), (String)((String)this.evaluateExpression(((JRBar3DPlot)this.getPlot()).getValueAxisLabelExpression(), evaluation)), (CategoryDataset)((CategoryDataset)this.dataset.getDataset()), (PlotOrientation)this.getPlot().getOrientation(), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(chart, evaluation);
        CategoryPlot categoryPlot = (CategoryPlot)chart.getPlot();
        StackedBarRenderer3D stackedBarRenderer3D = new StackedBarRenderer3D(((JRFillBar3DPlot)this.getPlot()).getXOffset(), ((JRFillBar3DPlot)this.getPlot()).getYOffset());
        categoryPlot.setRenderer((CategoryItemRenderer)stackedBarRenderer3D);
        stackedBarRenderer3D.setBaseItemLabelGenerator((CategoryItemLabelGenerator)((JRFillCategoryDataset)this.getDataset()).getLabelGenerator());
        stackedBarRenderer3D.setItemLabelsVisible(((JRFillBar3DPlot)this.getPlot()).isShowLabels());
        return this.getCategoryRenderer(chart);
    }

    protected JFreeChartRenderer evaluateStackedBarImage(byte evaluation) throws JRException {
        JFreeChart chart = ChartFactory.createStackedBarChart((String)((String)this.evaluateExpression(this.getTitleExpression(), evaluation)), (String)((String)this.evaluateExpression(((JRBarPlot)this.getPlot()).getCategoryAxisLabelExpression(), evaluation)), (String)((String)this.evaluateExpression(((JRBarPlot)this.getPlot()).getValueAxisLabelExpression(), evaluation)), (CategoryDataset)((CategoryDataset)this.dataset.getDataset()), (PlotOrientation)this.getPlot().getOrientation(), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(chart, evaluation);
        CategoryPlot categoryPlot = (CategoryPlot)chart.getPlot();
        categoryPlot.getDomainAxis().setTickMarksVisible(((JRFillBarPlot)this.getPlot()).isShowTickMarks());
        categoryPlot.getDomainAxis().setTickLabelsVisible(((JRFillBarPlot)this.getPlot()).isShowTickLabels());
        ((NumberAxis)categoryPlot.getRangeAxis()).setTickMarksVisible(((JRFillBarPlot)this.getPlot()).isShowTickMarks());
        ((NumberAxis)categoryPlot.getRangeAxis()).setTickLabelsVisible(((JRFillBarPlot)this.getPlot()).isShowTickLabels());
        CategoryItemRenderer categoryRenderer = categoryPlot.getRenderer();
        categoryRenderer.setBaseItemLabelGenerator((CategoryItemLabelGenerator)((JRFillCategoryDataset)this.getDataset()).getLabelGenerator());
        categoryRenderer.setItemLabelsVisible(((JRFillBarPlot)this.getPlot()).isShowLabels());
        return this.getCategoryRenderer(chart);
    }

    protected JFreeChartRenderer evaluateXyAreaImage(byte evaluation) throws JRException {
        JFreeChart chart = ChartFactory.createXYAreaChart((String)((String)this.evaluateExpression(this.getTitleExpression(), evaluation)), (String)((String)this.evaluateExpression(((JRAreaPlot)this.getPlot()).getCategoryAxisLabelExpression(), evaluation)), (String)((String)this.evaluateExpression(((JRAreaPlot)this.getPlot()).getValueAxisLabelExpression(), evaluation)), (XYDataset)((XYDataset)this.dataset.getDataset()), (PlotOrientation)this.getPlot().getOrientation(), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(chart, evaluation);
        return this.getXYRenderer(chart);
    }

    protected JFreeChartRenderer evaluateXYBarImage(byte evaluation) throws JRException {
        IntervalXYDataset tmpDataset = (IntervalXYDataset)this.dataset.getDataset();
        boolean isDate = true;
        if (this.dataset.getDatasetType() == 3) {
            isDate = false;
        }
        JFreeChart chart = ChartFactory.createXYBarChart((String)((String)this.evaluateExpression(this.getTitleExpression(), evaluation)), (String)((String)this.evaluateExpression(((JRBarPlot)this.getPlot()).getCategoryAxisLabelExpression(), evaluation)), (boolean)isDate, (String)((String)this.evaluateExpression(((JRBarPlot)this.getPlot()).getValueAxisLabelExpression(), evaluation)), (IntervalXYDataset)tmpDataset, (PlotOrientation)this.getPlot().getOrientation(), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(chart, evaluation);
        XYPlot xyPlot = (XYPlot)chart.getPlot();
        XYItemRenderer itemRenderer = xyPlot.getRenderer();
        if (this.getDataset().getDatasetType() == 6) {
            itemRenderer.setBaseItemLabelGenerator((XYItemLabelGenerator)((JRFillTimeSeriesDataset)this.getDataset()).getLabelGenerator());
        } else if (this.getDataset().getDatasetType() == 5) {
            itemRenderer.setBaseItemLabelGenerator((XYItemLabelGenerator)((JRFillTimePeriodDataset)this.getDataset()).getLabelGenerator());
        } else if (this.getDataset().getDatasetType() == 3) {
            itemRenderer.setBaseItemLabelGenerator((XYItemLabelGenerator)((JRFillXyDataset)this.getDataset()).getLabelGenerator());
        }
        itemRenderer.setBaseItemLabelsVisible(((JRFillBarPlot)this.getPlot()).isShowLabels());
        return this.getXYBarRenderer(chart);
    }

    protected JFreeChartRenderer evaluateXyLineImage(byte evaluation) throws JRException {
        JRLinePlot linePlot = (JRLinePlot)this.getPlot();
        JFreeChart chart = ChartFactory.createXYLineChart((String)((String)this.evaluateExpression(this.getTitleExpression(), evaluation)), (String)((String)this.evaluateExpression(linePlot.getCategoryAxisLabelExpression(), evaluation)), (String)((String)this.evaluateExpression(linePlot.getValueAxisLabelExpression(), evaluation)), (XYDataset)((XYDataset)this.dataset.getDataset()), (PlotOrientation)linePlot.getOrientation(), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(chart, evaluation);
        XYLineAndShapeRenderer lineRenderer = (XYLineAndShapeRenderer)chart.getXYPlot().getRenderer();
        lineRenderer.setShapesVisible(linePlot.isShowShapes());
        lineRenderer.setLinesVisible(linePlot.isShowLines());
        return this.getXYRenderer(chart);
    }

    protected JFreeChartRenderer evaluateTimeSeriesImage(byte evaluation) throws JRException {
        String timeAxisLabel = (String)this.evaluateExpression(((JRTimeSeriesPlot)this.getPlot()).getTimeAxisLabelExpression(), evaluation);
        String valueAxisLabel = (String)this.evaluateExpression(((JRTimeSeriesPlot)this.getPlot()).getValueAxisLabelExpression(), evaluation);
        JFreeChart chart = ChartFactory.createTimeSeriesChart((String)((String)this.evaluateExpression(this.getTitleExpression(), evaluation)), (String)timeAxisLabel, (String)valueAxisLabel, (XYDataset)((TimeSeriesCollection)this.dataset.getDataset()), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(chart, evaluation);
        XYPlot xyPlot = (XYPlot)chart.getPlot();
        XYLineAndShapeRenderer lineRenderer = (XYLineAndShapeRenderer)xyPlot.getRenderer();
        lineRenderer.setLinesVisible(((JRTimeSeriesPlot)this.getPlot()).isShowLines());
        lineRenderer.setShapesVisible(((JRTimeSeriesPlot)this.getPlot()).isShowShapes());
        return this.getTimeSeriesRenderer(chart);
    }

    protected void resolveElement(JRPrintElement element, byte evaluation) throws JRException {
        this.evaluateImage(evaluation);
        this.copy((JRPrintImage)element);
    }

    public int getBookmarkLevel() {
        return ((JRChart)this.parent).getBookmarkLevel();
    }

    public String getCustomizerClass() {
        return this.customizerClass;
    }

    public byte getBorder() {
        return JRStyleResolver.getBorder(this);
    }

    public Byte getOwnBorder() {
        return ((JRBox)((Object)this.parent)).getOwnBorder();
    }

    public void setBorder(byte border) {
    }

    public void setBorder(Byte border) {
    }

    public Color getBorderColor() {
        return JRStyleResolver.getBorderColor(this, this.getForecolor());
    }

    public Color getOwnBorderColor() {
        return ((JRBox)((Object)this.parent)).getOwnBorderColor();
    }

    public void setBorderColor(Color borderColor) {
    }

    public int getPadding() {
        return JRStyleResolver.getPadding(this);
    }

    public Integer getOwnPadding() {
        return ((JRBox)((Object)this.parent)).getOwnPadding();
    }

    public void setPadding(int padding) {
    }

    public void setPadding(Integer padding) {
    }

    public byte getTopBorder() {
        return JRStyleResolver.getTopBorder(this);
    }

    public Byte getOwnTopBorder() {
        return ((JRBox)((Object)this.parent)).getOwnTopBorder();
    }

    public void setTopBorder(byte topBorder) {
    }

    public void setTopBorder(Byte topBorder) {
    }

    public Color getTopBorderColor() {
        return JRStyleResolver.getTopBorderColor(this, this.getForecolor());
    }

    public Color getOwnTopBorderColor() {
        return ((JRBox)((Object)this.parent)).getOwnTopBorderColor();
    }

    public void setTopBorderColor(Color topBorderColor) {
    }

    public int getTopPadding() {
        return JRStyleResolver.getTopPadding(this);
    }

    public Integer getOwnTopPadding() {
        return ((JRBox)((Object)this.parent)).getOwnTopPadding();
    }

    public void setTopPadding(int topPadding) {
    }

    public void setTopPadding(Integer topPadding) {
    }

    public byte getLeftBorder() {
        return JRStyleResolver.getLeftBorder(this);
    }

    public Byte getOwnLeftBorder() {
        return ((JRBox)((Object)this.parent)).getOwnLeftBorder();
    }

    public void setLeftBorder(byte leftBorder) {
    }

    public void setLeftBorder(Byte leftBorder) {
    }

    public Color getLeftBorderColor() {
        return JRStyleResolver.getLeftBorderColor(this, this.getForecolor());
    }

    public Color getOwnLeftBorderColor() {
        return ((JRBox)((Object)this.parent)).getOwnLeftBorderColor();
    }

    public void setLeftBorderColor(Color leftBorderColor) {
    }

    public int getLeftPadding() {
        return JRStyleResolver.getLeftPadding(this);
    }

    public Integer getOwnLeftPadding() {
        return ((JRBox)((Object)this.parent)).getOwnLeftPadding();
    }

    public void setLeftPadding(int leftPadding) {
    }

    public void setLeftPadding(Integer leftPadding) {
    }

    public byte getBottomBorder() {
        return JRStyleResolver.getBottomBorder(this);
    }

    public Byte getOwnBottomBorder() {
        return ((JRBox)((Object)this.parent)).getOwnBottomBorder();
    }

    public void setBottomBorder(byte bottomBorder) {
    }

    public void setBottomBorder(Byte bottomBorder) {
    }

    public Color getBottomBorderColor() {
        return JRStyleResolver.getBottomBorderColor(this, this.getForecolor());
    }

    public Color getOwnBottomBorderColor() {
        return ((JRBox)((Object)this.parent)).getOwnBottomBorderColor();
    }

    public void setBottomBorderColor(Color bottomBorderColor) {
    }

    public int getBottomPadding() {
        return JRStyleResolver.getBottomPadding(this);
    }

    public Integer getOwnBottomPadding() {
        return ((JRBox)((Object)this.parent)).getOwnBottomPadding();
    }

    public void setBottomPadding(int bottomPadding) {
    }

    public void setBottomPadding(Integer bottomPadding) {
    }

    public byte getRightBorder() {
        return JRStyleResolver.getRightBorder(this);
    }

    public Byte getOwnRightBorder() {
        return ((JRBox)((Object)this.parent)).getOwnRightBorder();
    }

    public void setRightBorder(byte rightBorder) {
    }

    public void setRightBorder(Byte rightBorder) {
    }

    public Color getRightBorderColor() {
        return JRStyleResolver.getRightBorderColor(this, this.getForecolor());
    }

    public Color getOwnRightBorderColor() {
        return ((JRBox)((Object)this.parent)).getOwnRightBorderColor();
    }

    public void setRightBorderColor(Color rightBorderColor) {
    }

    public int getRightPadding() {
        return JRStyleResolver.getRightPadding(this);
    }

    public Integer getOwnRightPadding() {
        return ((JRBox)((Object)this.parent)).getOwnRightPadding();
    }

    public void setRightPadding(int rightPadding) {
    }

    public void setRightPadding(Integer rightPadding) {
    }

    private void evaluateDatasetRun(byte evaluation) throws JRException {
        this.dataset.evaluateDatasetRun(evaluation);
    }

    public JRCloneable createClone(JRFillCloneFactory factory) {
        return null;
    }

    public JRHyperlinkParameter[] getHyperlinkParameters() {
        return ((JRChart)this.parent).getHyperlinkParameters();
    }

    public String getLinkType() {
        return ((JRChart)this.parent).getLinkType();
    }

    public JRExpression getHyperlinkTooltipExpression() {
        return ((JRChart)this.parent).getHyperlinkTooltipExpression();
    }

    protected JFreeChartRenderer getCategoryRenderer(JFreeChart chart) {
        JRFillCategoryDataset categoryDataset = (JRFillCategoryDataset)this.getDataset();
        JFreeChartRenderer chartRenderer = categoryDataset.hasItemHyperlinks() ? new JRCategoryChartImageMapRenderer(chart, categoryDataset.getItemHyperlinks()) : new JFreeChartRenderer(chart);
        return chartRenderer;
    }

    protected JFreeChartRenderer getPieRenderer(JFreeChart chart) {
        JRFillPieDataset pieDataset = (JRFillPieDataset)this.getDataset();
        JFreeChartRenderer chartRenderer = pieDataset.hasSectionHyperlinks() ? new JRPieChartImageMapRenderer(chart, pieDataset.getSectionHyperlinks()) : new JFreeChartRenderer(chart);
        return chartRenderer;
    }

    protected JFreeChartRenderer getXYRenderer(JFreeChart chart) {
        JRFillXyDataset xyDataset = (JRFillXyDataset)this.getDataset();
        JFreeChartRenderer chartRenderer = xyDataset.hasItemHyperlinks() ? new JRXYChartImageMapRenderer(chart, xyDataset.getItemHyperlinks()) : new JFreeChartRenderer(chart);
        return chartRenderer;
    }

    protected JFreeChartRenderer getXYBarRenderer(JFreeChart chart) {
        JFreeChartRenderer chartRenderer = this.getDataset().getDatasetType() == 6 ? this.getTimeSeriesRenderer(chart) : (this.getDataset().getDatasetType() == 5 ? this.getTimePeriodRenderer(chart) : (this.getDataset().getDatasetType() == 3 ? this.getXYRenderer(chart) : new JFreeChartRenderer(chart)));
        return chartRenderer;
    }

    protected JFreeChartRenderer getXYZRenderer(JFreeChart chart) {
        JRFillXyzDataset xyDataset = (JRFillXyzDataset)this.getDataset();
        JFreeChartRenderer chartRenderer = xyDataset.hasItemHyperlinks() ? new JRXYChartImageMapRenderer(chart, xyDataset.getItemHyperlinks()) : new JFreeChartRenderer(chart);
        return chartRenderer;
    }

    protected JFreeChartRenderer getHighLowRenderer(JFreeChart chart) {
        JRFillHighLowDataset hlDataset = (JRFillHighLowDataset)this.getDataset();
        JFreeChartRenderer chartRenderer = hlDataset.hasItemHyperlink() ? new JRHighLowChartImageMapRenderer(chart, hlDataset.getItemHyperlinks()) : new JFreeChartRenderer(chart);
        return chartRenderer;
    }

    protected JFreeChartRenderer getTimeSeriesRenderer(JFreeChart chart) {
        JRFillTimeSeriesDataset tsDataset = (JRFillTimeSeriesDataset)this.getDataset();
        JFreeChartRenderer chartRenderer = tsDataset.hasItemHyperlinks() ? new JRTimeSeriesChartImageMapRenderer(chart, tsDataset.getItemHyperlinks()) : new JFreeChartRenderer(chart);
        return chartRenderer;
    }

    protected JFreeChartRenderer getTimePeriodRenderer(JFreeChart chart) {
        JRFillTimePeriodDataset tpDataset = (JRFillTimePeriodDataset)this.getDataset();
        JFreeChartRenderer chartRenderer = tpDataset.hasItemHyperlinks() ? new JRTimePeriodChartImageMapRenderer(chart, tpDataset.getItemHyperlinks()) : new JFreeChartRenderer(chart);
        return chartRenderer;
    }
}

