/*
 * ProjectExplorerTreeCellRenderer.java
 *
 *  iReport  --  Visual designer for generating JasperReports Documents
 *  Copyright (C) 2002-2003  Giulio Toffoli gt@businesslogic.it
 *
 *  This program is free software; you can redistribute  and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Giulio Toffoli
 *  Via T.Aspetti, 233
 *  35100 Padova ITALY
 *  gt@businesslogic.it
 *
 *
 * Created on 1 giugno 2003, 16.04
 */

package it.businesslogic.ireport.gui;
import it.businesslogic.ireport.*;
import  javax.swing.tree.*;
import  javax.swing.*;
import  java.awt.*;
/**
 *
 * @author  Administrator
 */
public class ProjectExplorerTreeCellRenderer extends DefaultTreeCellRenderer {
    static ImageIcon folderClosedIcon;
    static ImageIcon folderOpenedIcon;
    
    static ImageIcon dirtyDocumentIcon;
    static ImageIcon documentIcon;

    public ProjectExplorerTreeCellRenderer() {
        super();
        if (folderClosedIcon == null) 
            folderClosedIcon = new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/tree/folderClosed.gif"));
        if (folderOpenedIcon == null) 
            folderOpenedIcon = new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/tree/folderOpened.gif"));
        if (dirtyDocumentIcon == null) 
            dirtyDocumentIcon = new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/tree/docDirty.gif"));
        if (documentIcon == null) 
            documentIcon = new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/tree/doc.gif"));
        
        /*
        this.setOpenIcon(folderOpenedIcon);
        this.setClosedIcon(folderClosedIcon);
        this.setLeafIcon(documentIcon);
         */
    }

    public Component getTreeCellRendererComponent(
                        JTree tree,
                        Object value,
                        boolean sel,
                        boolean expanded,
                        boolean leaf,
                        int row,
                        boolean hasFocus) {

        super.getTreeCellRendererComponent(
                        tree, value, sel,
                        expanded, leaf, row,
                        hasFocus);
             
        if (!((DefaultMutableTreeNode)value).isRoot() && leaf && isDirty(value)) {
            setIcon(dirtyDocumentIcon);
            setToolTipText(null);
        } else if (!((DefaultMutableTreeNode)value).isRoot() && leaf && !isDirty(value)) {
            setIcon(documentIcon);
            setToolTipText(null);
        } 
        else if (( ((DefaultMutableTreeNode)value).isRoot() || !leaf) && expanded)
        {
             setIcon(folderOpenedIcon);
            setToolTipText(null); //no tool tip
        }
        else if (( ((DefaultMutableTreeNode)value).isRoot() || !leaf) && !expanded)
        {
            setIcon(folderClosedIcon);
            setToolTipText(null); //no tool tip
        } 

        return this;
    }

    protected boolean isDirty(Object value) {
        DefaultMutableTreeNode node =
                (DefaultMutableTreeNode)value;
        
        if (node.getUserObject() instanceof DocumentTreeEntry)
        {
            DocumentTreeEntry nodeInfo =
                (DocumentTreeEntry)(node.getUserObject());
            if (nodeInfo.getJrf() != null)
                return nodeInfo.getJrf().getReport().isModified();
        }
        return false;
    }
}

