/*
 * TranslationStatusDialog.java
 *
 * Created on March 27, 2006, 8:06 PM
 */

package it.businesslogic.ireport.plugin.locale;


import it.businesslogic.ireport.util.LocaleAdapter;
import it.businesslogic.ireport.util.Misc;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import javax.swing.DefaultListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

/**
 *
 * @author  gtoffoli
 */
public class TranslationStatusDialog extends javax.swing.JDialog {
    
    /** Creates new form TranslationStatusDialog */
    public TranslationStatusDialog(java.awt.Frame parent, boolean modal) {
        super(parent, modal);
        initComponents();
        
        TableColumnModel tcm = jTableLanguages.getColumnModel();
        TableColumn tc = tcm.getColumn(1);
        tc.setCellRenderer(new ProgressBarCellRenderer());
        
        DefaultListSelectionModel dsm = new DefaultListSelectionModel();
        dsm.setSelectionMode( dsm.SINGLE_SELECTION );
        dsm.addListSelectionListener( new ListSelectionListener() {
            public void valueChanged(ListSelectionEvent e) {
                jButtonDetails.setEnabled( jTableLanguages.getSelectedRow() >= 0);
            }
        });
        jTableLanguages.setSelectionModel( dsm );
        updateStatus();
        
        pack();
        Misc.centerFrame(this);
        
        javax.swing.KeyStroke escape =  javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_ESCAPE, 0, false);
            javax.swing.Action escapeAction = new javax.swing.AbstractAction() {
                public void actionPerformed(java.awt.event.ActionEvent e) {
                    jButtonOkActionPerformed(e);
                }
            };

            getRootPane().getInputMap(javax.swing.JComponent.WHEN_IN_FOCUSED_WINDOW).put(escape, "ESCAPE");
            getRootPane().getActionMap().put("ESCAPE", escapeAction);


            //to make the default button ...
            this.getRootPane().setDefaultButton(this.jButtonOk);
    }
    
    
    public void updateStatus()
    {
        
        List listOfLanguages = it.businesslogic.ireport.util.I18n.getListOfAvailLanguages();
        
        DefaultTableModel dtm = (DefaultTableModel)jTableLanguages.getModel();
        
        //dtm.addRow(new Object[]{"Default",null,null});
        
        Properties props_default = new Properties();
        try {
            props_default.load( this.getClass().getResourceAsStream("/it/businesslogic/ireport/locale/Ireport.properties") );
        } catch (Exception ex)
        {
            ex.printStackTrace();
        }
        
        for (int i=0; i< listOfLanguages.size(); ++i)
        {
            Locale lang = (Locale)listOfLanguages.get(i);
            LocaleAdapter adapter = new LocaleAdapter(lang);
            String language = lang.getLanguage();
            String country = lang.getCountry();
            String variant = lang.getVariant();
        
            String language_name = (language.length() > 0) ? "_" + language : "";
            language_name += (country.length() > 0) ? "_" + country : "";
            language_name += (variant.length() > 0) ? "_" + variant : "";
            
            language_name = "Ireport" + language_name + ".properties";
            
            int percentage_language = getLanguageCompletation(props_default,language_name);
            /*
            if( lang.getCountry().equals(selectedCountry) && 
                lang.getLanguage().equals(selectedLanguage) &&
                lang.getVariant().equals(selectedVariant) ) {
                        def_language = "" + adapter;
            }
            */
            
            dtm.addRow(new Object[]{adapter,new Integer(percentage_language),language_name});
        }
        
        
        
    }
    
    public int getLanguageCompletation(Properties defaultTranslations, String language)
    {
        Properties props2 = new Properties();
        try {
        props2.load( this.getClass().getResourceAsStream("/it/businesslogic/ireport/locale/" + language ) );
        } catch (Exception ex){}
        double size = 0;
        Iterator namesIterator = defaultTranslations.keySet().iterator();
        size = defaultTranslations.size();
        double translated = 0;
        while (namesIterator.hasNext())
        {
            String name = ""+namesIterator.next();
            if (name.equals("defaultFont"))
            {
                size--;
                continue;
            }
            if (props2.getProperty(name) != null)
            {
                translated++;
            }
        }
        if (translated == 0) return 0;
        return (int)((translated/size)*100);
    }
    
    /** This method is called from within the constructor to
     * initialize the form
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jScrollPane1 = new javax.swing.JScrollPane();
        jTableLanguages = new javax.swing.JTable();
        jButtonOk = new javax.swing.JButton();
        jButtonDetails = new javax.swing.JButton();

        getContentPane().setLayout(new java.awt.GridBagLayout());

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        jTableLanguages.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {

            },
            new String [] {
                "Title 1", "Title 2", "Title 3"
            }
        ) {
            boolean[] canEdit = new boolean [] {
                false, false, false
            };

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return canEdit [columnIndex];
            }
        });
        jTableLanguages.setGridColor(new java.awt.Color(204, 204, 204));
        jTableLanguages.setShowVerticalLines(false);
        jTableLanguages.setTableHeader(null);
        jTableLanguages.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                jTableLanguagesMouseClicked(evt);
            }
        });

        jScrollPane1.setViewportView(jTableLanguages);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        getContentPane().add(jScrollPane1, gridBagConstraints);

        jButtonOk.setText("Close");
        jButtonOk.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonOkActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 4, 4);
        getContentPane().add(jButtonOk, gridBagConstraints);

        jButtonDetails.setText("Details...");
        jButtonDetails.setEnabled(false);
        jButtonDetails.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonDetailsActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        getContentPane().add(jButtonDetails, gridBagConstraints);

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void jButtonOkActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonOkActionPerformed
        
        this.setVisible(false);
        this.dispose();
        
    }//GEN-LAST:event_jButtonOkActionPerformed

    private void jTableLanguagesMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jTableLanguagesMouseClicked
        if (evt.getClickCount() == 2 &&
            evt.getButton() == evt.BUTTON1)
        {
            jButtonDetailsActionPerformed(null);
        }

    }//GEN-LAST:event_jTableLanguagesMouseClicked

    private void jButtonDetailsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonDetailsActionPerformed

        if (jTableLanguages.getSelectedRow() < 0) return;
        int row = jTableLanguages.getSelectedRow();
        
        LocaleAdapter adapter = (LocaleAdapter)jTableLanguages.getValueAt(jTableLanguages.getSelectedRow(), 0);
        
        TranslationStatusDetailDialog tsdd = new TranslationStatusDetailDialog(this,true);
        
        Properties props_default = new Properties();
        try {
            props_default.load( this.getClass().getResourceAsStream("/it/businesslogic/ireport/locale/Ireport.properties") );
        } catch (Exception ex)
        {
            ex.printStackTrace();
        }
        
        if (props_default != null)
        {
            tsdd.setLanguage( ""+ jTableLanguages.getValueAt(jTableLanguages.getSelectedRow(), 2),props_default);
            tsdd.setVisible(true);
        } 
        
        
    }//GEN-LAST:event_jButtonDetailsActionPerformed
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new TranslationStatusDialog(new javax.swing.JFrame(), true).setVisible(true);
            }
        });
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButtonDetails;
    private javax.swing.JButton jButtonOk;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTable jTableLanguages;
    // End of variables declaration//GEN-END:variables
    
}
