/*
 * InsertElementOperation.java
 *
 *  iReport  --  Visual designer for generating JasperReports Documents
 *  Copyright (C) 2002-2003  Giulio Toffoli gt@businesslogic.it
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Giulio Toffoli
 *  Via T.Aspetti, 233
 *  35100 Padova ITALY
 *  gt@businesslogic.it
 *
 *
 *
 * Created on 19 giugno 2003, 23.23
 */

package it.businesslogic.ireport.undo;
import it.businesslogic.ireport.gui.event.*;
import it.businesslogic.ireport.*;
import it.businesslogic.ireport.gui.*;
import it.businesslogic.ireport.util.*;

import java.util.*;

/**
 *  This class handle the Insert operation.
 *  As all operations, the costructor take the JReportFrame (owner of the element)
 *  The ReportElement is not cloned, this can be a problem if not all undo operations
 *  are correctly logged and handled.
 * @author  Giulio Toffoli
 */
public class InsertElementOperation  implements it.businesslogic.ireport.UndoOperation {
    
    /*
     *  The report element that was inserted.
     */
    private ReportElement element = null; 
    
    private JReportFrame jrf = null;
    private CrosstabReportElement crosstabReportElement = null;
    
    /** Creates a new instance of InsertElementOperation */
    public InsertElementOperation(JReportFrame jrf, CrosstabReportElement crosstabReportElement, ReportElement element) {
        this.crosstabReportElement = crosstabReportElement;
        this.element = element;
        this.jrf = jrf;
    }
    
    /** Creates a new instance of InsertElementOperation */
    public InsertElementOperation(JReportFrame jrf, ReportElement element) {
        this(jrf, null, element);
    }
    
    public void undo()
    {
        // We must remove our element...
        if (jrf == null && crosstabReportElement == null) return;
        if (crosstabReportElement != null)
        {
            crosstabReportElement.getElements().remove( element );
            jrf.getCrosstabEditor(crosstabReportElement).getPanelEditor().getSelectedElements().remove( element );
            jrf.getCrosstabEditor(crosstabReportElement).getPanelEditor().repaint();
        }
        else
        {
            jrf.getReport().getElements().remove( element );
            jrf.getSelectedElements().remove( element );
            if (element instanceof CrosstabReportElement)
            {
                jrf.removeCrosstabEditor((CrosstabReportElement)element);
            }
            jrf.getReportPanel().repaint();
        }
        jrf.fireReportListenerReportElementsChanged(new ReportElementChangedEvent(jrf, crosstabReportElement, element , ReportElementChangedEvent.REMOVED));  
        
    }
    
    public void redo()
    {
        if (jrf == null && crosstabReportElement == null) return;
        if (crosstabReportElement != null)
        {
            crosstabReportElement.getElements().addElement( element );
            jrf.getCrosstabEditor(crosstabReportElement).getPanelEditor().setSelectedElement( element );
            jrf.getCrosstabEditor(crosstabReportElement).getPanelEditor().repaint();
        }
        else
        {
            jrf.getReport().getElements().addElement( element );
            if (element instanceof CrosstabReportElement)
            {
                jrf.addCrosstabEditor((CrosstabReportElement)element);
            }
            jrf.setSelectedElement(element);
            jrf.getReportPanel().repaint();
        }
        jrf.fireReportListenerReportElementsChanged(new ReportElementChangedEvent(jrf, crosstabReportElement, element , ReportElementChangedEvent.ADDED));  
    }   
    
    public String toString()
    {
        return "insert element";
    }

    public CrosstabReportElement getCrosstabReportElement() {
        return crosstabReportElement;
    }

    public void setCrosstabReportElement(CrosstabReportElement crosstabReportElement) {
        this.crosstabReportElement = crosstabReportElement;
    }
}

