/*
 * Decompiled with CFR 0.152.
 */
package jcmdline;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import jcmdline.CmdLineException;
import jcmdline.CmdLineHandler;
import jcmdline.CmdLineParser;
import jcmdline.Parameter;
import jcmdline.PosixCmdLineParser;
import jcmdline.Strings;

public class BasicCmdLineHandler
implements CmdLineHandler {
    private static final ResourceBundle rb = ResourceBundle.getBundle("jcmdline.strings");
    private String cmdName;
    private String cmdDesc;
    private HashMap options = new HashMap();
    private ArrayList args = new ArrayList();
    private CmdLineParser parser;
    private boolean dieOnParseError = true;
    private String parseError;

    public BasicCmdLineHandler(String cmdName, String cmdDesc, Parameter[] options, Parameter[] args, CmdLineParser parser) {
        this.setCmdName(cmdName);
        this.setCmdDesc(cmdDesc);
        this.setOptions(options);
        this.setArgs(args);
        this.setParser(parser);
    }

    public BasicCmdLineHandler(String cmdName, String cmdDesc, Parameter[] options, Parameter[] args) {
        this(cmdName, cmdDesc, options, args, new PosixCmdLineParser());
    }

    public BasicCmdLineHandler(String cmdName, String cmdDesc, Collection options, Collection args) {
        this(cmdName, cmdDesc, options.toArray(new Parameter[0]), args.toArray(new Parameter[0]));
    }

    public boolean parse(String[] clargs) {
        if (clargs == null) {
            clargs = new String[]{};
        }
        try {
            this.parser.parse(clargs, this.options, this.args);
            if (!this.canSkipRequiredCheck()) {
                this.checkForRequired();
            }
        }
        catch (CmdLineException e) {
            if (this.dieOnParseError) {
                this.exitUsageError(e.getMessage());
            }
            this.parseError = e.getMessage();
            return false;
        }
        return true;
    }

    public void setParser(CmdLineParser parser) {
        this.parser = parser;
    }

    public CmdLineParser getParser() {
        return this.parser;
    }

    public void setDieOnParseError(boolean val) {
        this.dieOnParseError = val;
    }

    public boolean getDieOnParseError() {
        return this.dieOnParseError;
    }

    public void exitUsageError(String errMsg) {
        System.err.println(this.getUsage(false));
        System.err.println("\n" + this.parser.getUsageFormatter().formatErrorMsg(errMsg));
        this.quitProgram(1);
    }

    public void setArgs(Parameter[] args) {
        this.args.clear();
        for (int i = 0; i < args.length; ++i) {
            this.addArg(args[i]);
        }
    }

    public void addArg(Parameter arg) {
        if (arg == null) {
            throw new IllegalArgumentException(Strings.get("BasicCmdLineHandler.nullArgNotAllowed"));
        }
        if (this.args.size() > 0) {
            Parameter lastArg = (Parameter)this.args.get(this.args.size() - 1);
            if (lastArg.isMultiValued()) {
                throw new IllegalArgumentException(Strings.get("BasicCmdLineHandler.multiValueArgNotLast", new Object[]{lastArg.getTag()}));
            }
            if (!arg.isOptional() && lastArg.isOptional()) {
                throw new IllegalArgumentException(Strings.get("BasicCmdLineHandler.requiredArgAfterOptArg", new Object[]{arg.getTag(), lastArg.getTag()}));
            }
        }
        this.args.add(arg);
    }

    public List getArgs() {
        return this.args;
    }

    public Parameter getArg(String tag) {
        Iterator itr = this.args.iterator();
        while (itr.hasNext()) {
            Parameter arg = (Parameter)itr.next();
            if (!arg.getTag().equals(tag)) continue;
            return arg;
        }
        return null;
    }

    public void setOptions(Parameter[] options) {
        this.options.clear();
        for (int i = 0; i < options.length; ++i) {
            this.addOption(options[i]);
        }
    }

    public void addOption(Parameter opt) {
        if (opt == null) {
            throw new NullPointerException();
        }
        if (this.options.containsKey(opt.getTag())) {
            throw new IllegalArgumentException(Strings.get("BasicCmdLineHandler.duplicateOption", new Object[]{opt.getTag()}));
        }
        this.options.put(opt.getTag().toLowerCase(), opt);
    }

    public Collection getOptions() {
        return this.options.values();
    }

    public Parameter getOption(String tag) {
        return (Parameter)this.options.get(tag);
    }

    public void setCmdDesc(String cmdDesc) {
        if (cmdDesc == null || cmdDesc.length() <= 0) {
            throw new IllegalArgumentException(Strings.get("BasicCmdLineHandler.cmdDescTooShort", new Object[]{cmdDesc}));
        }
        this.cmdDesc = cmdDesc;
    }

    public String getCmdDesc() {
        return this.cmdDesc;
    }

    public void setCmdName(String cmdName) {
        if (cmdName == null && cmdName.length() <= 0) {
            throw new IllegalArgumentException(Strings.get("BasicCmdLineHandler.cmdNameTooShort", new Object[]{cmdName}));
        }
        this.cmdName = cmdName;
    }

    public String getCmdName() {
        return this.cmdName;
    }

    public String getUsage(boolean hidden) {
        return this.parser.getUsageFormatter().formatUsage(this.cmdName, this.cmdDesc, this.options, this.args, hidden);
    }

    public void setParseError(String parseError) {
        this.parseError = parseError;
    }

    public String getParseError() {
        return this.parseError;
    }

    private boolean canSkipRequiredCheck() {
        Parameter p;
        Iterator<Object> itr = this.options.values().iterator();
        while (itr.hasNext()) {
            p = (Parameter)itr.next();
            if (!p.getIgnoreRequired() || !p.isSet()) continue;
            return true;
        }
        itr = this.args.iterator();
        while (itr.hasNext()) {
            p = (Parameter)itr.next();
            if (!p.getIgnoreRequired() || !p.isSet()) continue;
            return true;
        }
        return false;
    }

    private void checkForRequired() throws CmdLineException {
        Parameter p;
        Iterator<Object> itr = this.options.values().iterator();
        while (itr.hasNext()) {
            p = (Parameter)itr.next();
            if (p.isOptional() || p.isSet()) continue;
            throw new CmdLineException(Strings.get("BasicCmdLineHandler.missingRequiredOpt", new Object[]{p.getTag()}));
        }
        itr = this.args.iterator();
        while (itr.hasNext()) {
            p = (Parameter)itr.next();
            if (p.isOptional() || p.isSet()) continue;
            throw new CmdLineException(Strings.get("BasicCmdLineHandler.missingRequiredArg", new Object[]{p.getTag()}));
        }
    }

    private void quitProgram(int exitStatus) {
        System.exit(exitStatus);
    }
}

