/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.hibernate;

import bsh.EvalError;
import bsh.Interpreter;
import it.businesslogic.ireport.IReportConnection;
import it.businesslogic.ireport.JRField;
import it.businesslogic.ireport.JRParameter;
import it.businesslogic.ireport.connection.JRHibernateConnection;
import it.businesslogic.ireport.data.FieldClassWrapper;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.gui.ReportQueryDialog;
import it.businesslogic.ireport.util.Misc;
import java.beans.PropertyDescriptor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.Hibernate;
import org.hibernate.Query;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.hibernate.type.Type;

public class HQLFieldsReader {
    private static final Map hibernateTypeMap = new HashMap();
    private Interpreter interpreter = null;
    private Vector reportParameters = null;
    private String queryString = "";
    private HashMap queryParameters = new HashMap();
    private Vector notScalars = new Vector();

    public HQLFieldsReader(String query, Vector reportParameters) {
        this.setQueryString(query);
        this.setReportParameters(reportParameters);
    }

    public String prepareQuery() throws Exception {
        System.out.println(this.getReportParameters());
        Enumeration enumParams = this.getReportParameters().elements();
        while (enumParams.hasMoreElements()) {
            Object paramVal;
            JRParameter param = (JRParameter)enumParams.nextElement();
            String parameterName = param.getName();
            if (this.queryString.indexOf("$P!{" + parameterName + "}") > 0) {
                paramVal = ReportQueryDialog.recursiveInterpreter(this.getInterpreter(), param.getDefaultValueExpression(), this.getReportParameters());
                if (paramVal == null) {
                    paramVal = "";
                }
                this.queryString = Misc.string_replace("" + paramVal, "$P!{" + parameterName + "}", this.queryString);
                continue;
            }
            if (this.getQueryString().indexOf("$P{" + parameterName + "}") <= 0) continue;
            paramVal = ReportQueryDialog.recursiveInterpreter(this.getInterpreter(), param.getDefaultValueExpression(), this.getReportParameters());
            String parameterReplacement = "_" + HQLFieldsReader.getLiteral(parameterName);
            this.queryParameters.put(parameterReplacement, paramVal);
            this.queryString = Misc.string_replace(":" + parameterReplacement, "$P{" + parameterName + "}", this.queryString);
            System.out.println(this.queryString);
        }
        return this.queryString;
    }

    public Vector readFields() throws Exception {
        this.prepareQuery();
        Object hb_sessionFactory = null;
        Session hb_session = null;
        Transaction transaction = null;
        this.notScalars.clear();
        try {
            IReportConnection conn = (IReportConnection)MainFrame.getMainInstance().getProperties().get("DefaultConnection");
            if (!(conn instanceof JRHibernateConnection)) {
                throw new Exception("No Hibernate connection selected.");
            }
            hb_session = ((JRHibernateConnection)conn).createSession();
            if (hb_session == null) {
                throw new Exception("Problem creating the Session object for Hibernate");
            }
            transaction = hb_session.beginTransaction();
            Query q = hb_session.createQuery(this.getQueryString());
            Iterator paramIterator = this.queryParameters.keySet().iterator();
            while (paramIterator.hasNext()) {
                String hqlParamName = "" + paramIterator.next();
                this.setParameter(hb_session, q, hqlParamName, this.queryParameters.get(hqlParamName));
            }
            q.setFetchSize(1);
            Iterator iterator = q.iterate();
            String[] aliases = q.getReturnAliases();
            Type[] types = q.getReturnTypes();
            Vector<JRField> fields = new Vector<JRField>();
            for (int i = 0; i < types.length; ++i) {
                JRField field;
                if (types[i].isComponentType() || types[i].isEntityType()) {
                    String aliasName = null;
                    if (aliases != null && aliases.length > i && !aliases[i].equals(i + "")) {
                        aliasName = aliases[i];
                        field = new JRField(aliases[i], types[i].getReturnedClass().getName());
                        field.setDescription(aliases[i]);
                        fields.add(field);
                    }
                    PropertyDescriptor[] pd = PropertyUtils.getPropertyDescriptors((Class)types[i].getReturnedClass());
                    if (aliasName != null) {
                        this.notScalars.add(new FieldClassWrapper(aliasName, types[i].getReturnedClass().getName()));
                    } else {
                        this.notScalars.add(types[i].getReturnedClass().getName());
                    }
                    for (int nd = 0; nd < pd.length; ++nd) {
                        String fieldName = pd[nd].getName();
                        if (pd[nd].getPropertyType() == null || pd[nd].getReadMethod() == null || fieldName.equals("class")) continue;
                        String returnType = pd[nd].getPropertyType().getName();
                        JRField field2 = new JRField(fieldName, returnType);
                        if (types.length > 1 && aliasName != null) {
                            fieldName = aliasName + "." + fieldName;
                            field2.setDescription(fieldName);
                            field2.setName(fieldName);
                        }
                        fields.add(field2);
                    }
                    continue;
                }
                String fieldName = types[i].getName();
                if (aliases != null && aliases.length > i && !aliases[i].equals("" + i)) {
                    fieldName = aliases[i];
                }
                field = new JRField(fieldName, types[i].getReturnedClass().getName());
                field.setDescription("");
                fields.add(field);
            }
            Vector<JRField> vector = fields;
            return vector;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
        finally {
            if (transaction != null) {
                try {
                    transaction.rollback();
                }
                catch (Exception ex) {}
            }
            if (hb_session != null) {
                try {
                    hb_session.close();
                }
                catch (Exception ex) {}
            }
        }
    }

    protected void setParameter(Session session, Query query, String hqlParamName, Object parameterValue) throws Exception {
        if (parameterValue == null) {
            System.out.println("Parameter: " + hqlParamName);
            query.setParameter(hqlParamName, parameterValue);
            return;
        }
        Class<?> clazz = parameterValue.getClass();
        Type type = (Type)hibernateTypeMap.get(clazz);
        if (type != null) {
            query.setParameter(hqlParamName, parameterValue, type);
        } else if (Collection.class.isAssignableFrom(clazz)) {
            query.setParameterList(hqlParamName, (Collection)parameterValue);
        } else if (session.getSessionFactory().getClassMetadata(clazz) != null) {
            query.setEntity(hqlParamName, parameterValue);
        } else {
            query.setParameter(hqlParamName, parameterValue);
        }
    }

    private Interpreter prepareExpressionEvaluator() throws EvalError {
        Interpreter interpreter = new Interpreter();
        interpreter.setClassLoader(interpreter.getClass().getClassLoader());
        return interpreter;
    }

    public static String getLiteral(String name) {
        if (HQLFieldsReader.isValidLiteral(name)) {
            return name;
        }
        StringBuffer buffer = new StringBuffer(name.length() + 5);
        char[] literalChars = new char[name.length()];
        name.getChars(0, literalChars.length, literalChars, 0);
        for (int i = 0; i < literalChars.length; ++i) {
            if (i == 0 && !Character.isJavaIdentifierStart(literalChars[i])) {
                buffer.append((int)literalChars[i]);
                continue;
            }
            if (i != 0 && !Character.isJavaIdentifierPart(literalChars[i])) {
                buffer.append((int)literalChars[i]);
                continue;
            }
            buffer.append(literalChars[i]);
        }
        return buffer.toString();
    }

    private static boolean isValidLiteral(String literal) {
        boolean result = true;
        char[] literalChars = new char[literal.length()];
        literal.getChars(0, literalChars.length, literalChars, 0);
        for (int i = 0; i < literalChars.length; ++i) {
            if (i == 0 && !Character.isJavaIdentifierStart(literalChars[i])) {
                result = false;
                break;
            }
            if (i == 0 || Character.isJavaIdentifierPart(literalChars[i])) continue;
            result = false;
            break;
        }
        return result;
    }

    public Interpreter getInterpreter() {
        if (this.interpreter == null) {
            try {
                this.interpreter = this.prepareExpressionEvaluator();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.interpreter;
    }

    public void setInterpreter(Interpreter interpreter) {
        this.interpreter = interpreter;
    }

    public Vector getReportParameters() {
        return this.reportParameters;
    }

    public void setReportParameters(Vector reportParameters) {
        this.reportParameters = reportParameters;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public HashMap getQueryParameters() {
        return this.queryParameters;
    }

    public void setQueryParameters(HashMap queryParameters) {
        this.queryParameters = queryParameters;
    }

    public Vector getNotScalars() {
        return this.notScalars;
    }

    public void setNotScalars(Vector notScalars) {
        this.notScalars = notScalars;
    }

    static {
        hibernateTypeMap.put(Boolean.class, Hibernate.BOOLEAN);
        hibernateTypeMap.put(Byte.class, Hibernate.BYTE);
        hibernateTypeMap.put(Double.class, Hibernate.DOUBLE);
        hibernateTypeMap.put(Float.class, Hibernate.FLOAT);
        hibernateTypeMap.put(Integer.class, Hibernate.INTEGER);
        hibernateTypeMap.put(Long.class, Hibernate.LONG);
        hibernateTypeMap.put(Short.class, Hibernate.SHORT);
        hibernateTypeMap.put(BigDecimal.class, Hibernate.BIG_DECIMAL);
        hibernateTypeMap.put(BigInteger.class, Hibernate.BIG_INTEGER);
        hibernateTypeMap.put(Character.class, Hibernate.CHARACTER);
        hibernateTypeMap.put(String.class, Hibernate.STRING);
        hibernateTypeMap.put(Date.class, Hibernate.DATE);
        hibernateTypeMap.put(Timestamp.class, Hibernate.TIMESTAMP);
        hibernateTypeMap.put(Time.class, Hibernate.TIME);
    }
}

