/*
 * Decompiled with CFR 0.152.
 */
package com.digitprop.tonic;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.LookAndFeel;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTableHeaderUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class TableHeaderUI
extends BasicTableHeaderUI {
    private static Cursor resizeCursor = Cursor.getPredefinedCursor(11);
    protected JTableHeader header;
    protected CellRendererPane rendererPane;
    protected MouseInputListener mouseInputListener;

    protected MouseInputListener createMouseInputListener() {
        return new MouseInputHandler();
    }

    public static ComponentUI createUI(JComponent component) {
        return new TableHeaderUI();
    }

    public void installUI(JComponent c) {
        this.header = (JTableHeader)c;
        this.rendererPane = new CellRendererPane();
        this.header.add(this.rendererPane);
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
    }

    protected void installDefaults() {
        LookAndFeel.installColorsAndFont(this.header, "TableHeader.background", "TableHeader.foreground", "TableHeader.font");
    }

    protected void installListeners() {
        this.mouseInputListener = this.createMouseInputListener();
        this.header.addMouseListener(this.mouseInputListener);
        this.header.addMouseMotionListener(this.mouseInputListener);
    }

    protected void installKeyboardActions() {
    }

    public void uninstallUI(JComponent c) {
        this.uninstallDefaults();
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        this.header.remove(this.rendererPane);
        this.rendererPane = null;
        this.header = null;
    }

    protected void uninstallDefaults() {
    }

    protected void uninstallListeners() {
        this.header.removeMouseListener(this.mouseInputListener);
        this.header.removeMouseMotionListener(this.mouseInputListener);
        this.mouseInputListener = null;
    }

    protected void uninstallKeyboardActions() {
    }

    public void paint(Graphics g, JComponent c) {
        int column;
        if (this.header.getColumnModel().getColumnCount() <= 0) {
            return;
        }
        boolean ltr = this.header.getComponentOrientation().isLeftToRight();
        Rectangle clip = g.getClipBounds();
        Point left = clip.getLocation();
        Point right = new Point(clip.x + clip.width - 1, clip.y);
        TableColumnModel cm = this.header.getColumnModel();
        int cMin = this.header.columnAtPoint(ltr ? left : right);
        int cMax = this.header.columnAtPoint(ltr ? right : left);
        if (cMin == -1) {
            cMin = 0;
        }
        if (cMax == -1) {
            cMax = cm.getColumnCount() - 1;
        }
        TableColumn draggedColumn = this.header.getDraggedColumn();
        int columnMargin = cm.getColumnMargin();
        Rectangle cellRect = this.header.getHeaderRect(cMin);
        if (ltr) {
            column = cMin;
            while (column <= cMax) {
                TableColumn aColumn = cm.getColumn(column);
                int columnWidth = aColumn.getWidth();
                cellRect.width = columnWidth - columnMargin;
                if (aColumn != draggedColumn) {
                    this.paintCell(g, cellRect, column, column + 1 == this.header.getColumnModel().getColumnCount());
                }
                cellRect.x += columnWidth;
                ++column;
            }
        } else {
            int columnWidth;
            TableColumn aColumn = cm.getColumn(cMin);
            if (aColumn != draggedColumn) {
                columnWidth = aColumn.getWidth();
                cellRect.width = columnWidth - columnMargin;
                cellRect.x += columnMargin;
                this.paintCell(g, cellRect, cMin, false);
            }
            column = cMin + 1;
            while (column <= cMax) {
                aColumn = cm.getColumn(column);
                columnWidth = aColumn.getWidth();
                cellRect.width = columnWidth - columnMargin;
                cellRect.x -= columnWidth;
                if (aColumn != draggedColumn) {
                    this.paintCell(g, cellRect, column, false);
                }
                ++column;
            }
        }
        if (draggedColumn != null) {
            int draggedColumnIndex = this.viewIndexForColumn(draggedColumn);
            Rectangle draggedCellRect = this.header.getHeaderRect(draggedColumnIndex);
            g.setColor(this.header.getParent().getBackground());
            g.fillRect(draggedCellRect.x, draggedCellRect.y, draggedCellRect.width, draggedCellRect.height);
            draggedCellRect.x += this.header.getDraggedDistance();
            g.setColor(this.header.getBackground());
            g.fillRect(draggedCellRect.x, draggedCellRect.y, draggedCellRect.width, draggedCellRect.height);
            this.paintCell(g, draggedCellRect, draggedColumnIndex, false);
        }
        this.rendererPane.removeAll();
    }

    private Component getHeaderRenderer(int columnIndex) {
        TableColumn aColumn = this.header.getColumnModel().getColumn(columnIndex);
        TableCellRenderer renderer = aColumn.getHeaderRenderer();
        if (renderer == null) {
            renderer = this.header.getDefaultRenderer();
        }
        return renderer.getTableCellRendererComponent(this.header.getTable(), aColumn.getHeaderValue(), false, false, -1, columnIndex);
    }

    private void paintCell(Graphics g, Rectangle cellRect, int columnIndex, boolean isLastCell) {
        Component component = this.getHeaderRenderer(columnIndex);
        this.rendererPane.paintComponent(g, component, this.header, cellRect.x, cellRect.y, cellRect.width + (isLastCell ? 1 : 0), cellRect.height, true);
    }

    private int viewIndexForColumn(TableColumn aColumn) {
        TableColumnModel cm = this.header.getColumnModel();
        int column = 0;
        while (column < cm.getColumnCount()) {
            if (cm.getColumn(column) == aColumn) {
                return column;
            }
            ++column;
        }
        return -1;
    }

    private int getHeaderHeight() {
        int height = 0;
        boolean accomodatedDefault = false;
        TableColumnModel columnModel = this.header.getColumnModel();
        int column = 0;
        while (column < columnModel.getColumnCount()) {
            TableColumn aColumn = columnModel.getColumn(column);
            if (aColumn.getHeaderRenderer() != null || !accomodatedDefault) {
                Component comp = this.getHeaderRenderer(column);
                int rendererHeight = comp.getPreferredSize().height;
                height = Math.max(height, rendererHeight);
                if (rendererHeight > 0) {
                    accomodatedDefault = true;
                }
            }
            ++column;
        }
        return height;
    }

    private Dimension createHeaderSize(long width) {
        TableColumnModel columnModel = this.header.getColumnModel();
        if (width > Integer.MAX_VALUE) {
            width = Integer.MAX_VALUE;
        }
        return new Dimension((int)width, this.getHeaderHeight());
    }

    public Dimension getMinimumSize(JComponent c) {
        long width = 0L;
        Enumeration<TableColumn> enumeration = this.header.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn aColumn = enumeration.nextElement();
            width += (long)aColumn.getMinWidth();
        }
        return this.createHeaderSize(width);
    }

    public Dimension getPreferredSize(JComponent c) {
        long width = 0L;
        Enumeration<TableColumn> enumeration = this.header.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn aColumn = enumeration.nextElement();
            width += (long)aColumn.getPreferredWidth();
        }
        return this.createHeaderSize(width);
    }

    public Dimension getMaximumSize(JComponent c) {
        long width = 0L;
        Enumeration<TableColumn> enumeration = this.header.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn aColumn = enumeration.nextElement();
            width += (long)aColumn.getMaxWidth();
        }
        return this.createHeaderSize(width);
    }

    public class MouseInputHandler
    implements MouseInputListener {
        private int mouseXOffset;
        private Cursor otherCursor = TableHeaderUI.access$0();

        public void mouseClicked(MouseEvent e) {
        }

        private boolean canResize(TableColumn column) {
            return column != null && TableHeaderUI.this.header.getResizingAllowed() && column.getResizable();
        }

        private TableColumn getResizingColumn(Point p) {
            return this.getResizingColumn(p, TableHeaderUI.this.header.columnAtPoint(p));
        }

        private TableColumn getResizingColumn(Point p, int column) {
            int columnIndex;
            if (column == -1) {
                return null;
            }
            Rectangle r = TableHeaderUI.this.header.getHeaderRect(column);
            r.grow(-3, 0);
            if (r.contains(p)) {
                return null;
            }
            int midPoint = r.x + r.width / 2;
            if (TableHeaderUI.this.header.getComponentOrientation().isLeftToRight()) {
                columnIndex = p.x < midPoint ? column - 1 : column;
            } else {
                int n = columnIndex = p.x < midPoint ? column : column - 1;
            }
            if (columnIndex == -1) {
                return null;
            }
            return TableHeaderUI.this.header.getColumnModel().getColumn(columnIndex);
        }

        public void mousePressed(MouseEvent e) {
            TableHeaderUI.this.header.setDraggedColumn(null);
            TableHeaderUI.this.header.setResizingColumn(null);
            TableHeaderUI.this.header.setDraggedDistance(0);
            Point p = e.getPoint();
            TableColumnModel columnModel = TableHeaderUI.this.header.getColumnModel();
            int index = TableHeaderUI.this.header.columnAtPoint(p);
            if (index != -1) {
                TableColumn resizingColumn = this.getResizingColumn(p, index);
                if (this.canResize(resizingColumn)) {
                    TableHeaderUI.this.header.setResizingColumn(resizingColumn);
                    this.mouseXOffset = TableHeaderUI.this.header.getComponentOrientation().isLeftToRight() ? p.x - resizingColumn.getWidth() : p.x + resizingColumn.getWidth();
                } else if (TableHeaderUI.this.header.getReorderingAllowed()) {
                    TableColumn hitColumn = columnModel.getColumn(index);
                    TableHeaderUI.this.header.setDraggedColumn(hitColumn);
                    this.mouseXOffset = p.x;
                }
            }
        }

        private void swapCursor() {
            Cursor tmp = TableHeaderUI.this.header.getCursor();
            TableHeaderUI.this.header.setCursor(this.otherCursor);
            this.otherCursor = tmp;
        }

        public void mouseMoved(MouseEvent e) {
            if (this.canResize(this.getResizingColumn(e.getPoint())) != (TableHeaderUI.this.header.getCursor() == resizeCursor)) {
                this.swapCursor();
            }
        }

        public void mouseDragged(MouseEvent e) {
            int mouseX = e.getX();
            TableColumn resizingColumn = TableHeaderUI.this.header.getResizingColumn();
            TableColumn draggedColumn = TableHeaderUI.this.header.getDraggedColumn();
            boolean headerLeftToRight = TableHeaderUI.this.header.getComponentOrientation().isLeftToRight();
            if (resizingColumn != null) {
                JTable table;
                Container container;
                int oldWidth = resizingColumn.getWidth();
                int newWidth = headerLeftToRight ? mouseX - this.mouseXOffset : this.mouseXOffset - mouseX;
                resizingColumn.setWidth(newWidth);
                if (TableHeaderUI.this.header.getParent() == null || (container = TableHeaderUI.this.header.getParent().getParent()) == null || !(container instanceof JScrollPane)) {
                    return;
                }
                if (!container.getComponentOrientation().isLeftToRight() && !headerLeftToRight && (table = TableHeaderUI.this.header.getTable()) != null) {
                    JViewport viewport = ((JScrollPane)container).getViewport();
                    int viewportWidth = viewport.getWidth();
                    int diff = newWidth - oldWidth;
                    int newHeaderWidth = table.getWidth() + diff;
                    Dimension tableSize = table.getSize();
                    tableSize.width += diff;
                    table.setSize(tableSize);
                    if (newHeaderWidth >= viewportWidth && table.getAutoResizeMode() == 0) {
                        Point p = viewport.getViewPosition();
                        p.x = Math.max(0, Math.min(newHeaderWidth - viewportWidth, p.x + diff));
                        viewport.setViewPosition(p);
                        this.mouseXOffset += diff;
                    }
                }
            } else if (draggedColumn != null) {
                TableColumnModel cm = TableHeaderUI.this.header.getColumnModel();
                int draggedDistance = mouseX - this.mouseXOffset;
                int direction = draggedDistance < 0 ? -1 : 1;
                int columnIndex = TableHeaderUI.this.viewIndexForColumn(draggedColumn);
                int newColumnIndex = columnIndex + (headerLeftToRight ? direction : -direction);
                if (newColumnIndex >= 0 && newColumnIndex < cm.getColumnCount()) {
                    int width = cm.getColumn(newColumnIndex).getWidth();
                    if (Math.abs(draggedDistance) > width / 2) {
                        this.mouseXOffset += direction * width;
                        TableHeaderUI.this.header.setDraggedDistance(draggedDistance - direction * width);
                        cm.moveColumn(columnIndex, newColumnIndex);
                        return;
                    }
                }
                this.setDraggedDistance(draggedDistance, columnIndex);
            }
        }

        public void mouseReleased(MouseEvent e) {
            this.setDraggedDistance(0, TableHeaderUI.this.viewIndexForColumn(TableHeaderUI.this.header.getDraggedColumn()));
            TableHeaderUI.this.header.setResizingColumn(null);
            TableHeaderUI.this.header.setDraggedColumn(null);
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        private void setDraggedDistance(int draggedDistance, int column) {
            TableHeaderUI.this.header.setDraggedDistance(draggedDistance);
            if (column != -1) {
                TableHeaderUI.this.header.getColumnModel().moveColumn(column, column);
            }
        }
    }
}

