/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLStreamHandlerFactory;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.JRResourcesUtil;

public class JRImageLoader {
    public static final byte NO_IMAGE = 1;
    public static final byte SUBREPORT_IMAGE = 2;
    public static final byte CHART_IMAGE = 3;
    public static final byte CROSSTAB_IMAGE = 4;
    private static final String str_NO_IMAGE = "net/sf/jasperreports/engine/images/noimage.GIF";
    private static final String str_SUBREPORT_IMAGE = "net/sf/jasperreports/engine/images/subreport.GIF";
    private static final String str_CHART_IMAGE = "net/sf/jasperreports/engine/images/chart.GIF";
    private static final String str_CROSSTAB_IMAGE = "net/sf/jasperreports/engine/images/crosstab.GIF";
    private static Image img_NO_IMAGE = null;
    private static Image img_SUBREPORT_IMAGE = null;
    private static Image img_CHART_IMAGE = null;
    private static Image img_CROSSTAB_IMAGE = null;
    static /* synthetic */ Class class$net$sf$jasperreports$engine$util$JRImageLoader;

    public static byte[] loadImageDataFromFile(File file) throws JRException {
        try {
            return JRLoader.loadBytes(file);
        }
        catch (JRException e) {
            throw new JRException("Error loading image data : " + file, e);
        }
    }

    public static byte[] loadImageDataFromURL(URL url) throws JRException {
        try {
            return JRLoader.loadBytes(url);
        }
        catch (JRException e) {
            throw new JRException("Error loading image data : " + url, e);
        }
    }

    public static byte[] loadImageDataFromInputStream(InputStream is) throws JRException {
        try {
            return JRLoader.loadBytes(is);
        }
        catch (JRException e) {
            throw new JRException("Error loading image data from input stream.", e);
        }
    }

    public static byte[] loadImageDataFromLocation(String location) throws JRException {
        return JRImageLoader.loadImageDataFromLocation(location, null, null);
    }

    public static byte[] loadImageDataFromLocation(String location, ClassLoader classLoader) throws JRException {
        return JRImageLoader.loadImageDataFromLocation(location, classLoader, null);
    }

    public static byte[] loadImageDataFromLocation(String location, ClassLoader classLoader, URLStreamHandlerFactory urlHandlerFactory) throws JRException {
        URL url = JRResourcesUtil.createURL(location, urlHandlerFactory);
        if (url != null) {
            return JRImageLoader.loadImageDataFromURL(url);
        }
        File file = new File(location);
        if (file.exists() && file.isFile()) {
            return JRImageLoader.loadImageDataFromFile(file);
        }
        url = JRResourcesUtil.findClassLoaderResource(location, classLoader, class$net$sf$jasperreports$engine$util$JRImageLoader == null ? (class$net$sf$jasperreports$engine$util$JRImageLoader = JRImageLoader.class$("net.sf.jasperreports.engine.util.JRImageLoader")) : class$net$sf$jasperreports$engine$util$JRImageLoader);
        if (url != null) {
            return JRImageLoader.loadImageDataFromURL(url);
        }
        throw new JRException("Image not found : " + location);
    }

    public static byte[] loadImageDataFromAWTImage(BufferedImage bi) throws JRException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)baos);
            JPEGEncodeParam param = encoder.getDefaultJPEGEncodeParam(bi);
            param.setQuality(1.0f, true);
            encoder.encode(bi, param);
        }
        catch (IOException e) {
            throw new JRException("Error trying to load image data from AWT image.", e);
        }
        return baos.toByteArray();
    }

    public static byte[] loadImageDataFromAWTImage(Image img) throws JRException {
        BufferedImage bi = new BufferedImage(img.getWidth(null), img.getHeight(null), 1);
        Graphics2D g = bi.createGraphics();
        g.drawImage(img, 0, 0, null);
        g.dispose();
        return JRImageLoader.loadImageDataFromAWTImage(bi);
    }

    public static Image getImage(byte index) throws JRException {
        Image image = null;
        switch (index) {
            case 1: {
                if (img_NO_IMAGE == null) {
                    img_NO_IMAGE = JRImageLoader.loadImage(str_NO_IMAGE);
                }
                image = img_NO_IMAGE;
                break;
            }
            case 2: {
                if (img_SUBREPORT_IMAGE == null) {
                    img_SUBREPORT_IMAGE = JRImageLoader.loadImage(str_SUBREPORT_IMAGE);
                }
                image = img_SUBREPORT_IMAGE;
                break;
            }
            case 3: {
                if (img_CHART_IMAGE == null) {
                    img_CHART_IMAGE = JRImageLoader.loadImage(str_CHART_IMAGE);
                }
                image = img_CHART_IMAGE;
                break;
            }
            case 4: {
                if (img_CROSSTAB_IMAGE == null) {
                    img_CROSSTAB_IMAGE = JRImageLoader.loadImage(str_CROSSTAB_IMAGE);
                }
                image = img_CROSSTAB_IMAGE;
            }
        }
        return image;
    }

    public static Image loadImage(byte[] bytes) throws JRException {
        Image image = Toolkit.getDefaultToolkit().createImage(bytes);
        MediaTracker tracker = new MediaTracker(new Panel());
        tracker.addImage(image, 0);
        try {
            tracker.waitForID(0);
        }
        catch (Exception e) {
            throw new JRException(e);
        }
        if (tracker.isErrorID(0)) {
            throw new JRException("Image failed to load.");
        }
        return image;
    }

    protected static Image loadImage(String image) throws JRException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        URL url = classLoader.getResource(image);
        if (url == null) {
            classLoader = (class$net$sf$jasperreports$engine$util$JRImageLoader == null ? (class$net$sf$jasperreports$engine$util$JRImageLoader = JRImageLoader.class$("net.sf.jasperreports.engine.util.JRImageLoader")) : class$net$sf$jasperreports$engine$util$JRImageLoader).getClassLoader();
        }
        InputStream is = classLoader == null ? (class$net$sf$jasperreports$engine$util$JRImageLoader == null ? (class$net$sf$jasperreports$engine$util$JRImageLoader = JRImageLoader.class$("net.sf.jasperreports.engine.util.JRImageLoader")) : class$net$sf$jasperreports$engine$util$JRImageLoader).getResourceAsStream("/" + image) : classLoader.getResourceAsStream(image);
        return JRImageLoader.loadImage(JRImageLoader.loadImageDataFromInputStream(is));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

