/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport;

import com.lowagie.text.DocumentException;
import com.lowagie.text.FontFactory;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.DefaultFontMapper;
import it.businesslogic.ireport.IRFont;
import java.awt.Font;
import java.awt.FontFormatException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;

public class FontListLoader {
    public static Font loadFont(String file) {
        Font f = null;
        try {
            f = Font.createFont(0, new FileInputStream(file));
        }
        catch (IllegalArgumentException ett) {
            System.out.println(ett.getMessage() + " No TrueType font");
        }
        catch (FontFormatException ef) {
            System.out.println(ef.getMessage() + " FontFormatException");
        }
        catch (IOException ioex) {
            System.out.println(ioex.getMessage() + " IOException");
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage() + " General Exception");
        }
        return f;
    }

    public static Vector loadTTFFonts() {
        Vector<IRFont> fonts = new Vector<IRFont>();
        String path = System.getProperty("java.class.path");
        if (path != null && path.length() > 0) {
            StringTokenizer st = new StringTokenizer(path, System.getProperty("path.separator"));
            while (st.hasMoreTokens()) {
                String path_str = st.nextToken();
                File file = new File(path_str);
                if (!file.exists()) continue;
                if (file.isDirectory()) {
                    String[] files = file.list(new FilenameFilter(){

                        public boolean accept(File dir, String filename) {
                            return filename.toUpperCase().endsWith(".TTF") || filename.toUpperCase().endsWith(".TTC");
                        }
                    });
                    DefaultFontMapper fontMapper = new DefaultFontMapper();
                    if (files == null) {
                        System.out.println("Unable to list files in: " + file);
                        continue;
                    }
                    for (int i = 0; i < files.length; ++i) {
                        if (files[i].toUpperCase().endsWith(".TTC")) {
                            try {
                                String[] names = BaseFont.enumerateTTCNames((String)(file.getPath() + File.separator + files[i]));
                                for (int a = 0; a < names.length; ++a) {
                                    Font f = fontMapper.pdfToAwt(FontFactory.getFont((String)(file.getPath() + File.separator + files[i])).getBaseFont(), 10);
                                    if (f != null) {
                                        fonts.addElement(new IRFont(f, files[i]));
                                        continue;
                                    }
                                    System.out.println("Failed to load font " + file.getPath() + File.separator + files[i]);
                                }
                                continue;
                            }
                            catch (DocumentException de) {
                                System.out.println((Object)de);
                                continue;
                            }
                            catch (IOException ioe) {
                                System.out.println(ioe);
                                continue;
                            }
                        }
                        Font f = FontListLoader.loadFont(file.getPath() + File.separator + files[i]);
                        if (f != null) {
                            fonts.addElement(new IRFont(f, files[i]));
                            continue;
                        }
                        System.out.println("Failed to load font " + file.getPath() + File.separator + files[i]);
                    }
                    continue;
                }
                if (path_str.toUpperCase().endsWith(".TTF")) {
                    System.out.println("m" + path_str);
                    continue;
                }
                if (!path_str.toUpperCase().endsWith(".TTC")) continue;
                System.out.println("TTC: " + path_str);
            }
        }
        return fonts;
    }
}

