/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.crosstab.gui;

import it.businesslogic.ireport.SubDataset;
import it.businesslogic.ireport.crosstab.CrosstabColumnGroup;
import it.businesslogic.ireport.crosstab.CrosstabGroup;
import it.businesslogic.ireport.gui.JNumberField;
import it.businesslogic.ireport.gui.JRTextExpressionArea;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.gui.sheet.Tag;
import it.businesslogic.ireport.util.Misc;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyVetoException;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class CrosstabGroupDialog
extends JDialog {
    public static final int ROWGROUP = 0;
    public static final int COLUMNGROUP = 1;
    private CrosstabGroup tmpGroup = null;
    private int groupType = 1;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JComboBox jComboBoxBucketClass;
    private JComboBox jComboBoxHeaderPosition;
    private JComboBox jComboBoxOrder;
    private JComboBox jComboBoxTotalPosition;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabelSize;
    private JNumberField jNumberFieldSize;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JRTextExpressionArea jRTextExpressionAreaComparatorExpression;
    private JRTextExpressionArea jRTextExpressionAreaExpression;
    private JTextField jTextFieldName;
    private int dialogResult;

    public CrosstabGroupDialog(int groupType, Frame parent, boolean modal) {
        super(parent, modal);
        this.initAll(groupType);
    }

    public CrosstabGroupDialog(int groupType, Dialog parent, boolean modal) {
        super(parent, modal);
        this.initAll(groupType);
    }

    public void initAll(int groupType) {
        this.initComponents();
        this.jComboBoxBucketClass.addItem("java.lang.String");
        this.jComboBoxBucketClass.addItem("java.lang.Double");
        this.jComboBoxBucketClass.addItem("java.lang.Float");
        this.jComboBoxBucketClass.addItem("java.lang.Integer");
        this.jComboBoxBucketClass.addItem("java.lang.Long");
        this.jComboBoxBucketClass.addItem("java.lang.Short");
        this.jComboBoxBucketClass.addItem("java.math.BigDecimal");
        this.jComboBoxBucketClass.addItem("java.util.Date");
        this.jComboBoxBucketClass.addItem("java.sql.Timestamp");
        this.jComboBoxBucketClass.addItem("java.sql.Time");
        this.setGroupType(groupType);
        Misc.centerFrame(this);
        this.pack();
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                CrosstabGroupDialog.this.jButtonCancelActionPerformed(e);
            }
        };
        this.getRootPane().getInputMap(2).put(escape, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", escapeAction);
        this.getRootPane().setDefaultButton(this.jButtonOK);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jTextFieldName = new JTextField();
        this.jPanel1 = new JPanel();
        this.jPanel4 = new JPanel();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.jLabelSize = new JLabel();
        this.jNumberFieldSize = new JNumberField();
        this.jPanel2 = new JPanel();
        this.jLabel3 = new JLabel();
        this.jRTextExpressionAreaExpression = new JRTextExpressionArea();
        this.jLabel4 = new JLabel();
        this.jComboBoxOrder = new JComboBox();
        this.jLabel5 = new JLabel();
        this.jPanel5 = new JPanel();
        this.jLabel6 = new JLabel();
        this.jComboBoxBucketClass = new JComboBox();
        this.jRTextExpressionAreaComparatorExpression = new JRTextExpressionArea();
        this.jPanel3 = new JPanel();
        this.jComboBoxTotalPosition = new JComboBox();
        this.jComboBoxHeaderPosition = new JComboBox();
        this.jLabel2 = new JLabel();
        this.jLabel7 = new JLabel();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Add/modify crosstab group");
        this.setModal(true);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                CrosstabGroupDialog.this.closeDialog(evt);
            }
        });
        this.jLabel1.setText("Group name");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 0, 3);
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        this.jTextFieldName.setPreferredSize(new Dimension(360, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 3, 3, 3);
        this.getContentPane().add((Component)this.jTextFieldName, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel1.setMinimumSize(new Dimension(126, 40));
        this.jPanel1.setPreferredSize(new Dimension(126, 40));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jPanel4, gridBagConstraints);
        this.jButtonOK.setMnemonic('o');
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrosstabGroupDialog.this.jButtonOKActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 14;
        this.jPanel1.add((Component)this.jButtonOK, gridBagConstraints);
        this.jButtonCancel.setMnemonic('c');
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrosstabGroupDialog.this.jButtonCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.jPanel1.add((Component)this.jButtonCancel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 99;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.jLabelSize.setText("Group width / height");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jLabelSize, gridBagConstraints);
        this.jNumberFieldSize.setColumns(4);
        this.jNumberFieldSize.setHorizontalAlignment(4);
        try {
            this.jNumberFieldSize.setDecimals(0);
        }
        catch (PropertyVetoException e1) {
            e1.printStackTrace();
        }
        this.jNumberFieldSize.setMinimumSize(new Dimension(40, 21));
        this.jNumberFieldSize.setPreferredSize(new Dimension(38, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jNumberFieldSize, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Bucket", 0, 0, new Font("Dialog", 0, 11)));
        this.jLabel3.setText("Bucket expression");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.jPanel2.add((Component)this.jLabel3, gridBagConstraints);
        this.jRTextExpressionAreaExpression.setBorder(BorderFactory.createEtchedBorder());
        this.jRTextExpressionAreaExpression.setCaretVisible(false);
        this.jRTextExpressionAreaExpression.setElectricScroll(0);
        this.jRTextExpressionAreaExpression.setMinimumSize(new Dimension(657, 90));
        this.jRTextExpressionAreaExpression.setPreferredSize(new Dimension(325, 100));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 3, 3);
        this.jPanel2.add((Component)this.jRTextExpressionAreaExpression, gridBagConstraints);
        this.jLabel4.setText("Order");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 18;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.jPanel2.add((Component)this.jLabel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel2.add((Component)this.jComboBoxOrder, gridBagConstraints);
        this.jLabel5.setText("Custom comparator expression");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 20;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.jPanel2.add((Component)this.jLabel5, gridBagConstraints);
        this.jPanel5.setLayout(new GridBagLayout());
        this.jLabel6.setText("Class");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.jPanel5.add((Component)this.jLabel6, gridBagConstraints);
        this.jComboBoxBucketClass.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel5.add((Component)this.jComboBoxBucketClass, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel2.add((Component)this.jPanel5, gridBagConstraints);
        this.jRTextExpressionAreaComparatorExpression.setBorder(BorderFactory.createEtchedBorder());
        this.jRTextExpressionAreaComparatorExpression.setCaretVisible(false);
        this.jRTextExpressionAreaComparatorExpression.setElectricScroll(0);
        this.jRTextExpressionAreaComparatorExpression.setMinimumSize(new Dimension(657, 45));
        this.jRTextExpressionAreaComparatorExpression.setPreferredSize(new Dimension(325, 45));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 21;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 3, 3);
        this.jPanel2.add((Component)this.jRTextExpressionAreaComparatorExpression, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jPanel2, gridBagConstraints);
        this.jPanel3.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel3.add((Component)this.jComboBoxTotalPosition, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel3.add((Component)this.jComboBoxHeaderPosition, gridBagConstraints);
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText("Print the group header on this position: ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        this.jPanel3.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel7.setHorizontalAlignment(4);
        this.jLabel7.setText("Print the group total on this position: ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        this.jPanel3.add((Component)this.jLabel7, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jPanel3, gridBagConstraints);
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dialogSize = this.getSize();
        this.setLocation((screenSize.width - dialogSize.width) / 2, (screenSize.height - dialogSize.height) / 2);
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.setDialogResult(2);
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.jTextFieldName.getText().trim().length() <= 0) {
            JOptionPane.showMessageDialog(this, "Please insert a valid group name!", "Invalid group!", 2);
            return;
        }
        if (("" + this.jComboBoxBucketClass.getSelectedItem()).trim().length() <= 0) {
            JOptionPane.showMessageDialog(this, "Please insert a valid class name for the bucket!", "Invalid class!", 2);
            return;
        }
        this.tmpGroup = new CrosstabGroup();
        this.tmpGroup.setName(this.jTextFieldName.getText().trim());
        this.tmpGroup.setBucketExpressionClass(this.jComboBoxBucketClass.getSelectedItem() + "");
        this.tmpGroup.setSize((int)this.jNumberFieldSize.getValue());
        this.tmpGroup.setBucketExpression(this.jRTextExpressionAreaExpression.getText());
        this.tmpGroup.setBucketComparatorExpression(this.jRTextExpressionAreaComparatorExpression.getText());
        this.tmpGroup.setBucketOrder("" + ((Tag)this.jComboBoxOrder.getSelectedItem()).getValue());
        this.tmpGroup.setTotalPosition("" + ((Tag)this.jComboBoxTotalPosition.getSelectedItem()).getValue());
        this.tmpGroup.setHasTotal(!this.tmpGroup.getTotalPosition().equals("None"));
        this.tmpGroup.setHasHeader(true);
        this.tmpGroup.setHeaderPosition("" + ((Tag)this.jComboBoxHeaderPosition.getSelectedItem()).getValue());
        this.setVisible(false);
        this.setDialogResult(0);
        this.dispose();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.setDialogResult(-1);
        this.dispose();
    }

    public int getDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }

    public void setExpressionContext(SubDataset sds) {
        if (sds == null) {
            sds = MainFrame.getMainInstance().getActiveReportFrame().getReport();
        }
        this.jRTextExpressionAreaComparatorExpression.setSubDataset(sds);
        this.jRTextExpressionAreaComparatorExpression.getCrosstabElements().removeAllElements();
        this.jRTextExpressionAreaExpression.setSubDataset(sds);
        this.jRTextExpressionAreaExpression.getCrosstabElements().removeAllElements();
    }

    public CrosstabGroup getGroup() {
        return this.tmpGroup;
    }

    public void setGroup(CrosstabGroup group) {
        if (group instanceof CrosstabColumnGroup) {
            this.setGroupType(1);
        } else {
            this.setGroupType(0);
        }
        this.jTextFieldName.setText(group.getName());
        try {
            this.jNumberFieldSize.setValue(group.getSize());
        }
        catch (Exception exception) {
            // empty catch block
        }
        Misc.setComboboxSelectedTagValue(this.jComboBoxTotalPosition, group.getTotalPosition());
        Misc.setComboboxSelectedTagValue(this.jComboBoxHeaderPosition, group.getHeaderPosition());
        this.jRTextExpressionAreaExpression.setText(group.getBucketExpression());
        Misc.setComboboxSelectedTagValue(this.jComboBoxOrder, group.getBucketOrder());
        this.jRTextExpressionAreaComparatorExpression.setText(group.getBucketComparatorExpression());
        this.jComboBoxBucketClass.setSelectedItem(group.getBucketExpressionClass());
    }

    public int getGroupType() {
        return this.groupType;
    }

    public void setGroupType(int groupType) {
        this.groupType = groupType;
        this.jComboBoxOrder.removeAllItems();
        this.jComboBoxOrder.addItem(new Tag("Ascending", "Ascending"));
        this.jComboBoxOrder.addItem(new Tag("Descending", "Descending"));
        Misc.setComboboxSelectedTagValue(this.jComboBoxTotalPosition, "Ascending");
        this.jComboBoxTotalPosition.removeAllItems();
        this.jComboBoxTotalPosition.addItem(new Tag("None", "None"));
        this.jComboBoxTotalPosition.addItem(new Tag("Start", "Start"));
        this.jComboBoxTotalPosition.addItem(new Tag("End", "End"));
        Misc.setComboboxSelectedTagValue(this.jComboBoxTotalPosition, "None");
        if (groupType == 1) {
            try {
                this.jNumberFieldSize.setValue(30);
            }
            catch (Exception ex) {
                // empty catch block
            }
            this.jLabelSize.setText("Group height");
            this.jComboBoxHeaderPosition.removeAllItems();
            this.jComboBoxHeaderPosition.addItem(new Tag("Left", "Left"));
            this.jComboBoxHeaderPosition.addItem(new Tag("Center", "Center"));
            this.jComboBoxHeaderPosition.addItem(new Tag("Right", "Right"));
            this.jComboBoxHeaderPosition.addItem(new Tag("Stretch", "Stretch"));
            Misc.setComboboxSelectedTagValue(this.jComboBoxHeaderPosition, "Left");
        } else {
            try {
                this.jNumberFieldSize.setValue(100);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.jLabelSize.setText("Group width");
            this.jComboBoxHeaderPosition.removeAllItems();
            this.jComboBoxHeaderPosition.addItem(new Tag("Top", "Top"));
            this.jComboBoxHeaderPosition.addItem(new Tag("Middle", "Middle"));
            this.jComboBoxHeaderPosition.addItem(new Tag("Bottom", "Bottom"));
            this.jComboBoxHeaderPosition.addItem(new Tag("Stretch", "Stretch"));
            Misc.setComboboxSelectedTagValue(this.jComboBoxHeaderPosition, "Top");
        }
    }
}

