/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.plaf.mappings;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import org.flexdock.logging.Log;
import org.flexdock.plaf.Configurator;
import org.flexdock.plaf.XMLConstants;
import org.flexdock.plaf.mappings.RefResolver;
import org.w3c.dom.Element;

public class PlafMappingFactory
implements XMLConstants {
    public static final String PLAF_KEY = "plaf";
    private static final HashMap PLAF_MAPPINGS = PlafMappingFactory.loadPlafMappings();

    public static List getAvailablePlafNames() {
        return new ArrayList(PLAF_MAPPINGS.keySet());
    }

    public static String getInstalledPlafReference() {
        LookAndFeel currentPlaf = UIManager.getLookAndFeel();
        if (currentPlaf == null) {
            return null;
        }
        String key = currentPlaf.getClass().getName();
        return PlafMappingFactory.getPlafReference(key);
    }

    public static String getPlafReference(String key) {
        if (key == null) {
            return null;
        }
        Object value = PLAF_MAPPINGS.get(key);
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof RefResolver) {
            RefResolver resolver = (RefResolver)value;
            return resolver.getRef(key);
        }
        return null;
    }

    private static HashMap loadPlafMappings() {
        HashMap elements = Configurator.getNamedElementsByTagName(PLAF_KEY);
        HashMap<String, Object> mappings = new HashMap<String, Object>(elements.size());
        Iterator it = elements.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            Element elem = (Element)elements.get(key);
            String name = elem.getAttribute("name");
            String ref = elem.getAttribute("ref");
            String resolver = elem.getAttribute("handler");
            Object value = PlafMappingFactory.createPlafMapping(ref, resolver);
            mappings.put(name, value);
        }
        return mappings;
    }

    private static Object createPlafMapping(String refName, String resolverName) {
        if (Configurator.isNull(resolverName)) {
            return refName;
        }
        RefResolver resolver = null;
        try {
            Class<?> clazz = Class.forName(resolverName);
            resolver = (RefResolver)clazz.newInstance();
        }
        catch (Exception e) {
            Log.debug("Error trying to create new instance of '" + resolverName + "'.", e);
            return refName;
        }
        resolver.setDefaultRef(refName);
        return resolver;
    }
}

