/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context.scope;

import org.springframework.aop.target.scope.ScopeMap;
import org.springframework.web.context.scope.RequestContextHolder;

public class SessionScopeMap
implements ScopeMap {
    private int scope = 1;

    public void setGlobalSession(boolean globalSession) {
        this.scope = globalSession ? 2 : 1;
    }

    public boolean isPersistent() {
        return false;
    }

    public Object get(String name) {
        return RequestContextHolder.currentRequestAttributes().getAttribute(name, this.scope);
    }

    public void put(String name, Object value) {
        RequestContextHolder.currentRequestAttributes().setAttribute(name, value, this.scope);
    }

    public void remove(String name) {
        RequestContextHolder.currentRequestAttributes().removeAttribute(name, this.scope);
    }
}

