/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.chart.gui;

import it.businesslogic.ireport.JRVariable;
import it.businesslogic.ireport.chart.AvailableCharts;
import it.businesslogic.ireport.chart.ChartDefinition;
import it.businesslogic.ireport.chart.gui.ChartCellRenderer;
import it.businesslogic.ireport.chart.gui.ComboBoxRenderer;
import it.businesslogic.ireport.chart.gui.ComboCellEditor;
import it.businesslogic.ireport.chart.gui.ReportSeriesDialog;
import it.businesslogic.ireport.gui.JReportFrame;
import it.businesslogic.ireport.gui.listview.JListView;
import it.businesslogic.ireport.gui.sheet.SheetPanel;
import it.businesslogic.ireport.gui.sheet.SheetProperty;
import it.businesslogic.ireport.util.I18n;
import it.businesslogic.ireport.util.Misc;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;

public class IReportChartDialog
extends JDialog {
    private Properties properties = null;
    private int dialogResult = 0;
    private JReportFrame jReportFrame = null;
    private SheetPanel sheetPanel = null;
    private JListView jListView = null;
    private JList jList1 = null;
    private JButton jButton1;
    private JButton jButton6;
    private JButton jButton7;
    private JButton jButtonAddDataSerie;
    private JLabel jLabelChartName;
    private JLabel jLabelChartNameVal;
    private JLabel jLabelFactory;
    private JLabel jLabelFactoryVal;
    private JLabel jLabelSeries;
    private JLabel jLabelSeriesVal;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanelChartType;
    private JPanel jPanelData;
    private JPanel jPanelDetails;
    private JScrollPane jScrollPane3;
    private JTabbedPane jTabbedPane1;
    private JTable jTable1;

    public IReportChartDialog(Dialog parent, boolean modal) {
        super(parent, modal);
        this.initAll();
    }

    public IReportChartDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initAll();
    }

    public void initAll() {
        this.initComponents();
        this.setDialogResult(2);
        this.jListView = new JListView();
        this.jList1 = this.jListView.getList();
        this.jPanelChartType.add((Component)this.jListView, "Center");
        DefaultListModel dlm = new DefaultListModel();
        this.jList1.setModel(dlm);
        this.jList1.setCellRenderer(new ChartCellRenderer());
        this.sheetPanel = new SheetPanel();
        Vector charts = AvailableCharts.getAvailableCharts();
        for (int i = 0; i < charts.size(); ++i) {
            dlm.addElement(charts.elementAt(i));
        }
        this.jList1.updateUI();
        String[] values = new String[]{};
        TableColumn col = this.jTable1.getColumnModel().getColumn(1);
        col.setCellEditor(new ComboCellEditor(values));
        col.setCellRenderer(new ComboBoxRenderer(values));
        this.jTabbedPane1.updateUI();
        this.jTable1.setRowHeight(24);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanelDetails.add((Component)this.sheetPanel, gridBagConstraints);
        this.jList1.setLayoutOrientation(2);
        this.setSize(400, 400);
        Misc.centerFrame(this);
        this.jList1.setSelectionMode(0);
        this.jList1.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                IReportChartDialog.this.selectedChart();
            }
        });
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                IReportChartDialog.this.jButton7ActionPerformed(e);
            }
        };
        this.getRootPane().getInputMap(2).put(escape, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", escapeAction);
        this.applyI18n();
        this.getRootPane().setDefaultButton(this.jButton6);
    }

    public void updateSeriesComboBoxes() {
        Vector<String> values = new Vector<String>();
        if (this.getJReportFrame() == null) {
            return;
        }
        values.add("");
        Enumeration var_enum = this.getJReportFrame().getReport().getVariables().elements();
        while (var_enum.hasMoreElements()) {
            JRVariable var = (JRVariable)var_enum.nextElement();
            if (!var.getName().startsWith("SERIE_")) continue;
            values.add(var.getName());
        }
        TableColumn col = this.jTable1.getColumnModel().getColumn(1);
        col.setCellEditor(new ComboCellEditor(values));
        col.setCellRenderer(new ComboBoxRenderer((Vector)values));
        this.jTabbedPane1.updateUI();
    }

    public JReportFrame getJReportFrame() {
        return this.jReportFrame;
    }

    public void setJReportFrame(JReportFrame jReportFrame) {
        this.jReportFrame = jReportFrame;
        this.updateSeriesComboBoxes();
    }

    public void setProperties(Properties props) {
        int i;
        this.properties = props;
        String chartName = props.getProperty("chartName", "pie");
        DefaultListModel dlm = (DefaultListModel)this.jList1.getModel();
        boolean found = false;
        for (i = 0; i < dlm.getSize(); ++i) {
            ChartDefinition cd = (ChartDefinition)dlm.getElementAt(i);
            if (!cd.getChartName().equals(chartName)) continue;
            this.jList1.setSelectedIndex(i);
            found = true;
            break;
        }
        if (!found) {
            this.jList1.setSelectedIndex(0);
        }
        i = 0;
        while (props.getProperty("serie" + i) != null) {
            String var = props.getProperty("serie" + i);
            if (this.jTable1.getRowCount() < i) {
                ((DefaultTableModel)this.jTable1.getModel()).addRow(new Object[]{"Serie", var});
            } else {
                DefaultTableModel dtm = (DefaultTableModel)this.jTable1.getModel();
                try {
                    dtm.setValueAt(var, i, 1);
                }
                catch (Exception ex) {
                    props.remove("serie" + i);
                }
            }
            ++i;
        }
    }

    public int getDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }

    public Properties getProperties() {
        return this.properties;
    }

    private void initComponents() {
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanelChartType = new JPanel();
        this.jPanel5 = new JPanel();
        this.jLabelChartName = new JLabel();
        this.jLabelChartNameVal = new JLabel();
        this.jLabelSeries = new JLabel();
        this.jLabelSeriesVal = new JLabel();
        this.jLabelFactory = new JLabel();
        this.jLabelFactoryVal = new JLabel();
        this.jPanel6 = new JPanel();
        this.jPanelData = new JPanel();
        this.jScrollPane3 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jPanel2 = new JPanel();
        this.jButton1 = new JButton();
        this.jButtonAddDataSerie = new JButton();
        this.jPanel3 = new JPanel();
        this.jPanelDetails = new JPanel();
        this.jPanel1 = new JPanel();
        this.jPanel4 = new JPanel();
        this.jButton6 = new JButton();
        this.jButton7 = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Chart properties");
        this.jPanelChartType.setLayout(new BorderLayout());
        this.jPanel5.setLayout(new GridBagLayout());
        this.jPanel5.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Chart info"));
        this.jPanel5.setMinimumSize(new Dimension(10, 100));
        this.jPanel5.setPreferredSize(new Dimension(10, 100));
        this.jLabelChartName.setText("Chart type");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.jPanel5.add((Component)this.jLabelChartName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.jPanel5.add((Component)this.jLabelChartNameVal, gridBagConstraints);
        this.jLabelSeries.setText("Series");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.jPanel5.add((Component)this.jLabelSeries, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.jPanel5.add((Component)this.jLabelSeriesVal, gridBagConstraints);
        this.jLabelFactory.setText("Factory");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.jPanel5.add((Component)this.jLabelFactory, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.jPanel5.add((Component)this.jLabelFactoryVal, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel5.add((Component)this.jPanel6, gridBagConstraints);
        this.jPanelChartType.add((Component)this.jPanel5, "South");
        this.jTabbedPane1.addTab("Chart type", this.jPanelChartType);
        this.jPanelData.setLayout(new GridBagLayout());
        this.jTable1.setModel(new DefaultTableModel(new Object[0][], new String[]{"Serie name", "Variable"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false, true};
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jScrollPane3.setViewportView(this.jTable1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanelData.add((Component)this.jScrollPane3, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.jPanel2.setMinimumSize(new Dimension(100, 151));
        this.jPanel2.setPreferredSize(new Dimension(140, 100));
        this.jButton1.setText("Report series");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                IReportChartDialog.this.jButton1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.jPanel2.add((Component)this.jButton1, gridBagConstraints);
        this.jButtonAddDataSerie.setText("Add serie");
        this.jButtonAddDataSerie.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.jPanel2.add((Component)this.jButtonAddDataSerie, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel2.add((Component)this.jPanel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(4, 0, 4, 4);
        this.jPanelData.add((Component)this.jPanel2, gridBagConstraints);
        this.jTabbedPane1.addTab("Data", this.jPanelData);
        this.jPanelDetails.setLayout(new GridBagLayout());
        this.jTabbedPane1.addTab("Chart details", this.jPanelDetails);
        this.getContentPane().add((Component)this.jTabbedPane1, "Center");
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel1.setMinimumSize(new Dimension(10, 34));
        this.jPanel1.setPreferredSize(new Dimension(10, 34));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.jPanel4, gridBagConstraints);
        this.jButton6.setText("OK");
        this.jButton6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                IReportChartDialog.this.jButton6ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.jButton6, gridBagConstraints);
        this.jButton7.setText("Cancel");
        this.jButton7.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                IReportChartDialog.this.jButton7ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.jButton7, gridBagConstraints);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.pack();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        ReportSeriesDialog rsd = new ReportSeriesDialog((Dialog)this, true);
        rsd.setJReportFrame(this.getJReportFrame());
        rsd.setVisible(true);
        this.updateSeriesComboBoxes();
    }

    private void jButton7ActionPerformed(ActionEvent evt) {
        this.setDialogResult(2);
        this.setVisible(false);
    }

    private void jButton6ActionPerformed(ActionEvent evt) {
        if (this.jList1.getSelectedIndex() < 0) {
            JOptionPane.showMessageDialog(this, I18n.getString("messages.selectChartFirst", "Please select a chart type first!"));
            return;
        }
        this.properties = this.sheetPanel.getPropertiesValues();
        ChartDefinition cd = (ChartDefinition)this.jList1.getSelectedValue();
        for (int i = 0; i < this.jTable1.getRowCount(); ++i) {
            String s = "" + this.jTable1.getValueAt(i, 1);
            if (s == null || s.equals("null") || s.length() == 0) {
                s = "X" + i;
            }
            this.properties.setProperty("serie" + i, "" + this.jTable1.getValueAt(i, 1));
        }
        this.getProperties().setProperty("chartName", cd.getChartName());
        this.setDialogResult(0);
        this.setVisible(false);
    }

    void selectedChart() {
        if (this.jList1.getSelectedIndex() >= 0) {
            int i;
            ChartDefinition cd = (ChartDefinition)this.jList1.getSelectedValue();
            this.jLabelChartNameVal.setText(cd.getChartName());
            String series = "";
            DefaultTableModel dtm = (DefaultTableModel)this.jTable1.getModel();
            dtm.setRowCount(0);
            String[] series_a = cd.getNeededSeries();
            for (i = 0; i < series_a.length; ++i) {
                if (i > 0) {
                    series = series + ", ";
                }
                series = series + series_a[i];
                dtm.addRow(new Object[]{series_a[i], ""});
            }
            this.jLabelSeriesVal.setText(series);
            this.jLabelFactoryVal.setText(cd.getFactory());
            this.sheetPanel.removeAllProperties();
            for (i = 0; i < cd.getSheetProperties().size(); ++i) {
                SheetProperty sp = (SheetProperty)cd.getSheetProperties().elementAt(i);
                this.sheetPanel.addSheetProperty(sp);
                if (sp.getDefaultValue() == null || this.getProperties().getProperty(sp.getKeyName()) != null) continue;
                this.getProperties().setProperty(sp.getKeyName(), "" + sp.getDefaultValue());
            }
            this.sheetPanel.setPropertiesValues(this.getProperties());
        }
    }

    public void applyI18n() {
        this.jButton1.setText(I18n.getString("iReportChartDialog.button1", "Report series"));
        this.jButton6.setText(I18n.getString("iReportChartDialog.button6", "OK"));
        this.jButton7.setText(I18n.getString("iReportChartDialog.button7", "Cancel"));
        this.jButtonAddDataSerie.setText(I18n.getString("iReportChartDialog.buttonAddDataSerie", "Add serie"));
        this.jLabelChartName.setText(I18n.getString("iReportChartDialog.labelChartName", "Chart type"));
        this.jLabelFactory.setText(I18n.getString("iReportChartDialog.labelFactory", "Factory"));
        this.jLabelSeries.setText(I18n.getString("iReportChartDialog.labelSeries", "Series"));
        this.jTable1.getColumnModel().getColumn(0).setHeaderValue(I18n.getString("iReportChartDialog.tablecolumn.serieName", "Serie name"));
        this.jTable1.getColumnModel().getColumn(1).setHeaderValue(I18n.getString("iReportChartDialog.tablecolumn.variable", "Variable"));
        ((TitledBorder)this.jPanel5.getBorder()).setTitle(I18n.getString("iReportChartDialog.panelBorder.ChartInfo", "Chart info"));
    }
}

