/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.chart.gui;

import it.businesslogic.ireport.Group;
import it.businesslogic.ireport.JRVariable;
import it.businesslogic.ireport.gui.JRTextExpressionArea;
import it.businesslogic.ireport.gui.JReportFrame;
import it.businesslogic.ireport.util.I18n;
import it.businesslogic.ireport.util.Misc;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.syntax.jedit.SyntaxDocument;
import org.syntax.jedit.tokenmarker.JavaTokenMarker;

public class SerieDialog
extends JDialog {
    int dialogResult = 0;
    private JReportFrame jrf = null;
    private String serieExpression = null;
    private String serieName = null;
    private String serieReset = null;
    private String serieType = null;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JComboBox jComboBox1;
    private JComboBox jComboBoxClassType;
    private JLabel jLabelName;
    private JLabel jLabelName1;
    private JLabel jLabelName2;
    private JLabel jLabelTitle;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JRTextExpressionArea jRTextExpressionAreaDefaultExpression;
    private JTextField jTextFieldName;

    public SerieDialog(Dialog parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.initFrame();
    }

    public void initFrame() {
        this.setSize(400, 450);
        this.setModal(true);
        SyntaxDocument sd = new SyntaxDocument();
        sd.setTokenMarker(new JavaTokenMarker());
        this.jRTextExpressionAreaDefaultExpression.setDocument(sd);
        this.jComboBoxClassType.addItem("java.lang.String");
        this.jComboBoxClassType.addItem("java.lang.Object");
        this.jComboBoxClassType.addItem("java.lang.Boolean");
        this.jComboBoxClassType.addItem("java.lang.Byte");
        this.jComboBoxClassType.addItem("java.util.Date");
        this.jComboBoxClassType.addItem("java.sql.Timestamp");
        this.jComboBoxClassType.addItem("java.sql.Time");
        this.jComboBoxClassType.addItem("java.lang.Double");
        this.jComboBoxClassType.addItem("java.lang.Float");
        this.jComboBoxClassType.addItem("java.lang.Integer");
        this.jComboBoxClassType.addItem("java.io.InputStream");
        this.jComboBoxClassType.addItem("java.lang.Long");
        this.jComboBoxClassType.addItem("java.lang.Short");
        this.jComboBoxClassType.addItem("java.math.BigDecimal");
        this.dialogResult = 2;
        Misc.centerFrame(this);
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                SerieDialog.this.jButtonCancelActionPerformed(e);
            }
        };
        this.getRootPane().getInputMap(2).put(escape, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", escapeAction);
        this.applyI18n();
        this.getRootPane().setDefaultButton(this.jButtonOK);
    }

    public void setVariable(JRVariable var) {
        String var_name = var.getName();
        if ((var_name = var_name.substring("SERIE_".length())).startsWith("G_")) {
            Group g;
            var_name = var_name.substring(2);
            String grp_name = "";
            Enumeration enum_groups = this.getJrf().getReport().getGroups().elements();
            while (enum_groups.hasMoreElements() && !var_name.startsWith((grp_name = (g = (Group)enum_groups.nextElement()).getName()) + "_")) {
            }
            this.jComboBox1.setSelectedItem(grp_name);
            var_name = var_name.substring(grp_name.length() + 1);
        } else {
            this.jComboBox1.setSelectedIndex(0);
        }
        this.jTextFieldName.setText(var_name);
        this.jComboBoxClassType.setSelectedItem(var.getClassType());
        this.jRTextExpressionAreaDefaultExpression.setText(var.getExpression());
    }

    private void initComponents() {
        this.jLabelTitle = new JLabel();
        this.jRTextExpressionAreaDefaultExpression = new JRTextExpressionArea();
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.jTextFieldName = new JTextField();
        this.jLabelName = new JLabel();
        this.jLabelName1 = new JLabel();
        this.jComboBox1 = new JComboBox();
        this.jLabelName2 = new JLabel();
        this.jComboBoxClassType = new JComboBox();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(2);
        this.jLabelTitle.setText("Serie expression (the single object of this serie)");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(8, 4, 0, 4);
        this.getContentPane().add((Component)this.jLabelTitle, gridBagConstraints);
        this.jRTextExpressionAreaDefaultExpression.setBorder(BorderFactory.createEtchedBorder());
        this.jRTextExpressionAreaDefaultExpression.setElectricScroll(0);
        this.jRTextExpressionAreaDefaultExpression.setMinimumSize(new Dimension(0, 60));
        this.jRTextExpressionAreaDefaultExpression.setPreferredSize(new Dimension(310, 60));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 0.2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jRTextExpressionAreaDefaultExpression, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel1.setMinimumSize(new Dimension(10, 30));
        this.jPanel1.setPreferredSize(new Dimension(10, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.jPanel2, gridBagConstraints);
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SerieDialog.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jPanel1.add((Component)this.jButtonOK, new GridBagConstraints());
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SerieDialog.this.jButtonCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.jPanel1.add((Component)this.jButtonCancel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.75;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.getContentPane().add((Component)this.jTextFieldName, gridBagConstraints);
        this.jLabelName.setText("Serie name");
        this.jLabelName.setMaximumSize(new Dimension(40, 16));
        this.jLabelName.setMinimumSize(new Dimension(40, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 0, 0);
        this.getContentPane().add((Component)this.jLabelName, gridBagConstraints);
        this.jLabelName1.setText("Reset when");
        this.jLabelName1.setMaximumSize(new Dimension(40, 16));
        this.jLabelName1.setMinimumSize(new Dimension(40, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 0, 0);
        this.getContentPane().add((Component)this.jLabelName1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.getContentPane().add((Component)this.jComboBox1, gridBagConstraints);
        this.jLabelName2.setText("Exp Class");
        this.jLabelName2.setMaximumSize(new Dimension(40, 16));
        this.jLabelName2.setMinimumSize(new Dimension(40, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 0, 0);
        this.getContentPane().add((Component)this.jLabelName2, gridBagConstraints);
        this.jComboBoxClassType.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.getContentPane().add((Component)this.jComboBoxClassType, gridBagConstraints);
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dialogResult = 2;
        this.setVisible(false);
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.jRTextExpressionAreaDefaultExpression.getText().trim().length() == 0) {
            JOptionPane.showMessageDialog(this, I18n.getString("gui.chart.SerieDialog.selectexpression", "Please specify an expression"));
            return;
        }
        if (this.jTextFieldName.getText().trim().length() == 0) {
            JOptionPane.showMessageDialog(this, I18n.getString("gui.chart.SerieDialog.selectname", "Please specify an name for this serie"));
            return;
        }
        this.serieExpression = this.jRTextExpressionAreaDefaultExpression.getText();
        this.serieName = this.jTextFieldName.getText();
        this.serieReset = "";
        this.setSerieType("" + this.jComboBoxClassType.getSelectedItem());
        if (this.jComboBox1.getSelectedIndex() > 0) {
            this.serieReset = this.serieReset + "" + this.jComboBox1.getSelectedItem();
        }
        this.dialogResult = 0;
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new SerieDialog(null, true).setVisible(true);
            }
        });
    }

    public JReportFrame getJrf() {
        return this.jrf;
    }

    public void setJrf(JReportFrame jrf) {
        this.jrf = jrf;
        this.jRTextExpressionAreaDefaultExpression.getTokenMarker().setKeywordLookup(jrf.getReport().getKeywordLookup());
        this.jComboBox1.removeAllItems();
        this.jComboBox1.addItem(I18n.getString("serieDialog.none", "<None>"));
        if (jrf == null) {
            this.jComboBox1.updateUI();
            return;
        }
        Enumeration e = jrf.getReport().getGroups().elements();
        while (e.hasMoreElements()) {
            this.jComboBox1.addItem("" + e.nextElement());
        }
    }

    public int getDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }

    public String getSerieName() {
        return this.serieName;
    }

    public void setSerieName(String serieName) {
        this.serieName = serieName;
    }

    public String getSerieReset() {
        return this.serieReset;
    }

    public void setSerieReset(String serieReset) {
        this.serieReset = serieReset;
    }

    public String getSerieType() {
        return this.serieType;
    }

    public void setSerieType(String serieType) {
        this.serieType = serieType;
    }

    public String getSerieExpression() {
        return this.serieExpression;
    }

    public void setSerieExpression(String serieExpression) {
        this.serieExpression = serieExpression;
    }

    public void applyI18n() {
        this.jButtonCancel.setText(I18n.getString("serieDialog.buttonCancel", "Cancel"));
        this.jButtonOK.setText(I18n.getString("serieDialog.buttonOK", "OK"));
        this.jLabelName.setText(I18n.getString("serieDialog.labelName", "Serie name"));
        this.jLabelName1.setText(I18n.getString("serieDialog.labelName1", "Reset when"));
        this.jLabelName2.setText(I18n.getString("serieDialog.labelName2", "Exp Class"));
        this.jLabelTitle.setText(I18n.getString("serieDialog.labelTitle", "Serie expression (the single object of this serie)"));
    }
}

