/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui;

import it.businesslogic.ireport.PluginEntry;
import it.businesslogic.ireport.util.I18n;
import it.businesslogic.ireport.util.Misc;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class PluginConfigurationDialog
extends JDialog {
    private JButton jButtonClose;
    private JButton jButtonConfig;
    private JList jListPlugins;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;

    public PluginConfigurationDialog(JFrame owner) {
        super((Frame)owner, false);
        this.initComponents();
        this.applyI18n();
        this.setSize(450, 250);
        Misc.centerFrame(this);
        this.jListPlugins.setModel(new DefaultListModel());
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                PluginConfigurationDialog.this.jButtonCloseActionPerformed(e);
            }
        };
        this.getRootPane().getInputMap(2).put(escape, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", escapeAction);
        this.getRootPane().setDefaultButton(this.jButtonClose);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jListPlugins = new JList();
        this.jPanel1 = new JPanel();
        this.jButtonConfig = new JButton();
        this.jButtonClose = new JButton();
        this.jPanel2 = new JPanel();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Plugins configuration");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                PluginConfigurationDialog.this.exitForm(evt);
            }
        });
        this.jListPlugins.setSelectionMode(0);
        this.jListPlugins.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                PluginConfigurationDialog.this.jListPluginsValueChanged(evt);
            }
        });
        this.jListPlugins.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                PluginConfigurationDialog.this.jListPluginsMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jListPlugins);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jScrollPane1, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel1.setMinimumSize(new Dimension(120, 150));
        this.jPanel1.setPreferredSize(new Dimension(120, 150));
        this.jButtonConfig.setText("Configure");
        this.jButtonConfig.setEnabled(false);
        this.jButtonConfig.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PluginConfigurationDialog.this.jButtonConfigActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.jButtonConfig, gridBagConstraints);
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PluginConfigurationDialog.this.jButtonCloseActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.jPanel1.add((Component)this.jButtonClose, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jPanel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(4, 0, 4, 4);
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.pack();
    }

    private void jListPluginsMouseClicked(MouseEvent evt) {
        if (evt.getButton() == 1 && evt.getClickCount() == 2) {
            this.jButtonConfigActionPerformed(new ActionEvent(this, 0, ""));
        }
    }

    private void jButtonConfigActionPerformed(ActionEvent evt) {
        if (this.jListPlugins.getSelectedValue() == null) {
            return;
        }
        PluginEntry pe = (PluginEntry)this.jListPlugins.getSelectedValue();
        pe.getPlugin().configure();
    }

    private void jListPluginsValueChanged(ListSelectionEvent evt) {
        if (this.jListPlugins.getSelectedValue() != null) {
            PluginEntry pe = (PluginEntry)this.jListPlugins.getSelectedValue();
            if (pe.isConfigurable()) {
                this.jButtonConfig.setEnabled(true);
            } else {
                this.jButtonConfig.setEnabled(false);
            }
        } else {
            this.jButtonConfig.setEnabled(false);
        }
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void exitForm(WindowEvent evt) {
        this.setVisible(false);
    }

    public void setPlugins(Collection plugins) {
        Iterator iter = plugins.iterator();
        while (iter.hasNext()) {
            PluginEntry pe = (PluginEntry)iter.next();
            ((DefaultListModel)this.jListPlugins.getModel()).addElement(pe);
        }
    }

    public void applyI18n() {
        this.jButtonClose.setText(I18n.getString("pluginConfigurationDialog.buttonClose", "Close"));
        this.jButtonConfig.setText(I18n.getString("pluginConfigurationDialog.buttonConfig", "Configure"));
    }
}

