/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui.sheet;

import it.businesslogic.ireport.chart.SeriesColor;
import it.businesslogic.ireport.gui.sheet.ColorsListCellRenderer;
import it.businesslogic.ireport.util.I18n;
import it.businesslogic.ireport.util.Misc;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SeriesColorsDialog
extends JDialog {
    private int dialogResult = 2;
    private List seriescolors = null;
    public static List clipboard = new ArrayList();
    public static List lastSeries = new ArrayList();
    private JButton jButtonAddColor;
    private JButton jButtonCancel;
    private JButton jButtonCopySeries;
    private JButton jButtonDelete;
    private JButton jButtonModify;
    private JButton jButtonMoveDown;
    private JButton jButtonMoveUp;
    private JButton jButtonOk;
    private JButton jButtonPasteSeries;
    private JButton jButtonRandomColor;
    private JButton jButtonUseLast;
    private JList jList1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;

    public SeriesColorsDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initAll();
    }

    public SeriesColorsDialog(Dialog parent, boolean modal) {
        super(parent, modal);
        this.initAll();
    }

    public void initAll() {
        this.initComponents();
        this.jList1.setModel(new DefaultListModel());
        this.jList1.setCellRenderer(new ColorsListCellRenderer());
        this.jList1ValueChanged(null);
        this.jButtonPasteSeries.setEnabled(clipboard.size() > 0);
        this.jButtonUseLast.setEnabled(lastSeries.size() > 0);
        this.applyI18n();
        this.pack();
        Misc.centerFrame(this);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new JList();
        this.jPanel2 = new JPanel();
        this.jButtonAddColor = new JButton();
        this.jButtonModify = new JButton();
        this.jButtonDelete = new JButton();
        this.jButtonMoveUp = new JButton();
        this.jButtonMoveDown = new JButton();
        this.jButtonCopySeries = new JButton();
        this.jButtonPasteSeries = new JButton();
        this.jButtonUseLast = new JButton();
        this.jButtonRandomColor = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jPanel1 = new JPanel();
        this.jButtonOk = new JButton();
        this.jButtonCancel = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(2);
        this.jList1.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                SeriesColorsDialog.this.jList1ValueChanged(evt);
            }
        });
        this.jList1.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                SeriesColorsDialog.this.jList1MouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jList1);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jScrollPane1, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.jPanel2.setMinimumSize(new Dimension(150, 150));
        this.jPanel2.setPreferredSize(new Dimension(100, 283));
        this.jButtonAddColor.setText("Add");
        this.jButtonAddColor.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonAddColor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SeriesColorsDialog.this.jButtonAddColorActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanel2.add((Component)this.jButtonAddColor, gridBagConstraints);
        this.jButtonModify.setText("Modify");
        this.jButtonModify.setEnabled(false);
        this.jButtonModify.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonModify.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SeriesColorsDialog.this.jButtonModifyActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanel2.add((Component)this.jButtonModify, gridBagConstraints);
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.setEnabled(false);
        this.jButtonDelete.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonDelete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SeriesColorsDialog.this.jButtonDeleteActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanel2.add((Component)this.jButtonDelete, gridBagConstraints);
        this.jButtonMoveUp.setText("Move up");
        this.jButtonMoveUp.setEnabled(false);
        this.jButtonMoveUp.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonMoveUp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SeriesColorsDialog.this.jButtonMoveUpActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanel2.add((Component)this.jButtonMoveUp, gridBagConstraints);
        this.jButtonMoveDown.setText("Move down");
        this.jButtonMoveDown.setEnabled(false);
        this.jButtonMoveDown.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonMoveDown.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SeriesColorsDialog.this.jButtonMoveDownActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 14, 4);
        this.jPanel2.add((Component)this.jButtonMoveDown, gridBagConstraints);
        this.jButtonCopySeries.setText("Copy series");
        this.jButtonCopySeries.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonCopySeries.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SeriesColorsDialog.this.jButtonCopySeriesActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanel2.add((Component)this.jButtonCopySeries, gridBagConstraints);
        this.jButtonPasteSeries.setText("Paste series");
        this.jButtonPasteSeries.setEnabled(false);
        this.jButtonPasteSeries.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonPasteSeries.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SeriesColorsDialog.this.jButtonPasteSeriesActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanel2.add((Component)this.jButtonPasteSeries, gridBagConstraints);
        this.jButtonUseLast.setText("Use the last");
        this.jButtonUseLast.setEnabled(false);
        this.jButtonUseLast.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonUseLast.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SeriesColorsDialog.this.jButtonUseLastActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanel2.add((Component)this.jButtonUseLast, gridBagConstraints);
        this.jButtonRandomColor.setText("Random color");
        this.jButtonRandomColor.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonRandomColor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SeriesColorsDialog.this.jButtonRandomColorActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanel2.add((Component)this.jButtonRandomColor, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(4, 0, 4, 4);
        this.getContentPane().add((Component)this.jPanel2, gridBagConstraints);
        this.jSeparator1.setMinimumSize(new Dimension(0, 2));
        this.jSeparator1.setPreferredSize(new Dimension(3, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.jSeparator1, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel1.setPreferredSize(new Dimension(320, 23));
        this.jButtonOk.setText("OK");
        this.jButtonOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SeriesColorsDialog.this.jButtonOkActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.jPanel1.add((Component)this.jButtonOk, gridBagConstraints);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SeriesColorsDialog.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jPanel1.add((Component)this.jButtonCancel, new GridBagConstraints());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.pack();
    }

    private void jButtonUseLastActionPerformed(ActionEvent evt) {
        DefaultListModel dtm = (DefaultListModel)this.jList1.getModel();
        if (lastSeries.size() > 0) {
            for (int i = 0; i < lastSeries.size(); ++i) {
                dtm.addElement(new Color(((Color)lastSeries.get(i)).getRGB()));
            }
        }
    }

    private void jButtonPasteSeriesActionPerformed(ActionEvent evt) {
        DefaultListModel dtm = (DefaultListModel)this.jList1.getModel();
        if (clipboard.size() > 0) {
            for (int i = 0; i < clipboard.size(); ++i) {
                dtm.addElement(new Color(((Color)clipboard.get(i)).getRGB()));
            }
        }
    }

    private void jButtonCopySeriesActionPerformed(ActionEvent evt) {
        DefaultListModel dtm = (DefaultListModel)this.jList1.getModel();
        if (dtm.size() > 0) {
            clipboard.clear();
            for (int i = 0; i < dtm.size(); ++i) {
                clipboard.add(new Color(((Color)dtm.get(i)).getRGB()));
            }
        }
        this.jButtonPasteSeries.setEnabled(true);
    }

    private void jButtonRandomColorActionPerformed(ActionEvent evt) {
        Color c = new Color((int)(Math.random() * 255.0), (int)(Math.random() * 255.0), (int)(Math.random() * 255.0));
        DefaultListModel dtm = (DefaultListModel)this.jList1.getModel();
        dtm.addElement(c);
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.setDialogResult(2);
        this.setVisible(false);
        this.dispose();
    }

    private void jButtonOkActionPerformed(ActionEvent evt) {
        ArrayList<SeriesColor> temp_list = new ArrayList<SeriesColor>();
        DefaultListModel dtm = (DefaultListModel)this.jList1.getModel();
        lastSeries.clear();
        for (int i = 0; i < dtm.size(); ++i) {
            SeriesColor sc = new SeriesColor();
            sc.setSeriesOrder(i);
            sc.setColor((Color)dtm.get(i));
            temp_list.add(sc);
            lastSeries.add((Color)dtm.get(i));
        }
        this.setSeriescolors(temp_list);
        this.setDialogResult(0);
        this.setVisible(false);
        this.dispose();
    }

    private void jButtonMoveDownActionPerformed(ActionEvent evt) {
        if (this.jList1.getSelectedValues() != null) {
            int[] indices = this.jList1.getSelectedIndices();
            for (int i = indices.length - 1; i >= 0; --i) {
                if (indices[i] >= ((DefaultListModel)this.jList1.getModel()).size() - 1) continue;
                Object val = ((DefaultListModel)this.jList1.getModel()).remove(indices[i]);
                ((DefaultListModel)this.jList1.getModel()).insertElementAt(val, indices[i] + 1);
                int n = i;
                indices[n] = indices[n] + 1;
            }
            this.jList1.setSelectedIndices(indices);
        }
    }

    private void jButtonMoveUpActionPerformed(ActionEvent evt) {
        if (this.jList1.getSelectedValues() != null) {
            int[] indices = this.jList1.getSelectedIndices();
            for (int i = 0; i < indices.length; ++i) {
                if (indices[i] == 0) continue;
                Object val = ((DefaultListModel)this.jList1.getModel()).remove(indices[i]);
                ((DefaultListModel)this.jList1.getModel()).insertElementAt(val, indices[i] - 1);
                int n = i;
                indices[n] = indices[n] - 1;
            }
            this.jList1.setSelectedIndices(indices);
        }
    }

    private void jList1ValueChanged(ListSelectionEvent evt) {
        if (this.jList1.getSelectedIndex() >= 0) {
            this.jButtonDelete.setEnabled(true);
            this.jButtonModify.setEnabled(true);
            this.jButtonMoveUp.setEnabled(this.jList1.getSelectedIndex() > 0);
            this.jButtonMoveDown.setEnabled(this.jList1.getSelectedIndex() < ((DefaultListModel)this.jList1.getModel()).size() - 1);
        } else {
            this.jButtonModify.setEnabled(false);
            this.jButtonDelete.setEnabled(false);
            this.jButtonMoveUp.setEnabled(false);
            this.jButtonMoveDown.setEnabled(false);
        }
    }

    private void jList1MouseClicked(MouseEvent evt) {
        if (evt.getButton() == 1 && evt.getClickCount() == 2) {
            this.jButtonModifyActionPerformed(null);
        }
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        int[] indexes = this.jList1.getSelectedIndices();
        for (int i = indexes.length - 1; i >= 0; --i) {
            ((DefaultListModel)this.jList1.getModel()).removeElementAt(indexes[i]);
        }
    }

    private void jButtonModifyActionPerformed(ActionEvent evt) {
        int index = this.jList1.getSelectedIndex();
        if (index >= 0) {
            Color c = (Color)this.jList1.getSelectedValue();
            JColorChooser cc = new JColorChooser();
            if ((c = JColorChooser.showDialog(this, "Pick a color", c)) != null) {
                ((DefaultListModel)this.jList1.getModel()).setElementAt(c, index);
            }
        }
    }

    private void jButtonAddColorActionPerformed(ActionEvent evt) {
        JColorChooser cc = new JColorChooser();
        Color c = JColorChooser.showDialog(this, "Pick a color", null);
        if (c != null) {
            ((DefaultListModel)this.jList1.getModel()).addElement(c);
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new SeriesColorsDialog((Frame)new JFrame(), true).setVisible(true);
            }
        });
    }

    public int getDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }

    public List getSeriescolors() {
        return this.seriescolors;
    }

    public void setSeriescolors(List seriescolors) {
        this.seriescolors = seriescolors;
        DefaultListModel dlm = (DefaultListModel)this.jList1.getModel();
        dlm.removeAllElements();
        for (int i = 0; i < seriescolors.size(); ++i) {
            SeriesColor c = (SeriesColor)seriescolors.get(i);
            dlm.addElement(c.getColor());
        }
    }

    public void applyI18n() {
        this.jButtonAddColor.setText(I18n.getString("seriesColorsDialog.buttonAddColor", "Add"));
        this.jButtonCancel.setText(I18n.getString("seriesColorsDialog.buttonCancel", "Cancel"));
        this.jButtonCopySeries.setText(I18n.getString("seriesColorsDialog.buttonCopySeries", "Copy series"));
        this.jButtonDelete.setText(I18n.getString("seriesColorsDialog.buttonDelete", "Delete"));
        this.jButtonModify.setText(I18n.getString("seriesColorsDialog.buttonModify", "Modify"));
        this.jButtonMoveDown.setText(I18n.getString("seriesColorsDialog.buttonMoveDown", "Move down"));
        this.jButtonMoveUp.setText(I18n.getString("seriesColorsDialog.buttonMoveUp", "Move up"));
        this.jButtonOk.setText(I18n.getString("seriesColorsDialog.buttonOk", "OK"));
        this.jButtonPasteSeries.setText(I18n.getString("seriesColorsDialog.buttonPasteSeries", "Paste series"));
        this.jButtonRandomColor.setText(I18n.getString("seriesColorsDialog.buttonRandomColor", "Random color"));
        this.jButtonUseLast.setText(I18n.getString("seriesColorsDialog.buttonUseLast", "Use the last"));
    }
}

