/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.api.gui;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.JPanel;
import nickyb.sqleonardo.api.gui.AbstractDialogModal;
import nickyb.sqleonardo.api.gui.CommandButton;

public abstract class AbstractDialogWizard
extends AbstractDialogModal {
    private int step = 0;
    private JPanel cardPanel = new JPanel();
    private CardLayout cardLayout = new CardLayout();
    protected CommandButton btnBack;
    protected CommandButton btnNext;

    protected AbstractDialogWizard(Component owner, String title) {
        this(owner, title, 495, 355);
    }

    protected AbstractDialogWizard(Component owner, String title, int width, int height) {
        super(owner, title, width, height);
        this.cardPanel.setLayout(this.cardLayout);
        this.getContentPane().add(this.cardPanel);
        this.btnNext = this.insertButton(1, "next >");
        this.btnBack = this.insertButton(1, "< back");
    }

    protected void setBarEnabled(boolean b) {
        super.setBarEnabled(b);
        this.btnBack.setEnabled(this.step != 0);
    }

    protected boolean onBack() {
        this.setStep(0);
        return false;
    }

    protected abstract boolean onNext();

    protected void addStep(Component c) {
        this.cardPanel.add("step" + this.cardPanel.getComponentCount(), c);
    }

    protected int getStep() {
        return this.step;
    }

    protected void setStep(int idx) {
        this.setBarEnabled(false);
        this.step = idx;
        this.cardLayout.show(this.cardPanel, "step" + this.step);
        if (this.step == this.cardPanel.getComponentCount() - 1) {
            this.btnNext.setText("ok");
        } else {
            this.btnNext.setText("next >");
        }
        this.setBarEnabled(true);
    }

    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.btnBack) {
            if (this.onBack()) {
                this.setStep(this.step - 1);
            }
            return;
        }
        if (ae.getSource() == this.btnNext) {
            if (!this.onNext()) {
                return;
            }
            if (!this.btnNext.getText().equals("ok")) {
                this.setStep(this.step + 1);
                return;
            }
        }
        super.actionPerformed(ae);
    }
}

