/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.api.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.Vector;

public class Classpath {
    private static Vector startup;
    private static Vector runtime;

    public static ArrayList getLibraries() {
        ArrayList libs = new ArrayList();
        libs.addAll(startup.subList(0, startup.size()));
        libs.addAll(runtime.subList(0, runtime.size()));
        return libs;
    }

    public static boolean isRuntime(String library) {
        if (startup.contains(library)) {
            return false;
        }
        if (!runtime.contains(library)) {
            runtime.addElement(library);
        }
        return true;
    }

    public static ClassLoader loadLibrary(String library) throws MalformedURLException {
        if (Classpath.isRuntime(library)) {
            return new URLClassLoader(new URL[]{new File(library).toURL()}, ClassLoader.getSystemClassLoader());
        }
        return ClassLoader.getSystemClassLoader();
    }

    static {
        String filename;
        startup = new Vector();
        runtime = new Vector();
        String bootPath = System.getProperty("sun.boot.class.path");
        String classPath = System.getProperty("java.class.path");
        String extDir = System.getProperty("java.ext.dirs");
        StringTokenizer tokenizer = new StringTokenizer(bootPath, ";");
        while (tokenizer.hasMoreTokens()) {
            filename = tokenizer.nextToken();
            if (!filename.endsWith(".zip") && !filename.endsWith(".jar")) continue;
            startup.addElement(filename);
        }
        tokenizer = new StringTokenizer(classPath, ";");
        while (tokenizer.hasMoreTokens()) {
            filename = tokenizer.nextToken();
            if (!filename.endsWith(".zip") && !filename.endsWith(".jar")) continue;
            startup.addElement(filename);
        }
        File fileExtDir = new File(extDir);
        String[] exts = fileExtDir.list();
        for (int i = 0; i < exts.length; ++i) {
            if (!exts[i].endsWith(".zip") && !exts[i].endsWith(".jar")) continue;
            startup.addElement(new File(fileExtDir, exts[i]).toString());
        }
    }
}

