/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.api.util;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class Store {
    protected static final int INDEX_DATA = 0;
    protected static final int INDEX_SUBS = 1;
    protected static final int INDEX_JUMP = 2;
    private Hashtable mountpoints = new Hashtable();
    private Object[] cmp = new Object[3];

    public Store() {
        this.cmp[0] = new ArrayList();
        this.cmp[1] = new Hashtable();
    }

    protected Object[] get(String entry) {
        return (Object[])this.mountpoints.get(entry);
    }

    protected void put(String entry, Object[] content) {
        this.mountpoints.put(entry, content);
    }

    public void home() {
        this.cmp[2] = null;
    }

    public boolean canMount(String entry) {
        return this.mountpoints.containsKey(entry);
    }

    public ArrayList mount() {
        return (ArrayList)this.cmp[0];
    }

    public ArrayList mount(String entry) {
        if (this.mountpoints.containsKey(entry)) {
            this.cmp = (Object[])this.mountpoints.get(entry);
        } else {
            this.cmp = new Object[3];
            this.cmp[0] = new ArrayList();
            this.cmp[1] = new Hashtable();
            this.mountpoints.put(entry, this.cmp);
        }
        return this.mount();
    }

    public Enumeration mounts() {
        return this.mountpoints.keys();
    }

    public void umount(String entry) {
        this.cmp = new Object[3];
        this.cmp[0] = new ArrayList();
        this.cmp[1] = new Hashtable();
        this.mountpoints.remove(entry);
    }

    public boolean canJump(String sub) {
        Hashtable subs = (Hashtable)this.cmp[1];
        return subs.containsKey(sub);
    }

    public ArrayList jump() {
        return (ArrayList)((Object[])this.cmp[2])[0];
    }

    public ArrayList jump(String sub) {
        Hashtable subs = (Hashtable)this.cmp[1];
        if (this.cmp[2] != null) {
            subs = (Hashtable)((Object[])this.cmp[2])[1];
        }
        if (subs.containsKey(sub)) {
            this.cmp[2] = (Object[])subs.get(sub);
        } else {
            Object[] jp = new Object[]{new ArrayList(), new Hashtable()};
            subs.put(sub, jp);
            this.cmp[2] = jp;
        }
        return this.jump();
    }

    public Enumeration jumps() {
        Hashtable subs = (Hashtable)this.cmp[1];
        if (this.cmp[2] != null) {
            subs = (Hashtable)((Object[])this.cmp[2])[1];
        }
        return subs.keys();
    }

    public void ujump(String sub) {
        Hashtable subs = (Hashtable)this.cmp[1];
        subs.remove(sub);
        this.home();
    }

    public void rename(String oldentry, String newentry) {
        Object[] obj = (Object[])this.mountpoints.get(oldentry);
        this.mountpoints.put(newentry, obj);
        this.mountpoints.remove(oldentry);
    }

    public void reset() {
        this.mountpoints = new Hashtable();
        this.cmp = new Object[3];
        this.cmp[0] = new ArrayList();
        this.cmp[1] = new Hashtable();
    }

    public void load(String filename) throws IOException, ClassNotFoundException {
        ZipInputStream zin = new ZipInputStream(new FileInputStream(filename));
        ZipEntry entry = null;
        while ((entry = zin.getNextEntry()) != null) {
            Object[] content = new Object[3];
            content[0] = new ObjectInputStream(zin).readObject();
            content[1] = new ObjectInputStream(zin).readObject();
            this.put(entry.getName(), content);
        }
        zin.close();
    }

    public void save(String filename) throws IOException {
        ZipOutputStream zout = new ZipOutputStream(new FileOutputStream(filename));
        Enumeration e = this.mounts();
        while (e.hasMoreElements()) {
            String name = e.nextElement().toString();
            zout.putNextEntry(new ZipEntry(name));
            Object[] content = this.get(name);
            new ObjectOutputStream(zout).writeObject(content[0]);
            new ObjectOutputStream(zout).writeObject(content[1]);
            zout.closeEntry();
        }
        zout.close();
    }

    private void print() {
        Enumeration e = this.mountpoints.keys();
        while (e.hasMoreElements()) {
            String entry = e.nextElement().toString();
            System.out.println("*** " + entry + " ***");
            this.print("", (Object[])this.mountpoints.get(entry));
        }
    }

    private void print(String indent, Object[] obj) {
        ArrayList al = (ArrayList)obj[0];
        System.out.print(indent + al.size() + "{");
        for (int i = 0; i < al.size(); ++i) {
            System.out.print(al.get(i) + ",");
        }
        System.out.println("}");
        Hashtable h = (Hashtable)obj[1];
        Enumeration e = h.keys();
        while (e.hasMoreElements()) {
            String entry = e.nextElement().toString();
            System.out.println(indent + "\t" + entry);
            this.print(indent + "\t", (Object[])h.get(entry));
        }
    }

    public static void main(String[] args) {
        Store s = new Store();
        try {
            String filename = System.getProperty("user.home") + "/.sqleonardo";
            System.out.println("### " + filename + " ###");
            s.load(filename);
            s.print();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }
}

