/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.ctrl;

import java.awt.Cursor;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import nickyb.sqleonardo.Application;
import nickyb.sqleonardo.api.gui.BorderLayoutPanel;
import nickyb.sqleonardo.api.jdbc._TaskSource;
import nickyb.sqleonardo.ctrl.grid.DataGridModel;
import nickyb.sqleonardo.ctrl.grid.DataGridView;
import nickyb.sqleonardo.ctrl.grid.TableMetaData;
import nickyb.sqleonardo.ctrl.grid.TaskLoader;

public class DataGridControl
extends BorderLayoutPanel
implements ChangeListener {
    private boolean readonly;
    private JSlider sld;
    private JLabel status;
    private JTextArea syntax;
    private DataGridView view;
    private _TaskSource query;
    private Thread queryThread;

    public DataGridControl(_TaskSource query, boolean readonly) {
        super(2, 2);
        this.getActionMap().put("changes-save", new ActionSaveChanges());
        this.getActionMap().put("row-insert", new ActionInsertRow());
        this.getActionMap().put("row-delete", new ActionDeleteRow());
        this.getActionMap().put("show-log", new ActionShowLog());
        this.getActionMap().put("stop-task", new ActionStopTask());
        this.getActionMap().put("copy-cell", new ActionCopyCell());
        this.getActionMap().put("paste-cell", new ActionPasteCell());
        this.sld = new JSlider(1);
        this.sld.addChangeListener(this);
        this.sld.setSnapToTicks(true);
        this.sld.setInverted(true);
        this.sld.setValue(0);
        this.sld.setMinimum(0);
        this.sld.setMaximum(0);
        this.status = new JLabel("...");
        this.status.setBorder(new CompoundBorder(LineBorder.createGrayLineBorder(), new EmptyBorder(2, 4, 2, 4)));
        this.syntax = new JTextArea();
        JScrollPane scroll = new JScrollPane(this.syntax);
        this.syntax.setRows(3);
        this.syntax.setText(query.getSyntax());
        this.syntax.setWrapStyleWord(true);
        this.syntax.setLineWrap(true);
        this.syntax.setEditable(false);
        this.syntax.setOpaque(false);
        BorderLayoutPanel pnlSouth = new BorderLayoutPanel(2, 2);
        pnlSouth.setComponentCenter(this.status);
        pnlSouth.setComponentNorth(scroll);
        this.setComponentWest(this.sld);
        this.setComponentSouth(pnlSouth);
        this.view = new DataGridView(this);
        this.setComponentCenter(this.view);
        this.query = query;
        this.readonly = readonly;
        this.startThread();
    }

    public boolean isReadOnly() {
        return this.readonly;
    }

    public _TaskSource getTaskSource() {
        return this.query;
    }

    public JSlider getSlider() {
        return this.sld;
    }

    public DataGridView getView() {
        return this.view;
    }

    public boolean isValidThread() {
        return this.queryThread != null;
    }

    private void startThread() {
        this.setCursor(new Cursor(3));
        this.getActionMap().get("changes-save").setEnabled(false);
        this.getActionMap().get("row-insert").setEnabled(false);
        this.getActionMap().get("row-delete").setEnabled(false);
        this.getActionMap().get("show-log").setEnabled(false);
        this.queryThread = new Thread(new TaskLoader(this, this.query));
        this.queryThread.start();
        this.getActionMap().get("stop-task").setEnabled(true);
    }

    public void endThread() {
        this.getActionMap().get("stop-task").setEnabled(false);
        this.queryThread = null;
        this.view.tableChanged();
        this.refreshStatus();
        this.getActionMap().get("changes-save").setEnabled(!this.readonly);
        this.getActionMap().get("row-insert").setEnabled(!this.readonly);
        this.getActionMap().get("row-delete").setEnabled(!this.readonly);
        this.getActionMap().get("paste-cell").setEnabled(!this.readonly);
        this.getActionMap().get("show-log").setEnabled(!this.readonly);
        this.setCursor(new Cursor(0));
    }

    public void restartThread() {
        this.view.reset();
        this.startThread();
    }

    public void refreshStatus() {
        this.sld.setMaximum(this.view.getBlockCount() == 0 ? 0 : this.view.getBlockCount() - 1);
        if (this.view.getRowCount() > 0) {
            this.status.setText("block " + this.view.getBlock() + " of " + this.view.getBlockCount() + " - record " + this.view.getValueAt(0, 0) + " to " + this.view.getValueAt(this.view.getRowCount() - 1, 0) + " of " + this.view.getFlatRowCount());
        } else {
            this.status.setText("0 records");
        }
    }

    public void stateChanged(ChangeEvent e) {
        JSlider source = (JSlider)e.getSource();
        if (!source.getValueIsAdjusting()) {
            int block = source.getValue() + 1;
            if (this.view != null && block != this.view.getBlock()) {
                this.view.setBlock(block);
                this.refreshStatus();
            }
        }
    }

    private class ActionStopTask
    extends AbstractAction {
        ActionStopTask() {
            this.putValue("SmallIcon", Application.resources.getIcon("icon.011"));
        }

        public void actionPerformed(ActionEvent ae) {
            DataGridControl.this.endThread();
        }
    }

    private class ActionDeleteRow
    extends AbstractAction {
        ActionDeleteRow() {
            this.putValue("SmallIcon", Application.resources.getIcon("icon.161"));
            this.putValue("ShortDescription", "delete row");
        }

        public void actionPerformed(ActionEvent ae) {
            int row = DataGridControl.this.view.getCurrentRow();
            int col = DataGridControl.this.view.getCurrentColumn();
            if (row == -1) {
                return;
            }
            DataGridControl.this.view.deleteRow(row);
            DataGridControl.this.refreshStatus();
            if (DataGridControl.this.view.getRowCount() == 0) {
                return;
            }
            if (row >= DataGridControl.this.view.getRowCount()) {
                row = DataGridControl.this.view.getRowCount() - 1;
            }
            DataGridControl.this.view.setSelectedCell(row, col == -1 ? 0 : col);
        }
    }

    private class ActionInsertRow
    extends AbstractAction {
        ActionInsertRow() {
            this.putValue("SmallIcon", Application.resources.getIcon("icon.160"));
            this.putValue("ShortDescription", "insert row");
        }

        public void actionPerformed(ActionEvent ae) {
            int row = DataGridControl.this.view.getCurrentRow();
            int col = DataGridControl.this.view.getCurrentColumn();
            DataGridControl.this.view.insertRow(++row);
            DataGridControl.this.refreshStatus();
            if (row == DataGridModel.MAX_BLOCK_RECORDS) {
                row = 0;
                DataGridControl.this.sld.setValue(DataGridControl.this.sld.getValue() + 1);
            }
            DataGridControl.this.view.setSelectedCell(row, col == -1 ? 0 : col);
        }
    }

    private class ActionShowLog
    extends AbstractAction {
        ActionShowLog() {
            super("log...");
        }

        public void actionPerformed(ActionEvent ae) {
            DataGridControl.this.view.getLogManager().preview((TableMetaData)DataGridControl.this.query);
            DataGridControl.this.view.tableDataChanged();
        }
    }

    private class ActionSaveChanges
    extends AbstractAction {
        ActionSaveChanges() {
            this.putValue("SmallIcon", Application.resources.getIcon("icon.162"));
            this.putValue("ShortDescription", "save changes");
        }

        public void actionPerformed(ActionEvent ae) {
            DataGridControl.this.view.getLogManager().perform((TableMetaData)DataGridControl.this.query);
            DataGridControl.this.view.tableDataChanged();
        }
    }

    private class ActionPasteCell
    extends AbstractAction {
        ActionPasteCell() {
            super("paste");
        }

        public void actionPerformed(ActionEvent ae) {
            try {
                Clipboard cb = DataGridControl.this.getToolkit().getSystemClipboard();
                DataGridControl.this.view.setCellValue(cb.getContents(null).getTransferData(DataFlavor.stringFlavor));
            }
            catch (UnsupportedFlavorException e) {
                Application.println(e, false);
            }
            catch (IOException e) {
                Application.println(e, false);
            }
        }
    }

    private class ActionCopyCell
    extends AbstractAction {
        ActionCopyCell() {
            super("copy");
        }

        public void actionPerformed(ActionEvent ae) {
            int col = DataGridControl.this.view.getCurrentColumn();
            int row = DataGridControl.this.view.getCurrentRow();
            if (DataGridControl.this.view.getValueAt(row, col) == null) {
                return;
            }
            Clipboard cb = DataGridControl.this.getToolkit().getSystemClipboard();
            String value = DataGridControl.this.view.getValueAt(row, col).toString();
            StringSelection contents = new StringSelection(value);
            cb.setContents(contents, Application.defaultClipboardOwner);
        }
    }
}

