/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.ctrl.grid;

import java.awt.Component;
import nickyb.sqleonardo.Application;
import nickyb.sqleonardo.api.gui.AbstractDialogWizard;
import nickyb.sqleonardo.api.gui.MaskChooser;
import nickyb.sqleonardo.ctrl.grid.AbstractMaskPerform;
import nickyb.sqleonardo.ctrl.grid.DataGridView;
import nickyb.sqleonardo.ctrl.grid.MaskExport;
import nickyb.sqleonardo.ctrl.grid.MaskImport;

public class DialogIEData
extends AbstractDialogWizard {
    private String content = null;
    private DataGridView gbv;
    private AbstractMaskPerform mkp;
    private MaskChooser mkc;
    private TaskOwner task;

    private DialogIEData(String title, DataGridView view, String content) {
        super((Component)Application.window, title);
        this.content = content;
        this.gbv = view;
    }

    public static void showExport(DataGridView view, String content) {
        new DialogIEData("export", view, content).show();
    }

    public static void showImport(DataGridView view, String content) {
        new DialogIEData("import", view, content).show();
    }

    protected boolean onNext() {
        if (this.getStep() == 0) {
            if (this.mkc.getSelectedFile() != null) {
                this.mkp.setType(this.mkc.getPerformType(), this.content, this.mkc.getSelectedFile().toString());
                return true;
            }
        } else {
            this.task = new TaskOwner();
            new Thread(this.task).start();
        }
        return false;
    }

    protected void onOpen() {
        if (this.getTitle().equals("export")) {
            this.mkp = new MaskExport();
            this.mkc = new MaskChooser(1, 0, false);
            this.mkc.setFileFilter(new SQLFilter());
            this.mkc.setFileFilter(new WebFilter());
        } else if (this.getTitle().equals("import")) {
            this.mkp = new MaskImport();
            this.mkc = new MaskChooser(0, 0, false);
        }
        this.mkc.setFileFilter(new TXTFilter());
        this.addStep(this.mkc);
        this.addStep(this.mkp);
    }

    private static class WebFilter
    extends MaskChooser.AbstractFileFilter {
        WebFilter() {
            super("web pages", new String[]{".htm", ".html"});
        }

        public short getPerformType() {
            return 2;
        }
    }

    private static class TXTFilter
    extends MaskChooser.AbstractFileFilter {
        TXTFilter() {
            super("text files", new String[]{".txt"});
        }

        public short getPerformType() {
            return 1;
        }
    }

    private static class SQLFilter
    extends MaskChooser.AbstractFileFilter {
        SQLFilter() {
            super("insert statements", new String[]{".sql"});
        }

        public short getPerformType() {
            return 0;
        }
    }

    private class TaskOwner
    implements Runnable {
        private TaskOwner() {
        }

        public void run() {
            DialogIEData.this.setBarEnabled(false);
            DialogIEData.this.mkp.setEnabled(false);
            DialogIEData.this.mkp.init(DialogIEData.this.gbv);
            while (DialogIEData.this.task != null && !DialogIEData.this.mkp.abort() && !DialogIEData.this.mkp.finished()) {
                DialogIEData.this.mkp.next();
            }
            DialogIEData.this.mkp.setEnabled(true);
            DialogIEData.this.setBarEnabled(true);
        }
    }
}

