/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.ctrl.grid;

import java.awt.Cursor;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JOptionPane;
import nickyb.sqleonardo.Application;
import nickyb.sqleonardo.api.jdbc.ConnectionAssistant;
import nickyb.sqleonardo.api.jdbc.ConnectionHandler;
import nickyb.sqleonardo.ctrl.DataGridControl;
import nickyb.sqleonardo.ctrl.grid.TableMetaData;
import nickyb.sqleonardo.ctrl.querybuilder.syntax.SQLFormatter;
import nickyb.sqleonardo.mdi.ClientDataGrid;

public class JumpManager
implements Runnable {
    private DataGridControl owner;
    private Hashtable h = new Hashtable();
    private Vector v = new Vector();

    public static void perform(DataGridControl control) {
        JumpManager j = new JumpManager();
        j.owner = control;
        new Thread(j).start();
    }

    public void run() {
        String id;
        int i;
        this.owner.setCursor(new Cursor(3));
        TableMetaData tmd = (TableMetaData)this.owner.getTaskSource();
        int row = this.owner.getView().getCurrentRow();
        int col = this.owner.getView().getCurrentColumn();
        String column = this.owner.getView().getColumnName(col);
        for (i = 0; i < tmd.getImportedKeys().size(); ++i) {
            if (!tmd.getImportedKeyProperty(i, 7).equals(column)) continue;
            TableMetaData tmdPK = new TableMetaData(tmd.getHandlerKey(), tmd.getImportedKeyProperty(i, 1), tmd.getImportedKeyProperty(i, 2));
            String pk = tmd.getImportedKeyProperty(i, 3);
            id = ">> " + tmdPK.getIdentifier() + " (" + pk + ")";
            this.h.put(id, tmdPK);
            if (this.v.contains(id)) continue;
            this.v.addElement(id);
        }
        if (tmd.isPrimaryKey(column)) {
            for (i = 0; i < tmd.getExportedKeys().size(); ++i) {
                if (!tmd.getExportedKeyProperty(i, 3).equals(column)) continue;
                TableMetaData tmdFK = new TableMetaData(tmd.getHandlerKey(), tmd.getExportedKeyProperty(i, 5), tmd.getExportedKeyProperty(i, 6));
                String fk = tmd.getExportedKeyProperty(i, 7);
                id = "<< " + tmdFK.getIdentifier() + " (" + fk + ")";
                this.h.put(id, tmdFK);
                if (this.v.contains(id)) continue;
                this.v.addElement(id);
            }
        }
        this.owner.setCursor(new Cursor(0));
        Object jumpTo = null;
        if (this.v.size() == 1) {
            if (JOptionPane.showConfirmDialog(Application.window, "jump from '" + column + "' to:\n" + this.v.elementAt(0), "SQLeonardo", 2, -1) == 0) {
                jumpTo = this.v.elementAt(0);
            }
        } else if (this.v.size() > 1) {
            jumpTo = JOptionPane.showInputDialog(Application.window, "jump from '" + column + "' to:", "SQLeonardo", -1, null, this.v.toArray(), null);
        } else {
            JOptionPane.showMessageDialog(Application.window, "column '" + column + "' has no references", "SQLeonardo", 1);
            return;
        }
        if (jumpTo != null) {
            this.owner.setCursor(new Cursor(3));
            TableMetaData tmdJ = (TableMetaData)this.h.get(jumpTo);
            int pos = jumpTo.toString().indexOf(40);
            String filter = jumpTo.toString().substring(pos + 1, jumpTo.toString().length() - 1);
            int sqltype = 0;
            for (int i2 = 0; i2 < tmdJ.getColumns().size(); ++i2) {
                if (!tmdJ.getColumnProperty(i2, 3).equals(filter)) continue;
                sqltype = Integer.valueOf(tmdJ.getColumnProperty(i2, 4));
            }
            ConnectionHandler ch = ConnectionAssistant.getHandler(tmdJ.getHandlerKey());
            filter = SQLFormatter.ensureQuotes(filter, ch.getObject("$identifierQuoteString").toString(), false);
            Object value = this.owner.getView().getValueAt(row, col);
            tmdJ.setFilter(filter + " = " + SQLFormatter.toJdbcValue(value, sqltype));
            String title = "CONTENT : " + tmdJ.getIdentifier() + " : " + tmdJ.getHandlerKey();
            Application.window.add(new ClientDataGrid(title, tmdJ, !tmdJ.getType().equals("TABLE")));
            this.owner.setCursor(new Cursor(0));
        }
    }
}

