/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.ctrl.querybuilder;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import nickyb.sqleonardo.ctrl.querybuilder.BaseMask;
import nickyb.sqleonardo.ctrl.querybuilder.BasePanel;
import nickyb.sqleonardo.ctrl.querybuilder.DiagramEntity;
import nickyb.sqleonardo.ctrl.querybuilder.DiagramLoader;
import nickyb.sqleonardo.ctrl.querybuilder.syntax.QueryTokens;

public class MaskReferences
extends BaseMask
implements Runnable {
    private DiagramEntity item;
    private JList foreignTables;
    private JList primaryTables;

    public MaskReferences(DiagramEntity item) {
        super(item.querytoken.getReference() + " references");
        this.item = item;
        this.foreignTables = new JList();
        this.primaryTables = new JList();
        BasePanel contentL = new BasePanel();
        contentL.setComponentNorth(new JLabel("foreign tables"));
        contentL.setComponentCenter(new JScrollPane(this.foreignTables));
        BasePanel contentR = new BasePanel();
        contentR.setComponentNorth(new JLabel("primary tables"));
        contentR.setComponentCenter(new JScrollPane(this.primaryTables));
        JPanel pnlCenter = new JPanel(new GridLayout(1, 2, 2, 2));
        pnlCenter.add(contentL);
        pnlCenter.add(contentR);
        this.setComponentCenter(pnlCenter);
    }

    public Dimension getPreferredSize() {
        return new Dimension(400, 220);
    }

    private void addToSource(Object[] tables) {
        for (int i = 0; i < tables.length; ++i) {
            String schema = null;
            String table = tables[i].toString();
            if (table.indexOf(46) != -1) {
                schema = table.substring(0, table.indexOf(46));
                table = table.substring(table.indexOf(46) + 1);
            }
            QueryTokens.Table token = new QueryTokens.Table(schema, table);
            DiagramLoader.run(0, this.item.builder, token, true);
        }
    }

    protected boolean onConfirm() {
        this.addToSource(this.foreignTables.getSelectedValues());
        this.addToSource(this.primaryTables.getSelectedValues());
        return true;
    }

    protected void onShowing() {
        new Thread(this).start();
    }

    private void loadImportedKeys() throws SQLException {
        DefaultListModel<String> model = new DefaultListModel<String>();
        DatabaseMetaData dbmd = this.item.builder.getConnection().getMetaData();
        String schema = this.item.builder.getModel().getSchema() == null ? this.item.querytoken.getSchema() : this.item.builder.getModel().getSchema();
        String catalog = schema == null ? null : dbmd.getConnection().getCatalog();
        ResultSet rs = dbmd.getImportedKeys(catalog, schema, this.item.querytoken.getName());
        while (rs.next()) {
            String pkElement;
            String pkschema = rs.getString(2);
            String pktable = rs.getString(3).trim();
            if (this.item.builder.getModel().getSchema() != null) {
                pkschema = null;
            }
            if (pkschema != null) {
                pkschema = pkschema.trim();
            }
            if (pktable.equals(this.item.querytoken.getName()) || model.contains(pkElement = pkschema == null ? pktable : pkschema + "." + pktable)) continue;
            model.addElement(pkElement);
        }
        rs.close();
        this.primaryTables.setModel(model);
    }

    private void loadExportedKeys() throws SQLException {
        DefaultListModel<String> model = new DefaultListModel<String>();
        DatabaseMetaData dbmd = this.item.builder.getConnection().getMetaData();
        String schema = this.item.builder.getModel().getSchema() == null ? this.item.querytoken.getSchema() : this.item.builder.getModel().getSchema();
        String catalog = schema == null ? null : dbmd.getConnection().getCatalog();
        ResultSet rs = dbmd.getExportedKeys(catalog, schema, this.item.querytoken.getName());
        while (rs.next()) {
            String fkElement;
            String fkschema = rs.getString(6);
            String fktable = rs.getString(7).trim();
            if (this.item.builder.getModel().getSchema() != null) {
                fkschema = null;
            }
            if (fkschema != null) {
                fkschema = fkschema.trim();
            }
            if (fktable.equals(this.item.querytoken.getName()) || model.contains(fkElement = fkschema == null ? fktable : fkschema + "." + fktable)) continue;
            model.addElement(fkElement);
        }
        rs.close();
        this.foreignTables.setModel(model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.setCursor(new Cursor(3));
            this.loadExportedKeys();
            this.loadImportedKeys();
        }
        catch (SQLException sqle) {
            System.out.println("[ MaskReferences::onShowing ]\n" + sqle);
        }
        finally {
            this.setCursor(new Cursor(0));
        }
    }
}

