/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.ctrl.querybuilder.syntax;

import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ListIterator;
import java.util.Vector;
import nickyb.sqleonardo.ctrl.querybuilder.QueryBuilder;
import nickyb.sqleonardo.ctrl.querybuilder.QueryModel;
import nickyb.sqleonardo.ctrl.querybuilder.syntax.QueryExpression;
import nickyb.sqleonardo.ctrl.querybuilder.syntax.QuerySpecification;
import nickyb.sqleonardo.ctrl.querybuilder.syntax.QueryTokens;
import nickyb.sqleonardo.ctrl.querybuilder.syntax.SubQuery;

public class SQLParser {
    public static QueryModel toQueryModel(String sql) throws IOException {
        return SQLParser.toQueryModel(new StringReader(sql));
    }

    private static QueryModel toQueryModel(Reader r) throws IOException {
        QueryModel qm = new QueryModel();
        ArrayList al = SQLParser.doTokenize(r);
        SQLParser.doAdjustSequence(al);
        ListIterator li = al.listIterator();
        SQLParser.doParseQuery(li, qm.getQueryExpression());
        if (li.hasNext() && li.next().toString().toUpperCase().equalsIgnoreCase("ORDER BY")) {
            SQLParser.doParseOrderBy(li, qm);
        }
        return qm;
    }

    private static void doParseQuery(ListIterator li, QueryExpression qe) throws IOException {
        while (li.hasNext()) {
            int i;
            QueryTokens.Condition[] tokens;
            Object next = li.next();
            if (next.toString().equalsIgnoreCase("SELECT")) {
                SQLParser.doParseSelect(li, qe.getQuerySpecification());
                continue;
            }
            if (next.toString().equalsIgnoreCase("FROM")) {
                SQLParser.doParseFrom(li, qe.getQuerySpecification());
                SQLParser.doEnsureReferences(qe.getQuerySpecification());
                continue;
            }
            if (next.toString().equalsIgnoreCase("WHERE")) {
                tokens = SQLParser.doParseConditions(li);
                for (i = 0; i < tokens.length; ++i) {
                    qe.getQuerySpecification().addWhereClause(tokens[i]);
                }
                continue;
            }
            if (next.toString().equalsIgnoreCase("GROUP BY")) {
                SQLParser.doParseGroupBy(li, qe.getQuerySpecification());
                continue;
            }
            if (next.toString().equalsIgnoreCase("HAVING")) {
                tokens = SQLParser.doParseConditions(li);
                for (i = 0; i < tokens.length; ++i) {
                    qe.getQuerySpecification().addHavingClause(tokens[i]);
                }
                continue;
            }
            if (next.toString().equalsIgnoreCase("UNION")) {
                QueryExpression union = new QueryExpression();
                SQLParser.doParseQuery(li, union);
                qe.setUnion(union);
                continue;
            }
            if (next.toString().equalsIgnoreCase("ORDER BY")) {
                li.previous();
                break;
            }
            if (!next.toString().equals(")")) continue;
            break;
        }
    }

    private static void doParseSelect(ListIterator li, QuerySpecification qs) throws IOException {
        int surrounds = 0;
        String value = new String();
        while (li.hasNext()) {
            char last;
            Object next = li.next();
            if (next.toString().equalsIgnoreCase("DISTINCT")) {
                qs.setQuantifier((short)2);
                continue;
            }
            if (next.toString().equals(",") && surrounds == 0) {
                qs.addSelectList(new QueryTokens.DefaultExpression(value.trim()));
                value = new String();
                continue;
            }
            if (SQLParser.isClauseWord(next.toString())) {
                li.previous();
                if (next.toString().equalsIgnoreCase("SELECT")) {
                    SubQuery sub = new SubQuery();
                    SQLParser.doParseQuery(li, sub);
                    qs.addSelectList(sub);
                    value = new String();
                    continue;
                }
                if (value.trim().equals("")) break;
                qs.addSelectList(new QueryTokens.DefaultExpression(value.trim()));
                break;
            }
            if (next.toString().equals("(")) {
                ++surrounds;
            }
            if (next.toString().equals(")")) {
                --surrounds;
            }
            if (value.length() > 0 && next instanceof String && (Character.isLetter(last = value.charAt(value.length() - 1)) || String.valueOf(last).equals(QueryBuilder.identifierQuoteString))) {
                value = value + ' ';
            }
            value = value + next.toString();
        }
    }

    private static void doParseFrom(ListIterator li, QuerySpecification qs) {
        Hashtable<String, QueryTokens.AbstractDatabaseObject> tables = new Hashtable<String, QueryTokens.AbstractDatabaseObject>();
        Vector<QueryTokens.Condition> conditions = new Vector<QueryTokens.Condition>();
        QueryTokens.AbstractDatabaseObject t = null;
        while (li.hasNext()) {
            Object next = li.next();
            if (SQLParser.isClauseWord(next.toString()) || next.toString().equals(")") || next.toString().equals(";")) {
                if (t != null) {
                    tables.put(SQLParser.stripQuote(t.getReference()), t);
                }
                li.previous();
                break;
            }
            if (next.toString().equals(",") || SQLParser.isJoinWord(next.toString())) {
                if (t != null) {
                    tables.put(SQLParser.stripQuote(t.getReference()), t);
                }
                t = null;
                continue;
            }
            if (next.toString().equalsIgnoreCase("ON") || next.toString().equalsIgnoreCase("AND") || next.toString().equalsIgnoreCase("OR")) {
                if (t != null) {
                    tables.put(SQLParser.stripQuote(t.getReference()), t);
                }
                t = null;
                QueryTokens.Condition token = new QueryTokens.Condition(new QueryTokens.DefaultExpression(li.next().toString()), li.next().toString(), new QueryTokens.DefaultExpression(li.next().toString()));
                conditions.add(token);
                continue;
            }
            if (next.toString().equalsIgnoreCase("AS")) continue;
            if (t == null) {
                String schema = null;
                String name = SQLParser.stripQuote(next.toString());
                int i = name.lastIndexOf(46);
                if (i > 0) {
                    schema = name.substring(0, i);
                    name = name.substring(i + 1);
                }
                t = new QueryTokens.Table(schema, name);
                continue;
            }
            t.setAlias(next.toString());
        }
        Hashtable<String, QueryTokens.Table> joined = new Hashtable<String, QueryTokens.Table>();
        for (int i = 0; i < conditions.size(); ++i) {
            QueryTokens.Condition tc = (QueryTokens.Condition)conditions.get(i);
            for (int j = 0; j < 2; ++j) {
                String e = j == 0 ? tc.getLeft().toString() : tc.getRight().toString();
                e = SQLParser.stripQuote(e);
                int dot = e.lastIndexOf(46);
                String ref = dot == -1 ? new String() : e.substring(0, dot);
                QueryTokens.Table tt = new QueryTokens.Table(null, ref);
                if (!joined.containsKey(ref)) {
                    if (tables.containsKey(ref)) {
                        tt = (QueryTokens.Table)tables.get(ref);
                        joined.put(ref, tt);
                        tables.remove(ref);
                    }
                } else {
                    tt = (QueryTokens.Table)joined.get(ref);
                }
                if (j == 0) {
                    tc.setLeft(new QueryTokens.Column(tt, e.substring(dot + 1)));
                    continue;
                }
                tc.setRight(new QueryTokens.Column(tt, e.substring(dot + 1)));
            }
            QueryTokens.Join tj = new QueryTokens.Join((QueryTokens.Column)tc.getLeft(), tc.getOperator(), (QueryTokens.Column)tc.getRight());
            qs.addFromClause(tj);
        }
        Enumeration e = tables.elements();
        while (e.hasMoreElements()) {
            qs.addFromClause((QueryTokens.Table)e.nextElement());
        }
    }

    private static void doParseGroupBy(ListIterator li, QuerySpecification qs) {
        while (li.hasNext()) {
            Object next = li.next();
            if (SQLParser.isReservedWord(next.toString()) || next.toString().equals(";")) {
                li.previous();
                break;
            }
            if (!(next instanceof String)) continue;
            qs.addGroupByClause(new QueryTokens.Group(next.toString()));
        }
    }

    private static void doParseOrderBy(ListIterator li, QueryModel qm) {
        QueryTokens.Sort token = null;
        while (li.hasNext()) {
            Object next = li.next();
            if (next.toString().equals(",") || next.toString().equals(";")) {
                qm.addOrderByClause(token);
                token = null;
                continue;
            }
            if (token == null) {
                token = new QueryTokens.Sort(new QueryTokens.DefaultExpression(next.toString()));
                continue;
            }
            if (next.toString().equalsIgnoreCase("ASC")) {
                token.setType((short)0);
                continue;
            }
            if (!next.toString().equalsIgnoreCase("DESC")) continue;
            token.setType((short)1);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private static QueryTokens.Condition[] doParseConditions(ListIterator li) throws IOException {
        ArrayList<QueryTokens.Condition> tokens = new ArrayList<QueryTokens.Condition>();
        QueryTokens.Condition token = null;
        Object var3_3 = null;
        int surrounds = 0;
        do {
            char last;
            String value;
            void var3_4;
            if (!li.hasNext()) return tokens.toArray(new QueryTokens.Condition[tokens.size()]);
            Object next = li.next();
            if (next.toString().equals("(")) {
                ++surrounds;
            }
            if (next.toString().equals(")")) {
                --surrounds;
            }
            if (next.toString().equalsIgnoreCase("EXISTS") || next.toString().equalsIgnoreCase("NOT EXISTS")) {
                SubQuery sub = new SubQuery();
                SQLParser.doParseQuery(li, sub);
                token.setLeft(null);
                token.setOperator(next.toString());
                token.setRight(sub);
                tokens.add(token);
                token = null;
                Object var3_5 = null;
                continue;
            }
            if (SQLParser.isClauseWord(next.toString())) {
                li.previous();
                if (!next.toString().equalsIgnoreCase("SELECT")) {
                    if (token == null) return tokens.toArray(new QueryTokens.Condition[tokens.size()]);
                    token.setRight((QueryTokens._Expression)var3_4);
                    tokens.add(token);
                    return tokens.toArray(new QueryTokens.Condition[tokens.size()]);
                }
                SubQuery subQuery = new SubQuery();
                SQLParser.doParseQuery(li, subQuery);
                continue;
            }
            if (SQLParser.isOperator(next.toString())) {
                if (token == null) {
                    token = new QueryTokens.Condition();
                }
                token.setLeft((QueryTokens._Expression)var3_4);
                token.setOperator(next.toString().toUpperCase());
                Object var3_7 = null;
                continue;
            }
            if (next.toString().equalsIgnoreCase("AND") || next.toString().equalsIgnoreCase("OR") || next.toString().equals(";") || surrounds < 0) {
                if (token != null) {
                    token.setRight((QueryTokens._Expression)var3_4);
                    tokens.add(token);
                }
                token = new QueryTokens.Condition();
                token.setAppend(next.toString());
                Object var3_8 = null;
                continue;
            }
            String string = value = var3_4 == null ? new String() : var3_4.toString();
            if (value.length() > 0 && next instanceof String && Character.isLetter(last = value.charAt(value.length() - 1))) {
                value = value + ' ';
            }
            value = value + next.toString();
            QueryTokens.DefaultExpression defaultExpression = new QueryTokens.DefaultExpression(value);
        } while (surrounds >= 0);
        li.previous();
        return tokens.toArray(new QueryTokens.Condition[tokens.size()]);
    }

    private static void doEnsureReferences(QuerySpecification qs) throws IOException {
        Hashtable<String, QueryTokens._TableReference> tables = new Hashtable<String, QueryTokens._TableReference>();
        QueryTokens._TableReference[] fromClause = qs.getFromClause();
        for (int i = 0; i < fromClause.length; ++i) {
            QueryTokens._TableReference token = fromClause[i];
            if (token instanceof QueryTokens.Join) {
                tables.put(SQLParser.stripQuote(((QueryTokens.Join)token).getPrimary().getTable().getReference()), ((QueryTokens.Join)token).getPrimary().getTable());
                tables.put(SQLParser.stripQuote(((QueryTokens.Join)token).getForeign().getTable().getReference()), ((QueryTokens.Join)token).getForeign().getTable());
                continue;
            }
            tables.put(SQLParser.stripQuote(((QueryTokens.Table)token).getReference()), token);
        }
        QueryTokens._Expression[] selectList = qs.getSelectList();
        for (int i = 0; i < selectList.length; ++i) {
            String e = selectList[i].toString();
            qs.removeSelectList(selectList[i]);
            StreamTokenizer stream = SQLParser.createTokenizer(new StringReader(e));
            ArrayList<String> al = new ArrayList<String>();
            while (true) {
                stream.nextToken();
                if (stream.ttype == -1) {
                    ListIterator li = al.listIterator();
                    String ref = li.next().toString();
                    String alias = null;
                    while (li.hasNext()) {
                        String next = li.next().toString();
                        if (next.toString().equals(String.valueOf('.')) || ref.endsWith(String.valueOf('.'))) {
                            ref = ref + next;
                            continue;
                        }
                        alias = next;
                    }
                    int dot = (ref = SQLParser.stripQuote(ref)).lastIndexOf(46);
                    if (dot == -1) break;
                    String owner = ref.substring(0, dot);
                    String cname = ref.substring(dot + 1);
                    if (!tables.containsKey(owner)) break;
                    selectList[i] = new QueryTokens.Column((QueryTokens.Table)tables.get(owner), cname);
                    if (alias == null) break;
                    ((QueryTokens.Column)selectList[i]).setAlias(alias);
                    break;
                }
                if (stream.sval == null && (char)stream.ttype != '.') break;
                al.add(stream.sval == null ? String.valueOf('.') : stream.sval);
            }
            qs.addSelectList(selectList[i]);
        }
    }

    private static boolean isOperator(String s) {
        return SQLParser.isOperatorSimbol(s) || s.equalsIgnoreCase("IS") || s.equalsIgnoreCase("IS NOT") || s.equalsIgnoreCase("IN") || s.equalsIgnoreCase("NOT IN") || s.equalsIgnoreCase("LIKE") || s.equalsIgnoreCase("NOT LIKE") || s.equalsIgnoreCase("EXISTS") || s.equalsIgnoreCase("NOT EXISTS");
    }

    private static boolean isOperatorSimbol(String s) {
        return s.equals("<") || s.equals(">") || s.equals("=") || s.equals("<=") || s.equals(">=");
    }

    private static boolean isReservedWord(String s) {
        return SQLParser.isClauseWord(s) || SQLParser.isJoinWord(s) || s.equals("ON") || s.equals("AND") || s.equals("OR");
    }

    private static boolean isJoinWord(String s) {
        return s.equalsIgnoreCase("INNER JOIN") || s.equalsIgnoreCase("FULL OUTER JOIN") || s.equalsIgnoreCase("LEFT OUTER JOIN") || s.equalsIgnoreCase("RIGHT OUTER JOIN");
    }

    private static boolean isClauseWord(String s) {
        return s.equalsIgnoreCase("SELECT") || s.equalsIgnoreCase("FROM") || s.equalsIgnoreCase("WHERE") || s.equalsIgnoreCase("GROUP BY") || s.equalsIgnoreCase("HAVING") || s.equalsIgnoreCase("UNION") || s.equalsIgnoreCase("ORDER BY");
    }

    private static void doAdjustSequence(ArrayList al) {
        for (int i = 0; i < al.size(); ++i) {
            if (al.get(i).toString().equalsIgnoreCase("SELECT") || al.get(i).toString().equalsIgnoreCase("FROM") || al.get(i).toString().equalsIgnoreCase("HAVING")) {
                al.set(i, al.get(i).toString().toUpperCase());
                continue;
            }
            if (al.get(i).toString().equalsIgnoreCase("BY")) {
                al.set(i - 1, al.get(i - 1).toString().toUpperCase() + ' ' + "BY");
                al.remove(i--);
                continue;
            }
            if (al.get(i).toString().equalsIgnoreCase("JOIN")) {
                if (al.get(i - 1).toString().equalsIgnoreCase("INNER")) {
                    al.set(i - 1, al.get(i - 1).toString().toUpperCase() + ' ' + "JOIN");
                    al.remove(i--);
                    continue;
                }
                if (!al.get(i - 1).toString().equalsIgnoreCase("OUTER")) continue;
                al.set(i - 2, al.get(i - 2).toString().toUpperCase() + ' ' + "OUTER" + ' ' + "JOIN");
                al.remove(i--);
                al.remove(i--);
                continue;
            }
            if (al.get(i).toString().equalsIgnoreCase("NOT")) {
                if (al.get(i - 1).toString().equalsIgnoreCase("IS")) {
                    al.set(i - 1, "IS NOT");
                    al.remove(i--);
                    continue;
                }
                if (!al.get(i + 1).toString().equalsIgnoreCase("IN") && !al.get(i + 1).toString().equalsIgnoreCase("LIKE") && !al.get(i + 1).toString().equalsIgnoreCase("EXISTS")) continue;
                al.set(i, "NOT " + al.get(i + 1).toString().toUpperCase());
                al.remove(i + 1);
                continue;
            }
            if (al.get(i).toString().equals("=")) {
                if (!al.get(i - 1).toString().equals("<") && !al.get(i - 1).toString().equals(">")) continue;
                al.set(i - 1, al.get(i - 1).toString() + "=");
                al.remove(i--);
                continue;
            }
            if (!al.get(i).toString().equals(".")) continue;
            al.set(i, al.get(i - 1).toString() + '.' + al.get(i + 1).toString());
            al.remove(i - 1);
            al.remove(i--);
        }
    }

    private static ArrayList doTokenize(Reader r) throws IOException {
        ArrayList<Object> al = new ArrayList<Object>();
        StreamTokenizer stream = SQLParser.createTokenizer(r);
        while (stream.ttype != -1) {
            stream.nextToken();
            if (stream.ttype == -3) {
                al.add(stream.sval);
                continue;
            }
            if (stream.ttype == -2) {
                Double dval = new Double(stream.nval);
                al.add(dval == (double)dval.intValue() ? (Number)new Integer((int)stream.nval) : (Number)dval);
                continue;
            }
            if (stream.ttype == -1) continue;
            if (stream.sval == null) {
                al.add(new Character((char)stream.ttype));
                continue;
            }
            al.add((char)stream.ttype + stream.sval + (char)stream.ttype);
        }
        if (al.size() > 0 && !al.get(al.size() - 1).toString().equals(";")) {
            al.add(new Character(';'));
        }
        return al;
    }

    private static String stripQuote(String s) {
        if (s.startsWith(QueryBuilder.identifierQuoteString)) {
            s = s.substring(1);
        }
        if (s.endsWith(QueryBuilder.identifierQuoteString)) {
            s = s.substring(0, s.length() - 1);
        }
        int i = s.indexOf(QueryBuilder.identifierQuoteString);
        while (i != -1) {
            String l = s.substring(0, i);
            String r = s.substring(i + 1);
            s = l + r;
            i = s.indexOf(QueryBuilder.identifierQuoteString);
        }
        return s;
    }

    private static StreamTokenizer createTokenizer(Reader r) {
        StreamTokenizer stream = new StreamTokenizer(r);
        stream.ordinaryChar(46);
        stream.wordChars(95, 95);
        if (!QueryBuilder.identifierQuoteString.equals("\"")) {
            for (int i = 0; i < QueryBuilder.identifierQuoteString.length(); ++i) {
                char wc = QueryBuilder.identifierQuoteString.charAt(i);
                stream.wordChars(wc, wc);
            }
        }
        stream.slashSlashComments(true);
        stream.slashStarComments(true);
        return stream;
    }
}

