/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.io;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import nickyb.sqleonardo.Application;
import nickyb.sqleonardo.api.util.Text;
import nickyb.sqleonardo.ctrl.querybuilder.QueryModel;
import nickyb.sqleonardo.ctrl.querybuilder.syntax.QueryExpression;
import nickyb.sqleonardo.ctrl.querybuilder.syntax.QuerySpecification;
import nickyb.sqleonardo.ctrl.querybuilder.syntax.QueryTokens;
import nickyb.sqleonardo.ctrl.querybuilder.syntax.SubQuery;

public class FileStreamXLQ {
    public static QueryModel read(String filename) throws IOException, ClassNotFoundException {
        Reader r = new Reader(filename);
        return r.getQueryModel();
    }

    public static void write(String filename, QueryModel model) throws IOException {
        new Writer(filename, model);
    }

    private static String getAttribute(String t, String a) {
        int end;
        a = " " + a + "=\"";
        int start = t.indexOf(a) + a.length();
        return (t = t.substring(start, end = t.indexOf("\"", start))).equals("null") ? null : Text.replaceText(t, "&apos;", "'");
    }

    private static String toAttribute(String a, Object o) {
        return " " + a + "=\"" + (o == null ? null : Text.replaceText(o.toString(), "'", "&apos;")) + "\"";
    }

    private static class Writer {
        private BufferedWriter out;

        private Writer(String filename, QueryModel model) throws IOException {
            this.out = new BufferedWriter(new FileWriter(filename));
            this.writeln("<" + "SQLeonardo".toUpperCase() + FileStreamXLQ.toAttribute("version", Application.getVersion()) + ">");
            this.writeln("<MODEL" + FileStreamXLQ.toAttribute("schema", model.getSchema()) + ">");
            this.write(model.getQueryExpression());
            this.write(model.getOrderByClause(), "ORDER BY".replace(' ', '_'));
            this.writeln("</MODEL>");
            this.writeln("</" + "SQLeonardo".toUpperCase() + ">");
            this.out.flush();
            this.out.close();
        }

        private void write(QueryExpression qe) throws IOException {
            if (qe == null) {
                return;
            }
            this.writeln("<QUERY>");
            this.write(qe.getQuerySpecification().getSelectList(), "SELECT");
            this.write(qe.getQuerySpecification().getFromClause(), "FROM");
            this.write(qe.getQuerySpecification().getWhereClause(), "WHERE");
            this.write(qe.getQuerySpecification().getGroupByClause(), "GROUP BY".replace(' ', '_'));
            this.write(qe.getQuerySpecification().getHavingClause(), "HAVING");
            this.write(qe.getUnion());
            this.writeln("</QUERY>");
        }

        private void write(Object[] tokens, String tag) throws IOException {
            if (tokens.length == 0) {
                this.writeln("<" + tag + "/>");
                return;
            }
            this.writeln("<" + tag + ">");
            for (int i = 0; i < tokens.length; ++i) {
                if (tokens[i] instanceof QueryTokens._Expression) {
                    this.write((QueryTokens._Expression)tokens[i]);
                    continue;
                }
                if (tokens[i] instanceof QueryTokens.Join) {
                    this.write((QueryTokens.Join)tokens[i]);
                    continue;
                }
                if (tokens[i] instanceof QueryTokens.Sort) {
                    this.write((QueryTokens.Sort)tokens[i]);
                    continue;
                }
                if (tokens[i] instanceof QueryTokens.Group) {
                    this.write((QueryTokens.Group)tokens[i]);
                    continue;
                }
                if (tokens[i] instanceof QueryTokens.Table) {
                    this.write((QueryTokens.Table)tokens[i]);
                    continue;
                }
                if (!(tokens[i] instanceof QueryTokens.Condition)) continue;
                this.write((QueryTokens.Condition)tokens[i]);
            }
            this.writeln("</" + tag + ">");
        }

        private void write(QueryTokens._Expression token) throws IOException {
            if (token instanceof SubQuery) {
                this.write((QueryExpression)((Object)token));
            } else if (token instanceof QueryTokens.Column) {
                this.write((QueryTokens.Column)token);
            } else if (token != null) {
                this.writeln("<EXPRESSION" + FileStreamXLQ.toAttribute("value", token.toString()) + "/>");
            } else {
                this.writeln("<EXPRESSION/>");
            }
        }

        private void write(QueryTokens.Condition token) throws IOException {
            this.writeln("<CONDITION" + FileStreamXLQ.toAttribute("append", token.getAppend()) + FileStreamXLQ.toAttribute("operator", token.getOperator()) + ">");
            this.writeln("<LEFT>");
            this.write(token.getLeft());
            this.writeln("</LEFT>");
            this.writeln("<RIGHT>");
            this.write(token.getRight());
            this.writeln("</RIGHT>");
            this.writeln("</CONDITION>");
        }

        private void write(QueryTokens.Join token) throws IOException {
            this.writeln("<JOIN" + FileStreamXLQ.toAttribute("type", new Integer(token.getType())) + ">");
            this.write(token.getCondition());
            this.writeln("</JOIN>");
        }

        private void write(QueryTokens.Column token) throws IOException {
            this.writeln("<COLUMN" + FileStreamXLQ.toAttribute("name", token.getName()) + FileStreamXLQ.toAttribute("alias", token.getAlias()) + ">");
            this.write(token.getTable());
            this.writeln("</COLUMN>");
        }

        private void write(QueryTokens.Table token) throws IOException {
            this.writeln("<TABLE" + FileStreamXLQ.toAttribute("schema", token.getSchema()) + FileStreamXLQ.toAttribute("name", token.getName()) + FileStreamXLQ.toAttribute("alias", token.getAlias()) + "/>");
        }

        private void write(QueryTokens.Group token) throws IOException {
            this.write(token.getExpression());
        }

        private void write(QueryTokens.Sort token) throws IOException {
            this.writeln("<SORT" + FileStreamXLQ.toAttribute("type", new Short(token.isAscending() ? (short)0 : 1)) + ">");
            this.write(token.getExpression());
            this.writeln("</SORT>");
        }

        private void writeln(String s) throws IOException {
            this.out.write(s + '\n');
        }
    }

    private static class Reader {
        private QueryModel model = new QueryModel();
        private BufferedReader in;

        Reader(String filename) throws IOException, ClassNotFoundException {
            this.in = new BufferedReader(new FileReader(filename));
            this.in.readLine();
            String tag = this.in.readLine();
            String schema = FileStreamXLQ.getAttribute(tag, "schema");
            this.model.setSchema(schema);
            this.in.readLine();
            this.read(this.model.getQueryExpression());
            tag = this.in.readLine();
            if (!tag.endsWith("/>")) {
                while (!(tag = this.in.readLine()).equals("</ORDER_BY>")) {
                    short t = Short.valueOf(FileStreamXLQ.getAttribute(tag, "type"));
                    this.model.addOrderByClause(new QueryTokens.Sort((QueryTokens._Expression)this.getToken(this.in.readLine()), t));
                    this.in.readLine();
                }
            }
            this.in.readLine();
            this.in.readLine();
            this.in.close();
        }

        private QueryModel getQueryModel() {
            return this.model;
        }

        private void read(QueryExpression qe) throws IOException {
            block7: for (int i = 0; i < 5; ++i) {
                String tag = this.in.readLine();
                if (tag.endsWith("/>")) continue;
                switch (i) {
                    case 0: {
                        this.read(qe.getQuerySpecification(), "SELECT");
                        continue block7;
                    }
                    case 1: {
                        this.read(qe.getQuerySpecification(), "FROM");
                        continue block7;
                    }
                    case 2: {
                        this.read(qe.getQuerySpecification(), "WHERE");
                        continue block7;
                    }
                    case 3: {
                        this.read(qe.getQuerySpecification(), "GROUP BY".replace(' ', '_'));
                        continue block7;
                    }
                    case 4: {
                        this.read(qe.getQuerySpecification(), "HAVING");
                    }
                }
            }
            String tag = this.in.readLine();
            if (tag.equals("<QUERY>")) {
                QueryExpression union = new QueryExpression();
                qe.setUnion(union);
                this.read(union);
                this.in.readLine();
            }
        }

        private void read(QuerySpecification qs, String clause) throws IOException {
            String tag;
            while (!(tag = this.in.readLine()).equals("</" + clause + ">")) {
                QueryTokens._Base token = this.getToken(tag);
                if (clause.equals("SELECT")) {
                    qs.addSelectList((QueryTokens._Expression)token);
                    continue;
                }
                if (clause.equals("FROM")) {
                    qs.addFromClause((QueryTokens._TableReference)token);
                    continue;
                }
                if (clause.equals("WHERE")) {
                    qs.addWhereClause((QueryTokens.Condition)token);
                    continue;
                }
                if (clause.equals("GROUP BY".replace(' ', '_'))) {
                    qs.addGroupByClause(new QueryTokens.Group((QueryTokens._Expression)token));
                    continue;
                }
                if (!clause.equals("HAVING")) continue;
                qs.addHavingClause((QueryTokens.Condition)token);
            }
        }

        private QueryTokens._Base getToken(String tag) throws IOException {
            if (tag.startsWith("<QUERY")) {
                SubQuery sq = new SubQuery();
                this.read(sq);
                return sq;
            }
            if (tag.startsWith("<EXPRESSION")) {
                return this.getExpression(tag);
            }
            if (tag.startsWith("<COLUMN")) {
                return this.getColumn(tag);
            }
            if (tag.startsWith("<TABLE")) {
                return this.getTable(tag);
            }
            if (tag.startsWith("<CONDITION")) {
                return this.getCondition(tag);
            }
            if (tag.startsWith("<JOIN")) {
                return this.getJoin(tag);
            }
            return null;
        }

        private QueryTokens.DefaultExpression getExpression(String tag) {
            if (tag.equals("<EXPRESSION/>")) {
                return null;
            }
            return new QueryTokens.DefaultExpression(FileStreamXLQ.getAttribute(tag, "value"));
        }

        private QueryTokens.Column getColumn(String tag) throws IOException {
            QueryTokens.Column token = new QueryTokens.Column(this.getTable(this.in.readLine()), FileStreamXLQ.getAttribute(tag, "name"));
            token.setAlias(FileStreamXLQ.getAttribute(tag, "alias"));
            this.in.readLine();
            return token;
        }

        private QueryTokens.Table getTable(String tag) {
            QueryTokens.Table token = new QueryTokens.Table(FileStreamXLQ.getAttribute(tag, "schema"), FileStreamXLQ.getAttribute(tag, "name"));
            token.setAlias(FileStreamXLQ.getAttribute(tag, "alias"));
            return token;
        }

        private QueryTokens.Condition getCondition(String tag) throws IOException {
            this.in.readLine();
            QueryTokens._Expression left = (QueryTokens._Expression)this.getToken(this.in.readLine());
            this.in.readLine();
            this.in.readLine();
            QueryTokens._Expression right = (QueryTokens._Expression)this.getToken(this.in.readLine());
            this.in.readLine();
            QueryTokens.Condition token = new QueryTokens.Condition(FileStreamXLQ.getAttribute(tag, "append"), left, FileStreamXLQ.getAttribute(tag, "operator"), right);
            this.in.readLine();
            return token;
        }

        private QueryTokens.Join getJoin(String tag) throws IOException {
            this.in.readLine();
            QueryTokens.Condition condition = this.getCondition(tag);
            int t = Integer.valueOf(FileStreamXLQ.getAttribute(tag, "type"));
            QueryTokens.Join token = new QueryTokens.Join(t, (QueryTokens.Column)condition.getLeft(), condition.getOperator(), (QueryTokens.Column)condition.getRight());
            this.in.readLine();
            return token;
        }
    }
}

