/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.mdi;

import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.Date;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import nickyb.sqleonardo.Application;
import nickyb.sqleonardo.api.gui.Toolbar;
import nickyb.sqleonardo.api.jdbc._TaskSource;
import nickyb.sqleonardo.ctrl.DataGridControl;
import nickyb.sqleonardo.ctrl.grid.DialogIEData;
import nickyb.sqleonardo.ctrl.grid.JumpManager;
import nickyb.sqleonardo.mdi.MDIClient;
import nickyb.sqleonardo.mdi.MDIMenubar;

public class ClientDataGrid
extends MDIClient {
    public static final String DEFAULT_TITLE = "data grid";
    private DataGridControl control;
    private JMenuItem[] m_actions;

    public ClientDataGrid(String title, _TaskSource query, boolean readonly) {
        super(title == null ? DEFAULT_TITLE : title);
        this.setMaximizable(true);
        this.setResizable(true);
        this.control = new DataGridControl(query, readonly);
        this.setComponentCenter(this.control);
        this.control.getView().addMouseListener(new InternalClickHandler());
        this.control.setBorder(new EmptyBorder(2, 2, 2, 2));
        this.setDefaultCloseOperation(0);
        InternalFrameAdapter ifl = new InternalFrameAdapter(){

            public void internalFrameClosing(InternalFrameEvent evt) {
                if (!ClientDataGrid.this.control.isValidThread() && !ClientDataGrid.this.control.isReadOnly() && ClientDataGrid.this.control.getView().getLogManager().count() > 0) {
                    int option = JOptionPane.showConfirmDialog(Application.window, "do you want save changes?", "SQLeonardo", 1);
                    if (option == 0) {
                        ClientDataGrid.this.control.getActionMap().get("changes-save").actionPerformed(null);
                    } else if (option == 2) {
                        return;
                    }
                }
                ClientDataGrid.this.control.endThread();
                ClientDataGrid.this.dispose();
            }
        };
        this.addInternalFrameListener(ifl);
        this.createToolbar();
        this.initActionsMenu();
    }

    private void createToolbar() {
        Toolbar toolbar = new Toolbar(1);
        toolbar.add(this.control.getActionMap().get("changes-save"));
        toolbar.addSeparator();
        toolbar.add(this.control.getActionMap().get("row-insert"));
        toolbar.add(this.control.getActionMap().get("row-delete"));
        toolbar.addSeparator();
        toolbar.add(this.control.getActionMap().get("stop-task"));
        this.setComponentEast(toolbar);
    }

    private void initActionsMenu() {
        this.m_actions = new JMenuItem[]{new JMenuItem(this.control.getActionMap().get("show-log")), null, MDIMenubar.createItem(new ActionShowExport()), MDIMenubar.createItem(new ActionShowImport()), null, new JMenuItem(new ActionRelaunch())};
    }

    protected String getMessage() {
        int rows = this.control.getView().getRowCount();
        if (rows == 0) {
            return null;
        }
        String first = this.control.getView().getValueAt(0, 0).toString();
        String last = this.control.getView().getValueAt(rows - 1, 0).toString();
        return "block " + this.control.getView().getBlock() + " of " + this.control.getView().getBlockCount() + " - record(s) " + first + " to " + last + " of " + this.control.getView().getFlatRowCount();
    }

    protected JMenuItem[] getActionsMenu() {
        return this.m_actions;
    }

    protected void setPreferences() {
    }

    private class ActionShowExport
    extends AbstractAction {
        ActionShowExport() {
            this.putValue("Name", "export...");
        }

        public void actionPerformed(ActionEvent ae) {
            int pos1 = ClientDataGrid.this.getTitle().indexOf(58);
            int pos2 = ClientDataGrid.this.getTitle().lastIndexOf(58);
            String content = ClientDataGrid.this.getTitle().substring(pos1 + 1, pos2);
            DialogIEData.showExport(ClientDataGrid.this.control.getView(), content.trim());
        }
    }

    private class ActionShowImport
    extends AbstractAction {
        ActionShowImport() {
            this.putValue("Name", "import...");
            this.setEnabled(!ClientDataGrid.this.control.isReadOnly());
        }

        public void actionPerformed(ActionEvent ae) {
            int pos1 = ClientDataGrid.this.getTitle().indexOf(58);
            int pos2 = ClientDataGrid.this.getTitle().lastIndexOf(58);
            String content = ClientDataGrid.this.getTitle().substring(pos1 + 1, pos2);
            DialogIEData.showImport(ClientDataGrid.this.control.getView(), content.trim());
        }
    }

    private class ActionRelaunch
    extends AbstractAction {
        ActionRelaunch() {
            this.putValue("Name", "relaunch");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(116, 0));
        }

        public void actionPerformed(ActionEvent ae) {
            if (!ClientDataGrid.this.control.isValidThread()) {
                ClientDataGrid.this.control.restartThread();
            }
        }
    }

    private class ActionResetOldValue
    extends AbstractAction {
        ActionResetOldValue() {
            this.putValue("Name", "reset <old-value>");
            this.setEnabled(!ClientDataGrid.this.control.isReadOnly());
        }

        public void actionPerformed(ActionEvent ae) {
            if (ClientDataGrid.this.control.getView().getCurrentRow() != -1 && ClientDataGrid.this.control.getView().getCurrentColumn() != -1) {
                ClientDataGrid.this.control.getView().resetCellValue();
            }
        }
    }

    private class ActionSetToday
    extends AbstractAction {
        ActionSetToday() {
            this.putValue("Name", "set <today>");
            this.setEnabled(!ClientDataGrid.this.control.isReadOnly());
        }

        public void actionPerformed(ActionEvent ae) {
            if (ClientDataGrid.this.control.getView().getCurrentRow() != -1 && ClientDataGrid.this.control.getView().getCurrentColumn() != -1) {
                ClientDataGrid.this.control.getView().setCellValue(new Date(System.currentTimeMillis()));
            }
        }
    }

    private class ActionSetNull
    extends AbstractAction {
        ActionSetNull() {
            this.putValue("Name", "set <null>");
            this.setEnabled(!ClientDataGrid.this.control.isReadOnly());
        }

        public void actionPerformed(ActionEvent ae) {
            if (ClientDataGrid.this.control.getView().getCurrentRow() != -1 && ClientDataGrid.this.control.getView().getCurrentColumn() != -1) {
                ClientDataGrid.this.control.getView().setCellValue(null);
            }
        }
    }

    private class ActionJump
    extends AbstractAction {
        ActionJump() {
            this.putValue("Name", "jump...");
            this.setEnabled(!ClientDataGrid.this.control.isReadOnly());
        }

        public void actionPerformed(ActionEvent ae) {
            JumpManager.perform(ClientDataGrid.this.control);
        }
    }

    private class InternalClickHandler
    extends MouseAdapter {
        private InternalClickHandler() {
        }

        public void mouseReleased(MouseEvent me) {
            if (SwingUtilities.isRightMouseButton(me)) {
                JTable grid = (JTable)me.getSource();
                int row = grid.rowAtPoint(me.getPoint());
                int col = grid.columnAtPoint(me.getPoint());
                grid.changeSelection(row, col, false, false);
                if (col > 0) {
                    JPopupMenu popup = new JPopupMenu();
                    popup.add(ClientDataGrid.this.control.getActionMap().get("copy-cell"));
                    popup.add(ClientDataGrid.this.control.getActionMap().get("paste-cell"));
                    popup.addSeparator();
                    popup.add(new ActionSetNull());
                    popup.add(new ActionSetToday());
                    popup.add(new ActionResetOldValue());
                    popup.addSeparator();
                    popup.add(new ActionJump());
                    popup.show(grid, me.getX(), me.getY());
                }
            }
        }
    }
}

