/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.mdi;

import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import nickyb.sqleonardo.Application;
import nickyb.sqleonardo.api.gui.Toolbar;
import nickyb.sqleonardo.api.jdbc.ConnectionAssistant;
import nickyb.sqleonardo.api.jdbc._TaskSource;
import nickyb.sqleonardo.ctrl.querybuilder.QueryBuilder;
import nickyb.sqleonardo.ctrl.querybuilder.QueryModel;
import nickyb.sqleonardo.ctrl.querybuilder.syntax.SQLParser;
import nickyb.sqleonardo.io.FileStreamSQL;
import nickyb.sqleonardo.io.FileStreamXLQ;
import nickyb.sqleonardo.mdi.ClientDataGrid;
import nickyb.sqleonardo.mdi.DialogQuery;
import nickyb.sqleonardo.mdi.MDIActions;
import nickyb.sqleonardo.mdi.MDIClient;

public class ClientQueryBuilder
extends MDIClient
implements ChangeListener {
    public static final String DEFAULT_TITLE = "QUERY";
    public static int counter = 0;
    private QueryBuilder builder;
    private JTextArea syntax;
    private JTabbedPane control;
    private JMenuItem[] m_actions;
    private String keycah = null;
    private String filename = null;

    public ClientQueryBuilder(String keycah) {
        super(DEFAULT_TITLE);
        this.setMaximizable(false);
        this.setResizable(false);
        this.keycah = keycah;
        this.control = new JTabbedPane(3);
        this.setComponentCenter(this.control);
        this.builder = new QueryBuilder();
        this.control.add("builder", this.builder);
        this.syntax = new JTextArea();
        this.control.add("syntax", new JScrollPane(this.syntax));
        this.control.addChangeListener(this);
        this.createToolbar();
        this.initActionsMenu();
        if (keycah != null) {
            this.builder.setConnection(ConnectionAssistant.getHandler(keycah).get());
        }
        this.setFileName(null);
        this.addInternalFrameListener(new InternalFrameAdapter(){

            public void internalFrameActivated(InternalFrameEvent ife) {
                ClientQueryBuilder.this.setQueryParameters();
            }
        });
    }

    private void createToolbar() {
        JToggleButton btn = new JToggleButton(this.builder.getActionMap().get("change-work-mode"));
        btn.setIcon(Application.resources.getIcon("icon.150"));
        Toolbar toolbar = new Toolbar(1);
        toolbar.add(new ActionSave());
        toolbar.add(new ActionSaveAs());
        toolbar.addSeparator();
        toolbar.add(btn);
        toolbar.addSeparator();
        toolbar.add(new ActionLaunch());
        this.setComponentEast(toolbar);
    }

    private void initActionsMenu() {
        this.m_actions = new JMenuItem[]{new JMenuItem(this.builder.getActionMap().get("entities-arrange")), new JMenuItem(this.builder.getActionMap().get("entities-pack")), new JMenuItem(this.builder.getActionMap().get("entities-remove")), null, new JMenuItem(this.builder.getActionMap().get("copy-syntax"))};
    }

    protected JMenuItem[] getActionsMenu() {
        return this.m_actions;
    }

    public void stateChanged(ChangeEvent ce) {
        this.m_actions[0].setEnabled(this.control.getSelectedIndex() == 0);
        this.m_actions[1].setEnabled(this.control.getSelectedIndex() == 0);
        this.m_actions[2].setEnabled(this.control.getSelectedIndex() == 0);
        if (this.control.getSelectedIndex() == 0) {
            String msql = this.builder.getModel().toString(true);
            String tsql = this.syntax.getText();
            if (!tsql.equals(msql) && Application.confirm("SQLeonardo", "syntax changed!\ndo you want to apply changes (builder need to reload)?")) {
                new Thread(new Runnable(){

                    public void run() {
                        while (!ClientQueryBuilder.this.builder.isVisible()) {
                        }
                        try {
                            QueryModel qm = SQLParser.toQueryModel(ClientQueryBuilder.this.syntax.getText());
                            ClientQueryBuilder.this.builder.setModel(qm);
                        }
                        catch (IOException e) {
                            Application.println(e, true);
                        }
                    }
                }).start();
            }
        } else {
            this.syntax.setText(this.builder.getModel().toString(true));
        }
    }

    protected void setPreferences() {
    }

    public final void setFileName(String filename) {
        this.filename = filename;
        String filename2 = filename == null ? "<untitled" + ++counter + ">" : filename;
        super.setTitle(this.getID() + " - " + DEFAULT_TITLE + " : " + filename2 + " : " + this.keycah);
    }

    public final void setModel(QueryModel model) {
        this.builder.setModel(model);
    }

    private void setQueryParameters() {
        if (ConnectionAssistant.hasHandler(this.keycah)) {
            QueryBuilder.identifierQuoteString = ConnectionAssistant.getHandler(this.keycah).getObject("$identifierQuoteString").toString();
            QueryBuilder.maxColumnNameLength = (Integer)ConnectionAssistant.getHandler(this.keycah).getObject("$maxColumnNameLength");
        }
    }

    public class ActionSave
    extends ActionSaveAs {
        private ActionSave() {
            this.setText("save query");
            this.setIcon("icon.009");
            this.setTooltip("save query");
        }

        public void actionPerformed(ActionEvent ae) {
            if (ClientQueryBuilder.this.filename == null) {
                super.actionPerformed(ae);
            } else {
                try {
                    String fn = ClientQueryBuilder.this.filename;
                    if (fn.endsWith(".sql")) {
                        FileStreamSQL.write(fn, ClientQueryBuilder.this.builder.getModel());
                    } else {
                        if (!fn.endsWith(".xlq")) {
                            fn = fn + ".xlq";
                        }
                        FileStreamXLQ.write(fn, ClientQueryBuilder.this.builder.getModel());
                    }
                    ClientQueryBuilder.this.setFileName(fn);
                }
                catch (Exception e) {
                    Application.println(e, true);
                    e.printStackTrace();
                }
            }
        }
    }

    public class ActionSaveAs
    extends MDIActions.AbstractBase {
        private ActionSaveAs() {
            super("save query as...");
            this.setIcon("icon.010");
            this.setTooltip("save query as...");
        }

        public void actionPerformed(ActionEvent ae) {
            Object[] ret = DialogQuery.showSave(ClientQueryBuilder.this.builder.getModel());
            if (ret[0] != null) {
                ClientQueryBuilder.this.setFileName(ret[0].toString());
            }
        }
    }

    private class ActionLaunch
    extends MDIActions.AbstractBase
    implements _TaskSource {
        private ActionLaunch() {
            super("launch query");
            this.setIcon("icon.151");
            this.setTooltip("launch query");
        }

        public void actionPerformed(ActionEvent ae) {
            if (ClientQueryBuilder.this.builder.getConnection() == null) {
                Application.alert("SQLeonardo", "no connection!");
            } else {
                int pos = ClientQueryBuilder.this.getTitle().indexOf(":");
                String subtitle = ClientQueryBuilder.this.getTitle().substring(pos);
                Application.window.add(new ClientDataGrid("PREVIEW " + subtitle, this, true));
            }
        }

        public String getHandlerKey() {
            return ClientQueryBuilder.this.keycah;
        }

        public String getSyntax() {
            return ClientQueryBuilder.this.builder.getModel().toString();
        }
    }
}

